/*
 * Decompiled with CFR 0.152.
 */
package animalscriptapi.primitives;

import animalscriptapi.primitives.Primitive;
import animalscriptapi.primitives.generators.GraphGenerator;
import animalscriptapi.properties.GraphProperties;
import animalscriptapi.util.DisplayOptions;
import animalscriptapi.util.Node;
import animalscriptapi.util.Timing;

public class Graph
extends Primitive {
    private GraphGenerator generator = null;
    protected String[] nodeLabels = null;
    protected Node[] nodes = null;
    protected int[][] adjacencyMatrix = null;
    private GraphProperties properties = null;

    public Graph(GraphGenerator graphGen, String name, int[][] graphAdjacencyMatrix, Node[] graphNodes, String[] labels, DisplayOptions display, GraphProperties props) {
        super(graphGen, display);
        this.generator = graphGen;
        this.properties = props;
        this.setName(name);
        if (graphAdjacencyMatrix == null || graphNodes == null || graphAdjacencyMatrix.length != graphNodes.length) {
            throw new IllegalArgumentException("Adjacency matrix and nodes must not be empty and have same size!");
        }
        this.adjacencyMatrix = graphAdjacencyMatrix;
        this.nodes = graphNodes;
        this.nodeLabels = labels;
        this.generator.create(this);
    }

    public GraphProperties getProperties() {
        return this.properties;
    }

    private boolean checkForValidIndex(int row, int col, String methodName) {
        if (this.adjacencyMatrix != null && row >= 0 && row < this.adjacencyMatrix.length && col >= 0 && col < this.adjacencyMatrix[row].length) {
            return true;
        }
        throw new IllegalArgumentException("Invalid access for method " + methodName + " to non-existent cell [" + row + "][" + col + "]");
    }

    public int[][] getAdjacencyMatrix() {
        return this.adjacencyMatrix;
    }

    public int getSize() {
        if (this.adjacencyMatrix != null) {
            return this.adjacencyMatrix.length;
        }
        return 0;
    }

    public Node getNode(int nodeNr) {
        if (this.checkForValidIndex(nodeNr, nodeNr, "getNode")) {
            return this.nodes[nodeNr];
        }
        return null;
    }

    public String getNodeLabel(int nodeNr) {
        if (this.checkForValidIndex(nodeNr, nodeNr, "getNodeLabels")) {
            return this.nodeLabels[nodeNr];
        }
        return null;
    }

    public int[] getEdgesForNode(int node) {
        if (this.checkForValidIndex(node, 0, "getEdgesForNode")) {
            return this.adjacencyMatrix[node];
        }
        return null;
    }

    public int getEdgeWeight(int fromNode, int toNode) {
        if (this.checkForValidIndex(fromNode, toNode, "getEdgeWeight")) {
            return this.adjacencyMatrix[fromNode][toNode];
        }
        return 0;
    }

    public void setEdgeWeight(int fromNode, int toNode, int weight, Timing offset, Timing duration) {
        this.setEdgeWeight(fromNode, toNode, String.valueOf(weight), offset, duration);
        this.adjacencyMatrix[fromNode][toNode] = weight;
    }

    public void setEdgeWeight(int fromNode, int toNode, String weight, Timing offset, Timing duration) {
        if (this.checkForValidIndex(fromNode, toNode, "getEdgeWeight")) {
            this.generator.setEdgeWeight(this, fromNode, toNode, weight, offset, duration);
        }
    }

    public void hideNode(int index, Timing offset, Timing duration) {
        if (this.checkForValidIndex(index, index, "hideNode")) {
            this.generator.hideNode(this, index, offset, duration);
        }
    }

    public void hideNodes(int[] indices, Timing offset, Timing duration) {
        this.generator.hideNodes(this, indices, offset, duration);
    }

    public void hideEdge(int startNode, int endNode, Timing offset, Timing duration) {
        if (this.checkForValidIndex(startNode, endNode, "hideEdge")) {
            this.generator.hideEdge(this, startNode, endNode, offset, duration);
        }
    }

    public void hideEdgeWeight(int startNode, int endNode, Timing offset, Timing duration) {
        if (this.checkForValidIndex(startNode, endNode, "hideEdge")) {
            this.generator.hideEdgeWeight(this, startNode, endNode, offset, duration);
        }
    }

    public void showEdge(int startNode, int endNode, Timing offset, Timing duration) {
        if (this.checkForValidIndex(startNode, endNode, "showEdgeWeight")) {
            this.generator.showEdge(this, startNode, endNode, offset, duration);
        }
    }

    public void showEdgeWeight(int startNode, int endNode, Timing offset, Timing duration) {
        if (this.checkForValidIndex(startNode, endNode, "showEdgeWeight")) {
            this.generator.showEdgeWeight(this, startNode, endNode, offset, duration);
        }
    }

    public void showNode(int index, Timing offset, Timing duration) {
        if (this.checkForValidIndex(index, index, "hideNode")) {
            this.generator.showNode(this, index, offset, duration);
        }
    }

    public void showNodes(int[] indices, Timing offset, Timing duration) {
        this.generator.showNodes(this, indices, offset, duration);
    }

    public void highlightEdge(int startNode, int endNode, Timing offset, Timing duration) {
        if (this.checkForValidIndex(startNode, endNode, "highlightEdge")) {
            this.generator.highlightEdge(this, startNode, endNode, offset, duration);
        }
    }

    public void unhighlightEdge(int startNode, int endNode, Timing offset, Timing duration) {
        if (this.checkForValidIndex(startNode, endNode, "unhighlightEdge")) {
            this.generator.unhighlightEdge(this, startNode, endNode, offset, duration);
        }
    }

    public void highlightNode(int node, Timing offset, Timing duration) {
        if (this.checkForValidIndex(node, node, "highlightNode")) {
            this.generator.highlightNode(this, node, offset, duration);
        }
    }

    public void unhighlightNode(int node, Timing offset, Timing duration) {
        if (this.checkForValidIndex(node, node, "unhighlightNode")) {
            this.generator.unhighlightNode(this, node, offset, duration);
        }
    }

    public void translateNode(int nodeIndex, Node location, Timing offset, Timing duration) {
        if (this.checkForValidIndex(nodeIndex, nodeIndex, "translateNode")) {
            this.generator.translateNode(this, nodeIndex, location, offset, duration);
        }
    }

    public void translateWithFixedNodes(int[] nodeIndices, Node location, Timing offset, Timing duration) {
        this.generator.translateWithFixedNodes(this, nodeIndices, location, offset, duration);
    }

    public void translateNodes(int[] nodeIndices, Node location, Timing offset, Timing duration) {
        this.generator.translateNodes(this, nodeIndices, location, offset, duration);
    }

    public void setName(String newName) {
        this.properties.setName(newName);
        super.setName(newName);
    }
}

