/*
 * Decompiled with CFR 0.152.
 */
package animalscript.extensions;

import animal.misc.ParseSupport;
import animal.misc.XProperties;
import animalscript.core.AnimalParseSupport;
import animalscript.core.AnimalScriptInterface;
import animalscript.core.BasicParser;
import animalscript.extensions.MethodInvocationProducer;
import java.io.IOException;
import java.util.Hashtable;

public class MethodInvocationSupport
extends BasicParser
implements AnimalScriptInterface {
    private MethodInvocationProducer methodInvocationProducer;

    public MethodInvocationSupport() {
        this.handledKeywords = new Hashtable();
        this.rulesHash = new XProperties();
        this.handledKeywords.put("createobject", "parseCreateObjectInput");
        this.handledKeywords.put("invokemethod", "parseMethodInvocationInput");
        this.handledKeywords.put("invokegeneration", "parseCodeGenerationInput");
        this.methodInvocationProducer = new MethodInvocationProducer();
    }

    public boolean generateNewStep(String currentCommand) {
        return !sameStep;
    }

    public XProperties parseCreateObjectInput() throws IOException {
        String localType = ParseSupport.parseWord(stok, "create object type").toLowerCase();
        String objectName = AnimalParseSupport.parseText(stok, "name of created object");
        String basicFeedbackTag = String.valueOf(localType) + " '" + objectName + "' ";
        ParseSupport.parseWord(stok, String.valueOf(basicFeedbackTag) + " 'class'", "class");
        String targetClass = AnimalParseSupport.parseText(stok, "MethodInvocation class name");
        System.err.println("store object '" + objectName + "' of type " + targetClass);
        boolean invokeNow = ParseSupport.parseOptionalWord(stok, "create object keyword 'onLoad'", "onLoad");
        MethodInvocationProducer.createObject(objectName, targetClass, invokeNow);
        return new XProperties();
    }

    public XProperties parseMethodInvocationInput() throws IOException {
        String localType = ParseSupport.parseWord(stok, "method invocation type").toLowerCase();
        String methodName = AnimalParseSupport.parseText(stok, "method invocation object name");
        String basicFeedbackTag = String.valueOf(localType) + " '" + methodName + "' ";
        ParseSupport.parseWord(stok, String.valueOf(basicFeedbackTag) + "  'on'", "on");
        String targetObject = AnimalParseSupport.parseText(stok, "method invocation class name");
        boolean invokeNow = ParseSupport.parseOptionalWord(stok, "method invocation keyword 'onLoad'", "onLoad");
        this.methodInvocationProducer.invokeMethod(methodName, targetObject, invokeNow);
        return new XProperties();
    }

    public XProperties parseCodeGenerationInput() throws IOException {
        ParseSupport.parseWord(stok, "method invocation type");
        ParseSupport.parseWord(stok, "code generation 'on'", "on");
        String targetObject = AnimalParseSupport.parseText(stok, "method invocation object name");
        int tag = 0;
        if (ParseSupport.parseOptionalWord(stok, "'param'", "param")) {
            tag = ParseSupport.parseInt(stok, "param value");
        }
        boolean invokeNow = ParseSupport.parseOptionalWord(stok, "method invocation keyword 'onLoad'", "onLoad");
        this.methodInvocationProducer.getScriptingCode(targetObject, tag, invokeNow);
        return null;
    }
}

