/*
 * Decompiled with CFR 0.152.
 */
package animalscript.extensions;

import animal.animator.ColorChanger;
import animal.animator.Move;
import animal.animator.TimedShow;
import animal.graphics.PTGraphicObject;
import animal.graphics.PTPolyline;
import animal.graphics.PTText;
import animal.main.Animal;
import animal.misc.MessageDisplay;
import animal.misc.ParseSupport;
import animal.misc.XProperties;
import animalscript.core.AnimalParseSupport;
import animalscript.core.AnimalScriptInterface;
import animalscript.core.BasicParser;
import animalscript.extensions.ArrayProducer;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.IOException;
import java.util.Hashtable;
import java.util.StringTokenizer;

public class ArraySupport
extends BasicParser
implements AnimalScriptInterface {
    public ArraySupport() {
        this.handledKeywords = new Hashtable();
        this.rulesHash = new XProperties();
        this.handledKeywords.put("array", "parseArrayInput");
        this.handledKeywords.put("field", "parseArrayInput");
        this.handledKeywords.put("arraymarker", "parseArrayMarkerInput");
        this.handledKeywords.put("arraypointer", "parseArrayMarkerInput");
        this.handledKeywords.put("arrayindex", "parseArrayMarkerInput");
        this.handledKeywords.put("highlightarraycell", "parseColorChange");
        this.handledKeywords.put("highlightarrayelem", "parseColorChange");
        this.handledKeywords.put("highlightarrayelement", "parseColorChange");
        this.handledKeywords.put("unhighlightarraycell", "parseColorChange");
        this.handledKeywords.put("unhighlightarrayelem", "parseColorChange");
        this.handledKeywords.put("unhighlightarrayelement", "parseColorChange");
        this.handledKeywords.put("arrayput", "parseArrayPut");
        this.rulesHash.put("arrayput", "# put the given value at the given array position");
        this.handledKeywords.put("arrayswap", "parseArraySwap");
        this.rulesHash.put("arrayswap", "# swap the given array positions on the target array");
        this.handledKeywords.put("jumparrayindex", "parseMovePointer");
        this.handledKeywords.put("jumparraymarker", "parseMovePointer");
        this.handledKeywords.put("jumparraypointer", "parseMovePointer");
        this.handledKeywords.put("jumpindex", "parseMovePointer");
        this.handledKeywords.put("jumpmarker", "parseMovePointer");
        this.handledKeywords.put("jumppointer", "parseMovePointer");
        this.handledKeywords.put("movearrayindex", "parseMovePointer");
        this.handledKeywords.put("movearraymarker", "parseMovePointer");
        this.handledKeywords.put("movearraypointer", "parseMovePointer");
        this.handledKeywords.put("moveindex", "parseMovePointer");
        this.handledKeywords.put("movemarker", "parseMovePointer");
        this.handledKeywords.put("movepointer", "parseMovePointer");
    }

    public boolean generateNewStep(String currentCommand) {
        return !sameStep;
    }

    public void parseArrayInput() throws IOException {
        boolean cascadedDisplay;
        boolean verticalMode = false;
        int displayDelay = 0;
        int displayDuration = 0;
        int[] entryIDs = null;
        String localType = ParseSupport.parseWord(stok, "Array type").toLowerCase();
        String arrayName = AnimalParseSupport.parseText(stok, "Array object name");
        String basicFeedbackTag = String.valueOf(localType) + " '" + arrayName + "' ";
        ParseSupport.parseOptionalWord(stok, String.valueOf(basicFeedbackTag) + " deprecated 'at'", "at");
        Point basePoint = AnimalParseSupport.parseNodeInfo(stok, String.valueOf(basicFeedbackTag) + "start node", null);
        Color arrayColor = AnimalParseSupport.parseAndSetColor(stok, arrayName, "color", "black");
        Color fillColor = AnimalParseSupport.parseAndSetColor(stok, arrayName, "fillColor", "white");
        Color elementColor = AnimalParseSupport.parseAndSetColor(stok, arrayName, "elementColor", "black");
        AnimalParseSupport.parseAndSetColor(stok, arrayName, "elemHighlight", "red");
        AnimalParseSupport.parseAndSetColor(stok, arrayName, "cellHighlight", "yellow");
        verticalMode = ParseSupport.parseOptionalWord(stok, "Array '" + arrayName + "'orientation 'vertical'", "vertical");
        if (!verticalMode) {
            ParseSupport.parseOptionalWord(stok, String.valueOf(basicFeedbackTag) + "orientation 'horizontal'", "horizontal");
        }
        ParseSupport.parseMandatoryWord(stok, String.valueOf(basicFeedbackTag) + "Keyword 'length'", "length");
        int arrayLength = ParseSupport.parseInt(stok, String.valueOf(basicFeedbackTag) + "length(>=1)", 1);
        entryIDs = new int[arrayLength << 1];
        StringBuilder components = new StringBuilder(arrayLength << 3);
        String[] elements = new String[arrayLength];
        int i = 0;
        while (i < arrayLength) {
            elements[i] = AnimalParseSupport.parseText(stok, String.valueOf(basicFeedbackTag) + "element #" + i, null, false, chosenLanguage);
            ++i;
        }
        ArraySupport.getObjectProperties().put(String.valueOf(arrayName) + ".length", arrayLength);
        int basicDepth = 0x7FFFFFFB;
        if (ParseSupport.parseOptionalWord(stok, "'depth' tag for Array " + arrayName, "depth")) {
            basicDepth = ParseSupport.parseInt(stok, "Array '" + arrayName + "'  depth(>=0))", 0);
        }
        String unit = "ticks";
        if (ParseSupport.parseOptionalWord(stok, String.valueOf(basicFeedbackTag) + "keyword 'after'", "after")) {
            displayDelay = ParseSupport.parseInt(stok, String.valueOf(basicFeedbackTag) + "delay", 0);
            unit = ParseSupport.parseWord(stok, String.valueOf(basicFeedbackTag) + "delay unit");
        }
        if (cascadedDisplay = ParseSupport.parseOptionalWord(stok, String.valueOf(basicFeedbackTag) + "keyword 'cascaded'", "cascaded")) {
            if (ParseSupport.parseOptionalWord(stok, String.valueOf(basicFeedbackTag) + "keyword 'within'", "within")) {
                displayDuration = ParseSupport.parseInt(stok, String.valueOf(basicFeedbackTag) + "duration", 0);
                if (displayDelay == 0) {
                    unit = ParseSupport.parseWord(stok, String.valueOf(basicFeedbackTag) + "duration unit");
                } else if (ParseSupport.parseOptionalWord(stok, String.valueOf(basicFeedbackTag) + "duration unit", "ticks")) {
                    unit = "ticks";
                } else if (ParseSupport.parseOptionalWord(stok, String.valueOf(basicFeedbackTag) + "duration unit", "ms")) {
                    unit = "ms";
                }
            } else {
                displayDuration = arrayLength * (unit.equalsIgnoreCase("ticks") ? 10 : 200);
            }
        }
        int[] oids = new int[displayDuration == 0 ? arrayLength << 1 : 2];
        Font f = AnimalParseSupport.parseFontInfo(stok, "array");
        ArrayProducer.makeArray(arrayName, basePoint, arrayColor, fillColor, elementColor, verticalMode, arrayLength, elements, basicDepth, displayDelay, cascadedDisplay, displayDuration, oids, entryIDs, components, f, unit, stok);
    }

    public void parseArrayMarkerInput() throws IOException {
        String ids;
        int maxLength;
        String markerLabel = null;
        PTText labelText = null;
        String localType = ParseSupport.parseWord(stok, "Array marker type").toLowerCase();
        String markerName = AnimalParseSupport.parseText(stok, "Array marker name");
        String basicTag = String.valueOf(localType) + " '" + markerName + "' ";
        ParseSupport.parseMandatoryWord(stok, String.valueOf(basicTag) + "keyword 'on'", "on");
        String targetObjectName = AnimalParseSupport.parseText(stok, String.valueOf(basicTag) + "base array name");
        int[] targetOIDs = ArraySupport.getObjectIDs().getIntArrayProperty(targetObjectName);
        if (targetOIDs == null || !ArraySupport.getObjectTypes().getProperty(targetObjectName).equals(ArraySupport.getTypeIdentifier("array"))) {
            ParseSupport.formatException("Target object '" + targetObjectName + "' unknown or not an array.", stok);
        }
        if ((maxLength = ArraySupport.getObjectProperties().getIntProperty(String.valueOf(targetObjectName) + ".length", -1)) < 1) {
            ParseSupport.formatException("Invalid number of elements in array '" + targetObjectName + "'.", stok);
        }
        ParseSupport.parseMandatoryWord(stok, String.valueOf(basicTag) + "keyword 'atIndex'", "atIndex");
        int targetIndex = ParseSupport.parseInt(stok, String.valueOf(basicTag) + "target index([0, " + (maxLength - 1) + "])", 0, maxLength - 1);
        if (ParseSupport.parseOptionalWord(stok, String.valueOf(basicTag) + "optional keyword 'label'", "label")) {
            markerLabel = AnimalParseSupport.parseText(stok, String.valueOf(basicTag) + "label", null, false, chosenLanguage);
        }
        int length = 40;
        if (ParseSupport.parseOptionalWord(stok, String.valueOf(basicTag) + "optional keyword 'short'", "short")) {
            length = 20;
        } else if (ParseSupport.parseOptionalWord(stok, String.valueOf(basicTag) + "optional keyword 'long'", "long")) {
            length = 60;
        } else if (ParseSupport.parseOptionalWord(stok, String.valueOf(basicTag) + "optional keyword 'normal'", "normal")) {
            length = 40;
        }
        int indexOID = targetOIDs[maxLength + targetIndex];
        Point[] coords = new Point[2];
        PTGraphicObject ptgo = animState.getCloneByNum(indexOID);
        Rectangle boundingBox = ptgo.getBoundingBox();
        if (ArraySupport.getObjectProperties().getProperty(String.valueOf(targetObjectName) + ".orientation").equals("horizontal")) {
            coords[1] = new Point(boundingBox.x + (boundingBox.width >>> 1), boundingBox.y);
            coords[0] = new Point(coords[1].x, boundingBox.y - length);
        } else {
            coords[1] = new Point(boundingBox.x, boundingBox.y + (boundingBox.height >>> 1));
            coords[0] = new Point(boundingBox.x - length, coords[1].y);
        }
        PTPolyline indexMarker = new PTPolyline(coords);
        indexMarker.setObjectName(String.valueOf(markerLabel) + ".ptr");
        indexMarker.setFWArrow(true);
        indexMarker.setBWArrow(false);
        indexMarker.setColor(AnimalParseSupport.parseAndSetColor(stok, localType, "color"));
        AnimalParseSupport.parseAndSetDepth(stok, indexMarker, localType);
        if (markerLabel != null) {
            Font f = AnimalParseSupport.parseFontInfo(stok, "arrayIndex");
            labelText = new PTText(markerLabel, f);
            labelText.setObjectName(markerLabel);
            labelText.setColor(indexMarker.getColor());
            FontMetrics fm = Animal.getConcreteFontMetrics(f);
            int textWidth = fm.stringWidth(markerLabel);
            if (ArraySupport.getObjectProperties().getProperty(String.valueOf(targetObjectName) + ".orientation").equals("horizontal")) {
                labelText.setLocation(new Point(coords[0].x - (textWidth >>> 1), coords[0].y - 5));
            } else {
                labelText.setLocation(new Point(coords[0].x - textWidth - 5, coords[0].y + 8));
            }
            BasicParser.addGraphicObject(labelText, anim);
            ArraySupport.getObjectIDs().put(String.valueOf(markerName) + ".label", labelText.getNum(false));
        }
        BasicParser.addGraphicObject(indexMarker, anim);
        String markerID = String.valueOf(indexMarker.getNum(false));
        String string = ids = labelText == null ? markerID : String.valueOf(markerID) + " " + String.valueOf(labelText.getNum(false));
        if (ArraySupport.getObjectProperties().getProperty(String.valueOf(targetObjectName) + ".ptrs") != null) {
            ArraySupport.getObjectProperties().put(String.valueOf(targetObjectName) + ".ptrs", String.valueOf(ArraySupport.getObjectProperties().getProperty(String.valueOf(targetObjectName) + ".ptrs")) + " " + markerName);
        } else {
            ArraySupport.getObjectProperties().put(String.valueOf(targetObjectName) + ".ptrs", markerName);
        }
        ArraySupport.getObjectIDs().put(markerName, ids);
        ArraySupport.getObjectIDs().put(targetObjectName, String.valueOf(ArraySupport.getObjectIDs().getProperty(targetObjectName)) + ' ' + ids);
        ArraySupport.getObjectProperties().put(String.valueOf(markerName) + ".target", targetObjectName);
        ArraySupport.getObjectProperties().put(String.valueOf(markerName) + ".pos", targetIndex);
        ArraySupport.getObjectTypes().put(markerName, ArraySupport.getTypeIdentifier("arraymarker"));
        AnimalParseSupport.showComponents(stok, ids, localType, true);
    }

    public void parseArrayPut() throws IOException {
        ParseSupport.parseWord(stok, "data structure-specific operator");
        String arrayName = null;
        String objectValue = AnimalParseSupport.parseText(stok, "arrayPut value", null, false, chosenLanguage);
        ParseSupport.parseMandatoryWord(stok, "arrayPut keyword 'on'", "on");
        arrayName = AnimalParseSupport.parseText(stok, "arrayPut base array");
        int[] arrayIDs = ArraySupport.getObjectIDs().getIntArrayProperty(arrayName);
        if (arrayIDs == null || !ArraySupport.getObjectTypes().getProperty(arrayName).equals(ArraySupport.getTypeIdentifier("array"))) {
            ParseSupport.formatException("Target object '" + arrayName + "' unknown or not an array.", stok);
        }
        ParseSupport.parseMandatoryWord(stok, "arrayPut keyword 'position'", "position");
        int maxLength = ArraySupport.getObjectProperties().getIntProperty(String.valueOf(arrayName) + ".length", -1);
        if (maxLength < 1) {
            ParseSupport.formatException("Invalid number of elements in array '" + arrayName + "'.", stok);
        }
        int targetPos = ParseSupport.parseInt(stok, "arrayPut target pos [0, " + (maxLength - 1) + "]", 0, maxLength - 1);
        String defaultEntry = String.valueOf(arrayName) + "[" + targetPos + "]";
        Font f = ArraySupport.getObjectProperties().getFontProperty(String.valueOf(arrayName) + ".font");
        FontMetrics fm = Animal.getConcreteFontMetrics(f);
        int textWidth = fm.stringWidth(objectValue);
        int originalArrayCellID = arrayIDs[maxLength + targetPos];
        PTGraphicObject ptgo = animState.getCloneByNum(originalArrayCellID);
        Rectangle originalArrayCellBB = ptgo.getBoundingBox();
        boolean verticalMode = ArraySupport.getObjectProperties().getProperty(String.valueOf(arrayName) + ".orientation").equalsIgnoreCase("vertical");
        TimedShow hideOldElement = new TimedShow(currentStep, arrayIDs[targetPos], 0, null, false);
        AnimalParseSupport.parseTiming(stok, hideOldElement, "hide");
        BasicParser.addAnimatorToAnimation(hideOldElement, anim);
        ArraySupport.getCurrentlyVisible().put(String.valueOf(arrayIDs[targetPos]), "false");
        PTText newValue = new PTText(objectValue, f);
        newValue.setObjectName(defaultEntry);
        newValue.setLocation(new Point(originalArrayCellBB.x + 3, originalArrayCellBB.height + originalArrayCellBB.y - 8));
        newValue.setColor(ArraySupport.getObjectProperties().getColorProperty(String.valueOf(arrayName) + ".elementColor", Color.black));
        newValue.setDepth(ptgo.getDepth() - 1);
        BasicParser.addGraphicObject(newValue, anim);
        ArraySupport.getObjectIDs().put(defaultEntry, newValue.getNum(false));
        arrayIDs[targetPos] = newValue.getNum(false);
        ArraySupport.getObjectIDs().put(arrayName, arrayIDs);
        ArraySupport.getObjectTypes().put(defaultEntry, ArraySupport.getTypeIdentifier("text"));
        TimedShow showNewElement = new TimedShow(currentStep, newValue.getNum(false), 0, null, true);
        showNewElement.copyTimingFrom(hideOldElement);
        BasicParser.addAnimatorToAnimation(showNewElement, anim);
        ArraySupport.getCurrentlyVisible().put(String.valueOf(newValue.getNum(false)), "true");
        if (!verticalMode) {
            this.updateHArrayAfterPut(originalArrayCellBB, textWidth, originalArrayCellID, arrayName, targetPos, maxLength, arrayIDs, hideOldElement);
        } else {
            this.updateVArrayAfterPut(originalArrayCellBB, textWidth, originalArrayCellID, arrayName, targetPos, maxLength, arrayIDs, hideOldElement, newValue);
        }
        String unparsed = ParseSupport.consumeIncludingEOL(stok, "ds specific stuff");
        if (unparsed.length() > 1) {
            System.err.println("#Left unparsed...: '" + unparsed + "'");
        }
        stok.pushBack();
    }

    public void parseArraySwap() throws IOException {
        String localType = ParseSupport.parseWord(stok, "data structure-specific operator");
        String arrayName = null;
        ParseSupport.parseMandatoryWord(stok, String.valueOf(localType) + " keyword 'on'", "on");
        arrayName = AnimalParseSupport.parseText(stok, String.valueOf(localType) + " base array name");
        int[] arrayIDs = ArraySupport.getObjectIDs().getIntArrayProperty(arrayName);
        ParseSupport.parseMandatoryWord(stok, String.valueOf(localType) + " keyword 'position'", "position");
        int maxLength = ArraySupport.getObjectProperties().getIntProperty(String.valueOf(arrayName) + ".length");
        int firstSwapPos = ParseSupport.parseInt(stok, String.valueOf(localType) + " first position", 0, maxLength - 1);
        ParseSupport.parseMandatoryWord(stok, String.valueOf(localType) + " keyword 'with'", "with");
        int secondSwapPos = ParseSupport.parseInt(stok, String.valueOf(localType) + " second position", 0, maxLength - 1);
        int minPos = firstSwapPos < secondSwapPos ? firstSwapPos : secondSwapPos;
        int maxPos = firstSwapPos > secondSwapPos ? firstSwapPos : secondSwapPos;
        int minElemID = ArraySupport.getObjectIDs().getIntProperty(String.valueOf(arrayName) + "[" + minPos + "]");
        int maxElemID = ArraySupport.getObjectIDs().getIntProperty(String.valueOf(arrayName) + "[" + maxPos + "]");
        int minBoxID = ArraySupport.getObjectIDs().getIntProperty(String.valueOf(arrayName) + "[" + minPos + "].box");
        int maxBoxID = ArraySupport.getObjectIDs().getIntProperty(String.valueOf(arrayName) + "[" + maxPos + "].box");
        PTGraphicObject ptgo = animState.getCloneByNum(minBoxID);
        Rectangle minBB = ptgo.getBoundingBox();
        ptgo = animState.getCloneByNum(maxBoxID);
        Rectangle maxBB = ptgo.getBoundingBox();
        boolean horizontalMode = ArraySupport.getObjectProperties().getProperty(String.valueOf(arrayName) + ".orientation").equals("horizontal");
        Point[] boxExchanger = new Point[]{minBB.getLocation(), horizontalMode ? new Point(maxBB.x + maxBB.width - minBB.width, maxBB.y) : new Point(maxBB.x, maxBB.y + maxBB.height - minBB.height)};
        PTPolyline boxMover = new PTPolyline(boxExchanger);
        boxMover.setObjectName("boxMoveLine1");
        int[] moveIDs = new int[]{minBoxID};
        BasicParser.addGraphicObject(boxMover, anim);
        Move move = new Move(currentStep, moveIDs, 0, "translate", boxMover.getNum(false));
        AnimalParseSupport.parseTiming(stok, move, String.valueOf(localType) + " operation");
        boolean ticksMode = move.isUnitIsTicks();
        int durationOfWholeOperation = move.getDuration();
        int offsetForWholeOperation = move.getOffset();
        move.setDuration(0);
        BasicParser.addAnimatorToAnimation(move, anim);
        ArraySupport.getObjectIDs().put(String.valueOf(arrayName) + "[" + maxPos + "].box", minBoxID);
        boxExchanger[0] = maxBB.getLocation();
        boxExchanger[1] = minBB.getLocation();
        boxMover = new PTPolyline(boxExchanger);
        boxMover.setObjectName("boxMoveLine2");
        BasicParser.addGraphicObject(boxMover, anim);
        moveIDs = new int[]{maxBoxID};
        move = new Move(currentStep, moveIDs, 0, "translate", boxMover.getNum(false));
        move.setOffset(offsetForWholeOperation);
        move.setUnitIsTicks(ticksMode);
        move.setDuration(durationOfWholeOperation);
        BasicParser.addAnimatorToAnimation(move, anim);
        ArraySupport.getObjectIDs().put(String.valueOf(arrayName) + "[" + minPos + "].box", maxBoxID);
        arrayIDs[maxLength + minPos] = maxBoxID;
        arrayIDs[maxLength + maxPos] = minBoxID;
        if (maxPos > minPos) {
            StringBuilder fullUpdateIDs = new StringBuilder(200);
            StringBuilder halfUpdateIDs = new StringBuilder(50);
            int[] fullIDs = null;
            int[] halfIDs = null;
            int i = minPos + 1;
            while (i < maxPos) {
                fullUpdateIDs.append(ArraySupport.getObjectIDs().getIntProperty(String.valueOf(arrayName) + "[" + i + "].box")).append(' ');
                fullUpdateIDs.append(ArraySupport.getObjectIDs().getIntProperty(String.valueOf(arrayName) + "[" + i + "]")).append(' ');
                ++i;
            }
            String registeredMarkers = ArraySupport.getObjectProperties().getProperty(String.valueOf(arrayName) + ".ptrs");
            if (registeredMarkers != null) {
                StringTokenizer stringTok = new StringTokenizer(registeredMarkers);
                while (stringTok.hasMoreTokens()) {
                    String currentPointerName = stringTok.nextToken();
                    int currentPointerPos = ArraySupport.getObjectProperties().getIntProperty(String.valueOf(currentPointerName) + ".pos");
                    if (currentPointerPos < minPos || currentPointerPos > maxPos) continue;
                    int[] pointerIDs = ArraySupport.getObjectIDs().getIntArrayProperty(currentPointerName);
                    if (currentPointerPos != minPos && currentPointerPos != maxPos) {
                        if (pointerIDs.length == 2) {
                            fullUpdateIDs.append(pointerIDs[1]).append(" ");
                        }
                        fullUpdateIDs.append(pointerIDs[0]).append(" ");
                        continue;
                    }
                    if (pointerIDs.length == 2) {
                        halfUpdateIDs.append(pointerIDs[1]).append(" ");
                    }
                    halfUpdateIDs.append(pointerIDs[0]).append(" ");
                }
                stringTok = new StringTokenizer(fullUpdateIDs.toString());
                int n = stringTok.countTokens();
                if (n > 0) {
                    fullIDs = new int[n];
                    i = 0;
                    while (i < n) {
                        try {
                            fullIDs[i] = Integer.valueOf(stringTok.nextToken());
                        }
                        catch (NumberFormatException e) {
                            System.err.println("Could not determine int #" + i + "/" + fullUpdateIDs.toString());
                        }
                        ++i;
                    }
                }
                if ((n = (stringTok = new StringTokenizer(halfUpdateIDs.toString())).countTokens()) > 0) {
                    halfIDs = new int[n];
                    i = 0;
                    while (i < n) {
                        try {
                            halfIDs[i] = Integer.valueOf(stringTok.nextToken());
                        }
                        catch (NumberFormatException e) {
                            System.err.println("Could not determine int #" + i + "/" + halfUpdateIDs.toString());
                        }
                        ++i;
                    }
                }
            }
            this.updateArrayBoxesAndPointers(fullIDs, halfIDs, minBB, maxBB, offsetForWholeOperation, move.isUnitIsTicks());
        }
        Point[] firstMovePoints = new Point[4];
        Point[] secondMovePoints = new Point[4];
        firstMovePoints[0] = minBB.getLocation();
        secondMovePoints[0] = maxBB.getLocation();
        secondMovePoints[3] = minBB.getLocation();
        if (horizontalMode) {
            firstMovePoints[3] = new Point(maxBB.x + maxBB.width - minBB.width, maxBB.y);
            firstMovePoints[1] = new Point(firstMovePoints[0].x, firstMovePoints[0].y - minBB.height - 5);
            firstMovePoints[2] = new Point(firstMovePoints[3].x, firstMovePoints[1].y);
            secondMovePoints[1] = new Point(secondMovePoints[0].x, secondMovePoints[0].y + maxBB.height + 5);
            secondMovePoints[2] = new Point(secondMovePoints[3].x, secondMovePoints[1].y);
        } else {
            firstMovePoints[3] = new Point(maxBB.x, maxBB.y + maxBB.height - minBB.height);
            firstMovePoints[1] = new Point(firstMovePoints[0].x + minBB.width + 5, firstMovePoints[0].y);
            firstMovePoints[2] = new Point(firstMovePoints[1].x, firstMovePoints[3].y);
            secondMovePoints[1] = new Point(secondMovePoints[0].x - maxBB.width - 5, secondMovePoints[0].y);
            secondMovePoints[2] = new Point(secondMovePoints[1].x, secondMovePoints[3].y);
        }
        boxMover = new PTPolyline(firstMovePoints);
        boxMover.setObjectName("boxMoveLine3");
        moveIDs = new int[]{minElemID};
        BasicParser.addGraphicObject(boxMover, anim);
        move = new Move(currentStep, moveIDs, durationOfWholeOperation, "translate", boxMover.getNum(false));
        move.setOffset(offsetForWholeOperation);
        move.setUnitIsTicks(ticksMode);
        move.setDuration(durationOfWholeOperation);
        BasicParser.addAnimatorToAnimation(move, anim);
        boxMover = new PTPolyline(secondMovePoints);
        boxMover.setObjectName("boxMoveLine4");
        moveIDs = new int[]{maxElemID};
        BasicParser.addGraphicObject(boxMover, anim);
        move = new Move(currentStep, moveIDs, durationOfWholeOperation, "translate", boxMover.getNum(false));
        move.setOffset(offsetForWholeOperation);
        move.setUnitIsTicks(ticksMode);
        move.setDuration(durationOfWholeOperation);
        BasicParser.addAnimatorToAnimation(move, anim);
        arrayIDs[minPos] = maxElemID;
        arrayIDs[maxPos] = minElemID;
        ArraySupport.getObjectIDs().put(arrayName, arrayIDs);
        ArraySupport.getObjectIDs().put(String.valueOf(arrayName) + "[" + minPos + "]", maxElemID);
        ArraySupport.getObjectIDs().put(String.valueOf(arrayName) + "[" + maxPos + "]", minElemID);
        String unparsed = ParseSupport.consumeIncludingEOL(stok, "ds specific stuff");
        if (unparsed.length() > 1) {
            System.err.println("#Left unparsed...: '" + unparsed + "'");
        }
        stok.pushBack();
    }

    public void parseColorChange() throws IOException {
        String colorType = ParseSupport.parseWord(stok, "color change operation");
        ColorChanger colChanger = null;
        Color c = null;
        int[] targetOIDs = null;
        boolean elemMode = colorType.toLowerCase().endsWith("elem");
        boolean highlightMode = colorType.startsWith("high");
        ParseSupport.parseMandatoryWord(stok, String.valueOf(colorType) + " keyword 'on'", "on");
        String targetArray = AnimalParseSupport.parseText(stok, String.valueOf(colorType) + " array name");
        if (ParseSupport.parseOptionalWord(stok, String.valueOf(colorType) + " keyword 'position'", "position")) {
            if (ArraySupport.getObjectProperties().getIntProperty(String.valueOf(targetArray) + ".length", -2) == -2) {
                XProperties helper = ArraySupport.getObjectProperties().getElementsForPrefix(targetArray);
                helper.list(System.out);
            }
            int targetLine = ParseSupport.parseInt(stok, String.valueOf(colorType) + " array index", 0, ArraySupport.getObjectProperties().getIntProperty(String.valueOf(targetArray) + ".length", 0));
            targetOIDs = new int[]{ArraySupport.getObjectIDs().getIntProperty(String.valueOf(targetArray) + "[" + targetLine + (elemMode ? "]" : "].box"))};
        } else {
            int fromRange = 0;
            int toRange = ArraySupport.getObjectProperties().getIntProperty(String.valueOf(targetArray) + ".length") - 1;
            if (ParseSupport.parseOptionalWord(stok, String.valueOf(colorType) + " cell/element range keyword 'from'", "from")) {
                fromRange = ParseSupport.parseInt(stok, String.valueOf(colorType) + " array index", 0, ArraySupport.getObjectProperties().getIntProperty(String.valueOf(targetArray) + ".length"));
            }
            if (ParseSupport.parseOptionalWord(stok, String.valueOf(colorType) + " cell/element range keyword 'to'", "to")) {
                toRange = ParseSupport.parseInt(stok, String.valueOf(colorType) + " array index", fromRange, ArraySupport.getObjectProperties().getIntProperty(String.valueOf(targetArray) + ".length"));
            }
            targetOIDs = new int[toRange - fromRange + 1];
            int i = 0;
            while (fromRange <= toRange) {
                targetOIDs[i] = ArraySupport.getObjectIDs().getIntProperty(String.valueOf(targetArray) + "[" + fromRange + (elemMode ? "]" : "].box"));
                ++fromRange;
                ++i;
            }
        }
        c = elemMode ? (highlightMode ? ArraySupport.getObjectProperties().getColorProperty(String.valueOf(targetArray) + ".elemHighlight", Color.blue) : ArraySupport.getObjectProperties().getColorProperty(String.valueOf(targetArray) + ".elementColor", Color.black)) : (highlightMode ? ArraySupport.getObjectProperties().getColorProperty(String.valueOf(targetArray) + ".cellHighlight", Color.yellow) : ArraySupport.getObjectProperties().getColorProperty(String.valueOf(targetArray) + ".fillColor", Color.white));
        colChanger = new ColorChanger(currentStep, targetOIDs, 0, elemMode ? "color" : "fillColor", c);
        AnimalParseSupport.parseTiming(stok, colChanger, "Color");
        BasicParser.addAnimatorToAnimation(colChanger, anim);
    }

    public void parseMovePointer() throws IOException {
        int targetElementOID;
        String localType = ParseSupport.parseWord(stok, "move pointer keyword");
        String targetIDName = AnimalParseSupport.parseText(stok, "index marker name");
        int[] targetOIDs = ArraySupport.getObjectIDs().getIntArrayProperty(targetIDName);
        PTGraphicObject moveLine = null;
        PTGraphicObject ptgo = animState.getCloneByNum(targetOIDs[0]);
        String baseElementName = ArraySupport.getObjectProperties().getProperty(String.valueOf(targetIDName) + ".target");
        Rectangle boundingBox = ptgo.getBoundingBox();
        Point[] points = new Point[2];
        points[0] = new Point(boundingBox.x + boundingBox.width, boundingBox.y + boundingBox.height);
        if (targetOIDs == null || !ArraySupport.getObjectTypes().getProperty(targetIDName).equals(ArraySupport.getTypeIdentifier("arraymarker")) || !ArraySupport.getObjectTypes().getProperty(baseElementName).equals(ArraySupport.getTypeIdentifier("array"))) {
            ParseSupport.formatException("invalid or unknown array ID: " + targetIDName, stok);
        }
        ParseSupport.parseMandatoryWord(stok, "index marker keyword 'to'", "to");
        int maxIndex = ArraySupport.getObjectProperties().getIntProperty(String.valueOf(baseElementName) + ".length", -1);
        if (ParseSupport.parseOptionalWord(stok, "index marker keyword 'position'", "position")) {
            int targetPos = ParseSupport.parseInt(stok, "index marker position value [0, " + maxIndex + "]", 0, maxIndex);
            int targetElementOID2 = ArraySupport.getObjectIDs().getIntProperty(String.valueOf(baseElementName) + "[" + targetPos + "].box", -1);
            ptgo = animState.getCloneByNum(targetElementOID2);
            boundingBox = ptgo.getBoundingBox();
            points[1] = ArraySupport.getObjectProperties().getProperty(String.valueOf(baseElementName) + ".orientation").equals("horizontal") ? new Point(boundingBox.x + (boundingBox.width >>> 1), boundingBox.y) : new Point(boundingBox.x, boundingBox.y + (boundingBox.height >>> 1));
            moveLine = new PTPolyline(points);
            ArraySupport.getObjectProperties().put(String.valueOf(targetIDName) + ".pos", targetPos);
        } else if (ParseSupport.parseOptionalWord(stok, "index marker keyword 'arrayEnd'", "arrayEnd")) {
            targetElementOID = ArraySupport.getObjectIDs().getIntProperty(String.valueOf(baseElementName) + "[" + maxIndex + "].box", -1);
            ptgo = animState.getCloneByNum(targetElementOID);
            boundingBox = ptgo.getBoundingBox();
            points[1] = ArraySupport.getObjectProperties().getProperty(String.valueOf(baseElementName) + ".orientation").equals("horizontal") ? new Point(boundingBox.x + (boundingBox.width >>> 1), boundingBox.y) : new Point(boundingBox.x, boundingBox.y + (boundingBox.height >>> 1));
            moveLine = new PTPolyline(points);
        } else if (ParseSupport.parseOptionalWord(stok, "index marker keyword 'outside'", "outside")) {
            targetElementOID = ArraySupport.getObjectIDs().getIntProperty(String.valueOf(baseElementName) + "[" + (maxIndex - 1) + "].box", -1);
            ptgo = animState.getCloneByNum(targetElementOID);
            boundingBox = ptgo.getBoundingBox();
            points[1] = ArraySupport.getObjectProperties().getProperty(String.valueOf(baseElementName) + ".orientation").equals("horizontal") ? new Point(boundingBox.x + boundingBox.width + 20, boundingBox.y) : new Point(boundingBox.x, boundingBox.y + boundingBox.height + 20);
            moveLine = new PTPolyline(points);
        } else {
            ParseSupport.formatException("invalid keyword for array marker move", stok);
        }
        int[] oid = targetOIDs;
        moveLine.setObjectName("moveLine3");
        BasicParser.addGraphicObject(moveLine, anim);
        int moveBaseNum = moveLine.getNum(false);
        Move move = new Move(currentStep, oid, 0, "translate", moveBaseNum);
        AnimalParseSupport.parseTiming(stok, move, "Array Marker Move");
        if (localType.equalsIgnoreCase("jump") && move.getDuration() != 0) {
            MessageDisplay.message("'jump' can not have a duration - use 'move' instead in line " + stok.lineno());
            move.setDuration(0);
        }
        BasicParser.addAnimatorToAnimation(move, anim);
    }

    public void updateHArrayAfterPut(Rectangle originalArrayCellBB, int textWidth, int originalArrayCellID, String arrayName, int targetPos, int maxLength, int[] arrayIDs, TimedShow hideOldElement) {
        int moveIDSize;
        Point[] coords = new Point[]{new Point(originalArrayCellBB.x + originalArrayCellBB.width, originalArrayCellBB.y + originalArrayCellBB.height + 50), new Point(originalArrayCellBB.x + textWidth + 5, originalArrayCellBB.y + originalArrayCellBB.height + 50)};
        PTPolyline oldBoxMove = new PTPolyline(coords);
        BasicParser.addGraphicObject(oldBoxMove, anim);
        int[] moveIDs = new int[]{originalArrayCellID};
        Move move = new Move(currentStep, moveIDs, 0, "translateNodes 3 4", oldBoxMove.getNum(false));
        move.copyTimingFrom(hideOldElement);
        BasicParser.addAnimatorToAnimation(move, anim);
        int pos = 0;
        String registeredMarkers = ArraySupport.getObjectProperties().getProperty(String.valueOf(arrayName) + ".ptrs");
        int fullPos = 0;
        int partialPos = 0;
        int[] tmpFullMoveIDs = null;
        int[] tmpPartialMoveIDs = null;
        if (registeredMarkers != null) {
            StringTokenizer stringTok = new StringTokenizer(registeredMarkers);
            tmpFullMoveIDs = new int[stringTok.countTokens() << 1];
            tmpPartialMoveIDs = new int[stringTok.countTokens() << 1];
            while (stringTok.hasMoreTokens()) {
                String currentPointerName = stringTok.nextToken();
                int currentPointerPos = ArraySupport.getObjectProperties().getIntProperty(String.valueOf(currentPointerName) + ".pos");
                if (currentPointerPos < targetPos) continue;
                int[] pointerIDs = ArraySupport.getObjectIDs().getIntArrayProperty(currentPointerName);
                if (currentPointerPos > targetPos) {
                    if (pointerIDs.length == 2) {
                        tmpFullMoveIDs[fullPos++] = pointerIDs[1];
                    }
                    tmpFullMoveIDs[fullPos++] = pointerIDs[0];
                    continue;
                }
                if (pointerIDs.length == 2) {
                    tmpPartialMoveIDs[partialPos++] = pointerIDs[1];
                }
                tmpPartialMoveIDs[partialPos++] = pointerIDs[0];
            }
        }
        if ((moveIDSize = (maxLength - targetPos - 1 << 1) + fullPos) > 0) {
            moveIDs = new int[(maxLength - targetPos - 1 << 1) + fullPos];
            pos = 0;
            int i = targetPos + 1;
            while (i < maxLength) {
                moveIDs[pos++] = arrayIDs[i];
                ++i;
            }
            i = maxLength + targetPos + 1;
            while (i < maxLength << 1) {
                moveIDs[pos++] = arrayIDs[i];
                ++i;
            }
            i = 0;
            while (i < fullPos) {
                moveIDs[pos++] = tmpFullMoveIDs[i];
                ++i;
            }
            move = new Move(currentStep, moveIDs, 0, "translate", oldBoxMove.getNum(false));
            move.copyTimingFrom(hideOldElement);
            BasicParser.addAnimatorToAnimation(move, anim);
        }
        if (partialPos > 0) {
            Point[] partialMoveCoords = null;
            int dx = textWidth + 5 - originalArrayCellBB.width;
            partialMoveCoords = dx >= 0 ? new Point[]{new Point(0, 20), new Point(textWidth + 5 - originalArrayCellBB.width >>> 1, 20)} : new Point[]{new Point(-dx >>> 1, 20), new Point(0, 20)};
            PTPolyline markerBoxMove = new PTPolyline(partialMoveCoords);
            BasicParser.addGraphicObject(markerBoxMove, anim);
            int[] actualMoveTargets = new int[partialPos];
            System.arraycopy(tmpPartialMoveIDs, 0, actualMoveTargets, 0, partialPos);
            move = new Move(currentStep, actualMoveTargets, 0, "translate", markerBoxMove.getNum(false));
            move.copyTimingFrom(hideOldElement);
            BasicParser.addAnimatorToAnimation(move, anim);
        }
    }

    public void updateArrayBoxesAndPointers(int[] boxIDs, int[] pointerIDs, Rectangle originalArrayCellBB, Rectangle newBB, int offset, boolean unitIsTicks) {
        boolean needUpdate;
        boolean bl = needUpdate = originalArrayCellBB.width != newBB.width || originalArrayCellBB.height != newBB.height;
        if (needUpdate) {
            Move move;
            if (boxIDs != null) {
                Point[] boxMovePoints = new Point[]{new Point(originalArrayCellBB.width, originalArrayCellBB.height), new Point(newBB.width, newBB.height)};
                PTPolyline boxMoveLine = new PTPolyline(boxMovePoints);
                boxMoveLine.setObjectName("boxMoveLine");
                BasicParser.addGraphicObject(boxMoveLine, anim);
                move = new Move(currentStep, boxIDs, 0, "translate", boxMoveLine.getNum(false));
                move.setOffset(offset);
                move.setUnitIsTicks(unitIsTicks);
                BasicParser.addAnimatorToAnimation(move, anim);
            }
            if (pointerIDs != null) {
                Point[] pointerMovePoints = new Point[]{new Point(originalArrayCellBB.width >>> 1, originalArrayCellBB.height >>> 1), new Point(newBB.width >>> 1, newBB.height >>> 1)};
                PTPolyline pointerMoveLine = new PTPolyline(pointerMovePoints);
                pointerMoveLine.setObjectName("pointerMoveLine");
                BasicParser.addGraphicObject(pointerMoveLine, anim);
                move = new Move(currentStep, pointerIDs, 0, "translate", pointerMoveLine.getNum(false));
                move.setOffset(offset);
                move.setUnitIsTicks(unitIsTicks);
                BasicParser.addAnimatorToAnimation(move, anim);
            }
        }
    }

    public void updateVArrayAfterPut(Rectangle originalArrayCellBB, int textWidth, int originalArrayCellID, String arrayName, int targetPos, int maxLength, int[] arrayIDs, TimedShow hideOldElement, PTText newValue) {
        boolean checkForResize;
        int maxWidth = -1;
        int i = 0;
        while (i < maxLength) {
            int valueID = ArraySupport.getObjectIDs().getIntProperty(String.valueOf(arrayName) + "[" + i + "]", -1);
            PTGraphicObject currentValue = animState.getCloneByNum(valueID);
            if (currentValue != null && currentValue.getBoundingBox().getWidth() > (double)maxWidth) {
                maxWidth = (int)currentValue.getBoundingBox().getWidth();
            }
            ++i;
        }
        boolean bl = checkForResize = textWidth + 5 >= maxWidth || maxWidth + 5 < originalArrayCellBB.width;
        if (checkForResize) {
            Point[] coords = new Point[]{new Point(originalArrayCellBB.width, originalArrayCellBB.height + 50), new Point(maxWidth + 5, originalArrayCellBB.height + 50)};
            PTPolyline oldBoxMove = new PTPolyline(coords);
            BasicParser.addGraphicObject(oldBoxMove, anim);
            int[] moveIDs = new int[maxLength];
            int i2 = 0;
            while (i2 < maxLength) {
                int loopBoxID = ArraySupport.getObjectIDs().getIntProperty(String.valueOf(arrayName) + "[" + i2 + "].box", -1);
                if (loopBoxID != -1) {
                    moveIDs[i2] = loopBoxID;
                }
                ++i2;
            }
            Move move = new Move(currentStep, moveIDs, 0, "translateNodes 3 4", oldBoxMove.getNum(false));
            move.copyTimingFrom(hideOldElement);
            BasicParser.addAnimatorToAnimation(move, anim);
        }
    }
}

