/*
 * Decompiled with CFR 0.152.
 */
package animalscript.extensions;

import animal.animator.TimedShow;
import animal.graphics.PTGraphicObject;
import animal.graphics.PTPolyline;
import animal.graphics.PTText;
import animal.main.Animal;
import animalscript.core.AnimalParseSupport;
import animalscript.core.BasicParser;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.IOException;
import java.io.StreamTokenizer;

public class ArrayProducer
extends BasicParser {
    public static void makeArray(String arrayName, Point basePoint, Color arrayColor, Color fillColor, Color elementColor, boolean verticalMode, int arrayLength, String[] elements, int basicDepth, int displayDelay, boolean cascadedDisplay, int displayDuration, int[] oids, int[] entryIDs, StringBuilder components, Font f, String unit, StreamTokenizer stok) {
        int i;
        int textPixelWidth = 0;
        int textPixelHeight = 0;
        FontMetrics fm = Animal.getConcreteFontMetrics(f);
        textPixelHeight = fm.getMaxAscent() + fm.getMaxDescent();
        PTPolyline textBox = null;
        PTText textEntry = null;
        int[] nArray = new int[4];
        nArray[0] = basePoint.x;
        nArray[1] = basePoint.x;
        int[] xCoords = nArray;
        int[] nArray2 = new int[4];
        nArray2[0] = basePoint.y;
        nArray2[3] = basePoint.y;
        int[] yCoords = nArray2;
        int maxElementLength = -1;
        int oidPosition = 0;
        int displayStep = displayDuration / arrayLength;
        int currentDelay = displayDelay;
        TimedShow ts = new TimedShow();
        if (verticalMode) {
            i = 0;
            while (i < arrayLength) {
                if (fm.stringWidth(elements[i]) > maxElementLength) {
                    maxElementLength = fm.stringWidth(elements[i]);
                }
                ++i;
            }
            xCoords[2] = xCoords[0] + maxElementLength + 5;
            xCoords[3] = xCoords[2];
        }
        i = 0;
        while (i < arrayLength) {
            textPixelWidth = fm.stringWidth(elements[i]);
            if (!verticalMode) {
                xCoords[2] = xCoords[0] + textPixelWidth + 5;
                xCoords[3] = xCoords[2];
            }
            yCoords[1] = yCoords[0] + textPixelHeight + 5;
            yCoords[2] = yCoords[1];
            textBox = new PTPolyline(xCoords, yCoords);
            textBox.setObjectName(String.valueOf(arrayName) + "[" + i + "].box");
            textBox.setClosed(true);
            textBox.setFilled(true);
            textBox.setColor(arrayColor);
            textBox.setFillColor(fillColor);
            textBox.setDepth(basicDepth + 1);
            ArrayProducer.getObjectTypes().put(String.valueOf(arrayName) + "[" + i + "].box", ArrayProducer.getTypeIdentifier("polyline"));
            textEntry = new PTText(elements[i], f);
            textEntry.setObjectName(String.valueOf(arrayName) + "[" + i + "]");
            textEntry.setDepth(basicDepth);
            textEntry.setColor(elementColor);
            textEntry.setLocation(new Point(xCoords[0] + 3, yCoords[1] - 8));
            ArrayProducer.getObjectTypes().put(String.valueOf(arrayName) + "[" + i + "]", ArrayProducer.getTypeIdentifier("text"));
            BasicParser.addGraphicObject(textBox, anim);
            BasicParser.addGraphicObject(textEntry, anim);
            oids[oidPosition++] = textBox.getNum(false);
            oids[oidPosition++] = textEntry.getNum(false);
            components.append(textBox.getNum(false)).append(' ');
            components.append(textEntry.getNum(false)).append(' ');
            entryIDs[i] = textEntry.getNum(false);
            entryIDs[arrayLength + i] = textBox.getNum(false);
            ArrayProducer.getObjectIDs().put(String.valueOf(arrayName) + "[" + i + "].box", oids[oidPosition - 2]);
            ArrayProducer.getObjectIDs().put(String.valueOf(arrayName) + "[" + i + "]", oids[oidPosition - 1]);
            ArrayProducer.getObjectTypes().put(String.valueOf(arrayName) + "[" + i + "].box", ArrayProducer.getTypeIdentifier("polyline"));
            ArrayProducer.getObjectTypes().put(String.valueOf(arrayName) + "[" + i + "]", ArrayProducer.getTypeIdentifier("text"));
            if (displayDuration != 0) {
                ts = new TimedShow(currentStep, oids, 0, null, displayDelay >= 0);
                ts.setOffset(currentDelay);
                ts.setUnitIsTicks(unit.equalsIgnoreCase("ticks"));
                BasicParser.addAnimatorToAnimation(ts, anim);
                currentDelay += displayStep;
                oids = new int[2];
                oidPosition = 0;
            }
            if (verticalMode) {
                yCoords[0] = yCoords[1];
                yCoords[3] = yCoords[1];
            } else {
                xCoords[0] = xCoords[2];
                xCoords[1] = xCoords[2];
            }
            ++i;
        }
        if (displayDuration == 0) {
            ts = new TimedShow(currentStep, oids, 0, null, displayDelay >= 0);
            ts.setOffset(currentDelay);
            ts.setUnitIsTicks(unit.equalsIgnoreCase("ticks"));
            BasicParser.addAnimatorToAnimation(ts, anim);
        }
        xCoords[0] = basePoint.x;
        yCoords[0] = basePoint.y;
        xCoords[1] = xCoords[0];
        yCoords[3] = yCoords[0];
        textBox = new PTPolyline(xCoords, yCoords);
        textBox.setObjectName(arrayName);
        textBox.setClosed(true);
        textBox.setFilled(false);
        textBox.setColor(arrayColor);
        textBox.setFillColor(fillColor);
        textBox.setDepth(basicDepth + 1);
        BasicParser.addGraphicObject(textBox, anim);
        ArrayProducer.getObjectIDs().put(arrayName, entryIDs);
        i = 0;
        while (i < entryIDs.length) {
            ArrayProducer.getCurrentlyVisible().put(String.valueOf(entryIDs[i]), "true");
            ++i;
        }
        ArrayProducer.getObjectIDs().put(String.valueOf(arrayName) + ".bBox", textBox.getNum(false));
        ArrayProducer.getObjectProperties().put(String.valueOf(arrayName) + ".orientation", verticalMode ? "vertical" : "horizontal");
        ArrayProducer.getObjectProperties().put(String.valueOf(arrayName) + ".font", f);
        ArrayProducer.getObjectTypes().put(arrayName, ArrayProducer.getTypeIdentifier("array"));
    }

    public void arrayMarker(String localType, String markerName, String markerLabel, PTText labelText, String basicTag, String targetObjectName, int[] targetOIDs, int maxLength, int targetIndex, PTPolyline indexMarker, Point[] coords) throws IOException {
        String ids;
        int indexOID = targetOIDs[maxLength + targetIndex];
        PTGraphicObject ptgo = animState.getCloneByNum(indexOID);
        Rectangle boundingBox = ptgo.getBoundingBox();
        if (ArrayProducer.getObjectProperties().getProperty(String.valueOf(targetObjectName) + ".orientation").equals("horizontal")) {
            coords[1] = new Point(boundingBox.x + (boundingBox.width >>> 1), boundingBox.y);
            coords[0] = new Point(coords[1].x, boundingBox.y - 40);
        } else {
            coords[1] = new Point(boundingBox.x, boundingBox.y + (boundingBox.height >>> 1));
            coords[0] = new Point(boundingBox.x - 40, coords[1].y);
        }
        indexMarker.setObjectName(String.valueOf(markerLabel) + ".ptr");
        indexMarker.setFWArrow(true);
        if (markerLabel != null) {
            Font f = new Font("Serif", 0, 16);
            labelText = new PTText(markerLabel, f);
            labelText.setObjectName(markerLabel);
            FontMetrics fm = Animal.getConcreteFontMetrics(f);
            int textWidth = fm.stringWidth(markerLabel);
            if (ArrayProducer.getObjectProperties().getProperty(String.valueOf(targetObjectName) + ".orientation").equals("horizontal")) {
                labelText.setLocation(new Point(coords[0].x - (textWidth >>> 1), coords[0].y - 5));
            } else {
                labelText.setLocation(new Point(coords[0].x - textWidth - 5, coords[0].y + 8));
            }
            BasicParser.addGraphicObject(labelText, anim);
            ArrayProducer.getObjectIDs().put(String.valueOf(markerName) + ".label", labelText.getNum(false));
        }
        BasicParser.addGraphicObject(indexMarker, anim);
        String markerID = String.valueOf(indexMarker.getNum(false));
        String string = ids = labelText == null ? markerID : String.valueOf(markerID) + " " + String.valueOf(labelText.getNum(false));
        if (ArrayProducer.getObjectProperties().getProperty(String.valueOf(targetObjectName) + ".ptrs") != null) {
            ArrayProducer.getObjectProperties().put(String.valueOf(targetObjectName) + ".ptrs", String.valueOf(ArrayProducer.getObjectProperties().getProperty(String.valueOf(targetObjectName) + ".ptrs")) + " " + markerName);
        } else {
            ArrayProducer.getObjectProperties().put(String.valueOf(targetObjectName) + ".ptrs", markerName);
        }
        ArrayProducer.getObjectIDs().put(markerName, ids);
        ArrayProducer.getObjectIDs().put(targetObjectName, String.valueOf(ArrayProducer.getObjectIDs().getProperty(targetObjectName)) + ' ' + ids);
        ArrayProducer.getObjectProperties().put(String.valueOf(markerName) + ".target", targetObjectName);
        ArrayProducer.getObjectProperties().put(String.valueOf(markerName) + ".pos", targetIndex);
        ArrayProducer.getObjectTypes().put(markerName, ArrayProducer.getTypeIdentifier("arraymarker"));
        ArrayProducer.getCurrentlyVisible().put(String.valueOf(markerID), "true");
        if (labelText != null) {
            ArrayProducer.getCurrentlyVisible().put(String.valueOf(labelText.getNum(false)), "true");
        }
        AnimalParseSupport.showComponents(stok, ids, localType, true);
    }
}

