/*
 * Decompiled with CFR 0.152.
 */
package animal.misc;

import animal.editor.AnimatorEditor;
import animal.editor.Editor;
import animal.editor.GraphicEditor;
import animal.exchange.AnimationExporter;
import animal.exchange.AnimationImporter;
import animal.gui.AnimalMainWindow;
import animal.gui.AnimationOverview;
import animal.gui.DrawWindow;
import animal.gui.WindowCoordinator;
import animal.main.Animal;
import animal.main.AnimalConfiguration;
import animal.misc.AnimalFileChooser;
import animal.misc.AnimalTranslator;
import animal.misc.MessageDisplay;
import animalscript.core.AnimalScriptParser;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import translator.ExtendedResourceBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComponentConfigurer
implements ActionListener {
    private static final String ANIMATOR_TAG = "Animator";
    private static final String IMPORT_FILTER_TAG = "ImportFilter";
    private static final String EXPORT_FILTER_TAG = "ExportFilter";
    private static final String LANGUAGE_SUPPORT_TAG = "LanguageSupport";
    private static final String ANIMALSCRIPT_HANDLER_TAG = "AnimalScriptHandler";
    private static final String ANIMALSCRIPT_PREFIX = "animalscript.extensions.";
    private static final String GRAPHIC_OBJECT_TAG = "GraphicObject";
    private static final String internalScriptingPanelKey = "internalScriptingPanel";
    private static HashMap<String, String> coreElements;
    private AnimalConfiguration currentConfiguration;
    private static Hashtable<String, JPanel> guiElements;
    JTextField addPrimitives;
    JTextField addEffects;
    JTextField addScriptingHandler;
    JTextField addImportFilter;
    JTextField addExportFilter;
    JTextField addLanguage;
    String[] elements = null;
    private Vector<String> scriptingHandlers = new Vector(25, 15);
    JButton addLanguageButton;
    JPanel primitivesPanel;
    JPanel effectsPanel;
    JPanel scriptHandlersPanel;
    int lastPos = -1;
    JPanel internalLanguagePanel = new JPanel(new GridLayout(0, 1));
    private Hashtable<String, JCheckBox> componentsHash = new Hashtable(91);
    JFrame targetFrame = new JFrame("Component Configuration");

    static {
        guiElements = new Hashtable(53);
        coreElements = new HashMap(59);
        coreElements.put("Point", GRAPHIC_OBJECT_TAG);
        coreElements.put("Polyline", GRAPHIC_OBJECT_TAG);
        coreElements.put("Text", GRAPHIC_OBJECT_TAG);
        coreElements.put("Arc", GRAPHIC_OBJECT_TAG);
        coreElements.put("TimedShow", ANIMATOR_TAG);
        coreElements.put("ColorChanger", ANIMATOR_TAG);
        coreElements.put("Move", ANIMATOR_TAG);
        coreElements.put("Rotate", ANIMATOR_TAG);
        coreElements.put("Show", ANIMATOR_TAG);
        coreElements.put("animation/animal-ascii-compressed", IMPORT_FILTER_TAG);
        coreElements.put("animation/animal-ascii", IMPORT_FILTER_TAG);
        coreElements.put("animation/animalscript-compressed", IMPORT_FILTER_TAG);
        coreElements.put("animation/animalscript", IMPORT_FILTER_TAG);
        coreElements.put("animation/animal-ascii-compressed", EXPORT_FILTER_TAG);
        coreElements.put("animation/animal-ascii", EXPORT_FILTER_TAG);
        coreElements.put("animation/animalscript-compressed", EXPORT_FILTER_TAG);
        coreElements.put("animation/animalscript", EXPORT_FILTER_TAG);
        coreElements.put("English [en US]", LANGUAGE_SUPPORT_TAG);
        coreElements.put("animalscript.core.BaseAdminParser", ANIMALSCRIPT_HANDLER_TAG);
        coreElements.put("animalscript.core.BaseAnimatorParser", ANIMALSCRIPT_HANDLER_TAG);
        coreElements.put("animalscript.core.BaseObjectParser", ANIMALSCRIPT_HANDLER_TAG);
        coreElements.put("animalscript.extensions.ArraySupport", ANIMALSCRIPT_HANDLER_TAG);
        coreElements.put("animalscript.extensions.CodeSupport", ANIMALSCRIPT_HANDLER_TAG);
    }

    public ComponentConfigurer() {
        this(AnimalConfiguration.getDefaultConfiguration());
    }

    public ComponentConfigurer(AnimalConfiguration currentConfig) {
        this.targetFrame.getContentPane().setLayout(new BorderLayout());
        JTabbedPane tp = new JTabbedPane();
        this.primitivesPanel = new JPanel();
        this.primitivesPanel.setLayout(new BorderLayout());
        this.primitivesPanel.setBorder(BorderFactory.createTitledBorder(this.primitivesPanel.getBorder(), "Graphic Primitives", 2, 2));
        this.effectsPanel = new JPanel();
        this.effectsPanel.setLayout(new BorderLayout());
        this.effectsPanel.setBorder(BorderFactory.createTitledBorder(this.effectsPanel.getBorder(), "Animation Effects", 2, 2));
        Hashtable<String, Editor> knownEditors = Animal.get().getEditors();
        int n = knownEditors.size();
        this.elements = new String[n << 1];
        this.lastPos = -1;
        this.addPrimitives = new JTextField(20);
        this.addPrimitives.addActionListener(this);
        this.primitivesPanel.add("North", this.addPrimitives);
        this.primitivesPanel.setToolTipText(AnimalTranslator.translateMessage("confPrimitives"));
        this.insertEditors(knownEditors, n, true, this.primitivesPanel);
        tp.addTab("Primitives", this.primitivesPanel);
        this.addEffects = new JTextField(20);
        this.addEffects.addActionListener(this);
        this.effectsPanel.add("North", this.addEffects);
        this.effectsPanel.setToolTipText(AnimalTranslator.translateMessage("confEffects"));
        this.insertEditors(knownEditors, n, false, this.effectsPanel);
        tp.addTab("Animators", this.effectsPanel);
        JPanel importFilterPanel = new JPanel();
        importFilterPanel.setLayout(new BorderLayout());
        this.addImportFilter = new JTextField(20);
        this.addImportFilter.addActionListener(this);
        importFilterPanel.add("North", this.addImportFilter);
        importFilterPanel.setToolTipText(AnimalTranslator.translateMessage("confImportFilters"));
        this.insertImportFiltersTo(importFilterPanel);
        tp.addTab("Import Filter", importFilterPanel);
        JPanel exportFilterPanel = new JPanel();
        exportFilterPanel.setLayout(new BorderLayout());
        this.addExportFilter = new JTextField(20);
        this.addExportFilter.addActionListener(this);
        exportFilterPanel.add("North", this.addExportFilter);
        exportFilterPanel.setToolTipText(AnimalTranslator.translateMessage("confExportFilters"));
        this.insertExportFiltersTo(exportFilterPanel);
        tp.addTab("Export Filter", exportFilterPanel);
        JPanel languageSupportPanel = new JPanel();
        languageSupportPanel.setLayout(new BorderLayout());
        this.addLanguageButton = new JButton(AnimalTranslator.translateMessage("confLanguages"));
        this.addLanguageButton.addActionListener(this);
        languageSupportPanel.add("North", this.addLanguageButton);
        languageSupportPanel.setToolTipText(AnimalTranslator.translateMessage("confLanguages"));
        this.insertLanguages(languageSupportPanel);
        tp.addTab("Languages", languageSupportPanel);
        this.scriptHandlersPanel = new JPanel();
        this.scriptHandlersPanel.setLayout(new BorderLayout());
        this.scriptHandlersPanel.setToolTipText(AnimalTranslator.translateMessage("confScripting"));
        this.addScriptingHandler = new JTextField(20);
        this.addScriptingHandler.addActionListener(this);
        this.scriptHandlersPanel.add("North", this.addScriptingHandler);
        guiElements.put("scriptingPanel", this.scriptHandlersPanel);
        this.updateScriptingPanel();
        tp.addTab("AnimalScript", this.scriptHandlersPanel);
        this.targetFrame.getContentPane().add("Center", tp);
        JPanel buttonPanel = new JPanel();
        JButton button = new JButton(AnimalTranslator.translateMessage("ok"));
        button.addActionListener(this);
        buttonPanel.add(button);
        button = new JButton(AnimalTranslator.translateMessage("cancel"));
        button.addActionListener(this);
        buttonPanel.add(button);
        this.targetFrame.getContentPane().add("South", buttonPanel);
        this.targetFrame.pack();
        this.targetFrame.setVisible(true);
    }

    private void insertCheckBox(JPanel targetPanel, String entryKey, String entryToolTipText) {
        JCheckBox tmpBox = new JCheckBox(entryKey);
        tmpBox.setSelected(true);
        tmpBox.setEnabled(!coreElements.containsKey(entryKey));
        tmpBox.setToolTipText(entryToolTipText);
        tmpBox.addActionListener(this);
        targetPanel.add(tmpBox);
    }

    public void insertExportFiltersTo(JPanel targetPanel) {
        JPanel internalPanel = new JPanel(new GridLayout(0, 1));
        String[] exportFilterNames = AnimalConfiguration.getDefaultConfiguration().getExportFormats();
        int i = 0;
        while (i < exportFilterNames.length) {
            this.insertCheckBox(internalPanel, exportFilterNames[i], AnimationExporter.getExporterFor(exportFilterNames[i]).toString());
            ++i;
        }
        JScrollPane scrollPane = new JScrollPane(internalPanel);
        targetPanel.add("Center", scrollPane);
    }

    public void insertImportFiltersTo(JPanel targetPanel) {
        JPanel internalPanel = new JPanel(new GridLayout(0, 1));
        String[] importFilterNames = AnimalConfiguration.getDefaultConfiguration().getImportFormats();
        int i = 0;
        while (i < importFilterNames.length) {
            this.insertCheckBox(internalPanel, importFilterNames[i], AnimationImporter.getImporterFor(importFilterNames[i]).toString());
            ++i;
        }
        JScrollPane scrollPane = new JScrollPane(internalPanel);
        targetPanel.add("Center", scrollPane);
    }

    public void insertLanguages(JPanel targetPanel) {
        System.err.println("mainWindow: " + Animal.get().getMainWindow());
        String[] languageKeys = Animal.get().getMainWindow().getLanguageKeys();
        String currentEntry = null;
        String key = null;
        if (languageKeys != null) {
            int i = 0;
            while (i < languageKeys.length) {
                currentEntry = languageKeys[i];
                StringTokenizer stringTok = new StringTokenizer(currentEntry, ";");
                key = String.valueOf(stringTok.nextToken()) + " [" + stringTok.nextToken() + "]";
                this.insertCheckBox(this.internalLanguagePanel, key, stringTok.nextToken());
                ++i;
            }
        }
        JScrollPane scrollPane = new JScrollPane(this.internalLanguagePanel);
        targetPanel.add("Center", scrollPane);
    }

    public void updateScriptingPanel() {
        boolean panelIsAssociated = guiElements.containsKey(internalScriptingPanelKey);
        if (!panelIsAssociated) {
            guiElements.put(internalScriptingPanelKey, new JPanel(new GridLayout(0, 1)));
        }
        JPanel internalPanel = guiElements.get(internalScriptingPanelKey);
        if (this.scriptingHandlers == null || this.scriptingHandlers.size() == 0) {
            String[] handlers = Animal.getAnimalScriptParser(false).getRegisteredHandlers();
            int nrHandlers = handlers.length;
            int index = 0;
            while (index < nrHandlers) {
                this.scriptingHandlers.addElement(handlers[index]);
                ++index;
            }
        }
        internalPanel.removeAll();
        if (this.scriptingHandlers != null && this.scriptingHandlers.size() > 0) {
            int nrHandlers = this.scriptingHandlers.size();
            int i = 0;
            while (i < nrHandlers) {
                String currentHandler = this.scriptingHandlers.elementAt(i);
                this.insertCheckBox(internalPanel, currentHandler, currentHandler);
                ++i;
            }
        }
        if (!panelIsAssociated) {
            JScrollPane scrollPane = new JScrollPane(internalPanel);
            JPanel targetPanel = guiElements.get("scriptingPanel");
            targetPanel.add("Center", scrollPane);
        }
        internalPanel.repaint();
    }

    public void insertEditors(Hashtable<String, Editor> editors, int nrElems, boolean graphicEditorMode, JPanel targetPanel) {
        JPanel internalPanel = new JPanel();
        internalPanel.setLayout(new GridLayout(0, 1));
        Editor editor = null;
        String name = null;
        JCheckBox tmpBox = null;
        boolean isCore = false;
        int i = 0;
        while (i < nrElems) {
            Enumeration<Editor> elementList = editors.elements();
            while (elementList.hasMoreElements()) {
                editor = elementList.nextElement();
                if (i != editor.getNum() || (!graphicEditorMode || !(editor instanceof GraphicEditor)) && (graphicEditorMode || !(editor instanceof AnimatorEditor))) continue;
                this.elements[i] = name = editor.getName();
                if (i > this.lastPos) {
                    this.lastPos = i;
                }
                tmpBox = new JCheckBox(name);
                isCore = coreElements.containsKey(name);
                tmpBox.setToolTipText(AnimalTranslator.translateMessage(isCore ? "coreConfMessage" : "compConfMessage", new Object[]{name}));
                tmpBox.setEnabled(!isCore);
                tmpBox.setSelected(true);
                if (!isCore) {
                    tmpBox.addActionListener(this);
                }
                internalPanel.add(tmpBox);
                this.componentsHash.put(name, tmpBox);
            }
            ++i;
        }
        JScrollPane scrollPane = new JScrollPane(internalPanel);
        targetPanel.add(scrollPane);
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        if (event.getSource() instanceof JTextField) {
            boolean isPrimitive;
            JTextField targetField = (JTextField)event.getSource();
            boolean bl = isPrimitive = targetField == this.addPrimitives;
            if (targetField == this.addPrimitives || targetField == this.addEffects) {
                String name = targetField.getText();
                if (this.componentsHash.containsKey(name)) {
                    JCheckBox linkedObject = this.componentsHash.get(name);
                    if (linkedObject instanceof JCheckBox) {
                        linkedObject.setSelected(true);
                    }
                } else {
                    this.addComponent(name, isPrimitive);
                }
            } else if (targetField == this.addScriptingHandler) {
                this.addScriptingHandler(targetField.getText());
                this.updateScriptingPanel();
            } else if (targetField == this.addImportFilter) {
                this.addImportFilter(targetField.getText());
            } else if (targetField == this.addExportFilter) {
                System.err.println("add export filter 'animal.exchange." + targetField.getText());
            }
            targetField.setText("");
        } else if (event.getSource() instanceof JButton) {
            String command = event.getActionCommand();
            if (command.equalsIgnoreCase(AnimalTranslator.translateMessage("cancel"))) {
                this.targetFrame.setVisible(false);
                this.targetFrame.dispose();
            } else if (command.equalsIgnoreCase(AnimalTranslator.translateMessage("ok"))) {
                this.dumpFiles();
            } else if (command.equalsIgnoreCase(AnimalTranslator.translateMessage("confLanguages"))) {
                AnimalFileChooser aFileChooser = new AnimalFileChooser(AnimalConfiguration.getDefaultConfiguration());
                aFileChooser.setSpecificFilter(null, "AnimalResources", "Animal Resource Files", true);
                String filename = aFileChooser.openForStraightLoad(this.targetFrame);
                ExtendedResourceBundle resource = new ExtendedResourceBundle(filename);
                Animal.get().getMainWindow().addLanguageSupportEntry(resource.getMessage("language.locale"), resource.getMessage("language.label"), resource.getMessage("language.icon"), resource.getMessage("language.tooltip"));
                this.insertCheckBox(this.internalLanguagePanel, String.valueOf(resource.getMessage("language.label")) + " [" + resource.getMessage("language.locale") + "]", resource.getMessage("language.tooltip"));
            } else if (event.getSource() instanceof JCheckBox) {
                JCheckBox selectedCheckBox = (JCheckBox)event.getSource();
                System.err.println(selectedCheckBox);
            }
        }
    }

    private void dumpFiles() {
        JFileChooser fileChooser = new JFileChooser();
        int returnValue = fileChooser.showSaveDialog(this.targetFrame);
        if (returnValue == 0) {
            Component[] compos;
            File chosenDir = fileChooser.getCurrentDirectory();
            StringBuilder scriptHandlers = new StringBuilder(30);
            JPanel internalScriptingPanel = guiElements.get(internalScriptingPanelKey);
            if (internalScriptingPanel != null && (compos = internalScriptingPanel.getComponents()) != null) {
                int nrCompos = compos.length;
                int compoIndex = 0;
                while (compoIndex < nrCompos) {
                    if (compos[compoIndex] instanceof JCheckBox) {
                        JCheckBox currentBox = (JCheckBox)compos[compoIndex];
                        if (currentBox.isSelected()) {
                            scriptHandlers.append(currentBox.getActionCommand()).append("\n");
                        } else {
                            AnimalScriptParser.removeScriptingHandler(currentBox.getActionCommand());
                        }
                    }
                    ++compoIndex;
                }
            }
            try {
                DataOutputStream dos = new DataOutputStream(new FileOutputStream(new File(fileChooser.getCurrentDirectory(), "handlers.dat")));
                dos.writeBytes(scriptHandlers.toString());
                dos.close();
            }
            catch (IOException e) {
                MessageDisplay.errorMsg(AnimalTranslator.translateMessage("compConfigWriteError", new Object[]{AnimalTranslator.translateMessage("animalScriptHandlers"), "handlers.dat", chosenDir.getName()}), 4);
            }
            this.targetFrame.setVisible(false);
            this.targetFrame.dispose();
        }
    }

    private void addComponent(String name, boolean isGraphicObject) {
        AnimalConfiguration animalConfig = AnimalConfiguration.getDefaultConfiguration();
        JCheckBox newBox = new JCheckBox(name);
        newBox.setSelected(true);
        newBox.addActionListener(this);
        this.componentsHash.put(name, newBox);
        WindowCoordinator winCoord = AnimalMainWindow.getWindowCoordinator();
        if (isGraphicObject) {
            animalConfig.insertPrimitive(name, "animal.graphics." + name, 0, animalConfig.getProperties());
            this.primitivesPanel.add(newBox);
            DrawWindow drawWindow = winCoord.getDrawWindow(false);
            drawWindow.installPrimitiveToolBar();
        } else {
            this.effectsPanel.add(newBox);
            animalConfig.insertAnimator(name, "animal.animator." + name, 0, animalConfig.getProperties());
            AnimationOverview animationOverview = winCoord.getAnimationOverview(false);
            animationOverview.installAnimatorToolBar();
        }
    }

    private void addScriptingHandler(String handlerName) {
        StringBuilder className = new StringBuilder(handlerName);
        if (className != null && className.length() > 0) {
            if (!className.toString().startsWith(ANIMALSCRIPT_PREFIX)) {
                className.insert(0, ANIMALSCRIPT_PREFIX);
            }
            AnimalScriptParser.addScriptingHandler(className.toString());
            this.scriptingHandlers.addElement(className.toString());
        }
    }

    public void addExportFilter(String handlerName) {
        if (!handlerName.startsWith("animal.exchange.")) {
            handlerName = "animal.exchange." + handlerName;
        }
        try {
            AnimationExporter handler;
            Class<?> importerClass = Class.forName(handlerName);
            Object targetObject = importerClass.newInstance();
            if (targetObject instanceof AnimationExporter && (handler = (AnimationExporter)importerClass.newInstance()) != null) {
                this.currentConfiguration.insertExportFilter(handler.getDefaultExtension(), handlerName);
            }
        }
        catch (Exception e) {
            System.err.println("***" + handlerName + " does not exist or is not a proper AnimationExporter:");
        }
    }

    public void addImportFilter(String handlerName) {
        if (!handlerName.startsWith("animal.exchange.")) {
            handlerName = "animal.exchange." + handlerName;
        }
        System.err.println("trying to load importer class '" + handlerName + "'");
        try {
            AnimationImporter handler;
            Class<?> importerClass = Class.forName(handlerName);
            Object targetObject = importerClass.newInstance();
            if (targetObject instanceof AnimationImporter && (handler = (AnimationImporter)importerClass.newInstance()) != null) {
                this.currentConfiguration.insertImportFilter(handler.getDefaultExtension(), handlerName);
            }
        }
        catch (Exception e) {
            System.err.println("***" + handlerName + " does not exist or is not a proper AnimationImporter:");
        }
    }

    public void setVisible(boolean isVisible) {
        if (this.targetFrame != null) {
            this.targetFrame.setVisible(isVisible);
        }
    }
}

