/*
 * Decompiled with CFR 0.152.
 */
package animal.main;

import animal.exchange.AnimationExporter;
import animal.exchange.AnimationImporter;
import animal.main.Animal;
import animal.main.Animation;
import animal.misc.AnimalTranslator;
import animal.misc.MessageDisplay;
import java.io.File;

public class AnimationTester {
    public static void main(String[] animNames) {
        int startPos = 0;
        if (animNames == null || animNames.length < 1) {
            System.err.println("Usage: java animal.main.AnimationTester [-terse|-verbose] [-q|-quick] [-x] format filename1 [filename2...]");
            System.exit(0);
        }
        boolean verboseMode = false;
        boolean performStepChecking = true;
        if (animNames[0].equalsIgnoreCase("-terse")) {
            ++startPos;
        }
        if (animNames[startPos].equalsIgnoreCase("-verbose")) {
            ++startPos;
            verboseMode = true;
        }
        if (animNames[startPos].equalsIgnoreCase("-quick") || animNames[startPos].equalsIgnoreCase("-q")) {
            performStepChecking = false;
            ++startPos;
        }
        if (animNames != null && animNames.length > 1) {
            boolean useConversion = animNames[startPos].equalsIgnoreCase("-x");
            Animal animal = Animal.get();
            Animation animation = null;
            int i = useConversion ? startPos + 1 : startPos;
            String formatName = animNames[i++];
            if (verboseMode) {
                MessageDisplay.message("animTesterRequest");
                while (i < animNames.length) {
                    MessageDisplay.message(String.valueOf(animNames[i]) + " ");
                    ++i;
                }
                MessageDisplay.message("\n");
            }
            i = useConversion ? startPos + 2 : startPos + 1;
            while (i < animNames.length) {
                String currentFileName = animNames[i];
                currentFileName.endsWith(".zip");
                try {
                    File file = new File(currentFileName);
                    MessageDisplay.message("animTesterFNSize", new Object[]{currentFileName, file.length()});
                    file = null;
                    long timeNow = System.currentTimeMillis();
                    if (AnimationImporter.importAnimation(currentFileName, formatName)) {
                        animation = animal.getAnimation();
                        if (animation != null) {
                            if (verboseMode) {
                                MessageDisplay.message("animTestNrSOA", new Integer[]{animation.getNrAnimationSteps(), animation.getNrObjects(), animation.getNrAnimators()});
                            }
                            if (!performStepChecking) {
                                animal.testAnimation(AnimalTranslator.translateMessage("finishedTest", new Object[]{currentFileName, System.currentTimeMillis() - timeNow}));
                            } else {
                                MessageDisplay.message("finishedLoading", currentFileName);
                                if (verboseMode) {
                                    MessageDisplay.message("chosenLang", animation.getLanguage());
                                    animation.determineVisualizationSize();
                                    animal.showBoundingBox();
                                }
                            }
                            if (useConversion) {
                                AnimationExporter.exportAnimation(animation);
                            }
                        }
                    } else {
                        MessageDisplay.errorMsg("errorLoadingTestAnim", currentFileName, 4);
                    }
                }
                catch (Exception e) {
                    MessageDisplay.errorMsg("exceptionDuringTest", e.getMessage(), 4);
                    e.printStackTrace();
                }
                ++i;
            }
            MessageDisplay.message("goodbye");
        } else {
            MessageDisplay.message("animTesterUsage");
        }
        System.exit(0);
    }
}

