/*
 * Decompiled with CFR 0.152.
 */
package animal.gui;

import animal.editor.Editor;
import animal.gui.AnimalMainWindow;
import animal.main.Animal;
import animal.main.AnimalFrame;
import animal.main.Animation;
import animal.main.AnimationListEntry;
import animal.main.Link;
import animal.main.ObjectPanel;
import animal.misc.AnimalTranslator;
import animal.misc.XProperties;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JToolBar;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.MouseInputAdapter;

public class AnimationOverview
extends AnimalFrame
implements ActionListener,
ListSelectionListener {
    private static final long serialVersionUID = -2479876886704332851L;
    JPopupMenu popup;
    JMenuItem deleteItem;
    JMenuItem editItem;
    JMenuItem appendStepItem;
    JMenuItem prependStepItem;
    private Animation animation;
    JList animatorList;
    private ObjectPanel animatorPanel;
    private AnimationListEntry[] info = new AnimationListEntry[0];
    private int lastChange = -1;
    private JToolBar buttonToolBar;
    private JToolBar animatorToolBar;

    public AnimationOverview(Animal animalInstance, XProperties properties) {
        super(animalInstance, properties);
    }

    public void init() {
        super.init();
        this.workContainer().setLayout(new BorderLayout(0, 0));
        this.animatorList = new JList();
        this.animatorList.setSelectionMode(0);
        this.animatorList.addMouseListener(new AnimationOverviewMouseAdapter(this));
        this.animatorList.addListSelectionListener(this);
        JScrollPane scrollPane = new JScrollPane(this.animatorList);
        this.workContainer().add("Center", scrollPane);
        this.popup = AnimalTranslator.getGUIBuilder().generateJPopupMenu("objectActions");
        this.buttonToolBar = new JToolBar();
        this.buttonToolBar.getAccessibleContext().setAccessibleName(AnimalTranslator.translateMessage("stepOps"));
        this.buttonToolBar.setFloatable(true);
        AnimalTranslator.getGUIBuilder().insertToMenuAndToolBar("prependStep", null, (Object)this, null, this.popup, this.buttonToolBar);
        AnimalTranslator.getGUIBuilder().insertToMenuAndToolBar("appendStep", null, (Object)this, null, this.popup, this.buttonToolBar);
        AnimalTranslator.getGUIBuilder().insertToToolBar("refresh", null, this, null, this.buttonToolBar);
        AnimalTranslator.getGUIBuilder().insertToMenuAndToolBar("editAnimator", null, (Object)this, null, this.popup, this.buttonToolBar);
        AnimalTranslator.getGUIBuilder().insertToMenuAndToolBar("deleteAnimator", null, (Object)this, null, this.popup, this.buttonToolBar);
        JLabel l = new JLabel("ToolBar");
        l.setLabelFor(this.buttonToolBar);
        this.installAnimatorToolBar();
        this.workContainer().add("North", this.animatorToolBar);
        this.workContainer().add("South", this.buttonToolBar);
        this.setTitle(AnimalTranslator.translateMessage("animOverview"));
        this.setAnimation(Animation.get());
        this.setProperties(this.props);
        this.editItem = new JMenuItem("Edit", 69);
        this.editItem.addActionListener(this);
        this.popup.add(this.editItem);
        this.popup.add(new JSeparator());
    }

    public void installAnimatorToolBar() {
        this.animatorToolBar = this.getAnimatorPanel().getToolBar();
        this.animatorToolBar.getAccessibleContext().setAccessibleName("Animators");
        this.animatorToolBar.setFloatable(true);
        this.repaint();
    }

    public ObjectPanel getAnimatorPanel() {
        if (this.animatorPanel == null) {
            this.animatorPanel = new ObjectPanel(this.animal, this, this.props, false);
        }
        return this.animatorPanel;
    }

    public void setVisible(boolean b) {
        super.setVisible(b);
        if (b) {
            this.initList(true);
            this.valueChanged(null);
        }
    }

    void setProperties(XProperties properties) {
        this.setBounds(properties.getIntProperty("AnimationOverview.x", 50), properties.getIntProperty("AnimationOverview.y", 50), properties.getIntProperty("AnimationOverview.width", 320), properties.getIntProperty("AnimationOverview.height", 200));
    }

    public void getProperties(XProperties properties) {
        Rectangle b = this.getBounds();
        if (b.width + 11 == properties.getIntProperty("AnimationOverview.width", 320) && b.height + 8 == properties.getIntProperty("AnimationOverview.height", 200)) {
            b.width += 11;
            b.height += 8;
        }
        properties.put("AnimationOverview.x", b.x);
        properties.put("AnimationOverview.y", b.y);
        properties.put("AnimationOverview.width", b.width);
        properties.put("AnimationOverview.height", b.height);
    }

    public void initList() {
        this.lastChange = -1;
        this.initList(true);
    }

    public void initList(boolean getNewList) {
        if (this.isInitialized() && this.animation != null) {
            boolean endSelected;
            if (this.lastChange == this.animation.getLastChange()) {
                return;
            }
            this.lastChange = this.animation.getLastChange();
            int index = this.animatorList.getSelectedIndex();
            int step = this.getStep();
            if (getNewList) {
                this.info = this.animation.getAnimatorList();
            }
            boolean bl = endSelected = index == this.animatorList.getModel().getSize() - 1;
            if (this.info != null) {
                int i = 0;
                while (i < this.info.length) {
                    AnimationListEntry ai = this.info[i];
                    if (ai.mode == 1) {
                        ai.info = ai.animator.toString();
                    }
                    if (ai.mode == 2) {
                        ai.info = ai.link.toString();
                    }
                    ++i;
                }
                this.animatorList.setVisible(false);
                this.animatorList.removeAll();
                String[] infos = new String[this.info.length];
                int i2 = 0;
                while (i2 < this.info.length) {
                    infos[i2] = this.info[i2].info;
                    ++i2;
                }
                this.animatorList.setListData(infos);
                this.animatorList.setVisible(true);
                this.repaint();
            }
            ListSelectionEvent ie = null;
            if (index < 0) {
                this.animatorList.setSelectedIndex(0);
                this.animatorList.ensureIndexIsVisible(0);
            } else if (index > this.info.length - 1 || endSelected) {
                this.animatorList.setSelectedIndex(this.info.length - 1);
                this.animatorList.ensureIndexIsVisible(this.info.length - 1);
            } else {
                this.animatorList.setSelectedIndex(index);
                this.animatorList.ensureIndexIsVisible(index + (this.animatorList.getVisibleRowCount() >>> 1));
                if (this.animation.getLink(step) != null) {
                    this.setStep(step, false);
                } else if (step == AnimalMainWindow.getWindowCoordinator().getDrawWindow(false).getStep()) {
                    ie = new ListSelectionEvent(this.animatorList, 0, 0, false);
                }
            }
            this.valueChanged(ie);
        }
        AnimalMainWindow.getWindowCoordinator().getDrawWindow(false).update();
    }

    public void setStep(int step, boolean setOtherWindows) {
        if (this.isInitialized()) {
            if (setOtherWindows) {
                if (step == Integer.MAX_VALUE) {
                    int h = this.animatorList.getModel().getSize() - 2;
                    while (h >= 0 && this.info[h].mode != 2) {
                        --h;
                    }
                    if (h >= 0) {
                        step = this.info[h].link.getStep();
                    }
                }
                AnimalMainWindow.getWindowCoordinator().getDrawWindow(false).setStep(step);
                AnimalMainWindow.getWindowCoordinator().getAnimationWindow(false).setStep(step, true);
            }
            if (this.getStep() == step) {
                return;
            }
            int a = 0;
            while (a < this.info.length) {
                if (this.info[a].mode == 2 && this.info[a].link.getStep() == step) {
                    this.animatorList.setSelectedIndex(a);
                    this.animatorList.ensureIndexIsVisible(a);
                    return;
                }
                ++a;
            }
            this.animatorList.setSelectedIndex(0);
            this.animatorList.ensureIndexIsVisible(0);
        }
    }

    public int getStep() {
        return this.getStepBefore(this.animatorList.getSelectedIndex());
    }

    int getStepBefore(int line) {
        int a = line;
        while (a >= 0) {
            if (this.info[a].mode == 2) {
                return this.info[a].link.getStep();
            }
            --a;
        }
        return 0;
    }

    Link getCurrentLineStep(int line) {
        int a = line;
        while (a >= 0) {
            if (this.info[a].mode == 2) {
                return this.info[a].link;
            }
            --a;
        }
        return null;
    }

    public void valueChanged(ListSelectionEvent e) {
        this.setStep(this.getStep(), e != null);
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.animatorList || e.getSource() == this.editItem) {
            this.editLine();
        }
    }

    public void editLine() {
        Editor se;
        AnimationListEntry ai = this.info[this.animatorList.getSelectedIndex()];
        if (ai.mode == 1) {
            Editor se2 = ai.animator.getSecondaryEditor();
            if (se2 != null) {
                se2.setVisible(true);
            }
        } else if (ai.mode == 2 && (se = ai.link.getSecondaryEditor()) != null) {
            se.setVisible(true);
        }
    }

    public void deleteLine() {
        if (this.info != null) {
            AnimationListEntry ai = this.info[this.animatorList.getSelectedIndex()];
            if (ai.mode == 1) {
                this.animation.deleteAnimator(ai.animator);
                this.initList(true);
            }
            if (ai.mode == 2) {
                if (ai.link.getStep() == Integer.MAX_VALUE) {
                    JOptionPane.showMessageDialog(this, AnimalTranslator.translateMessage("cannotDeleteStartEndStep", "end"), AnimalTranslator.translateMessage("cannotDeleteStep"), 2);
                } else if (this.animation.getStepCount() <= 1) {
                    JOptionPane.showMessageDialog(this, AnimalTranslator.translateMessage("needAtLeastOneStep"), AnimalTranslator.translateMessage("cannotDeleteStep"), 2);
                } else if (this.animation.getAnimator(ai.link.getStep(), 0, null) == null || JOptionPane.showConfirmDialog(this, AnimalTranslator.translateMessage("deleteNonEmptyStep", ai.link.getStep()), AnimalTranslator.translateMessage("deleteStep"), 0) == 0) {
                    this.animation.deleteStep(ai.link.getStep());
                }
                this.initList(true);
            }
        }
    }

    public void setAnimation(Animation theAnimation) {
        this.animation = theAnimation;
        this.lastChange = -1;
        this.initList(true);
    }

    public void appendStep() {
        int step = this.getStep();
        int newStep = this.animation.appendStep(step);
        this.initList(true);
        this.setStep(newStep, true);
    }

    public void prependStep() {
        int step = this.getStep();
        if (step == 0) {
            step = this.animation.getNextStep(step);
        }
        int newStep = this.animation.newStep(step);
        this.initList(true);
        this.setStep(newStep, true);
    }

    class AnimationOverviewMouseAdapter
    extends MouseInputAdapter {
        Component component;

        AnimationOverviewMouseAdapter(Component c) {
            this.component = c;
        }

        public void mousePressed(MouseEvent evt) {
            if (AnimationOverview.this.animatorList.getSelectedIndex() != -1 && evt.isPopupTrigger()) {
                AnimationOverview.this.popup.show(this.component, evt.getX(), evt.getY());
                AnimationOverview.this.popup.setSelected(AnimationOverview.this.editItem);
            }
        }
    }
}

