/*
 * Decompiled with CFR 0.152.
 */
package animal.gui;

import animal.gui.AnimalMainWindow;
import animal.gui.AnimationControlToolBarController;
import animal.main.Animal;
import animal.main.Animation;
import animal.main.AnimationState;
import animal.main.AnimationWindow;
import animal.main.ButtonController;
import animal.main.Link;
import animal.misc.AnimalTranslator;
import animal.misc.MessageDisplay;
import java.awt.Dimension;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import translator.TranslatableGUIElement;

public class AnimationControlToolBar
extends JToolBar
implements ButtonController {
    private static final long serialVersionUID = -3065614895282195843L;
    public static final String END = "end";
    public static final String NEXT_BUTTON = "next";
    public static final String PAUSE = "pause";
    public static final String PLAY = "play";
    public static final String PREV = "prev";
    public static final String REVERSE_PLAY = "reverse play";
    public static final String REVERSE_SLIDE_SHOW = "reverse slideshow";
    public static final String SLIDE_SHOW = "slideshow";
    public static final String START = "start";
    public static final String STEP_NR_FIELD = "stepNumberField";
    public static final String STEP_SLIDER = "stepSlider";
    private AnimationWindow animationWindow;
    private ButtonController buttonController;
    private AnimationControlToolBarController controller;
    private AbstractButton endButton;
    private AbstractButton pauseButton;
    private AbstractButton playButton;
    private AbstractButton prevButton;
    private AbstractButton reverseSlideButton;
    private AbstractButton slideShowButton;
    private AbstractButton startButton;
    private JSlider stepSlider;
    private JTextField stepField;
    private JLabel nrSteps;

    public AnimationControlToolBar(String title, AnimationWindow animWindow) {
        super(title);
        if (animWindow == null) {
            animWindow = AnimalMainWindow.getWindowCoordinator().getAnimationWindow(true);
        }
        this.animationWindow = animWindow;
        this.controller = new AnimationControlToolBarController(this.animationWindow, this);
        this.buildToolBar();
    }

    public void activateStepSliderListener(boolean isActive) {
        if (this.stepSlider == null) {
            return;
        }
        if (isActive) {
            this.stepSlider.addChangeListener(this.controller);
        } else {
            this.stepSlider.removeChangeListener(this.controller);
        }
    }

    public boolean allowButtonAccess(int currentStep) {
        return true;
    }

    public void buildToolBar() {
        TranslatableGUIElement generator = AnimalTranslator.getGUIBuilder();
        this.getAccessibleContext().setAccessibleName(AnimalTranslator.translateMessage("animationControlToolBar"));
        this.setFloatable(true);
        Box basicControlBox = generator.generateBorderedBox(2, "basicControlBL");
        this.startButton = this.createButton(basicControlBox, "startButton", false, this.controller, START);
        this.prevButton = this.createButton(basicControlBox, "prevButton", false, this.controller, PREV);
        this.pauseButton = this.createButton(basicControlBox, "pauseButton", false, this.controller, PAUSE);
        this.playButton = this.createButton(basicControlBox, "playButton", false, this.controller, PLAY);
        this.endButton = this.createButton(basicControlBox, "endButton", false, this.controller, END);
        this.add(basicControlBox);
        this.addSeparator();
        Box kioskBox = generator.generateBorderedBox(2, "kioskModeBL");
        this.reverseSlideButton = this.createButton(kioskBox, "revSlideShowButton", false, this.controller, REVERSE_SLIDE_SHOW);
        this.slideShowButton = this.createButton(kioskBox, "slideShowButton", false, this.controller, SLIDE_SHOW);
        this.add(kioskBox);
        this.addSeparator();
        Box stepBox = generator.generateBorderedBox(2, "stepBL");
        this.stepField = generator.generateJTextField("stepChoiceAW", null, 3, "1");
        this.stepField.setMaximumSize(new Dimension(40, 30));
        this.stepField.setActionCommand(STEP_NR_FIELD);
        this.stepField.addActionListener(this.controller);
        stepBox.add(this.stepField);
        this.nrSteps = new JLabel("/ 0");
        stepBox.add(this.nrSteps);
        this.stepSlider = AnimalTranslator.getGUIBuilder().generateJSlider("sliderValue", new Object[]{"100%"}, 0, 100, 0, false, this.controller);
        stepBox.add(this.stepSlider);
        this.add(stepBox);
    }

    private AbstractButton createButton(Box container, String key, boolean isToggle, ActionListener listener, String command) {
        AbstractButton helper = AnimalTranslator.getGUIBuilder().generateJButton(key, null, isToggle, listener);
        helper.setActionCommand(command);
        container.add(helper);
        return helper;
    }

    public void determineButtonState(int step) {
        AnimationState animState = this.animationWindow.getAnimationState();
        Link thisLink = animState.getAnimation().getLink(animState.getStep());
        if (thisLink.getMode() != 4) {
            this.enableControls(this.getButtonController().allowButtonAccess(step));
        } else {
            MessageDisplay.addDebugMessage("turnOffControls");
            this.enableControls(false);
        }
        this.stepField.setText(String.valueOf(step));
        this.stepField.repaint();
    }

    public void enableControls(boolean enabled) {
        this.pauseButton.setEnabled(enabled);
        this.stepField.setEnabled(enabled);
        this.stepSlider.setEnabled(enabled);
        int animationWindowStep = this.animationWindow.getStep();
        int lastStep = this.animationWindow.getAnimationState().getLastStep();
        int firstStep = this.animationWindow.getAnimationState().getFirstRealStep();
        boolean active = enabled && this.animationWindow.getStep() != firstStep;
        this.startButton.setEnabled(active);
        this.prevButton.setEnabled(active);
        this.reverseSlideButton.setEnabled(active);
        active = enabled && animationWindowStep != lastStep;
        this.playButton.setEnabled(active);
        this.slideShowButton.setEnabled(active);
        this.endButton.setEnabled(active);
    }

    public void enablePlayButton(boolean enabled) {
        this.playButton.setEnabled(enabled);
    }

    public ButtonController getButtonController() {
        if (this.buttonController == null) {
            this.setButtonController(Animal.get());
        }
        return this.buttonController;
    }

    public void setButtonController(ButtonController aController) {
        this.buttonController = aController;
    }

    public void setStep(int targetStep, AnimationState animState) {
        String linkLabel;
        int animationPercentage = 0;
        Animation anim = animState.getAnimation();
        if (anim.getNrOfSteps() != 0) {
            this.activateStepSliderListener(false);
            animationPercentage = Math.round((100 * anim.getPositionOfStep(targetStep) + 1) / (anim.getNrOfSteps() - 1));
            this.stepSlider.setValue(animationPercentage);
            this.activateStepSliderListener(true);
        }
        if ((linkLabel = anim.getLink(targetStep).getLinkLabel()) == null) {
            linkLabel = AnimalTranslator.translateMessage("sliderValue.toolTipText", new Object[]{String.valueOf(animationPercentage) + "%"});
        }
        this.stepSlider.setToolTipText(linkLabel);
        this.stepField.setText(String.valueOf(targetStep));
        this.stepField.repaint();
    }

    public void setNrOfSteps(int nrTotalSteps) {
        if (nrTotalSteps > 0) {
            this.nrSteps.setText("/ " + nrTotalSteps);
        }
    }
}

