/*
 * Decompiled with CFR 0.152.
 */
package animal.graphics;

import animal.graphics.PTGraphicObject;
import animal.misc.XProperties;
import java.awt.Color;
import java.awt.Point;

public abstract class PolygonalShape
extends PTGraphicObject {
    protected Color color;
    protected Color fillColor;
    protected Point firstNode = null;
    protected boolean isFilled = false;
    protected int depth = 0;
    protected String objectName = null;

    public String nodeToString(Point node) {
        StringBuilder sb = new StringBuilder(32);
        if (node != null) {
            sb.append("(").append(node.x).append(",").append(node.y).append(") ");
        }
        return sb.toString();
    }

    public Color getColor() {
        if (this.color == null) {
            this.color = this.getDefaultProperties().getColorProperty(String.valueOf(this.getType()) + ".color", Color.BLACK);
        }
        return this.color;
    }

    public abstract XProperties getDefaultProperties();

    public int getDepth() {
        return this.depth;
    }

    public Color getFillColor() {
        if (this.fillColor == null) {
            this.fillColor = this.getDefaultProperties().getColorProperty(String.valueOf(this.getType()) + ".fillColor", Color.BLACK);
        }
        return this.fillColor;
    }

    public Point getFirstNode() {
        if (this.firstNode == null) {
            this.firstNode = new Point(10, 10);
        }
        return this.firstNode;
    }

    public String getObjectName() {
        if (this.objectName == null || this.objectName.length() == 0) {
            this.objectName = String.valueOf(this.getNum(false));
        }
        return this.objectName;
    }

    public boolean isFilled() {
        return this.isFilled;
    }

    public void setColor(Color c) {
        this.color = c != null ? c : Color.BLACK;
        this.getDefaultProperties().put(String.valueOf(this.getType()) + ".color", c);
    }

    public void setDepth(int targetDepth) {
        this.depth = targetDepth;
    }

    public void setFillColor(Color c) {
        this.fillColor = c != null ? c : Color.BLACK;
        this.getDefaultProperties().put(String.valueOf(this.getType()) + ".fillColor", c);
    }

    public void setFilled(boolean filled) {
        this.isFilled = filled;
        this.getDefaultProperties().put(String.valueOf(this.getType()) + ".filled", filled);
    }

    public void setFirstNode(int x, int y) {
        if (this.firstNode == null) {
            this.firstNode = new Point(x, y);
        } else {
            this.firstNode.x = x;
            this.firstNode.y = y;
        }
    }

    public void setFirstNode(Point node) {
        if (node == null) {
            this.setFirstNode(0, 0);
        } else {
            this.setFirstNode(node.x, node.y);
        }
    }

    public void setObjectName(String newName) {
        this.objectName = newName;
    }

    protected void cloneCommonFeaturesInto(PolygonalShape targetShape) {
        targetShape.setDepth(this.getDepth());
        targetShape.setObjectName(this.getObjectName());
        Color c = this.getColor();
        targetShape.setColor(new Color(c.getRed(), c.getGreen(), c.getBlue()));
        targetShape.setFilled(this.isFilled());
        c = this.getFillColor();
        targetShape.setFillColor(new Color(c.getRed(), c.getGreen(), c.getBlue()));
        targetShape.setNum(this.getNum(false));
    }

    public void discard() {
        this.firstNode = null;
        this.color = null;
        this.fillColor = null;
        super.discard();
    }
}

