/*
 * Decompiled with CFR 0.152.
 */
package animal.graphics;

import animal.graphics.PTArray;
import animal.graphics.PTPolyline;
import animal.graphics.PTText;
import animal.main.Animal;
import animal.main.AnimalConfiguration;
import animal.misc.XProperties;
import java.awt.Color;
import java.awt.Font;
import java.awt.Point;

public class PTStringArray
extends PTArray {
    public static final String TYPE_LABEL = "StringArray";
    public static final String STRING_ARRAY_LOCATION = "StringArray.location";
    public static final String BG_COLOR = "StringArray.bgColor";
    public static final String FONT_COLOR = "StringArray.fontColor";
    public static final String FONT = "StringArray.font";
    public static final String HIGHLIGHT_COLOR = "StringArray.highlightColor";
    public static final String ELEM_HIGHLIGHT_COLOR = "StringArray.elemHighlightColor";
    public static final String OUTLINE_COLOR = "StringArray.outlineColor";
    public static final String ARRAY_SIZE = "StringArray.arraySize";
    public static final String SHOW_INDICES = "StringArray.showIndices";
    public static final String FONT_NAME = "StringArray.fontName";
    public static final String FONT_SIZE = "StringArray.fontSize";
    public static final String FONT_STYLE = "StringArray.fontStyle";

    public PTStringArray() {
        if (DefaultProperties == null) {
            PTStringArray.initializeDefaultProperties(AnimalConfiguration.getDefaultConfiguration().getProperties());
        }
        this.setProperties((XProperties)DefaultProperties.clone());
        this.showIndices = this.getProperties().getBoolProperty(this.mapKey(SHOW_INDICES), true);
        int nrEntries = this.getProperties().getIntProperty(this.mapKey(ARRAY_SIZE), 1);
        this.myFont = this.getProperties().getFontProperty(this.mapKey(FONT), new Font(this.getProperties().getProperty(this.mapKey(FONT_NAME), "Monospaced"), this.getProperties().getIntProperty(this.mapKey(FONT_STYLE), 0), this.getProperties().getIntProperty(this.mapKey(FONT_SIZE), 14)));
        this.fm = Animal.getConcreteFontMetrics(this.myFont);
        this.origin = new Point();
        this.init(nrEntries);
    }

    public PTStringArray(int nrEntries) {
        this();
        this.getProperties().put(this.mapKey(ARRAY_SIZE), this.length);
        this.init(nrEntries);
    }

    public PTStringArray(String[] s) {
        this(s.length);
        int i = 0;
        while (i < s.length) {
            this.enterValue(i, s[i]);
            ++i;
        }
    }

    public PTStringArray(XProperties props) {
        this.setProperties(props);
        this.showIndices = this.getProperties().getBoolProperty(this.mapKey(SHOW_INDICES), true);
        int nrEntries = this.getProperties().getIntProperty(this.mapKey(ARRAY_SIZE), 1);
        this.myFont = this.getProperties().getFontProperty(this.mapKey(FONT), new Font(this.getProperties().getProperty(this.mapKey(FONT_NAME), "Monospaced"), this.getProperties().getIntProperty(this.mapKey(FONT_STYLE), 0), this.getProperties().getIntProperty(this.mapKey(FONT_SIZE), 14)));
        this.fm = Animal.getConcreteFontMetrics(this.myFont);
        this.origin = new Point();
        this.init(nrEntries);
    }

    public String[] handledKeywords() {
        return new String[]{TYPE_LABEL};
    }

    public static void initializeDefaultProperties(XProperties prop) {
        DefaultProperties = PTStringArray.extractDefaultProperties(prop, TYPE_LABEL);
    }

    public int enterValue(int index, String val) {
        if (index >= 0 && index < this.entry.length) {
            this.entry[index].setText(val);
            int delta = index == 0 ? this.cellWidth(0) - this.entryPos[0] : this.cellWidth(index) - this.getBoundingBox((int)index).width;
            int i = index;
            while (i < this.entry.length) {
                if (i == index) {
                    this.resizeCell(i, delta, false);
                } else {
                    this.translate(i, delta, 0, true, true);
                }
                this.entryPos[i] = this.entryPos[i] + delta;
                ++i;
            }
            return 0;
        }
        return -1;
    }

    public String getValue(int index) {
        if (index >= 0 && index < this.entry.length) {
            return this.entry[index].getText();
        }
        return null;
    }

    public void setSize(int n) {
        this.getProperties().put(this.mapKey(ARRAY_SIZE), n);
        this.init(n);
    }

    public int getSize() {
        return this.getProperties().getIntProperty(this.mapKey(ARRAY_SIZE), 1);
    }

    public void setBGColor(Color c) {
        this.getProperties().put(this.mapKey(BG_COLOR), c);
        int i = 0;
        while (i < this.cells.length) {
            if (this.isActivated(i)) {
                this.cells[i].setFillColor(this.isHighlighted(i) ? this.getHighlightColor() : c);
            }
            ++i;
        }
    }

    public Color getBGColor() {
        return this.getProperties().getColorProperty(this.mapKey(BG_COLOR), Color.white);
    }

    public void setFont(Font f) {
        this.getProperties().put(this.reverseMapKey(FONT), f);
        this.myFont = f;
        int textOffset = -this.fm.getAscent();
        int heightOffset = -this.fm.getAscent() - this.fm.getDescent();
        this.fm = Animal.getConcreteFontMetrics(f);
        textOffset += this.fm.getAscent();
        heightOffset = heightOffset + this.fm.getAscent() + this.fm.getDescent();
        int widthOffset = 0;
        int i = 0;
        while (i < this.entry.length) {
            this.entry[i].setFont(f);
            this.translate(i, 0, textOffset, true, false);
            this.resizeCell(i, heightOffset);
            this.translate(i, widthOffset, 0, true, true);
            int prevOffset = widthOffset;
            widthOffset = widthOffset + this.cellWidth(i) - this.getBoundingBox((int)i).width;
            this.resizeCell(i, this.cellWidth(i) - this.getBoundingBox((int)i).width, false);
            if (i > 0) {
                this.entryPos[i - 1] = this.entryPos[i - 1] + prevOffset;
            }
            ++i;
        }
        this.entryPos[this.entryPos.length - 1] = this.entryPos[this.entryPos.length - 1] + widthOffset;
    }

    public Font getFont() {
        return this.getProperties().getFontProperty(this.mapKey(FONT), this.myFont);
    }

    public void setFontColor(Color c) {
        this.getProperties().put(this.mapKey(FONT_COLOR), c);
        int i = 0;
        while (i < this.entry.length) {
            if (this.isActivated(i)) {
                this.entry[i].setColor(this.isElemHighlighted(i) ? this.getElemHighlightColor() : c);
            }
            ++i;
        }
    }

    public Color getFontColor() {
        return this.getProperties().getColorProperty(this.mapKey(FONT_COLOR), Color.black);
    }

    public void setHighlightColor(Color c) {
        this.getProperties().put(this.mapKey(HIGHLIGHT_COLOR), c);
        int i = 0;
        while (i < this.cells.length) {
            if (this.isActivated(i)) {
                this.cells[i].setFillColor(this.isHighlighted(i) ? c : this.getBGColor());
            }
            ++i;
        }
    }

    public Color getHighlightColor() {
        return this.getProperties().getColorProperty(this.mapKey(HIGHLIGHT_COLOR), Color.yellow);
    }

    public void setElemHighlightColor(Color c) {
        this.getProperties().put(this.mapKey(ELEM_HIGHLIGHT_COLOR), c);
        int i = 0;
        while (i < this.entry.length) {
            if (this.isActivated(i)) {
                this.entry[i].setColor(this.isElemHighlighted(i) ? c : this.getFontColor());
            }
            ++i;
        }
    }

    public Color getElemHighlightColor() {
        return this.getProperties().getColorProperty(this.mapKey(ELEM_HIGHLIGHT_COLOR), Color.red);
    }

    public void setOutlineColor(Color c) {
        this.getProperties().put(this.mapKey(OUTLINE_COLOR), c);
        int i = 0;
        while (i < this.cells.length) {
            this.cells[i].setColor(c);
            ++i;
        }
    }

    public Color getOutlineColor() {
        return this.getProperties().getColorProperty(this.mapKey(OUTLINE_COLOR), Color.yellow);
    }

    public void showIndices(boolean state) {
        this.getProperties().put(this.mapKey(SHOW_INDICES), state);
        this.showIndices = state;
    }

    public boolean indicesShown() {
        return this.getProperties().getBoolProperty(this.mapKey(SHOW_INDICES), true);
    }

    public String getType() {
        return TYPE_LABEL;
    }

    public Object clone() {
        PTStringArray array = (PTStringArray)super.clone();
        PTArray.DefaultProperties = (XProperties)DefaultProperties.clone();
        array.clonePropertiesFrom(this.getProperties(), true);
        return array;
    }

    public int getFileVersion() {
        return 3;
    }

    protected void init(int nrEntries) {
        this.length = nrEntries;
        this.setDepth(this.getDepth() < 2 ? 2 : this.getDepth());
        this.entry = new PTText[this.length];
        this.entryPos = new int[this.length];
        this.cells = new PTPolyline[this.length];
        this.entry[0] = new PTText("a", this.myFont);
        this.entryPos[0] = this.cellWidth(0);
        this.entry[0].setLocation(new Point(this.origin.x + 5, this.origin.y + this.fm.getAscent() + 5));
        this.entry[0].setColor(this.getFontColor());
        this.entry[0].setDepth(this.getDepth() - 2);
        this.cells[0] = new PTPolyline(new int[]{this.origin.x, this.origin.x + this.entryPos[0], this.origin.x + this.entryPos[0], this.origin.x}, new int[]{this.origin.y, this.origin.y, this.origin.y + this.fm.getAscent() + this.fm.getDescent() + 10, this.origin.y + this.fm.getAscent() + this.fm.getDescent() + 10});
        this.cells[0].setDepth(this.getDepth());
        this.cells[0].setClosed(true);
        this.cells[0].setFilled(true);
        this.cells[0].setColor(this.getOutlineColor());
        this.cells[0].setFillColor(this.getBGColor());
        this.states = new byte[this.length];
        this.states[0] = 1;
        int index = 1;
        while (index < this.length) {
            this.entry[index] = new PTText(Character.toString(Character.forDigit(10 + index % 26, 36)), this.myFont);
            this.entryPos[index] = this.entryPos[index - 1] + this.cellWidth(index);
            this.entry[index].setLocation(new Point(this.origin.x + this.entryPos[index - 1] + 5, this.origin.y + this.fm.getAscent() + 5));
            this.entry[index].setColor(this.getFontColor());
            this.entry[index].setDepth(this.getDepth() - 2);
            this.cells[index] = new PTPolyline(new int[]{this.origin.x + this.entryPos[index - 1], this.origin.x + this.entryPos[index], this.origin.x + this.entryPos[index], this.origin.x + this.entryPos[index - 1]}, new int[]{this.origin.y, this.origin.y, this.origin.y + this.fm.getAscent() + this.fm.getDescent() + 10, this.origin.y + this.fm.getAscent() + this.fm.getDescent() + 10});
            this.cells[index].setDepth(this.getDepth());
            this.cells[index].setClosed(true);
            this.cells[index].setFilled(true);
            this.cells[index].setColor(this.getOutlineColor());
            this.cells[index].setFillColor(this.getBGColor());
            this.states[index] = 1;
            ++index;
        }
    }
}

