/*
 * Decompiled with CFR 0.152.
 */
package animal.graphics;

import animal.animator.MoveBase;
import animal.graphics.PTGraphicObject;
import animal.graphics.PTPoint;
import animal.main.AnimalConfiguration;
import animal.misc.AnimalTranslator;
import animal.misc.MSMath;
import animal.misc.MessageDisplay;
import animal.misc.XProperties;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.util.Vector;
import javax.swing.SwingUtilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PTPolyline
extends PTGraphicObject
implements MoveBase {
    public static final String TYPE_LABEL = "Polyline";
    public static final String POLYLINE_BW_ARROW = "Polyline.bwArrow";
    public static final String POLYLINE_CLOSED = "Polyline.closed";
    public static final String POLYLINE_COLOR = "Polyline.color";
    public static final String POLYLINE_FILL_COLOR = "Polyline.fillColor";
    public static final String POLYLINE_FILLED = "Polyline.filled";
    public static final String POLYLINE_FW_ARROW = "Polyline.fwArrow";
    private Vector<PTPoint> nodes = new Vector(50, 10);
    public static XProperties DefaultProperties;
    private static final long serialVersionUID = 5793164474737251118L;

    public PTPolyline() {
        if (DefaultProperties == null) {
            PTPolyline.initializeDefaultProperties(AnimalConfiguration.getDefaultConfiguration().getProperties());
        }
        this.setProperties((XProperties)DefaultProperties.clone());
        this.setClosed(false);
    }

    public PTPolyline(int[] xCoords, int[] yCoords) {
        this();
        this.setClosed(false);
        if (xCoords != null && yCoords != null && xCoords.length > 0 && xCoords.length == yCoords.length) {
            int i = 0;
            while (i < xCoords.length) {
                this.addNode(new PTPoint(xCoords[i], yCoords[i], 1));
                ++i;
            }
        }
        this.setClosed();
    }

    public PTPolyline(Point[] edges) {
        this();
        int i = 0;
        while (i < edges.length) {
            this.addNode(new PTPoint(edges[i]));
            ++i;
        }
    }

    public PTPolyline(PTPoint[] edges) {
        this();
        int i = 0;
        while (i < edges.length) {
            this.addNode(edges[i]);
            ++i;
        }
    }

    public PTPolyline(XProperties props) {
        this.setProperties(props);
        Point[] points = props.getPointArrayProperty(this.mapKey("node"));
        int i = 0;
        while (i < points.length) {
            PTPoint tmpPoint = new PTPoint(points[i]);
            tmpPoint.setObjectName(String.valueOf(this.getObjectName()) + ".node" + i);
            this.addNode(tmpPoint);
            ++i;
        }
    }

    @Override
    public int getFileVersion() {
        return 4;
    }

    public PTPoint getNode(int index) {
        if (index >= 0 && index < this.nodes.size()) {
            return this.nodes.elementAt(index);
        }
        return null;
    }

    public int getNodeCount() {
        return this.nodes.size();
    }

    @Override
    public String getType() {
        return TYPE_LABEL;
    }

    public static void initializeDefaultProperties(XProperties properties) {
        DefaultProperties = PTPolyline.extractDefaultProperties(properties, TYPE_LABEL);
    }

    public void addNode(PTPoint node) {
        if (!this.isClosed()) {
            this.nodes.addElement(node);
        } else if (this.getNodeCount() == 0) {
            this.nodes.addElement(node);
            this.nodes.addElement(node);
        } else {
            this.nodes.insertElementAt(node, this.getNodeCount() - 1);
        }
    }

    public Color getFillColor() {
        return this.getProperties().getColorProperty(this.mapKey(POLYLINE_FILL_COLOR), Color.black);
    }

    @Override
    public String[] handledKeywords() {
        return new String[]{TYPE_LABEL, "Polygon"};
    }

    public boolean hasFWArrow() {
        return this.getProperties().getBoolProperty(this.mapKey(POLYLINE_FW_ARROW), false);
    }

    public boolean hasBWArrow() {
        return this.getProperties().getBoolProperty(this.mapKey(POLYLINE_BW_ARROW), false);
    }

    public boolean isClosed() {
        return this.getProperties().getBoolProperty(this.mapKey(POLYLINE_CLOSED), false);
    }

    public boolean isFilled() {
        return this.getProperties().getBoolProperty(this.mapKey(POLYLINE_FILLED), false);
    }

    public void setBWArrow(boolean backward) {
        this.getProperties().put(this.mapKey(POLYLINE_BW_ARROW), backward);
    }

    public void setClosed(boolean closed) {
        if (this.isClosed() != closed) {
            if (closed) {
                if (this.getNodeCount() > 0) {
                    this.addNode(this.getNode(0));
                }
            } else if (this.getNodeCount() > 1) {
                this.removeNode(this.getNodeCount() - 1);
            }
        }
        this.getProperties().put(this.mapKey(POLYLINE_CLOSED), closed);
    }

    public void setClosed() {
        this.getProperties().put(this.mapKey(POLYLINE_CLOSED), this.getNode(0).equals(this.getNode(this.getNodeCount() - 1)));
    }

    @Override
    public void setColor(Color c) {
        this.getProperties().put(this.mapKey(POLYLINE_COLOR), c);
    }

    public void setFillColor(Color c) {
        this.getProperties().put(this.mapKey(POLYLINE_FILL_COLOR), c);
    }

    public void setFilled(boolean filled) {
        this.getProperties().put(this.mapKey(POLYLINE_FILLED), filled);
    }

    public void setFWArrow(boolean forward) {
        this.getProperties().put(this.mapKey(POLYLINE_FW_ARROW), forward);
    }

    public void rotate(double angle) {
        int max_index = this.getDifferentNodesCount();
        int node_nr = 0;
        while (node_nr < max_index) {
            this.nodes.elementAt(node_nr).rotate(angle);
            ++node_nr;
        }
    }

    public void rotate(double angle, PTPoint center) {
        int max_index = this.getDifferentNodesCount();
        int node_nr = 0;
        while (node_nr < max_index) {
            if (this.nodes.elementAt(node_nr) != null) {
                this.nodes.elementAt(node_nr).rotate(angle, center);
            }
            ++node_nr;
        }
    }

    public void scale(double scale_x, double scale_y) {
        int max_index = this.getDifferentNodesCount();
        int node_nr = 0;
        while (node_nr < max_index) {
            if (this.nodes.elementAt(node_nr) != null) {
                this.nodes.elementAt(node_nr).scale(scale_x, scale_y);
            }
            ++node_nr;
        }
    }

    public void shear(double shear_x, double shear_y) {
        int max_index = this.getDifferentNodesCount();
        int node_nr = 0;
        while (node_nr < max_index) {
            if (this.nodes.elementAt(node_nr) != null) {
                this.nodes.elementAt(node_nr).shear(shear_x, shear_y);
            }
            ++node_nr;
        }
    }

    public int getDifferentNodesCount() {
        int c = this.nodes.size();
        if (this.isClosed() && c > 0 && this.nodes.elementAt(0) == this.nodes.elementAt(c - 1)) {
            return c - 1;
        }
        return c;
    }

    @Override
    public void translate(int delta_x, int delta_y) {
        int max_index = this.getDifferentNodesCount();
        int node_nr = 0;
        while (node_nr < max_index) {
            if (this.nodes.elementAt(node_nr) != null) {
                this.nodes.elementAt(node_nr).translate(delta_x, delta_y);
            }
            ++node_nr;
        }
    }

    public void translate(int aNum, int delta_x, int delta_y) {
        this.nodes.elementAt(aNum).translate(delta_x, delta_y);
    }

    public void translate(boolean[] moveTheseOnly, int deltaX, int deltaY) {
        int maxIndex = this.getDifferentNodesCount();
        int nodeNr = 0;
        while (nodeNr < maxIndex) {
            if (this.nodes.elementAt(nodeNr) != null && moveTheseOnly[nodeNr]) {
                this.nodes.elementAt(nodeNr).translate(deltaX, deltaY);
            }
            ++nodeNr;
        }
    }

    public String toString() {
        StringBuilder result = new StringBuilder(120);
        if (this.isClosed()) {
            result.append("PTPolygon ");
        } else {
            result.append("PTPolyline ");
        }
        if (this.getObjectName() != null) {
            result.append("\"").append(this.getObjectName()).append("\" ");
        }
        result.append("{ ");
        int limit = this.nodes.size();
        int i = 0;
        while (i < limit) {
            result.append(this.nodes.elementAt(i).toString()).append(i < limit - 1 ? ", " : "");
            ++i;
        }
        result.append(" }");
        return result.toString();
    }

    public Vector<PTPoint> getNodes() {
        return this.nodes;
    }

    public void setNodes(Vector<PTPoint> newNodes) {
        this.nodes = newNodes;
    }

    public void setNode(int index, PTPoint p) {
        if (index >= this.nodes.size() - (this.isClosed() ? 1 : 0)) {
            this.addNode(p);
        } else if (index == 0 && this.isClosed()) {
            this.nodes.setElementAt(p, 0);
            this.nodes.setElementAt(p, this.nodes.size() - 1);
        } else {
            this.nodes.setElementAt(p, index);
        }
    }

    void removeNodes() {
        if (this.nodes == null) {
            this.nodes = new Vector(20, 10);
        } else {
            this.nodes.clear();
        }
    }

    public void removeNode(int index) {
        this.nodes.removeElementAt(index);
    }

    public Polygon toPolygon() {
        int numNodes = this.nodes.size();
        int[] xpoints = new int[numNodes + 1];
        int[] ypoints = new int[numNodes + 1];
        Point oldP = null;
        int counter = 0;
        int i = 0;
        while (i < numNodes) {
            Point p = this.getNode(i).toPoint();
            if (!p.equals(oldP)) {
                xpoints[counter] = p.x;
                ypoints[counter] = p.y;
                ++counter;
            }
            oldP = p;
            ++i;
        }
        return new Polygon(xpoints, ypoints, counter);
    }

    @Override
    public void paint(Graphics g) {
        if (this.getNodeCount() > 1) {
            Polygon poly = this.toPolygon();
            int numNodes = poly.npoints;
            if (numNodes > 1) {
                if (numNodes < 4 || !this.isClosed()) {
                    g.setColor(this.getColor());
                    g.drawPolyline(poly.xpoints, poly.ypoints, numNodes);
                    if (!this.isClosed()) {
                        if (this.hasBWArrow()) {
                            this.drawArrow(g, false);
                        }
                        if (this.hasFWArrow()) {
                            this.drawArrow(g, true);
                        }
                    }
                } else {
                    if (this.isFilled()) {
                        g.setColor(this.getFillColor());
                        g.fillPolygon(poly);
                    }
                    g.setColor(this.getColor());
                    g.drawPolygon(poly);
                }
            }
        }
    }

    protected static void drawArrow(Graphics g, Point tip, Point tail) {
        if (tip == null || tail == null) {
            MessageDisplay.errorMsg(AnimalTranslator.translateMessage("internalError", new String[]{"tip / tail null", "PTPolyline.drawArrow"}), 16);
            return;
        }
        int xDiff = tail.x - tip.x;
        int yDiff = tail.y - tip.y;
        int dist = MSMath.dist(tip, tail);
        if (dist > 0) {
            if (dist < 20) {
                dist = 20;
            }
            xDiff = xDiff * 20 / dist;
            yDiff = yDiff * 20 / dist;
            int[] x = new int[]{tip.x, tip.x + yDiff / 2 + xDiff, tip.x + xDiff / 2, tip.x - yDiff / 2 + xDiff};
            int[] y = new int[]{tip.y, tip.y - xDiff / 2 + yDiff, tip.y + yDiff / 2, tip.y + xDiff / 2 + yDiff};
            g.fillPolygon(x, y, 4);
        }
    }

    /*
     * Unable to fully structure code
     */
    private void drawArrow(Graphics g, boolean forward) {
        block2: {
            nc = this.getNodeCount() - 1;
            startPoint = this.getNode(forward != false ? nc : 0).toPoint();
            next = forward != false ? nc - 1 : 1;
            nextPoint = null;
            if (!forward) ** GOTO lbl11
            while (next >= 0 && startPoint.equals(nextPoint = this.getNode(next).toPoint())) {
                --next;
            }
            break block2;
lbl-1000:
            // 1 sources

            {
                ++next;
lbl11:
                // 2 sources

                ** while (next <= nc && startPoint.equals((Object)(nextPoint = this.getNode((int)next).toPoint())))
            }
        }
        PTPolyline.drawArrow(g, startPoint, nextPoint);
    }

    @Override
    public Object clone() {
        PTPolyline p = (PTPolyline)super.clone();
        p.clonePropertiesFrom(this.getProperties(), true);
        p.nodes = new Vector(this.nodes.size());
        int a = 0;
        while (a < this.nodes.size()) {
            p.nodes.addElement((PTPoint)this.nodes.elementAt(a).clone());
            ++a;
        }
        return p;
    }

    @Override
    public int getLength() {
        int result = 0;
        int i = 0;
        while (i < this.getNodeCount() - 1) {
            result += MSMath.dist(this.getNode(i).toPoint(), this.getNode(i + 1).toPoint());
            ++i;
        }
        return result;
    }

    @Override
    public Point getPointAtLength(int length) {
        int i = 0;
        while (i < this.getNodeCount() - 1) {
            Point b;
            Point a = this.getNode(i).toPoint();
            int lineLength = MSMath.dist(a, b = this.getNode(i + 1).toPoint());
            if (lineLength >= length) {
                float percent = 1.0f * (float)length / (float)lineLength;
                return new Point((int)((float)a.x + (float)(b.x - a.x) * percent), (int)((float)a.y + (float)(b.y - a.y) * percent));
            }
            length -= lineLength;
            ++i;
        }
        return this.getNode(0).toPoint();
    }

    @Override
    public void useAsMoveBase() {
        this.setClosed(false);
        this.setFWArrow(true);
        this.setBWArrow(false);
    }

    @Override
    public boolean operationRequiresNodeSelector(String operation) {
        return operation != null && operation.indexOf("Nodes") != -1;
    }

    @Override
    public String baseOperationName(String methodName) {
        if (methodName.endsWith("...")) {
            return methodName.substring(0, methodName.indexOf(46));
        }
        if (methodName.indexOf("Nodes") != 0) {
            return methodName.substring(0, methodName.indexOf(32));
        }
        return methodName;
    }

    @Override
    public boolean enableMultiSelectionFor(String operation) {
        return operation != null && operation.indexOf("Nodes") != -1;
    }

    public boolean compatibleMethod(String method) {
        return method != null && method.indexOf("Nodes") != -1;
    }

    @Override
    public Rectangle getBoundingBox() {
        if (this.getNodeCount() == 0) {
            return new Rectangle(0, 0, 0, 0);
        }
        Rectangle r = new Rectangle(this.getNode(0).toPoint());
        int i = 1;
        while (i < this.getNodeCount()) {
            Point p = this.getNode(i).toPoint();
            r = SwingUtilities.computeUnion(p.x, p.y, 0, 0, r);
            ++i;
        }
        return r;
    }

    @Override
    public void discard() {
        this.nodes.removeAllElements();
        this.nodes = null;
        this.setFillColor(null);
        super.discard();
    }
}

