/*
 * Decompiled with CFR 0.152.
 */
package animal.graphics;

import animal.graphics.PTArc;
import animal.graphics.PTGraphicObject;
import animal.graphics.PTText;
import animal.main.Animal;
import animal.main.AnimalConfiguration;
import animal.misc.XProperties;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;

public class PTNode
extends PTGraphicObject {
    public static final String TYPE_LABEL = "Node";
    public static final String FONT = "Node.Font";
    public static final String FONT_NAME = "Node.fontName";
    public static final String FONT_SIZE = "Node.fontSize";
    public static final String FONT_COLOR = "Node.fontColor";
    public static final String OUTLINE_COLOR = "Node.outlineColor";
    public static final String BG_COLOR = "Node.bgColor";
    public static XProperties DefaultProperties;
    private Font myFont;
    private FontMetrics fm;
    private PTText entry;
    private PTArc node;
    private int[] connections;

    public PTNode() {
        if (DefaultProperties == null) {
            PTNode.initializeDefaultProperties(AnimalConfiguration.getDefaultConfiguration().getProperties());
        }
        this.setProperties((XProperties)DefaultProperties.clone());
        this.myFont = this.getProperties().getFontProperty(this.mapKey(FONT), new Font(this.getProperties().getProperty(this.mapKey(FONT_NAME), "Monospaced"), 0, this.getProperties().getIntProperty(this.mapKey(FONT_SIZE), 14)));
        this.fm = Animal.getConcreteFontMetrics(this.myFont);
    }

    public PTNode(String s) {
        this();
        this.enterValue(s);
    }

    public PTNode(XProperties props) {
        this.setProperties(props);
        this.myFont = this.getProperties().getFontProperty(this.mapKey(FONT), new Font(this.getProperties().getProperty(this.mapKey(FONT_NAME), "Monospaced"), 0, this.getProperties().getIntProperty(this.mapKey(FONT_SIZE), 14)));
        this.fm = Animal.getConcreteFontMetrics(this.myFont);
    }

    public void setDepth(int newDepth) {
        newDepth = newDepth < 2 ? 2 : newDepth;
        super.setDepth(newDepth);
        if (this.entry != null) {
            this.entry.setDepth(newDepth - 2);
            this.node.setDepth(newDepth);
        }
    }

    public String[] handledKeywords() {
        return new String[]{TYPE_LABEL};
    }

    public static void initializeDefaultProperties(XProperties prop) {
        DefaultProperties = PTNode.extractDefaultProperties(prop, TYPE_LABEL);
    }

    public void setBGColor(Color c) {
        this.getProperties().put(this.mapKey(BG_COLOR), c);
        this.node.setFillColor(c);
    }

    public void setFont(Font f) {
        this.getProperties().put(this.reverseMapKey(FONT), f);
        this.myFont = f;
        int textOffset = -this.fm.getAscent();
        int heightOffset = -this.fm.getAscent() - this.fm.getDescent();
        this.fm = Animal.getConcreteFontMetrics(f);
        textOffset += this.fm.getAscent();
        heightOffset = heightOffset + this.fm.getAscent() + this.fm.getDescent();
        this.entry.setFont(f);
    }

    public Font getFont() {
        return this.getProperties().getFontProperty(this.mapKey(FONT), this.myFont);
    }

    public Color getBGColor() {
        return this.getProperties().getColorProperty(this.mapKey(BG_COLOR), Color.white);
    }

    public void setFontColor(Color c) {
        this.getProperties().put(this.mapKey(FONT_COLOR), c);
        this.entry.setColor(c);
    }

    public Color getFontColor() {
        return this.getProperties().getColorProperty(this.mapKey(FONT_COLOR), Color.black);
    }

    public void setOutlineColor(Color c) {
        this.getProperties().put(this.mapKey(OUTLINE_COLOR), c);
        this.node.setColor(c);
    }

    public Color getOutlineColor() {
        return this.getProperties().getColorProperty(this.mapKey(OUTLINE_COLOR), Color.yellow);
    }

    public void enterValue(String val) {
        this.entry.setText(val);
    }

    public String getValue() {
        return this.entry.getText();
    }

    public void translate(int dx, int dy) {
    }

    public Rectangle getBoundingBox() {
        return new Rectangle(0, 0, 10, 10);
    }

    public Point getArrowPoint(int i) {
        return new Point(-1, -1);
    }

    public String getType() {
        return TYPE_LABEL;
    }

    public Object clone() {
        PTNode newNode = (PTNode)super.clone();
        return newNode;
    }

    public String toString() {
        String toString = new String();
        toString = this.getType();
        if (this.getObjectName() != null) {
            toString.concat(" '" + this.getObjectName() + "'");
        }
        toString.concat(" connected to");
        int c = 0;
        while (c < this.connections.length) {
            toString.concat(" " + this.connections[c]);
            if (c < this.connections.length - 2) {
                toString.concat(",");
            } else if (c == this.connections.length - 2) {
                toString.concat(" and");
            }
            ++c;
        }
        return toString;
    }

    public int getFileVersion() {
        return 1;
    }

    private void updateEdges() {
    }

    public void paint(Graphics g) {
        this.updateEdges();
        this.node.paint(g);
        this.entry.paint(g);
    }
}

