/*
 * Decompiled with CFR 0.152.
 */
package animal.graphics;

import animal.handler.GraphicObjectHandler;
import animal.main.Animation;
import animal.misc.EditableObject;
import animal.misc.MessageDisplay;
import animal.misc.XProperties;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Hashtable;

public abstract class PTGraphicObject
extends EditableObject
implements PropertyChangeListener {
    public static final String COLOR_LABEL = "color";
    public static final String DEPTH_LABEL = "depth";
    public static final String NAME_LABEL = "name";
    public static final String NODE_LABEL = "node";
    public static final String EMPTY_STRING = "";
    private static final long serialVersionUID = -20443585871477440L;
    public static Hashtable<String, String> registeredTypes = new Hashtable(43);
    public static Hashtable<String, GraphicObjectHandler> registeredHandlers = new Hashtable(43);
    protected int num;
    String numericIDs;

    public abstract void paint(Graphics var1);

    public void propertyChange(PropertyChangeEvent e) {
        if (this.getHandler() != null) {
            this.getHandler().propertyChange(this, e);
        } else {
            MessageDisplay.errorMsg("propertyChangePTGOIllegal", new String[]{this.getClass().getName()}, 8);
        }
    }

    public abstract void translate(int var1, int var2);

    public String baseOperationName(String method) {
        return method;
    }

    public boolean isCompatibleMethod(String method) {
        return false;
    }

    public boolean enableMultiSelectionFor(String operation) {
        return false;
    }

    public abstract Rectangle getBoundingBox();

    public Color getColor() {
        return this.getProperties().getColorProperty(this.mapKey(String.valueOf(this.getType()) + "." + COLOR_LABEL), Color.black);
    }

    public int getDepth() {
        return this.getProperties().getIntProperty(this.mapKey(String.valueOf(this.getType()) + "." + DEPTH_LABEL), 50);
    }

    public int getFileVersion() {
        return 1;
    }

    public Font getFont() {
        return null;
    }

    public GraphicObjectHandler getHandler() {
        return registeredHandlers.get(this.getType());
    }

    public abstract String[] handledKeywords();

    public Point getLocation() {
        return this.getBoundingBox().getLocation();
    }

    public int getNum(boolean unique) {
        if (this.num == 0 && unique) {
            this.num = Animation.get().getUniqueGraphicObjectNum();
        }
        return this.num;
    }

    public String getNumericIDs() {
        return this.numericIDs;
    }

    public String getObjectName() {
        String name;
        if (this.getProperties() != null && ((name = this.getProperties().getProperty(this.mapKey(String.valueOf(this.getType()) + "." + NAME_LABEL), null)) == null || name.length() == 0)) {
            name = String.valueOf(this.getNum(false));
            this.setObjectName(name);
        }
        return String.valueOf(this.getNum(false));
    }

    public abstract String getType();

    public static XProperties extractDefaultProperties(XProperties props, String prefix) {
        return props.getElementsForPrefix(prefix);
    }

    public static void initializeDefaultProperties(XProperties xProperties) {
        MessageDisplay.errorMsg("initPropsIllegalAtPTGO", 4);
    }

    public boolean operationRequiresNodeSelector(String operation) {
        return false;
    }

    public void resetNum() {
        this.num = 0;
    }

    public void setColor(Color color) {
        this.getProperties().put(this.mapKey(String.valueOf(this.getType()) + "." + COLOR_LABEL), color);
    }

    public void setDepth(int newDepth) {
        this.getProperties().put(this.mapKey(String.valueOf(this.getType()) + "." + DEPTH_LABEL), newDepth);
    }

    public void setFont(Font font) {
    }

    public void setLocation(Point targetPoint) {
        Point originPoint = this.getBoundingBox().getLocation();
        int dx = targetPoint.x - originPoint.x;
        int dy = targetPoint.y - originPoint.y;
        this.translate(dx, dy);
    }

    public void setObjectName(String targetName) {
        this.getProperties().put(this.mapKey(String.valueOf(this.getType()) + "." + NAME_LABEL), targetName);
    }

    public void setNum(int value) {
        this.num = value;
    }

    public void setNumericIDs(String ids) {
        this.numericIDs = ids;
    }

    public Object safeClone() {
        PTGraphicObject clonedBaseObject = (PTGraphicObject)this.clone();
        clonedBaseObject.setProperties((XProperties)this.getProperties().clone());
        return clonedBaseObject;
    }

    public Object clone() {
        PTGraphicObject ptgo = (PTGraphicObject)super.clone();
        ptgo.clonePropertiesFrom(this.getProperties(), true);
        return ptgo;
    }

    public void discard() {
        this.numericIDs = null;
    }
}

