/*
 * Decompiled with CFR 0.152.
 */
package animal.graphics;

import animal.graphics.Location;
import java.awt.Point;

public class ObjectRelativeLocation
extends Location {
    private int dx;
    private int dy;
    private int orientation;
    public static final int NW = 1;
    public static final int N = 2;
    public static final int NE = 3;
    public static final int W = 4;
    public static final int C = 5;
    public static final int E = 6;
    public static final int SW = 7;
    public static final int S = 8;
    public static final int SE = 9;
    private int referenceID;

    public ObjectRelativeLocation(Point offset, int targetOrientation, int reference) {
        if (offset != null) {
            this.setOffset(offset.x, offset.y, targetOrientation, reference);
        } else {
            this.setOffset(0, 0, targetOrientation, reference);
        }
    }

    public ObjectRelativeLocation(int deltaX, int deltaY, int targetOrientation, int reference) {
        this.setOffset(deltaX, deltaY, targetOrientation, reference);
    }

    private void setOffset(int deltaX, int deltaY, int targetOrientation, int reference) {
        this.dx = deltaX;
        this.dy = deltaY;
        this.orientation = targetOrientation;
        this.referenceID = reference;
    }

    public Point getLocation() {
        Point theLocation = new Point(0, 0);
        return theLocation;
    }

    public void setLocation(int x, int y) {
        Point tmp = new Point(x, y);
        this.setLocation(tmp);
    }

    public void setLocation(Point location) {
        if (location != null) {
            this.setLocation(location.x, location.y);
        } else {
            this.setLocation(0, 0);
        }
    }

    public String printLocation() {
        StringBuilder sb = new StringBuilder(32);
        sb.append("offset (").append(this.dx).append(", ");
        sb.append(this.dy).append(") from ").append(this.referenceID).append(" ").append(this.orientation);
        return sb.toString();
    }

    public void translate(int deltaX, int deltaY) {
        this.dx += deltaX;
        this.dy += deltaY;
    }

    public void translate(Point translateDelta) {
        if (translateDelta != null) {
            this.translate(translateDelta.x, translateDelta.y);
        }
    }
}

