/*
 * Decompiled with CFR 0.152.
 */
package animal.exchange.animalscript;

import animal.animator.Animator;
import animal.exchange.animalscript.Exporter;
import animal.exchange.animalscript.PTGraphicObjectExporter;
import animal.graphics.PTGraphicObject;
import java.util.Hashtable;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnimatorExporter
implements Exporter {
    static PTGraphicObject[] graphicObjects = null;
    static Hashtable<String, Exporter> objectExporters = new Hashtable(53);

    public static void setGraphicObjects(Vector<PTGraphicObject> objects) {
        int nrOfGraphicObjects = objects.size();
        PTGraphicObject lastGO = objects.lastElement();
        int lastObjectNumber = -1;
        int i = 0;
        while (i < nrOfGraphicObjects) {
            lastGO = objects.elementAt(i);
            if (lastGO.getNum(false) > lastObjectNumber) {
                lastObjectNumber = lastGO.getNum(false);
            }
            ++i;
        }
        graphicObjects = new PTGraphicObject[lastObjectNumber + 1];
        PTGraphicObject currentObject = null;
        int i2 = 0;
        while (i2 < nrOfGraphicObjects) {
            currentObject = objects.elementAt(i2);
            if (currentObject != null) {
                AnimatorExporter.graphicObjects[currentObject.getNum((boolean)false)] = currentObject;
            }
            ++i2;
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(2048);
        int i = 0;
        while (i < graphicObjects.length) {
            sb.append("@").append(i).append(": ").append(graphicObjects[i].getNum(false));
            ++i;
        }
        return sb.toString();
    }

    public String getExportString(Animator animator) {
        return "#***getExportString should never be invoked here " + this.getClass().getName() + " for " + animator;
    }

    public String exportObjectIDs(Animator animator) {
        int[] objectNums = animator.getObjectNums();
        return this.exportObjectIDs(objectNums);
    }

    public String exportObjectIDs(int objectNum) {
        return this.exportObjectIDs(new int[]{objectNum});
    }

    public String exportUsedObjects(int objectNum) {
        return this.exportUsedObjects(new int[]{objectNum});
    }

    public String exportUsedObjects(int[] objectNums) {
        return this.exportUsedObjects(objectNums, true);
    }

    public String exportUsedObjects(int[] objectNums, boolean isVisible) {
        PTGraphicObject ptgo = null;
        String className = null;
        String subName = null;
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < objectNums.length) {
            ptgo = graphicObjects[objectNums[i]];
            if (ptgo != null && !PTGraphicObjectExporter.getExportStatus(ptgo)) {
                className = ptgo.getClass().getName();
                try {
                    if (!objectExporters.containsKey(className)) {
                        StringBuilder handlerName = new StringBuilder("animal.exchange.animalscript.");
                        handlerName.append(className.substring(className.lastIndexOf(46) + 1));
                        handlerName.append("Exporter");
                        subName = handlerName.toString();
                        Class<?> c = Class.forName(subName);
                        PTGraphicObjectExporter handler = (PTGraphicObjectExporter)c.newInstance();
                        objectExporters.put(className, handler);
                    }
                    PTGraphicObjectExporter localHandler = (PTGraphicObjectExporter)objectExporters.get(className);
                    sb.append(localHandler.getExportString(ptgo));
                    if (!isVisible) {
                        sb.append(" hidden");
                    }
                    sb.append("\n").append("  ");
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            ++i;
        }
        return sb.toString();
    }

    public String exportObjectIDs(int[] objectNums) {
        PTGraphicObject ptgo = null;
        String currentName = null;
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (objectNums != null && i < objectNums.length) {
            sb.append(" \"");
            ptgo = graphicObjects[objectNums[i]];
            currentName = ptgo.getObjectName();
            if (currentName == null) {
                currentName = String.valueOf(ptgo.getNum(false));
            }
            sb.append(currentName);
            sb.append("\"");
            ++i;
        }
        return sb.toString();
    }
}

