/*
 * Decompiled with CFR 0.152.
 */
package animal.exchange.animalascii;

import animal.animator.Swap;
import animal.exchange.animalascii.TimedAnimatorImporter;
import animal.misc.MessageDisplay;
import animal.misc.ParseSupport;
import animal.misc.XProperties;
import java.io.IOException;
import java.io.StreamTokenizer;

public class SwapImporter
extends TimedAnimatorImporter {
    public Object importFrom(int version, int currentStep, StreamTokenizer stok) {
        XProperties props = new XProperties();
        int first = 0;
        int second = 1;
        int type = 0;
        int[] idList = new int[1];
        try {
            props.put("step", currentStep);
            props.put("objectNums", ParseSupport.parseObjectIDs(stok, "Swap"));
            if (stok.ttype != 10) {
                this.parseASCIIWithoutIDs(stok, currentStep, props.getProperty("method"), props);
            }
            ParseSupport.parseMandatoryWord(stok, "Swap cells keyword 'swapping'", "swapping");
            ParseSupport.parseMandatoryWord(stok, "Swap cells keyword 'cells'", "cells");
            first = ParseSupport.parseInt(stok, "First swap cell", 0);
            ParseSupport.parseMandatoryWord(stok, "Keyord 'and'", "and");
            second = ParseSupport.parseInt(stok, "Second swap cell", 0);
            if (version >= 2) {
                ParseSupport.parseMandatoryWord(stok, "Swap type keyword 'with'", "with");
                ParseSupport.parseMandatoryWord(stok, "Swap type keyword 'type'", "type");
                type = ParseSupport.parseInt(stok, "Animation type", 0, 1);
            }
            ParseSupport.parseMandatoryWord(stok, "Keyword 'using'", "using");
            idList = new int[ParseSupport.parseInt(stok, "Number of IDs", 5)];
            ParseSupport.parseMandatoryWord(stok, "Keyword 'IDs'", "IDs");
            int i = 0;
            while (i < idList.length) {
                idList[i] = ParseSupport.parseInt(stok, "Used IDs", 1);
                ++i;
            }
        }
        catch (IOException e) {
            MessageDisplay.errorMsg(e.getMessage(), 4);
        }
        Swap swap = new Swap(props);
        if (idList != null && idList.length > 1) {
            swap.restoreIDs(idList);
        } else {
            MessageDisplay.errorMsg("reassigningSwapCells", 2);
        }
        swap.setObjects(swap.getObjectNums());
        swap.setAnimationType(type);
        swap.setSwapElements(first, second);
        return swap;
    }
}

