/*
 * Decompiled with CFR 0.152.
 */
package animal.exchange.animalascii;

import animal.exchange.animalascii.PTGraphicObjectImporter;
import animal.graphics.PTPoint;
import animal.graphics.PTPolyline;
import animal.misc.MessageDisplay;
import animal.misc.ParseSupport;
import animal.misc.XProperties;
import animalscript.core.AnimalParseSupport;
import java.awt.Color;
import java.io.IOException;
import java.io.StreamTokenizer;
import java.util.Vector;

public class PTPolylineImporter
extends PTGraphicObjectImporter {
    public Object importFrom(int version, StreamTokenizer stok) {
        XProperties properties = new XProperties();
        Color fillColor = Color.white;
        Vector<PTPoint> nodes = new Vector<PTPoint>();
        try {
            PTPolyline dummy = new PTPolyline();
            if (version > dummy.getFileVersion()) {
                ParseSupport.formatException2("fileVersionMismatch", new Object[]{String.valueOf(version), String.valueOf(dummy.getFileVersion()), stok.toString()});
            }
            dummy = null;
            properties.put("Polyline.color", ParseSupport.parseColor(stok, "Polyline"));
            properties.put("Polyline.fwArrow", ParseSupport.parseOptionalWord(stok, "Polyline fwArrow", "fwArrow"));
            properties.put("Polyline.bwArrow", ParseSupport.parseOptionalWord(stok, "Polyline bwArrow", "bwArrow"));
            properties.put("Polyline.closed", ParseSupport.parseOptionalWord(stok, "Polyline closed", "closed"));
            properties.put("Polyline.filled", ParseSupport.parseOptionalWord(stok, "Polyline filled", "filled"));
            ParseSupport.parseMandatoryWord(stok, "Polyline keyword 'nodes'", "nodes");
            ParseSupport.parseMandatoryChar(stok, "Polyline keyword nodes ':'", ':');
            nodes = AnimalParseSupport.parsePolyline(stok, "Polyline nodes").getNodes();
            fillColor = ParseSupport.parseColor(stok, "Polyline", "fillColor");
            if (version >= 4) {
                ParseSupport.parseMandatoryWord(stok, "Polyline keyword 'depth'", "depth");
                properties.put("Polyline.depth", ParseSupport.parseInt(stok, "Polyline depth"));
            }
        }
        catch (IOException e) {
            MessageDisplay.errorMsg(e.getMessage(), 4);
        }
        PTPolyline thePolyline = new PTPolyline(properties);
        thePolyline.setFillColor(fillColor);
        thePolyline.setNodes(nodes);
        return thePolyline;
    }
}

