/*
 * Decompiled with CFR 0.152.
 */
package animal.exchange.animalascii;

import animal.exchange.animalascii.PTGraphicObjectExporter;
import animal.graphics.PTGraphicObject;
import animal.graphics.PTPoint;
import animal.graphics.PTPolyline;
import java.awt.Color;
import java.io.PrintWriter;

public class PTPolylineExporter
extends PTGraphicObjectExporter {
    public void exportTo(PrintWriter pw, PTGraphicObject ptgo) {
        PTPolyline polyline = (PTPolyline)ptgo;
        pw.print(polyline.getFileVersion());
        pw.print(" object ");
        pw.print(polyline.getNum(false));
        Color color = polyline.getColor();
        pw.print(" Polyline color (");
        pw.print(color.getRed());
        pw.print(",");
        pw.print(color.getGreen());
        pw.print(",");
        pw.print(color.getBlue());
        pw.print(") ");
        if (polyline.hasFWArrow()) {
            pw.print("fwArrow ");
        }
        if (polyline.hasBWArrow()) {
            pw.print("bwArrow ");
        }
        if (polyline.isClosed()) {
            pw.print("closed ");
        }
        if (polyline.isFilled()) {
            pw.print("filled ");
        }
        pw.print("nodes: {");
        int n = polyline.getNodeCount();
        PTPoint node = null;
        int i = 0;
        while (i < n) {
            node = polyline.getNode(i);
            pw.print(" (");
            pw.print(node.getX());
            pw.print(",");
            pw.print(node.getY());
            pw.print(")");
            ++i;
        }
        color = polyline.getFillColor();
        pw.print("} fillColor (");
        pw.print(color.getRed());
        pw.print(",");
        pw.print(color.getGreen());
        pw.print(",");
        pw.print(color.getBlue());
        pw.print(')');
        pw.print(" depth ");
        pw.println(polyline.getDepth());
    }
}

