/*
 * Decompiled with CFR 0.152.
 */
package animal.exchange;

import animal.exchange.FormatSpecification;
import animal.gui.AnimalMainWindow;
import animal.main.Animal;
import animal.main.AnimalConfiguration;
import animal.main.Animation;
import animal.main.AnimationListEntry;
import animal.main.AnimationWindow;
import animal.misc.AnimalFileChooser;
import animal.misc.AnimalTranslator;
import animal.misc.MessageDisplay;
import java.awt.Point;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;

public abstract class AnimationImporter
implements FormatSpecification {
    public static final int IMPORT_STATIC_SNAPSHOT = 1;
    public static final int IMPORT_DYNAMIC_STEP = 2;
    protected static AnimalConfiguration animalConfig = null;
    public static AnimalFileChooser fileChooser;
    private static AnimationImporter lastImporter;
    protected Animation animationToImport = null;
    protected int importCapabilities = 1;
    protected boolean[] importSteps = null;
    protected int importType = 1;
    String formatName = null;

    static {
        lastImporter = null;
    }

    public static AnimalFileChooser getFileChooser() {
        if (animalConfig == null) {
            animalConfig = AnimalConfiguration.getDefaultConfiguration();
        }
        return animalConfig.getImportFileChooser();
    }

    public static AnimationImporter getImporterFor(String format) {
        String handlerName = AnimationImporter.getHandlerFor(format);
        if (handlerName == null) {
            return null;
        }
        AnimationImporter handler = null;
        try {
            Class<?> c = Class.forName(handlerName);
            if (c != null) {
                handler = (AnimationImporter)c.newInstance();
            }
        }
        catch (Exception e) {
            MessageDisplay.errorMsg("missingOrImproperImporter", new String[]{handlerName, format}, 4);
        }
        if (handler != null) {
            handler.init(format);
        }
        lastImporter = handler;
        return handler;
    }

    public static AnimationImporter getLastImporter() {
        return lastImporter;
    }

    public static String getHandlerFor(String formatName) {
        if (animalConfig.validImportFormat(formatName)) {
            if (animalConfig != null) {
                return animalConfig.getImportHandlerFor(formatName);
            }
            return AnimalConfiguration.getDefaultConfiguration().getImportHandlerFor(formatName);
        }
        MessageDisplay.errorMsg("unknownFormat", new String[]{formatName}, 4);
        return null;
    }

    public Animation getAnimation() {
        return this.animationToImport;
    }

    public void init(String format) {
        this.formatName = format;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Animation importAnimationFrom(String filename) {
        Animation tmpAnimation = null;
        Animal.setAnimationLoadFinished(false);
        try {
            InputStream in = null;
            if (filename.startsWith("http:") || filename.startsWith("https:") || filename.startsWith("file:")) {
                URL targetURL = new URL(filename);
                if (targetURL == null) {
                    return null;
                }
                in = targetURL.openStream();
            } else {
                in = new FileInputStream(filename);
            }
            tmpAnimation = this.importAnimationFrom(in, filename);
            in.close();
            return tmpAnimation;
        }
        catch (IOException e) {
            MessageDisplay.errorMsg("ioErrorImporting", new String[]{filename, e.getMessage()}, 4);
            e.printStackTrace();
        }
        return tmpAnimation;
    }

    public abstract Animation importAnimationFrom(InputStream var1, String var2);

    public static void setAnimalConfig(AnimalConfiguration newAnimalConfig) {
        animalConfig = newAnimalConfig;
    }

    public String toString() {
        return AnimalTranslator.translateMessage("notOverridden", new String[]{this.getClass().getName()});
    }

    public void dumpState(Animation anim, boolean showAnimators, boolean showObjects) {
        if (showAnimators) {
            AnimationListEntry[] info = anim.getAnimatorList();
            int j = 0;
            while (j < info.length) {
                if (info[j].mode == 1) {
                    MessageDisplay.message(info[j].animator.toString());
                } else if (info[j].mode == 2) {
                    MessageDisplay.message(info[j].link.toString());
                }
                ++j;
            }
            if (showObjects) {
                MessageDisplay.message("*****************");
            }
            info = null;
        }
        if (showObjects) {
            int i = 0;
            while (i < anim.getGraphicObjects().size()) {
                MessageDisplay.message(anim.getGraphicObjects().elementAt(i) + " NUM: " + anim.getGraphicObjects().elementAt(i).getNum(false));
                ++i;
            }
        }
    }

    private static boolean finalizeAnimationLoading(Animation tmpAnimation, String filename, String targetFormat) {
        if (tmpAnimation == null) {
            return false;
        }
        Animal animal = Animal.get();
        if (animal.setAnimation(tmpAnimation)) {
            AnimationWindow animWin = AnimalMainWindow.WINDOW_COORDINATOR.getAnimationWindow(false);
            animal.resetChange();
            MessageDisplay.message(AnimalTranslator.translateMessage("animImportDone", new String[]{filename, targetFormat}));
            if (!animWin.isVisible()) {
                MessageDisplay.message(AnimalTranslator.translateMessage("animWinReminder"));
            }
            animalConfig.setCurrentFilename(filename);
            animalConfig.setCurrentFormat(targetFormat);
            animWin.getScrollPane().setScrollPosition(new Point(0, 0));
            animWin.setVisible(true);
            animWin.startOfAnimation();
            String animTitle = tmpAnimation.getTitle();
            if (animTitle == null) {
                animTitle = filename;
            }
            animWin.setTitle("Animal Animation: " + animTitle);
            return true;
        }
        return false;
    }

    public static boolean importAnimation() {
        Animal animal = Animal.get();
        String filename = AnimationImporter.getFileChooser().openForImport(animal);
        if (filename == null) {
            return false;
        }
        int index = filename.lastIndexOf(System.getProperty("file.separator"));
        if (index != -1) {
            animalConfig.setCurrentDirectory(filename.substring(0, index));
        }
        String targetFormat = AnimationImporter.getFileChooser().getFormat();
        if (filename != null && targetFormat != null) {
            return AnimationImporter.importAnimation(filename, targetFormat);
        }
        return false;
    }

    public static boolean importAnimation(String filename) {
        return AnimationImporter.importAnimation(filename, "animation/animal-ascii-compressed");
    }

    public static boolean importAnimation(InputStream in, String filename) {
        return AnimationImporter.importAnimation(in, filename, "animation/animal-ascii-compressed");
    }

    public static boolean importAnimation(String filename, String targetFormat) {
        return AnimationImporter.importAnimation(null, filename, targetFormat);
    }

    public static boolean importAnimation(InputStream in, String filename, String targetFormat) {
        Animal.setAnimationLoadFinished(false);
        AnimationImporter importer = AnimationImporter.getImporterFor(targetFormat);
        if (importer != null) {
            Animation tmpAnimation = null;
            tmpAnimation = in == null ? importer.importAnimationFrom(filename) : importer.importAnimationFrom(in, filename);
            return AnimationImporter.finalizeAnimationLoading(tmpAnimation, filename, targetFormat);
        }
        return false;
    }
}

