/*
 * Decompiled with CFR 0.152.
 */
package animal.exchange;

import animal.exchange.AnimationImporter;
import animal.main.Animal;
import animal.main.Animation;
import animal.misc.AnimalTranslator;
import animalscript.core.AnimalScriptParser;
import java.io.InputStream;

public class AnimalScriptImporter
extends AnimationImporter {
    private boolean isCompressed = false;

    public void init(String format) {
        super.init(format);
        this.isCompressed = format.endsWith("-compressed");
    }

    public Animation importAnimationFrom(String filename) {
        AnimalScriptParser animalScriptParser = Animal.getAnimalScriptParser(true);
        animalScriptParser.setCompressed(this.isCompressed);
        return animalScriptParser.programImport(filename, !filename.startsWith("%"));
    }

    public Animation importAnimationFrom(InputStream in, String filename) {
        AnimalScriptParser animalScriptParser = Animal.getAnimalScriptParser(false);
        animalScriptParser.setCompressed(this.isCompressed);
        return animalScriptParser.importAnimationFrom(in, filename, true);
    }

    public String getDefaultExtension() {
        return this.isCompressed ? "asc" : "asu";
    }

    public String getFormatDescription() {
        return this.toString();
    }

    public String getMIMEType() {
        return "animation/animalscript" + (this.isCompressed ? "-compressed" : "");
    }

    public String toString() {
        return AnimalTranslator.translateMessage("animalScriptImportDescription");
    }
}

