/*
 * Decompiled with CFR 0.152.
 */
package animal.editor;

import animal.editor.Editor;
import animal.editor.GraphicEditor;
import animal.graphics.PTGraphicObject;
import animal.graphics.PTPoint;
import animal.gui.DrawCanvas;
import animal.main.Animation;
import animal.misc.AnimalTranslator;
import animal.misc.ColorChoice;
import animal.misc.ColorChooserAction;
import animal.misc.EditPoint;
import animal.misc.EditableObject;
import animal.misc.MSMath;
import animal.misc.XProperties;
import java.awt.Color;
import java.awt.Point;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Box;
import javax.swing.JLabel;
import translator.ExtendedActionButton;
import translator.TranslatableGUIElement;

public class PointEditor
extends GraphicEditor
implements PropertyChangeListener {
    private static final long serialVersionUID = 2295451210977833754L;
    private ColorChooserAction colorChooser;

    public PointEditor() {
        TranslatableGUIElement generator = AnimalTranslator.getGUIBuilder();
        Box colorBox = generator.generateBorderedBox(2, "colorBL");
        JLabel colorLabel = AnimalTranslator.getGUIBuilder().generateJLabel("colorLabel");
        colorBox.add(colorLabel);
        Color initialColor = this.getCurrentObject(false) == null ? Color.black : ((PTPoint)this.getCurrentObject(false)).getColor();
        this.colorChooser = new ColorChooserAction(this, ColorChoice.getColorName(initialColor), "color", AnimalTranslator.translateMessage("chooseColor", new Object[]{"Point"}), initialColor);
        ExtendedActionButton button = new ExtendedActionButton(this.colorChooser, 67);
        colorBox.add(button);
        this.addBox(colorBox);
        this.finishBoxes();
    }

    public void setProperties(XProperties props) {
        this.colorChooser.setColor(props.getColorProperty("Point.color", Color.black));
    }

    public void getProperties(XProperties props) {
        props.put("Point.color", this.colorChooser.getColor());
    }

    public int pointsNeeded() {
        return 1;
    }

    public boolean nextPoint(int num, Point p) {
        if (num == 1) {
            ((PTPoint)this.getCurrentObject()).setPoint(p);
        }
        return true;
    }

    public int getMinDist(PTGraphicObject go, Point p) {
        return MSMath.dist(((PTPoint)go).toPoint(), p);
    }

    public EditPoint[] getEditPoints(PTGraphicObject go) {
        return new EditPoint[]{new EditPoint(-1, ((PTPoint)go).toPoint())};
    }

    public EditableObject createObject() {
        PTPoint result = new PTPoint();
        this.storeAttributesInto(result);
        return result;
    }

    public Editor getSecondaryEditor(EditableObject e) {
        PointEditor result = new PointEditor();
        result.extractAttributesFrom(e);
        return result;
    }

    void storeAttributesInto(EditableObject eo) {
        super.storeAttributesInto(eo);
        PTPoint point = (PTPoint)eo;
        point.setColor(this.colorChooser.getColor());
    }

    void extractAttributesFrom(EditableObject eo) {
        super.extractAttributesFrom(eo);
        PTPoint point = (PTPoint)eo;
        this.colorChooser.setColor(point.getColor());
    }

    public String getStatusLineMsg() {
        return AnimalTranslator.translateMessage("pointStatusLine", new Object[]{DrawCanvas.translateDrawButton(), DrawCanvas.translateFinishButton(), DrawCanvas.translateCancelButton()});
    }

    public void propertyChange(PropertyChangeEvent event) {
        PTPoint point = (PTPoint)this.getCurrentObject();
        String eventName = event.getPropertyName();
        if (eventName.equals("color")) {
            point.setColor((Color)event.getNewValue());
        }
        if (!event.getOldValue().equals(event.getNewValue())) {
            this.repaintNow();
            if (Animation.get() != null) {
                Animation.get().doChange();
            }
        }
    }

    public String getBasicType() {
        return "Point";
    }
}

