/*
 * Decompiled with CFR 0.152.
 */
package animal.editor;

import animal.editor.Editor;
import animal.graphics.PTGraphicObject;
import animal.gui.AnimalMainWindow;
import animal.misc.EditPoint;
import animal.misc.EditableObject;
import java.awt.Graphics;
import java.awt.Point;

public abstract class GraphicEditor
extends Editor {
    public GraphicEditor() {
        super(AnimalMainWindow.getWindowCoordinator().getDrawWindow(false));
    }

    public abstract int pointsNeeded();

    public abstract boolean nextPoint(int var1, Point var2);

    public void repaintNow() {
        AnimalMainWindow.getWindowCoordinator().getDrawWindow(true).getDrawCanvas().repaintAll();
    }

    public abstract int getMinDist(PTGraphicObject var1, Point var2);

    public abstract EditPoint[] getEditPoints(PTGraphicObject var1);

    public abstract String getBasicType();

    public void paintObject(Graphics g) {
        ((PTGraphicObject)this.getCurrentObject()).paint(g);
    }

    void storeAttributesInto(EditableObject eo) {
        super.storeAttributesInto(eo);
        if (eo instanceof PTGraphicObject) {
            PTGraphicObject go = (PTGraphicObject)eo;
            go.setDepth(Integer.valueOf((String)this.depthBox.getSelectedItem()));
            go.setObjectName(this.objectNameField.getText());
        }
    }

    void extractAttributesFrom(EditableObject eo) {
        super.extractAttributesFrom(eo);
        if (eo instanceof PTGraphicObject) {
            PTGraphicObject p = (PTGraphicObject)eo;
            if (p.getDepth() > 16 && p.getDepth() != Integer.MAX_VALUE) {
                this.depthBox.addItem(String.valueOf(p.getDepth()));
            }
            this.depthBox.addItem(String.valueOf(Integer.MAX_VALUE));
            this.depthBox.setSelectedItem(String.valueOf(p.getDepth()));
            this.objectNameField.setText(p.getObjectName());
        }
    }

    public String getStatusLineMsg() {
        return null;
    }
}

