/*
 * Decompiled with CFR 0.152.
 */
package animal.editor;

import animal.main.Animal;
import animal.main.AnimalConfiguration;
import animal.main.AnimalFrame;
import animal.misc.AnimalFileChooser;
import animal.misc.AnimalTranslator;
import animal.misc.MessageDisplay;
import animal.misc.XProperties;
import java.awt.BorderLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Properties;
import javax.swing.AbstractButton;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import translator.ResourceLocator;

public class AnnotationEditor
extends AnimalFrame
implements ActionListener {
    private static final long serialVersionUID = -8325459076725440472L;
    private String baseAnnotateURL = "http://www.animal.ahrgr.de/Anims/annotation.php";
    private int currentStep = 1;
    private String currentUser = null;
    private AnimalConfiguration animalConfig = null;
    private AnimalFileChooser fileChooser = null;
    private JTextArea foreignComments = null;
    private boolean hasChanged = false;
    private AbstractButton mergeButton = null;
    private XProperties props = null;
    private AbstractButton reloadButton = null;
    private AbstractButton saveAsButton = null;
    private AbstractButton undoButton = null;
    private JTextArea userComments = null;

    public AnnotationEditor(Animal animalInstance, XProperties properties, String userID, AnimalConfiguration animalConfiguration) {
        super(animalInstance, properties);
        this.setCurrentUserID(userID);
        this.animalConfig = animalConfiguration;
        this.fileChooser = new AnimalFileChooser(this.animalConfig);
        this.fileChooser.resetFilters();
        this.fileChooser.addFilter("ann", "Annotation File");
        this.workContainer().setLayout(new BorderLayout());
        JPanel textPanels = new JPanel();
        textPanels.setLayout(new GridLayout(2, 1));
        this.userComments = new JTextArea(60, 6);
        this.foreignComments = new JTextArea(60, 6);
        this.foreignComments.setEditable(false);
        textPanels.add(this.foreignComments);
        textPanels.add(this.userComments);
        this.workContainer().add("Center", textPanels);
        JPanel buttonPanel = new JPanel();
        this.reloadButton = AnimalTranslator.getGUIBuilder().generateJButton("reloadAnn", null, false, this);
        this.mergeButton = AnimalTranslator.getGUIBuilder().generateJButton("mergeAnn", null, false, this);
        this.saveAsButton = AnimalTranslator.getGUIBuilder().generateJButton("saveAnnAs", null, false, this);
        this.undoButton = AnimalTranslator.getGUIBuilder().generateJButton("undo", null, false, this);
        buttonPanel.add(this.reloadButton);
        buttonPanel.add(this.mergeButton);
        buttonPanel.add(this.saveAsButton);
        buttonPanel.add(this.undoButton);
        this.workContainer().add("South", buttonPanel);
        this.setSize(480, 320);
    }

    public AnnotationEditor(Animal animalInstance, XProperties properties, String userID, XProperties useThese, AnimalConfiguration animalConfiguration) {
        this(animalInstance, properties, userID, animalConfiguration);
        this.setAnnotations(useThese);
    }

    private XProperties getAnnotations() {
        if (this.props == null) {
            this.props = new XProperties();
        }
        return this.props;
    }

    public String getBaseAnimName() {
        String basicName = this.animalConfig.getCurrentFilename();
        if (basicName == null) {
            return "demo";
        }
        int lastDotPos = basicName.lastIndexOf(".");
        return basicName.substring(0, lastDotPos);
    }

    public int getCurrentStep() {
        if (this.currentStep < 1) {
            return 1;
        }
        return this.currentStep;
    }

    public String getCurrentUserID() {
        if (this.currentUser == null) {
            return "dummy";
        }
        return this.currentUser;
    }

    public boolean hasChanged() {
        return this.hasChanged;
    }

    public void resetChange() {
        this.hasChanged = false;
    }

    public void setChanged(boolean newState) {
        this.hasChanged = newState;
    }

    public void setCurrentStep(int stepNr) {
        this.storeCurrentEdits();
        this.currentStep = stepNr;
        this.showMessagesForStep();
        this.setTitle(AnimalTranslator.translateMessage("annotationWindowLabel", new String[]{String.valueOf(stepNr)}));
    }

    public void setCurrentUserID(String aUserID) {
        this.currentUser = aUserID;
    }

    public void setAnnotations(XProperties useThese) {
        if (useThese != null) {
            this.props = useThese;
        }
    }

    public void showMessagesForStep() {
        int step = this.getCurrentStep();
        String[] keysForStep = this.getAnnotations().getKeys(String.valueOf(step));
        StringBuilder userCommentBuffer = new StringBuilder(1024);
        StringBuilder foreignCommentBuffer = new StringBuilder(1024);
        if (keysForStep != null) {
            String comparator = String.valueOf(step) + "." + this.getCurrentUserID();
            int n = keysForStep.length;
            int i = 0;
            while (i < n) {
                String entry = keysForStep[i];
                if (entry.startsWith(comparator)) {
                    userCommentBuffer.append(this.getAnnotations().getProperty(entry)).append("\n");
                } else {
                    foreignCommentBuffer.append(this.strip(entry)).append(this.getAnnotations().getProperty(entry)).append("\n");
                }
                ++i;
            }
            this.userComments.setText(userCommentBuffer.toString());
            this.foreignComments.setText(foreignCommentBuffer.toString());
        }
    }

    public void loadAnnotations() {
        this.setAnnotations(new XProperties(this.rawLoadAnnotations(String.valueOf(this.getBaseAnimName()) + ".ann")));
    }

    private Properties rawLoadAnnotations(String filename) {
        ResourceLocator resourceLocator = ResourceLocator.getResourceLocator();
        Properties loadedProps = new Properties();
        InputStream is = resourceLocator.getResourceStream(filename);
        try {
            if (is != null) {
                loadedProps.load(is);
            }
        }
        catch (Exception e) {
            MessageDisplay.errorMsg(AnimalTranslator.translateMessage("couldNotLoadAnnotations", new String[]{filename}), 2);
        }
        this.setChanged(false);
        return loadedProps;
    }

    public void mergeAnnotations(String filename) {
        Properties compareAnnotations = this.rawLoadAnnotations(filename);
        Enumeration<?> elementList = compareAnnotations.propertyNames();
        String key = null;
        String message = null;
        while (elementList.hasMoreElements()) {
            key = (String)elementList.nextElement();
            message = compareAnnotations.getProperty(key);
            if (!this.props.containsKey(key)) {
                this.props.put(key, message);
                continue;
            }
            if (message.equals(this.props.getProperty(key))) continue;
            this.props.put(key, String.valueOf(this.props.getProperty(key)) + "\n" + message);
        }
        this.showMessagesForStep();
        this.setChanged(true);
    }

    public void saveAnnotationsAs() {
        String filename = this.fileChooser.openForFilenameChoice(this);
        if (!filename.endsWith(".ann")) {
            filename = String.valueOf(filename) + ".ann";
        }
        this.saveAnnotations(filename);
    }

    public void saveAnnotations(String filename) {
        try {
            this.props.list(System.out);
            this.props.store(new FileOutputStream(filename), "Animal Annotations by " + this.getCurrentUserID());
            this.setChanged(false);
            StringBuilder annotationURL = new StringBuilder(1024);
            long animationUID = Animal.get().getAnimation().getAnimationUID();
            annotationURL.append(this.baseAnnotateURL).append("?auid=").append(animationUID);
            annotationURL.append(";user=").append(this.getCurrentUserID()).append(";comment=");
            annotationURL.append("FIXED_TEXT");
            MessageDisplay.errorMsg(annotationURL.toString(), 1);
        }
        catch (Exception e) {
            MessageDisplay.errorMsg(AnimalTranslator.translateMessage("couldNotSaveAnnotations", new String[]{filename}), 4);
        }
    }

    private String strip(String entry) {
        if (entry == null) {
            return "";
        }
        StringBuilder result = new StringBuilder(60);
        result.append("[").append(entry.substring(entry.indexOf(".") + 1)).append("] ");
        return result.toString();
    }

    private void storeCurrentEdits() {
        String input = this.userComments.getText();
        if (input != null && input.length() > 1) {
            StringBuilder buf = new StringBuilder(1024);
            buf.append(String.valueOf(this.getCurrentStep())).append(".").append(this.getCurrentUserID());
            this.getAnnotations().put(buf.toString(), this.userComments.getText());
            this.setChanged(true);
        }
    }

    public void actionPerformed(ActionEvent evt) {
        if (evt.getSource() == this.reloadButton) {
            this.loadAnnotations();
        } else if (evt.getSource() == this.mergeButton) {
            String filename = this.fileChooser.openForFilenameChoice(this);
            this.mergeAnnotations(filename);
        } else if (evt.getSource() == this.saveAsButton) {
            this.saveAnnotationsAs();
        }
        this.showMessagesForStep();
    }
}

