/*
 * Decompiled with CFR 0.152.
 */
package animal.animator;

import animal.animator.PerformableAction;
import animal.animator.QuestionAction;
import animal.main.Animal;
import animal.misc.AnimalTranslator;
import animal.misc.MessageDisplay;
import animal.misc.TrueFalseQuestionInterface;

public class TrueFalseQuestionAction
extends QuestionAction
implements PerformableAction {
    private static final long serialVersionUID = 6655967163100757977L;
    public static final String TYPE_LABEL = "TrueFalseQuestion";
    private boolean constructed = false;
    private TrueFalseQuestionInterface handler = null;

    public TrueFalseQuestionAction() {
        this("none");
    }

    public TrueFalseQuestionAction(String theTitle) {
        this.setType(4);
        this.setTitle(theTitle);
        this.handler = (TrueFalseQuestionInterface)Animal.getInteractionHandler().getHandlerFor(2, theTitle);
    }

    public void perform() {
        if (Animal.animationLoadFinished()) {
            MessageDisplay.errorMsg(AnimalTranslator.translateMessage("questionText", new String[]{this.getQuestionText()}), 2);
            Animal.getInteractionHandler().initialize(this.handler, this.constructed, this.getQuestionText());
            this.constructed = true;
            Animal.getInteractionHandler().performQuestionOperation(this.handler);
        }
    }

    public void addAnswer(String answerText) {
        MessageDisplay.errorMsg("doNotInvokeMethodException", new Object[]{"addAnswer", this.getClass().getName()});
    }

    public void setCorrectAnswer(boolean isCorrect) {
        this.getProperties().put("QuestionAction.answerCorrect", isCorrect);
        this.handler.SetAnswer(isCorrect);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(400);
        sb.append("True / False Question: '").append(this.getQuestionText());
        sb.append("' [");
        if (!this.getProperties().getBoolProperty("QuestionAction.answerCorrect", false)) {
            sb.append("in");
        }
        sb.append("correct]");
        return sb.toString();
    }
}

