/*
 * Decompiled with CFR 0.152.
 */
package animal.animator;

import animal.animator.GraphicObjectSpecificAnimation;
import animal.animator.Move;
import animal.animator.PutType;
import animal.animator.TimedAnimator;
import animal.graphics.PTArray;
import animal.graphics.PTGraphicObject;
import animal.graphics.PTIntArray;
import animal.graphics.PTPoint;
import animal.graphics.PTPolyline;
import animal.graphics.PTStringArray;
import animal.graphics.PTText;
import animal.gui.GraphicVector;
import animal.main.Animation;
import animal.main.AnimationState;
import animal.misc.AnimalTranslator;
import animal.misc.MessageDisplay;
import animal.misc.XProperties;
import java.awt.Font;
import java.awt.Point;

public class Put
extends TimedAnimator
implements GraphicObjectSpecificAnimation {
    public static final String TYPE_LABEL = "Put";
    private PTText newContent;
    private PTPolyline poly;
    private Move oldFlyUp = new Move();
    private Move newFlyUp = new Move();
    private int animObjNum;
    private int cell = -1;
    private Font finalFont = new Font("Monospaced", 0, 14);
    private transient GraphicVector graphicVector;

    public Put() {
    }

    public Put(XProperties props) {
        this.setProperties(props);
    }

    public Put(int step, int objectNum, int totalTimeOrTicks, int offset, int new_val, int idx) {
        super(step, objectNum, totalTimeOrTicks, offset, "put");
        this.finalFont = ((PTIntArray)Animation.get().getGraphicObject(objectNum)).getFont();
        this.newContent = new PTText(String.valueOf(new_val), this.finalFont);
        this.setOffset(offset);
        this.newContent.setColor(((PTIntArray)Animation.get().getGraphicObject(objectNum)).getFontColor());
        this.newContent.setDepth(((PTIntArray)Animation.get().getGraphicObject(objectNum)).getEntry(idx).getDepth());
    }

    public Put(int step, int objectNum, int totalTimeOrTicks, int offset, String new_val, int idx) {
        super(step, objectNum, totalTimeOrTicks, offset, "put");
        this.setOffset(offset);
        this.finalFont = ((PTStringArray)Animation.get().getGraphicObject(objectNum)).getFont();
        this.newContent = new PTText(new_val, this.finalFont);
        this.newContent.setColor(((PTStringArray)Animation.get().getGraphicObject(objectNum)).getFontColor());
        this.newContent.setDepth(((PTStringArray)Animation.get().getGraphicObject(objectNum)).getEntry(idx).getDepth());
    }

    public void init(AnimationState animationState, long time, double ticks) {
        super.init(animationState, time, ticks);
        this.graphicVector = animationState.getCurrentObjects();
        this.graphicVector.addElement(this.newContent, 1);
        this.newContent.setFont(new Font(this.finalFont.getName(), this.finalFont.getStyle(), 0));
        PTGraphicObject ao = animationState.getCloneByNum(this.getObjectNums()[0]);
        if (ao instanceof PTArray) {
            this.poly.setNode(1, new PTPoint(((PTArray)ao).getEntry(this.cell).getLocation()));
            this.poly.setNode(0, new PTPoint(this.poly.getNode(1).getX(), this.poly.getNode(1).getY() + ((PTArray)ao).getBoundingBox((int)this.cell).height));
            this.newContent.setColor(((PTArray)ao).getFontColor());
            this.newContent.setDepth(((PTArray)ao).getEntry(this.cell).getDepth());
            this.newContent.setLocation(this.poly.getPointAtLength(0));
        }
        this.oldFlyUp.init(animationState, time, ticks);
        this.newFlyUp.init(animationState, time, ticks);
    }

    public Object getProperty(double factor) {
        if (this.newContent == null) {
            return new PutType();
        }
        this.newContent.setFont(new Font(this.finalFont.getName(), this.finalFont.getStyle(), (int)(factor * (double)this.finalFont.getSize())));
        this.newContent.setLocation((Point)this.newFlyUp.getProperty(factor));
        return new PutType(this.cell, (Point)this.oldFlyUp.getProperty(factor), this.newContent, (Point)this.newFlyUp.getProperty(factor), factor, this.hasFinished());
    }

    public String getContent() {
        return this.newContent == null ? "" : this.newContent.getText();
    }

    public void setContent(String val) {
        if (this.poly == null) {
            this.poly = new PTPolyline(new int[2], new int[2]);
            this.poly.setClosed(false);
            Animation.get().insertGraphicObject(this.poly);
        }
        if (this.newContent == null) {
            this.newContent = new PTText(val, this.finalFont);
            this.newContent.getNum(true);
            Animation.get().insertGraphicObject(this.newContent);
        } else {
            this.newContent.setText(val);
            this.newContent.setFont(this.finalFont);
        }
        PTGraphicObject go = Animation.get().getGraphicObject(this.animObjNum);
        if (go instanceof PTArray) {
            this.newContent.setColor(((PTArray)go).getFontColor());
            this.newContent.setDepth(((PTArray)go).getEntry(this.cell).getDepth());
        }
        this.newFlyUp = new Move(this.getStep(), this.newContent.getNum(true), this.getDuration(), this.getMethod(), this.poly.getNum(true));
    }

    public void setArray(int num) {
        this.updateAnimation(this.animObjNum, num, this.cell, this.cell);
        this.animObjNum = num;
    }

    public void setCell(int index) {
        this.updateAnimation(this.animObjNum, this.animObjNum, this.cell, index);
        this.cell = index;
    }

    private void updateAnimation(int oldObject, int newObject, int oldIndex, int newIndex) {
        if (oldObject != newObject || oldIndex != newIndex) {
            if (this.poly == null) {
                this.poly = new PTPolyline(new int[2], new int[2]);
                this.poly.setClosed(false);
                Animation.get().insertGraphicObject(this.poly);
            }
            if (this.oldFlyUp == null || oldObject != newObject) {
                this.oldFlyUp = new Move(this.getStep(), newObject, this.getDuration(), this.getMethod(), this.poly.getNum(true));
            } else {
                this.oldFlyUp.setDuration(this.getDuration());
            }
        }
    }

    public int getCell() {
        return this.cell;
    }

    public int[] exportIDs() {
        return new int[]{this.newContent.getNum(true), this.poly.getNum(true)};
    }

    public void restoreIDs(int[] idList) {
        if (idList.length != 2) {
            MessageDisplay.errorMsg(AnimalTranslator.translateMessage("putIDListLengthWrong"), 4);
        } else {
            this.newContent = (PTText)Animation.get().getGraphicObject(idList[0]);
            this.poly = (PTPolyline)Animation.get().getGraphicObject(idList[1]);
        }
    }

    public String getAnimatorName() {
        return TYPE_LABEL;
    }

    public String getType() {
        return TYPE_LABEL;
    }

    public String[] handledKeywords() {
        return new String[]{TYPE_LABEL};
    }

    public void discard() {
        PTArray go;
        if (Animation.get().getGraphicObjects().contains(this.newContent)) {
            Animation.get().deleteGraphicObject(this.newContent.getNum(true));
        }
        if ((go = (PTArray)Animation.get().getGraphicObject(this.animObjNum)) != null && Animation.get().getGraphicObjects().contains(go.getEntry(this.cell))) {
            Animation.get().deleteGraphicObject(go.getEntry(this.cell).getNum(true));
        }
        this.newContent.discard();
        this.poly.discard();
        this.finalFont = null;
        super.discard();
    }

    public void setFinalFont(Font font) {
        this.finalFont = new Font(font.getName(), font.getStyle(), font.getSize());
    }

    public int[] getTemporaryObjects() {
        return new int[]{this.poly.getNum(true)};
    }

    public String toString() {
        if (this.newContent == null) {
            return AnimalTranslator.translateMessage("putNoObjectsSet");
        }
        if (Animation.get().getGraphicObject(this.animObjNum) instanceof PTArray) {
            return "Replace '" + ((PTArray)Animation.get().getGraphicObject(this.animObjNum)).getEntry(this.cell).getText() + "' in cell " + this.cell + " of " + super.toString() + " by '" + this.newContent.getText() + "'";
        }
        return "Put '" + this.newContent.getText() + "' into " + super.toString();
    }

    public String[] getSupportedTypes() {
        return new String[]{"StringArray", "IntArray"};
    }
}

