/*
 * Decompiled with CFR 0.152.
 */
package algorithm.stringSearch;

import algorithm.animalTranslator.AnimalTranslator;
import algorithm.animalTranslator.codeItems.Hidden;
import algorithm.animalTranslator.codeItems.Node;
import algorithm.animalTranslator.codeItems.Off;
import algorithm.animalTranslator.codeItems.Pos;
import algorithm.animalTranslator.codeItems.TimeOffset;
import algorithm.animalTranslator.codeItems.Timing;
import algorithm.animalTranslator.codeItems.WithinTiming;

public class KMPStringSearch {
    private AnimalTranslator at;
    private String dataString;
    private String stringToSearch;
    private boolean initialized = false;
    private String stringArrayName;
    private String subStringArrayName;
    private String nextArrayName;
    private String algorithmName;
    private String markerIName;
    private String markerJName;
    private String markerStartName;
    private String markerNextName;
    private String legendeIName;
    private String legendeJName;
    private String legendeStartName;
    private String legendeNextName;
    private String legendeNextMinusEinsName;
    private int textPos;
    private int xPos;
    private int curStartPosition;
    private int previous_next_value;
    private int[] markedLinesInAlgorithm;

    public KMPStringSearch(AnimalTranslator newAT) {
        this.at = newAT;
    }

    public void initialize(String theString, String toBeSearched) {
        this.dataString = theString;
        this.stringToSearch = toBeSearched;
        this.stringArrayName = "KMPSearchArray";
        this.subStringArrayName = "KMPSearchArraySubString";
        this.nextArrayName = "KMPSearch_NextArray";
        this.algorithmName = "CodeGroup_Algorithm";
        this.markerIName = "markerInString";
        this.markerJName = "markerInSubString";
        this.markerStartName = "markerInStringStart";
        this.markerNextName = "markerOnNextArray";
        this.legendeIName = "dieLegendeStringPointer";
        this.legendeJName = "dieLegendeSubStringPointer";
        this.legendeStartName = "dieLegendeStringCompareStart";
        this.legendeNextName = "dieLegendeNextArray";
        this.legendeNextMinusEinsName = "dieMinusEinsAmNextArray";
        this.textPos = -100;
        this.xPos = -100;
        this.initialized = true;
    }

    public int generateAnimation() throws Exception {
        if (!this.initialized) {
            throw new Exception("Instance of KMP-StringSearch has not been initialized!");
        }
        this.at.advancedAddHeaderMM("KMP String-Suche");
        this.displayInitialScreen();
        this.displaySearchScreen();
        return this.kMPSearchIterativ(this.dataString, this.stringToSearch);
    }

    private void displayInitialScreen() {
        this.at.compositeStepStart();
        this.at.addLabel("initial screen");
        this.at.advancedCreateWorkSheet();
        this.at.addText("sollSortiert", "KMP-Suche nach einer Zeichenkette", new Pos(200, 200), "color black size 35 bold", null);
        this.at.compositeStepEnd();
        this.at.compositeStepStart();
        this.at.addText("comment1", "Es handelt sich hierbei um eine verbesserte Variante der BruteForce-Suche.", new Off(-420, 130, "sollSortiert", "S"), "color black size 25", null);
        this.at.addText("comment2", "Hierbei wird vor Beginn der Suche festgehalten, ab welcher Stelle", new Off(0, 40, "comment1", "SW"), "color black size 25", null);
        this.at.addText("comment3", "in der zu suchenden Zeichenkette der Vergleich, bei Ungleichheit", new Off(0, 40, "comment2", "SW"), "color black size 25", null);
        this.at.addText("comment4", "an einer beliebigen Stelle, fortgesetzt werden muss.", new Off(0, 40, "comment3", "SW"), "color black size 25", null);
        this.at.addText("comment5", "Hierdurch muss im Text grunds\u00c3\u00a4tzlich nicht mehr zum 2. Zeichen des aktuellen", new Off(0, 40, "comment4", "SW"), "color black size 25", null);
        this.at.addText("comment6", "Vergleichs zur\u00c3\u00bcckgesprungen werden, da anhand der bereits gepr\u00c3\u00bcften Zeichen", new Off(0, 40, "comment5", "SW"), "color black size 25", null);
        this.at.addText("comment7", "entschieden werden kann, ab welcher Stelle in der zu suchenden Zeichenkette", new Off(0, 40, "comment6", "SW"), "color black size 25", null);
        this.at.addText("comment8", "der Vergleich fortzusetzen ist.", new Off(0, 40, "comment7", "SW"), "color black size 25", null);
        this.at.compositeStepEnd();
    }

    private void displaySearchScreen() {
        this.at.compositeStepStart();
        this.at.addLabel("searching screen");
        this.at.hide(new String[]{"sollSortiert", "comment1", "comment2", "comment3", "comment4", "comment5", "comment6", "comment7", "comment8"}, null);
        this.at.advancedTextLine("headline", new Pos(300, 70), "color black size 25 bold", null, "KMP-Suche nach der Zeichenkette: '" + this.stringToSearch + "'");
        this.at.advancedArrayReduction(this.stringArrayName, (Node)new Off(-200, 120, "headline", "NW"), this.dataString);
        this.at.advancedArrayReduction(this.subStringArrayName, (Node)new Off(0, 50, this.stringArrayName, "SW"), this.stringToSearch);
        this.at.addArrayMarker(this.markerStartName, this.stringArrayName, 0, "color red", new Hidden());
        this.at.addArrayMarker(this.markerIName, this.stringArrayName, 0, "color blue", new Hidden());
        this.at.addArrayMarker(this.markerJName, this.subStringArrayName, 0, "color green3", new Hidden());
        this.at.advancedTextLine(this.legendeIName, new Off(0, -25, this.stringArrayName, "NW"), "color blue size 15", null, "(textPos) aktuell betrachtete Position im String");
        this.at.advancedTextLine(this.legendeJName, new Off(30, 0, this.legendeIName, "NE"), "color green3 size 15", null, "(xPos) aktuell betrachtete Position in der Zeichenkette");
        this.at.advancedTextLine(this.legendeStartName, new Off(30, 0, this.legendeJName, "NE"), "color red size 15", null, "Startposition des aktuellen Vergleichs");
        this.at.hide(new String[]{this.legendeIName, this.legendeJName, this.legendeStartName}, null);
        this.at.advancedCodeGroupStandard(this.algorithmName, new Off(15, 100, this.subStringArrayName, "SW"), new TimeOffset(0), new String[]{"1. Berechne f\u00c3\u00bcr Jedes Zeichen in der Zeichenkette den R\u00c3\u00bccksprungindex f\u00c3\u00bcr Ungleichheit in der jew. Position", "2. Betrachte jeweils das erste Zeichen in Text und zu suchender Zeichenkette", "3. Ist entweder das Ende des Textes oder das der Zeichenkette erreicht?", "   - falls ja, gehe zu Schritt 9", "4. Sind die beiden betrachteten Zeichen gleich oder ist die aktuelle Position in der Zeichenkette kleiner Null?", "   - falls ja, gehe zu Schritt 7", "5. Betrachte in der zu suchenden Zeichenkette das Zeichen entsprechend dem R\u00c3\u00bccksprungindex", "6. gehe zu Schritt 3 (Startposition des Vergleichs wird angepasst)", "7. gehe in Text und Zeichenkette jeweils ein Zeichen weiter", "8. gehe zu Schritt 3 (ggf. Anpassen der Startposition des Vergleichs)", "9. Ist das Ende der Zeichenkette erreicht?", "   - falls ja, gib die letzte 'Startposition' des Vergleichs zur\u00c3\u00bcck", "   - sonst wurde das Element nicht gefunden"});
        this.at.compositeStepEnd();
    }

    private int kMPSearchIterativ(String text, String x) {
        int[] next = this.printNext(this.initNext(x));
        this.at.compositeStepStart();
        this.setTextPos(0, true);
        this.setXPos(0, true);
        this.at.compositeStepEnd();
        while (this.xPos < x.length() && this.textPos < text.length()) {
            this.codeMarkingForWhile();
            while (this.xPos >= 0 && text.charAt(this.textPos) != x.charAt(this.xPos)) {
                this.setXPos(next[this.xPos], false);
                this.codeMarkingForWhile();
            }
            if (this.xPos >= x.length() || this.textPos >= text.length()) continue;
            this.at.compositeStepStart();
            this.setTextPos(this.textPos + 1, true);
            this.setXPos(this.xPos + 1, true);
            this.at.compositeStepEnd();
        }
        if (this.xPos == x.length()) {
            return this.returnResult(this.textPos - x.length());
        }
        return this.returnResult(-1);
    }

    /*
     * Unable to fully structure code
     */
    public int[] initNext(String p) {
        i = 0;
        j = -1;
        m = p.length();
        next = new int[m];
        next[0] = -1;
        ** GOTO lbl11
        {
            j = next[j];
            do {
                if (j >= 0 && p.charAt(i) != p.charAt(j)) continue block0;
                v0 = next[i] = p.charAt(++i) == p.charAt(++j) ? next[j] : j;
lbl11:
                // 2 sources

            } while (i < m - 1);
        }
        return next;
    }

    private void setTextPos(int newValue, boolean isFor) {
        this.at.compositeStepStart();
        if (this.textPos == -100) {
            this.at.show(this.legendeIName, null);
            this.at.moveArrayMarker(this.markerIName, newValue, (Timing)new WithinTiming(0));
            this.at.show(this.markerIName, null);
            this.markLines(new int[]{1});
        } else {
            if (newValue < this.dataString.length()) {
                this.at.moveArrayMarker(this.markerIName, newValue, (Timing)new WithinTiming(1000));
            } else {
                this.at.hide(this.markerIName, null);
            }
            if (isFor) {
                this.markLines(new int[]{8});
            }
        }
        this.textPos = newValue;
        this.at.compositeStepEnd();
    }

    private void setXPos(int newValue, boolean isFor) {
        this.at.compositeStepStart();
        if (this.previous_next_value >= 0) {
            this.at.unhighlightArrayCell(this.nextArrayName, this.previous_next_value, "", null);
        }
        if (this.xPos != -1 && newValue < this.xPos) {
            this.at.highlightArrayCell(this.nextArrayName, this.xPos, "", null);
        }
        if (newValue != -1) {
            if (this.xPos == -100) {
                this.at.show(this.legendeJName, new TimeOffset(1500));
                this.at.moveArrayMarker(this.markerJName, newValue, (Timing)new WithinTiming(0));
                this.at.moveArrayMarker(this.markerStartName, 0, (Timing)new WithinTiming(0));
                this.at.show(this.markerJName, new TimeOffset(1500));
                this.at.show(this.legendeStartName, new TimeOffset(1500));
                this.at.show(this.markerStartName, new TimeOffset(1500));
                this.at.show(this.markerNextName, new TimeOffset(1500));
                this.previous_next_value = 0;
            } else {
                this.at.show(this.markerNextName, null);
                this.at.hide(this.legendeNextMinusEinsName, null);
                if (newValue < this.stringToSearch.length()) {
                    this.at.moveArrayMarker(this.markerJName, newValue, (Timing)new WithinTiming(1000));
                    this.at.moveArrayMarker(this.markerNextName, newValue, (Timing)new WithinTiming(1000));
                } else {
                    this.at.hide(new String[]{this.markerJName, this.markerNextName}, new TimeOffset(0));
                }
                if (isFor) {
                    this.at.compositeStepEnd();
                    this.at.compositeStepEnd();
                    this.at.compositeStepStart();
                    this.at.compositeStepStart();
                    this.markLines(new int[]{9});
                    if (newValue == 0) {
                        if (this.textPos < this.dataString.length()) {
                            this.at.moveArrayMarker(this.markerStartName, this.textPos, (Timing)new WithinTiming(1000));
                        } else {
                            this.at.hide(this.markerStartName, null);
                        }
                    }
                } else {
                    this.markLines(new int[]{6});
                    this.at.compositeStepEnd();
                    this.at.compositeStepStart();
                    this.markLines(new int[]{7});
                    if (this.curStartPosition != this.textPos - newValue) {
                        if (this.textPos < this.dataString.length()) {
                            this.at.moveArrayMarker(this.markerStartName, this.textPos - newValue, (Timing)new WithinTiming(1000));
                        } else {
                            this.at.hide(this.markerStartName, null);
                        }
                    }
                }
            }
        } else {
            this.markLines(new int[]{6});
            this.at.compositeStepEnd();
            this.at.compositeStepStart();
            this.markLines(new int[]{7});
            this.at.hide(this.markerNextName, null);
            this.at.show(this.legendeNextMinusEinsName, null);
        }
        this.at.compositeStepEnd();
        this.previous_next_value = this.xPos;
        this.xPos = newValue;
    }

    private void codeMarkingForWhile() {
        if (this.textPos < this.dataString.length()) {
            this.markLines(new int[]{2});
            if (this.xPos < this.stringToSearch.length() && this.textPos < this.dataString.length()) {
                this.markLines(new int[]{4});
                if (this.xPos == -1 || this.dataString.charAt(this.textPos) == this.stringToSearch.charAt(this.xPos)) {
                    this.markLines(new int[]{4, 5});
                }
            }
        }
    }

    private int returnResult(int result) {
        this.at.compositeStepStart();
        this.markLines(new int[]{2, 3});
        this.at.compositeStepEnd();
        this.at.compositeStepStart();
        this.markLines(new int[]{10});
        if (result == -1) {
            this.markLines(new int[]{10, 12});
            this.at.advancedTextLine("Ergebnis", new Off(130, 100, this.algorithmName, "SW"), "color blue size 30", new TimeOffset(0), "Die gesuchte Zeichenfolge wurde nicht gefunden!");
        } else {
            this.markLines(new int[]{10, 11});
            this.at.advancedTextLine("Ergebnis", new Off(130, 50, this.algorithmName, "SW"), "color blue size 30", new TimeOffset(0), "Die gesuchte Zeichenfolge wurde bei index " + result + " gefunden!");
            this.at.advancedTextLine("Ergebnis2", new Off(200, 15, "Ergebnis", "SW"), "color blue size 15", new TimeOffset(0), "(der index beginnt bei 0 und geht bis text.length() - 1)");
        }
        this.at.compositeStepEnd();
        this.at.addLabel("SearchResult");
        return result;
    }

    private int[] printNext(int[] next) {
        this.at.compositeStepStart();
        this.markLines(new int[1]);
        this.at.advancedArrayStandard(this.nextArrayName, (Node)new Off(0, 50, this.subStringArrayName, "SW"), next);
        this.at.advancedTextLine(this.legendeNextName, new Off(15, 0, this.nextArrayName, "NE"), "color black size 15", null, "R\u00c3\u00bccksprungindex bei Ungleichheit in aktueller Position");
        this.at.advancedTextLine(this.legendeNextMinusEinsName, new Off(-25, -15, this.nextArrayName, "NW"), "color red size 20", null, "-1");
        this.at.hide(this.legendeNextMinusEinsName, null);
        this.at.addArrayMarker(this.markerNextName, this.nextArrayName, 0, "color green3", null);
        this.at.hide(this.markerNextName, null);
        this.at.compositeStepEnd();
        return next;
    }

    private void markLines(int[] linesInAlgorithm) {
        if (linesInAlgorithm == null) {
            System.out.println("useless call of markLines in KMPSearch - all parameters null");
        } else {
            this.at.compositeStepStart();
            if (this.markedLinesInAlgorithm == null) {
                this.markedLinesInAlgorithm = new int[0];
            }
            if (linesInAlgorithm != null) {
                int i = 0;
                while (i < this.markedLinesInAlgorithm.length) {
                    this.at.unhighlightCode(this.algorithmName, this.markedLinesInAlgorithm[i], "", null);
                    ++i;
                }
                this.markedLinesInAlgorithm = linesInAlgorithm;
                i = 0;
                while (i < this.markedLinesInAlgorithm.length) {
                    this.at.highlightCode(this.algorithmName, this.markedLinesInAlgorithm[i], "", null);
                    ++i;
                }
            }
            this.at.compositeStepEnd();
        }
    }
}

