/*
 * Decompiled with CFR 0.152.
 */
package translator;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;

public class ExtendedActionButton
extends JButton {
    private static final long serialVersionUID = 8245742211289028137L;
    private Action action;
    private PropertyChangeListener propertyChangeListener;

    public ExtendedActionButton() {
    }

    public ExtendedActionButton(Action theAction, int mnemonic) {
        this.setAction(theAction);
        this.setMnemonic(mnemonic);
    }

    public void setAction(Action newValue) {
        if (this.action != null && this.propertyChangeListener != null) {
            this.action.removePropertyChangeListener(this.propertyChangeListener);
            this.removeActionListener(this.action);
        }
        this.action = newValue;
        if (this.action == null) {
            this.setText("");
            this.setIcon(null);
        } else {
            this.setText((String)this.action.getValue("Name"));
            this.setIcon((Icon)this.action.getValue("SmallIcon"));
            this.setEnabled(this.action.isEnabled());
            String toolTipText = (String)this.action.getValue("ShortDescription");
            if (toolTipText != null) {
                this.setToolTipText(toolTipText);
            }
            this.addActionListener(this.action);
            if (this.propertyChangeListener == null) {
                this.propertyChangeListener = new LocalPropertyChangeListener();
            }
            this.action.addPropertyChangeListener(this.propertyChangeListener);
        }
    }

    class LocalPropertyChangeListener
    implements PropertyChangeListener {
        LocalPropertyChangeListener() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String propertyName = propertyChangeEvent.getPropertyName();
            if (propertyName.equals("Name")) {
                ExtendedActionButton.this.setText((String)propertyChangeEvent.getNewValue());
            } else if (propertyName.equals("SmallIcon")) {
                ExtendedActionButton.this.setIcon((Icon)propertyChangeEvent.getNewValue());
            } else if (propertyName.equals("ShortDescription")) {
                ExtendedActionButton.this.setToolTipText((String)propertyChangeEvent.getNewValue());
            } else if (propertyName.equals("enabled")) {
                ExtendedActionButton.this.setEnabled((Boolean)propertyChangeEvent.getNewValue());
            }
        }
    }
}

