/*
 * Decompiled with CFR 0.152.
 */
package generatorImplementations;

import generator.Generator;
import generatorImplementations.SortingAlgorithm;
import java.util.Locale;
import net.algoanim.aads.AnimatedIntArrayMarker;

public class SelectionSortGdI2
extends SortingAlgorithm
implements Generator {
    private static final String DESCRIPTION = "Dieser Generator sortiert das vom Nutzer eingegebene Array mittels Selection Sort.also das Element mit dem kleinsten Sortierschl\u00fcssel.\nDas Minimum wird dann mit dem ersten Element des Arrays vertauscht. Somit erh\u00e4lt man links ein sortiertes Teilarray der L\u00e4nge 1 und rechts ein unsortiertes der L\u00e4nge n-1.\nAnschlie\u00dfend wird der Algorithmus auf das unsortierte Teilarray angewendet.";
    private static final String HEADER_TEXT = "\n{\ntext \"f1-01\" \"Selection Sort\" at (120,50) color black font SansSerif size 32 bold\n}\n{\ntext \"f1-02a\" \"Das naheliegendste Verfahren zur Sortierung\" at (20,100) color black font SansSerif size 24\ntext \"f1-02b\" \"ist Sortieren durch Auswahl, auch als\" at (20,130) color black font SansSerif size 24\ntext \"f1-02c\" \"Selection Sort bezeichnet.\" at (20,160) color black font SansSerif size 24\n}\n{\nhideAll\ntext \"f2-01\" \"Der Algorithmus in Worten\" at (120,50) color black font SansSerif size 32 bold\n}\n{\ntext \"f2-02\" \"1. Setze i = 0\" at (20,100) color black font SansSerif size 24\n}\n{\ntext \"f2-03\" \"2. Suche von Position i + 1 bis n-1 das kleinste Element im Feld\" at (20,140) color black font SansSerif size 24\n}\n{\ntext \"f2-04\" \"3. Vertausche das kleinste Element mit dem Element an Position i\" at (20,180) color black font SansSerif size 24\n}\n{\ntext \"f2-05\" \"4. Setze i = i + 1 und fahre bei Schritt 2 fort bis i = n -1\" at (20,220) color black font SansSerif size 24\n}\n";
    private static final String SOURCE_CODE = "public void selectionSort(int[] array) { // sort by Selection Sort\n  int minPosition, i, j;\n  for (i = 0; i < array.length - 1; i++) {\n    minPosition = i; // min = current element\n    for (j = i + 1; j < array.length; j++)\n      if (array[j] < array[minPosition])\n        minPosition = j; // assign this as minimal element\n    swap(array, i, minPosition); // swap minimum with position i\n  }\n}";

    public void sort(int[] array) {
        int i = -1;
        int j = -1;
        if (array == null) {
            return;
        }
        int nrElems = array.length;
        this.sb.setLength(0);
        this.sb.append("%Animal 2.0\n");
        this.sb.append("title \"Selection Sort Animation\"\n");
        this.sb.append("author \"Dr. Guido Roessling <roessling@acm.org>\"\n");
        this.sb.append(HEADER_TEXT);
        this.sb.append("hideAll\n");
        this.toggleStep();
        this.targetArray = this.createIntArray("array");
        this.codeSupport = this.createCode(SOURCE_CODE, "code");
        this.codeSupport.highlightCode(0);
        this.addLabel(this.sb, "Initialisierung");
        this.codeSupport.highlightCode(0);
        this.toggleStep(this.sb);
        this.codeSupport.switchCodeLine(0, 1);
        this.toggleStep(this.sb);
        this.codeSupport.unhighlightCode(1);
        AnimatedIntArrayMarker minPosMarker = null;
        i = 0;
        while (i < nrElems - 1) {
            this.codeSupport.highlightCode(2);
            this.targetArray.incrementComparisons();
            this.targetArray.incrementAssignments();
            if (i == 0 || this.iMarker == null) {
                this.iMarker = this.createArrayMarker(this.targetArray, i, "i");
            } else {
                this.iMarker.moveArrayIndex(i);
            }
            this.toggleStep(this.sb);
            this.codeSupport.highlightCode(2, true, true);
            this.codeSupport.highlightCode(3);
            if (minPosMarker == null) {
                minPosMarker = this.createArrayMarker(this.targetArray, i, "min");
            } else {
                minPosMarker.moveArrayIndex(i);
            }
            this.addLabel(this.sb, "Anfang der Sortierung");
            this.toggleStep(this.sb);
            this.codeSupport.unhighlightCode(3);
            j = i + 1;
            while (j < nrElems) {
                if (this.jMarker == null) {
                    this.jMarker = this.createArrayMarker(this.targetArray, j, "j");
                } else {
                    this.jMarker.moveArrayIndex(j);
                }
                this.codeSupport.highlightCode(4);
                this.targetArray.incrementAssignments();
                this.targetArray.incrementComparisons();
                this.toggleStep(this.sb);
                this.codeSupport.highlightCode(4, true, true);
                this.codeSupport.highlightCode(5);
                this.targetArray.highlightArrayElement(j);
                this.targetArray.highlightArrayElement(minPosMarker.getCurrentIndex());
                this.toggleStep(this.sb);
                if (this.targetArray.getElementAt(this.jMarker.getCurrentIndex()) < this.targetArray.getElementAt(minPosMarker.getCurrentIndex())) {
                    this.codeSupport.highlightCode(5, true, true);
                    this.codeSupport.highlightCode(6);
                    this.targetArray.unhighlightArrayElement(minPosMarker.getCurrentIndex());
                    minPosMarker.moveArrayIndex(this.jMarker.getCurrentIndex());
                    this.targetArray.incrementComparisons();
                    this.toggleStep(this.sb);
                    this.codeSupport.unhighlightCode(6);
                }
                if (j != minPosMarker.getCurrentIndex()) {
                    this.targetArray.unhighlightArrayElement(j);
                }
                this.codeSupport.unhighlightCode(5);
                ++j;
            }
            this.targetArray.incrementComparisons();
            this.toggleStep(this.sb);
            this.codeSupport.unhighlightCode(4);
            this.codeSupport.highlightCode(7);
            this.targetArray.swap(this.iMarker.getCurrentIndex(), minPosMarker.getCurrentIndex());
            this.targetArray.unhighlightArrayElement(this.iMarker.getCurrentIndex());
            this.toggleStep(this.sb);
            this.addLabel(this.sb, "Ende der Iteration i=" + i);
            this.targetArray.highlightArrayCell(i);
            this.codeSupport.unhighlightCode(7);
            ++i;
        }
        this.targetArray.incrementComparisons();
        this.targetArray.highlightArrayCell(i);
        this.toggleStep(this.sb);
        this.addLabel(this.sb, "Aufwand");
        this.codeSupport.unhighlightCode(2);
        this.nrAssigns = this.targetArray.getNrAssignments();
        this.nrComparisons = this.targetArray.getNrComparisons();
        this.endAnimGeneration();
        this.endStep(this.sb);
        this.sb.append("{\n  hideAll\n  text \"eoa\" \"Ende der Animation\" at (120,50) color black font SansSerif size 32\n  text \"comps\" \"Es wurden \" +$\"nrComparisons\" asInt +\" Vergleiche\" at (20,100) color black font SansSerif size 24\n  text \"swaps\" \"und \" +$\"nrAssignments\" asInt +\" Zuweisungen durchgef\u00fchrt.\" at (20,130) color black font SansSerif size 24\n}");
    }

    protected String getAlgorithmDescription() {
        return DESCRIPTION;
    }

    protected String getAlgorithmCode() {
        return SOURCE_CODE;
    }

    public String getName() {
        return "Selection Sort (GdI 2)";
    }

    public String getDescription() {
        return DESCRIPTION;
    }

    public String getCodeExample() {
        return SOURCE_CODE;
    }

    public Locale getContentLocale() {
        return Locale.GERMANY;
    }
}

