/*
 * Decompiled with CFR 0.152.
 */
package generatorImplementations;

import animalscriptapi.animalscript.AnimalScript;
import animalscriptapi.exceptions.LineNotExistsException;
import animalscriptapi.primitives.ArrayMarker;
import animalscriptapi.primitives.Rect;
import animalscriptapi.primitives.SourceCode;
import animalscriptapi.primitives.StringArray;
import animalscriptapi.primitives.StringMatrix;
import animalscriptapi.primitives.Text;
import animalscriptapi.primitives.generators.Language;
import animalscriptapi.util.Coordinates;
import animalscriptapi.util.Offset;
import generator.Generator;
import generator.GeneratorType;
import generator.properties.AnimationPropertiesContainer;
import generatorImplementations.CompressionAlgorithm;
import java.awt.Color;
import java.util.Hashtable;
import java.util.Locale;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RLEEn
extends CompressionAlgorithm
implements Generator {
    private static final int inputLimit = 15;
    SourceCode sc;
    private static final String DESCRIPTION = "Run Length Encoding is a lossless compression algorithm. It is used for texts where characters are often repeated subsequently. For example, the string 'AAAA' is summarized to '4A'. Characters that appear single are not encoded. This version of the RLE algorithm cannot encode digits.";
    private static final String SOURCE_CODE = "The algorithm is explained by an animation. To ensure the animation  is not bigger than the size of the frame the text is limited to 15 characters.\n\npublic void rle(char[] array) {\n  int count = 1;\n  char tmp;\n  String result = \"\"\n  for (int i = 0; i < array.length; i++) {\n  \t tmp = array[i];\n  \t if (i == array.length - 1) {\n  \t\tresult += tmp;\n  \t\tbreak;\n  \t }\n  \t while (array[i + 1] == tmp) {\n  \t\ti++;\n  \t\tcount++;\n  \t }\n  \t if (count == 1) result += tmp;\n  \t else result = result + (String)count + tmp;\n  \t count = 1;\n  }\n}";

    public RLEEn() {
        this(new AnimalScript("Run Length Encoding EN", "Florian Lindner", 800, 600));
    }

    public RLEEn(Language l) {
        this.lang = l;
        this.lang.setStepMode(true);
    }

    public void compress(String[] text) throws LineNotExistsException {
        String[] t = new String[text.length];
        int i = 0;
        while (i < Math.min(15, text.length)) {
            t[i] = text[i];
            ++i;
        }
        text = t;
        Text topic = this.lang.newText(new Coordinates(20, 50), "Run Length Encoding EN", "Topic", null, tptopic);
        Rect topicRect = this.lang.newRect(new Offset(-5, -5, topic, "NW"), new Offset(5, 5, topic, "SE"), "topicRect", null, rctp);
        this.lang.nextStep();
        Text algoinWords = this.lang.newText(new Coordinates(20, 100), "Description of the algorithm:", "inWords", null, tpwords);
        this.lang.nextStep();
        Text step1 = this.lang.newText(new Offset(0, 100, topic, "SW"), "1) Iteratively read the characters of the string array.", "line1", null, tpsteps);
        this.lang.nextStep();
        Text step2 = this.lang.newText(new Offset(0, 40, step1, "SW"), "2) Count the number of equal subsequent following characters.", "line2", null, tpsteps);
        this.lang.nextStep();
        Text step3 = this.lang.newText(new Offset(0, 40, step2, "SW"), "3) Encode nX if there is a string with n times the character X and .", "line3", null, tpsteps);
        Text step31 = this.lang.newText(new Offset(0, 20, step3, "SW"), "   no letter inbetween.", "line3", null, tpsteps);
        this.lang.nextStep();
        Text step4 = this.lang.newText(new Offset(0, 40, step31, "SW"), "4) For the unique appereance of the letter Y encode Y.", "line4", null, tpsteps);
        this.lang.nextStep();
        algoinWords.hide();
        step1.hide();
        step2.hide();
        step3.hide();
        step31.hide();
        step4.hide();
        StringArray strArray = this.lang.newStringArray(new Offset(0, 100, topic, "SW"), text, "stringArray", null, ap);
        this.sc = this.lang.newSourceCode(new Offset(0, 50, strArray, "SW"), "codeName", null, scp);
        this.sc.addCodeLine("public void rle(char[] array) {", null, 0, null);
        this.sc.addCodeLine("int count = 1;", null, 1, null);
        this.sc.addCodeLine("char tmp; ", null, 1, null);
        this.sc.addCodeLine("String result;", null, 2, null);
        this.sc.addCodeLine("for (int i = 0; i < array.length; i++) {", null, 1, null);
        this.sc.addCodeLine("tmp = array[i];", null, 2, null);
        this.sc.addCodeLine("if (i == array.length - 1) {", null, 3, null);
        this.sc.addCodeLine("result += tmp;", null, 4, null);
        this.sc.addCodeLine("break;", null, 4, null);
        this.sc.addCodeLine("}", null, 3, null);
        this.sc.addCodeLine("while (array[i + 1] == tmp) {", null, 2, null);
        this.sc.addCodeLine("i++;", null, 3, null);
        this.sc.addCodeLine("count++;", null, 3, null);
        this.sc.addCodeLine("}", null, 2, null);
        this.sc.addCodeLine("if (count == 1) result += tmp;", null, 2, null);
        this.sc.addCodeLine("else result = result + (String)count + tmp;", null, 2, null);
        this.sc.addCodeLine("count = 1;", null, 2, null);
        this.sc.addCodeLine("}", null, 1, null);
        this.sc.addCodeLine("}", null, 0, null);
        String[][] varData = new String[2][2];
        varData[0][0] = "count";
        varData[1][0] = "tmp";
        varData[0][1] = "   ";
        varData[1][1] = "   ";
        StringMatrix varMatrix = this.lang.newStringMatrix(new Offset(75, 0, this.sc, "NE"), varData, "varMatrix", null, mp);
        Text resultLabel = this.lang.newText(new Offset(0, 50, this.sc, "SW"), "output:   ", "resultLabel", null, tpsteps);
        Text resultText = this.lang.newText(new Offset(10, -5, resultLabel, "SE"), "   ", "result", null, tpsteps);
        resultText.changeColor(null, Color.BLUE, null, null);
        this.lang.nextStep();
        this.sc.highlight(0, 0, false);
        this.lang.nextStep();
        this.sc.toggleHighlight(0, 0, false, 1, 0);
        varMatrix.put(0, 1, " 1 ", null, null);
        this.lang.nextStep();
        this.sc.toggleHighlight(1, 0, false, 2, 0);
        this.lang.nextStep();
        this.sc.toggleHighlight(2, 0, false, 3, 0);
        this.lang.nextStep();
        this.sc.toggleHighlight(3, 0, false, 4, 0);
        this.lang.nextStep();
        this.sc.unhighlight(4, 0, false);
        ArrayMarker am = this.lang.newArrayMarker(strArray, 0, "arrayMarker", null, amp);
        int marked = 0;
        int count = 1;
        String result = "";
        int i2 = 0;
        while (i2 < text.length) {
            am.move(i2, null, null);
            int m = 0;
            while (m <= marked) {
                strArray.unhighlightCell(i2 - m, null, null);
                ++m;
            }
            marked = 0;
            strArray.highlightCell(i2, null, null);
            ++marked;
            if (i2 > 0) {
                strArray.unhighlightCell(i2 - 1, null, null);
            }
            this.sc.unhighlight(4, 0, false);
            this.sc.highlight(5, 0, false);
            String tmp = text[i2];
            varMatrix.put(1, 1, " " + tmp + " ", null, null);
            this.lang.nextStep();
            this.sc.toggleHighlight(5, 0, false, 6, 0);
            if (i2 == text.length - 1) {
                this.lang.nextStep();
                this.sc.toggleHighlight(6, 0, false, 7, 0);
                result = String.valueOf(result) + tmp;
                resultText.setText(result, null, null);
                this.lang.nextStep();
                this.sc.toggleHighlight(7, 0, false, 8, 0);
                this.lang.nextStep();
                break;
            }
            this.lang.nextStep();
            this.sc.unhighlight(6, 0, false);
            this.sc.unhighlight(8, 0, false);
            this.sc.highlight(10, 0, false);
            while (text[i2 + 1].equals(tmp)) {
                this.lang.nextStep();
                this.sc.unhighlight(10, 0, false);
                this.sc.unhighlight(12, 0, false);
                this.sc.highlight(11, 0, false);
                am.move(++i2, null, null);
                strArray.highlightCell(i2, null, null);
                ++marked;
                this.lang.nextStep();
                this.sc.toggleHighlight(11, 0, false, 12, 0);
                varMatrix.put(0, 1, " " + ++count + " ", null, null);
            }
            this.lang.nextStep();
            this.sc.unhighlight(12, 0, false);
            this.sc.unhighlight(10, 0, false);
            this.sc.highlight(14, 0, false);
            if (count == 1) {
                this.lang.nextStep();
                this.sc.toggleHighlight(14, 0, false, 16, 0);
                result = String.valueOf(result) + tmp;
                resultText.setText(result, null, null);
            } else {
                this.lang.nextStep();
                result = String.valueOf(result) + new Integer(count).toString() + tmp;
                this.sc.toggleHighlight(14, 0, false, 15, 0);
                this.lang.nextStep();
                this.sc.toggleHighlight(15, 0, false, 16, 0);
                resultText.setText(result, null, null);
            }
            this.lang.nextStep();
            count = 1;
            varMatrix.put(0, 1, " " + count + " ", null, null);
            this.sc.toggleHighlight(16, 0, false, 4, 0);
            this.lang.nextStep();
            ++i2;
        }
        this.lang.nextStep();
        this.sc.unhighlight(8, 0, false);
        this.sc.highlight(18, 0, false);
        this.lang.nextStep();
        Text info = this.lang.newText(new Offset(0, 35, resultLabel, "SW"), "The Run Length Encoding is appropriate for texts that", "info", null, tpsteps);
        Text info2 = this.lang.newText(new Offset(0, 20, info, "SW"), "contain many subsequently repeating letters.", "info", null, tpsteps);
    }

    public static String getSOURCE_CODE() {
        return SOURCE_CODE;
    }

    @Override
    public String getCodeExample() {
        return SOURCE_CODE;
    }

    @Override
    public String getDescription() {
        return DESCRIPTION;
    }

    @Override
    public String getName() {
        return "Run Length Encoding";
    }

    @Override
    public String generate(AnimationPropertiesContainer props, Hashtable<String, Object> primitives) {
        String[] strArray = (String[])primitives.get("stringArray");
        try {
            this.compress(strArray);
        }
        catch (LineNotExistsException e) {
            e.printStackTrace();
        }
        return this.lang.toString();
    }

    @Override
    public String getFileExtension() {
        return "asu";
    }

    @Override
    public GeneratorType getGeneratorType() {
        return new GeneratorType(64);
    }

    @Override
    public Locale getContentLocale() {
        return Locale.US;
    }
}

