/*
 * Decompiled with CFR 0.152.
 */
package generatorImplementations;

import animalscriptapi.animalscript.AnimalScript;
import animalscriptapi.primitives.ArrayMarker;
import animalscriptapi.primitives.ArrayPrimitive;
import animalscriptapi.primitives.IntArray;
import animalscriptapi.primitives.Primitive;
import animalscriptapi.primitives.Rect;
import animalscriptapi.primitives.SourceCode;
import animalscriptapi.primitives.StringArray;
import animalscriptapi.primitives.Text;
import animalscriptapi.primitives.generators.Language;
import animalscriptapi.properties.AnimationProperties;
import animalscriptapi.properties.ArrayMarkerProperties;
import animalscriptapi.properties.ArrayProperties;
import animalscriptapi.properties.RectProperties;
import animalscriptapi.properties.SourceCodeProperties;
import animalscriptapi.properties.TextProperties;
import animalscriptapi.util.Coordinates;
import animalscriptapi.util.Hidden;
import animalscriptapi.util.Node;
import animalscriptapi.util.Offset;
import animalscriptapi.util.TicksTiming;
import animalscriptapi.util.Timing;
import generator.GeneratorType;
import generator.properties.AnimationPropertiesContainer;
import java.awt.Color;
import java.awt.Font;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Locale;
import translator.ResourceLocator;
import translator.Translator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AnimatedAlgorithm {
    protected static final Timing DEFAULT_TIMING = new TicksTiming(10);
    protected AnimationPropertiesContainer animationProperties;
    protected SourceCode code = null;
    protected SourceCode complexity = null;
    protected SourceCode description = null;
    protected Text descriptionHeader = null;
    protected Text header = null;
    protected HashMap<String, Integer> labelsToLines;
    protected Language lang;
    protected GeneratorType localType = null;
    protected Rect nrAssBox = null;
    protected Text nrAssLabel = null;
    protected Rect nrCompBox = null;
    protected Text nrCompLabel = null;
    protected int nrAssignments = 0;
    protected int nrComparisons = 0;
    protected Text nrStepsText = null;
    protected Hashtable<String, AnimationProperties> primitiveProps;
    protected Hashtable<String, Object> primitives;
    protected Translator translator;

    public AnimatedAlgorithm() {
    }

    public AnimatedAlgorithm(String resourceName, Locale locale) {
        this.translator = new Translator(resourceName, locale);
        this.primitiveProps = new Hashtable(59);
    }

    public GeneratorType getGeneratorType() {
        return this.localType;
    }

    public String getName() {
        return this.translator.translateMessage("algoName");
    }

    public String getDescription() {
        return this.translator.translateMessage("algoDesc");
    }

    public String getCodeExample() {
        return this.translator.translateMessageWithoutParameterExpansion("codeExample");
    }

    public String getFileExtension() {
        return ".asu";
    }

    protected void setParameters(AnimationPropertiesContainer props, Hashtable<String, Object> prims) {
        this.animationProperties = props;
        this.primitives = prims;
    }

    private void setUpAnimation(int width, int height) {
        this.lang = new AnimalScript(this.translator.translateMessage("animTitle"), this.translator.translateMessage("algoAuthor"), width, height);
        this.lang.setStepMode(true);
    }

    protected void setUpAnimation() {
        this.setUpAnimation(640, 480);
    }

    protected void createTitle() {
        boolean titleVisible;
        String message = this.translator.translateMessage("algoTitle");
        boolean bl = titleVisible = message != null && this.animationProperties.get("title", "hidden") != Boolean.FALSE;
        if (titleVisible) {
            this.header = this.installText("title", message, new Coordinates(20, 35));
            RectProperties rectProps = new RectProperties();
            rectProps.set("depth", this.animationProperties.get("headerRect", "depth"));
            rectProps.set("filled", this.animationProperties.get("headerRect", "filled"));
            rectProps.set("fillColor", (Color)this.animationProperties.get("headerRect", "fillColor"));
            Rect headerRect = this.lang.newRect(new Offset(-5, -5, this.header, "NW"), new Offset(5, 5, this.header, "SE"), "headerRect", null, rectProps);
            this.primitiveProps.put("headerRect", rectProps);
        }
    }

    protected void createAlgorithmDescription() {
        String message = this.translator.translateMessage("animDesc");
        if (message != null) {
            this.descriptionHeader = this.lang.newText(new Coordinates(20, 80), message, "descrHd", null, (TextProperties)this.primitiveProps.get("title"));
            this.description = this.installCodeBlock("description", "descr", new Offset(0, 30, this.descriptionHeader, "SW"));
            this.lang.nextStep();
        }
    }

    protected void createAnimationHeader() {
        this.createTitle();
        this.createAlgorithmDescription();
        if (this.descriptionHeader != null) {
            this.descriptionHeader.hide();
        }
        if (this.description != null) {
            this.description.hide();
        }
    }

    protected void createNrStepsDisplay() {
        String message = this.translator.translateMessage("nrSteps", new Integer[]{new Integer(this.nrAssignments), new Integer(this.nrComparisons)});
        this.nrStepsText = this.lang.newText(new Offset(0, 30, this.code, "SW"), message, "nrSteps", null, (TextProperties)this.primitiveProps.get("title"));
        this.lang.nextStep();
    }

    protected void createCounterBlocks(Node baseLocation) {
        String label = this.translator.translateMessage("nrAss");
        RectProperties rp = new RectProperties();
        rp.set("depth", 2);
        rp.set("filled", true);
        rp.set("fillColor", Color.BLUE);
        rp.set("color", Color.BLUE);
        this.nrAssLabel = this.lang.newText(baseLocation, label, "#A", null, (TextProperties)this.primitiveProps.get("title"));
        this.nrAssBox = this.lang.newRect(new Offset(10, 0, this.nrAssLabel, "NE"), new Offset(11, 0, this.nrAssLabel, "SE"), label, null, rp);
        label = this.translator.translateMessage("nrComp");
        this.nrCompLabel = this.lang.newText(new Offset(0, 35, this.nrAssLabel, "SW"), label, "#C", null, (TextProperties)this.primitiveProps.get("title"));
        this.nrCompBox = this.lang.newRect(new Offset(0, 35, this.nrAssBox, "NW"), new Offset(1, 35, this.nrAssBox, "SW"), label, null, rp);
    }

    protected void hideNrStepsArrayCode() {
        if (this.nrStepsText != null) {
            this.nrStepsText.hide();
        }
        if (this.code != null) {
            this.code.hide();
        }
        if (this.nrAssBox != null) {
            this.nrAssBox.hide();
        }
        if (this.nrAssLabel != null) {
            this.nrAssLabel.hide();
        }
        if (this.nrCompBox != null) {
            this.nrCompBox.hide();
        }
        if (this.nrCompLabel != null) {
            this.nrCompLabel.hide();
        }
    }

    protected void createComplexityDisplay() {
        this.complexity = this.installCodeBlock("complexity", "complexity", new Offset(0, 30, this.header, "SW"));
        this.lang.nextStep();
        if (this.complexity != null) {
            this.complexity.hide();
        }
    }

    protected void wrapUpAnimation() {
        this.createNrStepsDisplay();
        this.hideNrStepsArrayCode();
        this.createComplexityDisplay();
        Text linkToUrl = this.lang.newText(new Offset(0, 50, this.header, "SW"), this.translator.translateMessage("adForURL"), "adForURL", null, (TextProperties)this.primitiveProps.get("title"));
    }

    protected void incrementNrAssignments() {
        this.incrementNrAssignments(1);
    }

    protected void incrementNrAssignments(int howMany) {
        this.nrAssignments += howMany;
        if (this.nrAssBox != null) {
            this.nrAssBox.moveBy("translate #2", howMany * 2, 0, null, null);
        }
    }

    protected void incrementNrComparisons() {
        this.incrementNrComparisons(1);
    }

    protected void incrementNrComparisons(int howMany) {
        this.nrComparisons += howMany;
        if (this.nrCompBox != null) {
            this.nrCompBox.moveBy("translate #2", howMany * 2, 0, null, null);
        }
    }

    protected IntArray installIntArray(String key) {
        int[] arrayData = (int[])this.primitives.get(key);
        ArrayProperties iap = new ArrayProperties();
        iap.set("color", this.animationProperties.get(key, "color"));
        iap.set("fillColor", this.animationProperties.get(key, "fillColor"));
        iap.set("filled", Boolean.TRUE);
        iap.set("elementColor", this.animationProperties.get(key, "elementColor"));
        iap.set("elemHighlight", this.animationProperties.get(key, "elemHighlight"));
        iap.set("cellHighlight", this.animationProperties.get(key, "cellHighlight"));
        IntArray intArray = this.lang.newIntArray(new Coordinates(30, 150), arrayData, "array", null, iap);
        return intArray;
    }

    protected StringArray installStringArray(String key) {
        String[] arrayData = (String[])this.primitives.get(key);
        ArrayProperties iap = new ArrayProperties();
        iap.set("color", this.animationProperties.get(key, "color"));
        iap.set("fillColor", this.animationProperties.get(key, "fillColor"));
        iap.set("filled", Boolean.TRUE);
        iap.set("elementColor", this.animationProperties.get(key, "elementColor"));
        iap.set("elemHighlight", this.animationProperties.get(key, "elemHighlight"));
        iap.set("cellHighlight", this.animationProperties.get(key, "cellHighlight"));
        StringArray stringArray = this.lang.newStringArray(new Coordinates(30, 150), arrayData, "array", null, iap);
        return stringArray;
    }

    protected ArrayMarker installArrayMarker(String key, ArrayPrimitive baseArray, int initialPosition) {
        ArrayMarkerProperties amp = new ArrayMarkerProperties();
        amp.set("color", this.animationProperties.get(key, "color"));
        amp.set("label", this.animationProperties.get(key, "label"));
        amp.set("depth", this.animationProperties.get(key, "depth"));
        amp.set("hidden", this.animationProperties.get(key, "hidden"));
        ArrayMarker aMarker = this.lang.newArrayMarker(baseArray, initialPosition, key, null, amp);
        return aMarker;
    }

    private void formatText(SourceCode sourceCode, String key) {
        int lineNo = -1;
        int indentationLevel = 0;
        String message = null;
        String filename = this.translator.translateMessage(String.valueOf(key) + ".filename");
        StringBuilder sb = new StringBuilder(32337);
        String indenter = this.translator.translateMessage(String.valueOf(key) + ".level");
        int spacesPerLevel = new Integer(indenter);
        String labelChar = this.translator.translateMessage(String.valueOf(key) + ".labelSymbol");
        String lineLabel = null;
        if (this.labelsToLines == null) {
            this.labelsToLines = new HashMap(47);
        }
        if (filename != null) {
            try {
                InputStream f = ResourceLocator.getResourceLocator().getResourceStream(filename);
                BufferedReader br = new BufferedReader(new InputStreamReader(f));
                while ((message = br.readLine()) != null) {
                    sb.append(message).append("\n");
                    ++lineNo;
                    indentationLevel = 0;
                    lineLabel = null;
                    while (indentationLevel < message.length() && message.charAt(indentationLevel) == ' ') {
                        ++indentationLevel;
                    }
                    int startPos = indentationLevel;
                    int endPos = message.indexOf(labelChar);
                    if (endPos == -1) {
                        endPos = message.length();
                    } else {
                        lineLabel = message.substring(endPos + 1, message.length()).trim();
                    }
                    sourceCode.addCodeLine(message.substring(startPos, endPos).trim(), lineLabel, indentationLevel / spacesPerLevel, null);
                }
                f.close();
                br.close();
            }
            catch (IOException e) {
                System.err.println(e.getMessage());
            }
        }
    }

    protected Rect installCounterBoxes(Node location, String label) {
        Text nrAssLabel = this.lang.newText(location, label, label, null, (TextProperties)this.primitiveProps.get("title"));
        RectProperties rp = new RectProperties();
        rp.set("depth", 2);
        rp.set("filled", true);
        rp.set("fillColor", Color.BLUE);
        rp.set("color", Color.BLUE);
        Rect box = this.lang.newRect(new Offset(10, 0, nrAssLabel, "NE"), new Offset(11, 0, nrAssLabel, "SE"), label, null, rp);
        return box;
    }

    protected Text installText(String key, String message, Node location, TextProperties textProps) {
        boolean textHidden = (Boolean)this.animationProperties.get(key, "hidden");
        if (textHidden || message == null) {
            return null;
        }
        this.primitiveProps.put(key, textProps);
        Text aText = this.lang.newText(location, message, key, null, textProps);
        return aText;
    }

    protected Text installText(String key, String message, Node location) {
        TextProperties textProps = new TextProperties();
        textProps.set("color", (Color)this.animationProperties.get(key, "color"));
        textProps.set("centered", this.animationProperties.get(key, "centered"));
        Font userFont = (Font)this.animationProperties.get(key, "font");
        textProps.set("font", new Font(userFont.getFamily(), 1, 20));
        textProps.set("depth", this.animationProperties.get(key, "depth"));
        return this.installText(key, message, location, textProps);
    }

    protected SourceCode installCodeBlock(String key, String codeName, Node location) {
        boolean codeHidden = (Boolean)this.animationProperties.get(key, "hidden");
        SourceCodeProperties codeProps = new SourceCodeProperties();
        codeProps.set("color", (Color)this.animationProperties.get(key, "color"));
        codeProps.set("highlightColor", (Color)this.animationProperties.get(key, "highlightColor"));
        Font userFont = (Font)this.animationProperties.get(key, "font");
        codeProps.set("font", new Font(userFont.getFamily(), 1, 16));
        codeProps.set("depth", 3);
        Hidden display = null;
        if (codeHidden) {
            display = new Hidden();
        }
        codeProps.set("hidden", new Boolean(codeHidden));
        SourceCode aCode = this.lang.newSourceCode(location, codeName, display, codeProps);
        this.formatText(aCode, key);
        return aCode;
    }

    public abstract Primitive installAdditionalComponents(String var1, String var2, String var3, int var4, int var5);

    protected void setUpDefaultElements(AnimationPropertiesContainer props, Hashtable<String, Object> prims, String arrayKey, String codeKey, String codeName, int dx, int dy) {
        this.setParameters(props, prims);
        this.setUpAnimation();
        this.createAnimationHeader();
        Primitive alignmentPrimitive = this.installAdditionalComponents(arrayKey, codeKey, codeName, dx, dy);
        this.nrComparisons = 0;
        this.nrAssignments = 0;
        this.createCounterBlocks(new Offset(80, -80, alignmentPrimitive, "SE"));
    }

    public String generate(AnimationPropertiesContainer props, Hashtable<String, Object> prims) {
        this.setUpDefaultElements(props, prims, "intArray", "code", "code", 0, 20);
        return this.lang.toString();
    }
}

