/*
 * Decompiled with CFR 0.152.
 */
package generator.properties;

import animalscriptapi.properties.AnimationProperties;
import animalscriptapi.properties.Visitor;
import animalscriptapi.properties.items.AnimationPropertyItem;
import animalscriptapi.properties.items.BooleanPropertyItem;
import animalscriptapi.properties.items.ColorPropertyItem;
import animalscriptapi.properties.items.DoublePropertyItem;
import animalscriptapi.properties.items.FontPropertyItem;
import animalscriptapi.properties.items.IntegerPropertyItem;
import animalscriptapi.properties.items.StringPropertyItem;
import components.ColorChooserComboBox;
import generator.properties.tree.PropertiesTreeNode;
import java.awt.Color;
import java.awt.Font;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class LoadFromXMLVisitor
implements Visitor {
    Object objValue;
    Node nodeStart;

    public AnimationProperties loadPropsFromXML(Node n) throws IllegalArgumentException {
        AnimationProperties ap = null;
        NamedNodeMap attributes = n.getAttributes();
        if (attributes.getLength() != 1 && !attributes.item(0).getLocalName().equals("type")) {
            throw new IllegalArgumentException("'AnimationProperties' needs a 'type' attribute!");
        }
        String type = attributes.item(0).getNodeValue();
        ap = LoadFromXMLVisitor.createAnimationPropertiesByName(type);
        if (ap == null) {
            throw new IllegalArgumentException(String.valueOf(type) + " is not a " + "valid type for 'AnimationProperties'!");
        }
        Node child = null;
        Node item = null;
        child = n.getFirstChild();
        while (child != null) {
            if (child.getNodeType() == 3 && child.getLocalName() == null) {
                child = child.getNextSibling();
                continue;
            }
            if (!child.getLocalName().equals("AnimationPropertyItem")) {
                throw new IllegalArgumentException("Child Element is not 'AnimationPropertyItem'!");
            }
            attributes = child.getAttributes();
            if (attributes.getLength() != 1 && !attributes.item(0).getLocalName().equals("type")) {
                throw new IllegalArgumentException("'AnimationPropertyItem' needs a 'type' attribute!");
            }
            type = attributes.item(0).getNodeValue();
            item = child.getFirstChild();
            while (item != null && item.getNodeType() == 3 && item.getLocalName() == null) {
                item = item.getNextSibling();
            }
            if (item == null || item.getChildNodes().getLength() == 0) {
                throw new IllegalArgumentException("'AnimationPropertyItem' must have a 'name'!");
            }
            String name = item.getChildNodes().item(0).getNodeValue();
            item = item.getNextSibling();
            while (item != null && item.getNodeType() == 3 && item.getLocalName() == null) {
                item = item.getNextSibling();
            }
            if (item == null || item.getAttributes().getLength() == 0) {
                throw new IllegalArgumentException("'AnimationPropertyItem' must have a 'isEditable'!");
            }
            boolean isEditable = this.getBooleanValueByString(item.getAttributes().item(0).getNodeValue());
            item = item.getNextSibling();
            while (item != null && item.getNodeType() == 3 && item.getLocalName() == null) {
                item = item.getNextSibling();
            }
            if (item == null) {
                throw new IllegalArgumentException("'AnimationPropertyItem' must have a 'label'!");
            }
            String label = item.getChildNodes().getLength() == 0 ? "" : item.getChildNodes().item(0).getNodeValue();
            item = item.getNextSibling();
            while (item != null && item.getNodeType() == 3 && item.getLocalName() == null) {
                item = item.getNextSibling();
            }
            if (item == null) {
                throw new IllegalArgumentException("'AnimationPropertyItem' must have a 'value'!");
            }
            Object value = this.getValueForPropertyItemByName(type, item);
            ap.setLabel(name, label);
            ap.setIsEditable(name, isEditable);
            ap.set(name, value);
            AnimationPropertyItem apiDefault = (AnimationPropertyItem)ap.getItem(name).clone();
            ap.setDefault(name, apiDefault);
            child = child.getNextSibling();
        }
        return ap;
    }

    public PropertiesTreeNode loadPrimitiveFromXML(Node n) throws IllegalArgumentException {
        String theType = null;
        String theName = null;
        Object theValue = null;
        NamedNodeMap attributes = n.getAttributes();
        if (attributes.getLength() != 1 && !attributes.item(0).getLocalName().equals("type")) {
            throw new IllegalArgumentException("'Primitive' needs a 'type' attribute!");
        }
        theType = attributes.item(0).getNodeValue();
        Node item = n.getFirstChild();
        while (item != null && item.getNodeType() == 3 && item.getLocalName() == null) {
            item = item.getNextSibling();
        }
        if (item == null || item.getChildNodes().getLength() == 0) {
            throw new IllegalArgumentException("'Primitive' must have a 'name'!");
        }
        theName = item.getChildNodes().item(0).getNodeValue();
        item = item.getNextSibling();
        while (item != null && item.getNodeType() == 3 && item.getLocalName() == null) {
            item = item.getNextSibling();
        }
        if (item == null || item.getChildNodes().getLength() == 0) {
            throw new IllegalArgumentException("'Primitive' must have a 'value'!");
        }
        String theValueType = item.getChildNodes().item(0).getNodeName();
        if (!theValueType.equals(theType)) {
            throw new IllegalArgumentException("The types for Primitive and 'value' don't match!");
        }
        if (theType.equals("String")) {
            theValue = this.loadStringValueFromNode(item);
        }
        if (theType.equals("int")) {
            theValue = this.loadIntegerValueFromNode(item);
        }
        if (theType.equals("boolean")) {
            theValue = this.loadBooleanValueFromNode(item);
        }
        if (theType.equals("double")) {
            theValue = this.loadDoubleValueFromNode(item);
        }
        if (theType.equals("intArray")) {
            theValue = this.loadIntArrayValueFromNode(item);
        }
        if (theType.equals("StringArray")) {
            theValue = this.loadStringArrayValueFromNode(item);
        }
        if (theType.equals("Color")) {
            theValue = this.loadColorValueFromNode(item);
        }
        if (theType.equals("Font")) {
            theValue = this.loadFontValueFromNode(item);
        }
        if (theValue == null) {
            throw new IllegalArgumentException("The value for type '" + theType + "' was wrong!");
        }
        return new PropertiesTreeNode(theName, theValue);
    }

    public void visit(StringPropertyItem spi) {
        if (spi == null) {
            return;
        }
        this.objValue = this.loadStringValueFromNode(this.nodeStart);
    }

    public void visit(IntegerPropertyItem ipi) {
        if (ipi == null) {
            return;
        }
        this.objValue = this.loadIntegerValueFromNode(this.nodeStart);
    }

    public void visit(BooleanPropertyItem bpi) {
        if (bpi == null) {
            return;
        }
        this.objValue = this.loadBooleanValueFromNode(this.nodeStart);
    }

    public void visit(DoublePropertyItem dpi) {
        if (dpi == null) {
            return;
        }
        this.objValue = this.loadDoubleValueFromNode(this.nodeStart);
    }

    public void visit(ColorPropertyItem cpi) {
        if (cpi == null) {
            return;
        }
        this.objValue = this.loadColorValueFromNode(this.nodeStart);
    }

    public void visit(FontPropertyItem fpi) {
        if (fpi == null) {
            return;
        }
        this.objValue = this.loadFontValueFromNode(this.nodeStart);
    }

    private String loadStringValueFromNode(Node n) {
        Node helper;
        if (n.getChildNodes().getLength() == 1 && (helper = n.getChildNodes().item(0)).getLocalName().equals("String")) {
            if (helper.getChildNodes().getLength() == 0) {
                return "";
            }
            if (helper.getChildNodes().getLength() == 1) {
                return helper.getChildNodes().item(0).getNodeValue();
            }
        }
        throw new IllegalArgumentException("Error while loading String!");
    }

    private Integer loadIntegerValueFromNode(Node n) {
        Node helper;
        if (n.getChildNodes().getLength() == 1 && (helper = n.getChildNodes().item(0)).getLocalName().equals("int") && helper.getChildNodes().getLength() == 1) {
            return this.getIntegerValueByString(helper.getChildNodes().item(0).getNodeValue());
        }
        throw new IllegalArgumentException("Error while loading int!");
    }

    private Boolean loadBooleanValueFromNode(Node n) {
        Node helper;
        if (n.getChildNodes().getLength() == 1 && (helper = n.getChildNodes().item(0)).getLocalName().equals("boolean") && helper.getAttributes().getLength() == 1) {
            return this.getBooleanValueByString(helper.getAttributes().item(0).getNodeValue());
        }
        throw new IllegalArgumentException("Error while loading boolean!");
    }

    private Double loadDoubleValueFromNode(Node n) {
        Node helper;
        if (n.getChildNodes().getLength() == 1 && (helper = n.getChildNodes().item(0)).getLocalName().equals("double") && helper.getChildNodes().getLength() == 1) {
            return this.getDoubleValueByString(helper.getChildNodes().item(0).getNodeValue());
        }
        throw new IllegalArgumentException("Error while loading double!");
    }

    private int[] loadIntArrayValueFromNode(Node n) {
        Node helper;
        if (n.getChildNodes().getLength() == 1 && (helper = n.getChildNodes().item(0)).getLocalName().equals("intArray") && helper.getChildNodes().getLength() == 1) {
            return this.getIntArrayValueByString(helper.getChildNodes().item(0).getNodeValue());
        }
        throw new IllegalArgumentException("Error while loading intArray!");
    }

    private String[] loadStringArrayValueFromNode(Node n) {
        Node helper;
        if (n.getChildNodes().getLength() == 1 && (helper = n.getChildNodes().item(0)).getLocalName().equalsIgnoreCase("StringArray") && helper.getChildNodes().getLength() == 1) {
            return this.getStringArrayValueByString(helper.getChildNodes().item(0).getNodeValue());
        }
        throw new IllegalArgumentException("Error while loading intArray!");
    }

    private Color loadColorValueFromNode(Node n) {
        Node helper;
        if (n.getChildNodes().getLength() == 1 && (helper = n.getChildNodes().item(0)).getLocalName().equals("Color") && helper.getChildNodes().getLength() == 1) {
            return this.getColorValueByString(helper.getChildNodes().item(0).getNodeValue());
        }
        throw new IllegalArgumentException("Error while loading Color!");
    }

    private Font loadFontValueFromNode(Node n) {
        Node helper;
        if (n.getChildNodes().getLength() == 1 && (helper = n.getChildNodes().item(0)).getLocalName().equals("Font") && helper.getChildNodes().getLength() == 1) {
            return this.getFontValueByString(helper.getChildNodes().item(0).getNodeValue());
        }
        throw new IllegalArgumentException("Error while loading Font!");
    }

    public Integer getIntegerValueByString(String value) throws IllegalArgumentException {
        try {
            Integer retVal = new Integer(value);
            return retVal;
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException(String.valueOf(value) + " is not a valid value" + "for an int!");
        }
    }

    public Boolean getBooleanValueByString(String value) throws IllegalArgumentException {
        if (value.equalsIgnoreCase("true")) {
            return true;
        }
        if (value.equals("1")) {
            return true;
        }
        if (value.equalsIgnoreCase("false")) {
            return new Boolean(false);
        }
        if (value.equals("0")) {
            return new Boolean(false);
        }
        throw new IllegalArgumentException(String.valueOf(value) + " is not a valid value for a" + " boolean!");
    }

    public Double getDoubleValueByString(String value) throws IllegalArgumentException {
        try {
            Double retVal = new Double(value);
            return retVal;
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException(String.valueOf(value) + " is not a valid value" + "for a double!");
        }
    }

    public int[] getIntArrayValueByString(String value) throws IllegalArgumentException {
        String[] parts = value.split(",", 128);
        int[] tmp = new int[parts.length];
        int i = 0;
        while (i < parts.length) {
            try {
                tmp[i] = Integer.parseInt(parts[i].trim());
            }
            catch (Exception e) {
                throw new IllegalArgumentException(String.valueOf(value) + " is not a valid value for an intArray!");
            }
            ++i;
        }
        return tmp;
    }

    public String[] getStringArrayValueByString(String value) throws IllegalArgumentException {
        String[] parts = value.split(",", 128);
        String[] tmp = new String[parts.length];
        int i = 0;
        while (i < parts.length) {
            tmp[i] = parts[i].trim();
            ++i;
        }
        return tmp;
    }

    public Color getColorValueByString(String value) throws IllegalArgumentException {
        try {
            Color retVal = ColorChooserComboBox.getColorForString(value);
            return retVal;
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException(String.valueOf(value) + " is not a valid value" + "for a Color!");
        }
    }

    public Font getFontValueByString(String value) throws IllegalArgumentException {
        Font retVal = new Font(value, 0, 12);
        return retVal;
    }

    private static AnimationProperties createAnimationPropertiesByName(String className) {
        if (className == null) {
            return null;
        }
        AnimationProperties object = null;
        String pack = AnimationProperties.class.getPackage().getName();
        try {
            Class<?> genClass = Class.forName(String.valueOf(pack) + "." + className);
            object = (AnimationProperties)genClass.newInstance();
            return object;
        }
        catch (Exception e) {
            return null;
        }
    }

    private Object getValueForPropertyItemByName(String className, Node node) throws IllegalArgumentException {
        if (className == null || node == null) {
            return null;
        }
        AnimationPropertyItem object = null;
        String pack = AnimationPropertyItem.class.getPackage().getName();
        try {
            Class<?> genClass = Class.forName(String.valueOf(pack) + "." + className);
            object = (AnimationPropertyItem)genClass.newInstance();
            this.nodeStart = node;
            object.accept(this);
            return this.objValue;
        }
        catch (Exception e) {
            throw new IllegalArgumentException(String.valueOf(className) + " is not a valid type for an 'AnimationPropertyItem'!");
        }
    }
}

