/*
 * Decompiled with CFR 0.152.
 */
package generator;

import generator.WizardGUIListener;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import translator.Translator;

public class WizardGUI
extends WindowAdapter
implements ActionListener {
    private JFrame frame;
    private static final long serialVersionUID = 3690754016438989111L;
    private JPanel panelContent = new JPanel();
    public JButton btnBack;
    public AbstractButton btnNext;
    private JButton btnExit;
    private JLabel lblHelp;
    private int currentStep = 0;
    private int numberOfSteps = 0;
    private String[] strHelp;
    private JComponent[] content;
    private WizardGUIListener listener;
    private Translator translator;

    public WizardGUI(int newNumberOfSteps) {
        if (newNumberOfSteps < 1) {
            newNumberOfSteps = 1;
        }
        this.numberOfSteps = newNumberOfSteps;
        this.strHelp = new String[newNumberOfSteps];
        this.content = new JComponent[newNumberOfSteps];
        this.listener = null;
        this.frame = new JFrame();
    }

    public void displayWizard() {
        this.frame.setDefaultCloseOperation(2);
        BorderLayout borderLayout = new BorderLayout(0, 1);
        this.frame.getContentPane().setLayout(borderLayout);
        this.frame.getContentPane().setBackground(Color.black);
        JPanel panelHelp = new JPanel();
        panelHelp.setPreferredSize(new Dimension(600, 60));
        panelHelp.setBackground(Color.white);
        this.lblHelp = new JLabel(this.strHelp[0]);
        this.lblHelp.setFont(new Font("SansSerif", 0, 12));
        panelHelp.add(this.lblHelp);
        this.frame.getContentPane().add((Component)panelHelp, "First");
        this.panelContent.setPreferredSize(new Dimension(600, 300));
        this.panelContent.setLayout(new CardLayout(8, 8));
        this.frame.getContentPane().add((Component)this.panelContent, "Center");
        int i = 0;
        while (i < this.numberOfSteps) {
            if (this.content[i] == null) {
                throw new IllegalArgumentException(this.translator.translateMessage("illegalPanel", new String[]{Integer.toString(i)}));
            }
            this.panelContent.add((Component)this.content[i], Integer.toString(i));
            ++i;
        }
        JPanel panelButtons = new JPanel();
        panelButtons.setLayout(new FlowLayout(4, 8, 2));
        this.btnBack = new JButton(this.translator.translateMessage("backButton"));
        this.btnBack.setActionCommand("back");
        this.btnBack.setMnemonic('b');
        this.btnBack.setEnabled(false);
        panelButtons.add(this.btnBack);
        this.btnBack.addActionListener(this);
        this.btnNext = this.translator.getGenerator().generateJButton("confirm", null, false, this);
        this.btnNext.setActionCommand("next");
        this.frame.getRootPane().setDefaultButton((JButton)this.btnNext);
        this.btnNext.setEnabled(true);
        panelButtons.add(this.btnNext);
        this.btnExit = new JButton(this.translator.translateMessage("exit"));
        this.btnExit.setActionCommand("exit");
        this.btnExit.setMnemonic('a');
        panelButtons.add(this.btnExit);
        this.btnExit.addActionListener(this);
        this.frame.getContentPane().add((Component)panelButtons, "Last");
        this.frame.setResizable(true);
        this.frame.getRootPane().setMinimumSize(new Dimension(600, 400));
        this.frame.setSize(600, 440);
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension frameSize = this.frame.getSize();
        if (frameSize.height > screenSize.height) {
            frameSize.height = screenSize.height;
        }
        if (frameSize.width > screenSize.width) {
            frameSize.width = screenSize.width;
        }
        this.frame.setLocation((screenSize.width - frameSize.width) / 2, (screenSize.height - frameSize.height) / 2);
        this.showStep(0);
        this.frame.setVisible(true);
    }

    public void showStep(int index) {
        if (index < 0 || index >= this.numberOfSteps) {
            return;
        }
        this.lblHelp.setText(this.strHelp[index]);
        CardLayout cl = (CardLayout)this.panelContent.getLayout();
        cl.show(this.panelContent, Integer.toString(index));
        this.btnBack.setEnabled(index > 0);
        this.currentStep = index;
        if (this.listener != null) {
            this.listener.afterShowStep(index);
        }
    }

    public void setListener(WizardGUIListener newListener) {
        this.listener = newListener;
    }

    public void removeListener() {
        this.listener = null;
    }

    public void actionPerformed(ActionEvent e) {
        if (e == null) {
            return;
        }
        if (e.getActionCommand().equalsIgnoreCase("exit")) {
            this.frame.dispose();
        }
        if (e.getActionCommand().equalsIgnoreCase("back")) {
            boolean doit = true;
            if (this.listener != null) {
                doit = this.listener.backPressed();
            }
            if (!doit) {
                return;
            }
            if (this.currentStep > 0) {
                this.showStep(this.currentStep - 1);
            }
            return;
        }
        if (e.getActionCommand().equalsIgnoreCase("next")) {
            boolean doit = true;
            if (this.listener != null) {
                doit = this.listener.nextPressed();
            }
            if (!doit) {
                return;
            }
            if (this.currentStep < this.numberOfSteps - 1) {
                this.showStep(this.currentStep + 1);
            }
            return;
        }
    }

    public void windowClosing(WindowEvent closingEvent) {
        this.frame.setVisible(false);
        this.frame.dispose();
    }

    protected void setVisible(boolean isVisible) {
        this.frame.setVisible(isVisible);
    }

    protected JFrame getWizardFrame() {
        return this.frame;
    }

    public int getCurrentStep() {
        return this.currentStep;
    }

    public JComponent getContent(int index) {
        if (index < 0 || index >= this.numberOfSteps) {
            return null;
        }
        if (this.content == null) {
            return null;
        }
        return this.content[index];
    }

    public void setContent(int index, JComponent newContent) {
        if (index < 0 || index >= this.numberOfSteps) {
            return;
        }
        if (this.content == null) {
            return;
        }
        this.content[index] = newContent;
    }

    public int getNumberOfSteps() {
        return this.numberOfSteps;
    }

    public String getHelpString(int index) {
        if (index < 0 || index >= this.numberOfSteps) {
            return null;
        }
        if (this.strHelp == null) {
            return null;
        }
        return this.strHelp[index];
    }

    public void setHelpString(int index, String newHelpString) {
        if (index < 0 || index >= this.numberOfSteps) {
            return;
        }
        if (newHelpString == null) {
            return;
        }
        if (this.strHelp == null) {
            return;
        }
        this.strHelp[index] = newHelpString;
    }

    public void setTranslator(Translator trans) {
        this.translator = trans;
    }
}

