/*
 * Decompiled with CFR 0.152.
 */
package generator;

import animal.misc.AnimalTranslator;
import animal.misc.MessageDisplay;
import generator.CustomFileFilter;
import generator.Generator;
import generator.GeneratorInfos;
import generator.GeneratorType;
import generator.PropertiesPanel;
import generator.PropertiesPanelListener;
import generator.WizardGUI;
import generator.WizardGUIListener;
import generator.properties.tree.PropertiesTreeModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import java.util.Vector;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import translator.Translator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GeneratorGUI
implements ActionListener,
ListSelectionListener,
KeyListener,
WizardGUIListener,
PropertiesPanelListener {
    private String langCode = "en";
    private String animalGenerator;
    private static final long serialVersionUID = 3258417218155919665L;
    private static TreeMap<String, GeneratorInfos>[] generatorInfos;
    private static int numberOfDifferentGeneratorTypes;
    private static int numberOfDifferentGenerators;
    public WizardGUI wiz;
    private int currentIndex = -1;
    private int currentPosition = -1;
    protected Generator selectedGenerator;
    public String[] keysForGeneratorInfos;
    public Hashtable<Integer, Integer> hashTypes;
    private JList listGeneratorTypes;
    private JLabel lblTypeName;
    private JTextPane lblTypeDescription;
    private JLabel lblTypeDetails;
    private JList listGenerators;
    private JTextArea lblDescription;
    private JTextArea lblCodeExample;
    private JLabel lblFileExtension;
    protected PropertiesPanel propPanel;
    JTextField txtFileName = new JTextField();
    private Class<?> generatorDummy;
    public Translator translator;

    static {
        numberOfDifferentGeneratorTypes = 0;
        numberOfDifferentGenerators = 0;
    }

    public static void main(String[] args) {
        String langCode = "en";
        String countryCode = "US";
        if (args != null && args.length > 0 && args[0] != null && args[0].startsWith("-lang=")) {
            String code = args[0];
            int countryPos = code.indexOf(95);
            if (countryPos != -1) {
                countryCode = code.substring(countryPos + 1, countryPos + 3);
            }
            langCode = code.substring(6, 8);
        }
        new GeneratorGUI(langCode, countryCode);
    }

    public GeneratorGUI(String languageKey, String countryKey) {
        Locale locale = Locale.US;
        if (languageKey != null) {
            locale = countryKey == null ? new Locale(languageKey) : new Locale(languageKey, countryKey);
        }
        this.initialize(locale);
    }

    public GeneratorGUI(Locale targetLocale) {
        this.initialize(targetLocale);
    }

    private void initialize(Locale targetLocale) {
        this.langCode = targetLocale.getLanguage();
        if (this.translator == null) {
            this.translator = new Translator("GeneratorMsg", targetLocale);
        }
        this.getGeneratorInfos();
        this.animalGenerator = this.translator.translateMessage("animalGenerator");
        if (numberOfDifferentGenerators == 0) {
            System.out.println(this.translator.translateMessage("noValidGeneratorsFound"));
            return;
        }
        this.wiz = new WizardGUI(4);
        this.wiz.setTranslator(this.translator);
        this.wiz.getWizardFrame().setTitle(this.animalGenerator);
        this.wiz.setHelpString(0, this.translator.translateMessage("infoNrFound", new String[]{Integer.toString(numberOfDifferentGenerators), Integer.toString(numberOfDifferentGeneratorTypes)}));
        this.wiz.setHelpString(3, this.translator.translateMessage("pleaseSelectFile"));
        int i = 0;
        while (i < 5) {
            this.wiz.setContent(i, this.createPanelForStep(i));
            ++i;
        }
        this.wiz.setListener(this);
        this.wiz.displayWizard();
    }

    private JPanel createPanelForStep(int numberOfStep) {
        if (numberOfStep < 0 || numberOfStep > 4) {
            return null;
        }
        if (numberOfDifferentGenerators == 0) {
            return null;
        }
        switch (numberOfStep) {
            case 0: {
                return this.getGeneratorTypePanel();
            }
            case 1: {
                return this.getGeneratorSelectionPanel();
            }
            case 2: {
                return this.getGeneratorPropertiesPanel();
            }
            case 3: {
                return this.getFileChoicePanel();
            }
        }
        return new JPanel();
    }

    private JPanel getGeneratorTypePanel() {
        JPanel p = new JPanel();
        p.setLayout(new BorderLayout(8, 8));
        this.listGeneratorTypes = new JList();
        this.listGeneratorTypes.addListSelectionListener(this);
        JScrollPane scrollTypeList = new JScrollPane(this.listGeneratorTypes);
        scrollTypeList.setPreferredSize(new Dimension(200, 288));
        p.add((Component)scrollTypeList, "West");
        this.hashTypes = new Hashtable(numberOfDifferentGeneratorTypes);
        int[] genTypes = GeneratorType.getTypes();
        String[] listData = new String[numberOfDifferentGeneratorTypes];
        int pos = 0;
        int i = 0;
        while (i < generatorInfos.length) {
            if (generatorInfos[i].size() > 0) {
                this.hashTypes.put(new Integer(pos), new Integer(i));
                String displayName = this.translator.translateMessage(GeneratorType.getStringForType(genTypes[i]));
                listData[pos++] = displayName;
            }
            ++i;
        }
        this.listGeneratorTypes.setListData(listData);
        JPanel panelTypeInfo = new JPanel();
        panelTypeInfo.setLayout(new BorderLayout(8, 8));
        panelTypeInfo.setPreferredSize(new Dimension(388, 288));
        p.add((Component)panelTypeInfo, "Center");
        JPanel panelHead = new JPanel();
        panelHead.setLayout(new BorderLayout(8, 8));
        panelHead.setPreferredSize(new Dimension(388, 48));
        this.lblTypeName = new JLabel();
        this.lblTypeName.setFont(new Font("SansSerif", 0, 24));
        this.lblTypeName.setHorizontalTextPosition(4);
        this.lblTypeName.setVerticalTextPosition(0);
        this.lblTypeName.setIconTextGap(16);
        panelHead.add((Component)this.lblTypeName, "Before");
        panelTypeInfo.add((Component)panelHead, "First");
        this.lblTypeDescription = new JTextPane();
        this.lblTypeDescription.setContentType("text/html");
        this.lblTypeDescription.setEditable(false);
        JScrollPane scrollTypeDesc = new JScrollPane(this.lblTypeDescription);
        scrollTypeDesc.setPreferredSize(new Dimension(388, 200));
        panelTypeInfo.add((Component)scrollTypeDesc, "Center");
        this.lblTypeDetails = new JLabel();
        this.lblTypeDetails.setPreferredSize(new Dimension(388, 25));
        panelTypeInfo.add((Component)this.lblTypeDetails, "Last");
        if (this.listGeneratorTypes.getModel().getSize() > 0) {
            this.listGeneratorTypes.setSelectedIndex(0);
        }
        return p;
    }

    private JPanel getGeneratorSelectionPanel() {
        JPanel p = new JPanel();
        p.setLayout(new BorderLayout(8, 8));
        this.listGenerators = new JList();
        this.listGenerators.addListSelectionListener(this);
        JScrollPane scrollList = new JScrollPane(this.listGenerators);
        scrollList.setPreferredSize(new Dimension(200, 288));
        p.add((Component)scrollList, "West");
        JPanel panelInfo = new JPanel();
        panelInfo.setPreferredSize(new Dimension(388, 288));
        p.add((Component)panelInfo, "Center");
        panelInfo.setLayout(new BorderLayout(8, 8));
        this.lblDescription = new JTextArea();
        this.lblDescription.setLineWrap(true);
        this.lblDescription.setWrapStyleWord(true);
        this.lblDescription.setEditable(false);
        JScrollPane scrollDesc = new JScrollPane(this.lblDescription);
        scrollDesc.setPreferredSize(new Dimension(388, 120));
        panelInfo.add((Component)scrollDesc, "First");
        this.lblCodeExample = new JTextArea();
        this.lblCodeExample.setLineWrap(true);
        this.lblCodeExample.setWrapStyleWord(true);
        this.lblCodeExample.setEditable(false);
        JScrollPane scrollCode = new JScrollPane(this.lblCodeExample);
        scrollCode.setPreferredSize(new Dimension(388, 120));
        panelInfo.add((Component)scrollCode, "Center");
        this.lblFileExtension = new JLabel();
        this.lblFileExtension.setPreferredSize(new Dimension(388, 25));
        panelInfo.add((Component)this.lblFileExtension, "Last");
        return p;
    }

    private JPanel getGeneratorPropertiesPanel() {
        JPanel p = new JPanel();
        p.setLayout(new BorderLayout(8, 8));
        this.propPanel = new PropertiesPanel();
        this.propPanel.setListener(this);
        p.add((Component)this.propPanel, "Center");
        return p;
    }

    private JPanel getFileChoicePanel() {
        JPanel p = new JPanel();
        p.setLayout(new BoxLayout(p, 3));
        JPanel panelTextField = new JPanel();
        panelTextField.setLayout(new BorderLayout(8, 8));
        JLabel filenameLabel = new JLabel(this.translator.translateMessage("filenamePrompt"));
        panelTextField.add((Component)filenameLabel, "Before");
        panelTextField.add((Component)this.txtFileName, "Center");
        this.txtFileName.addKeyListener(this);
        int txtHeight = this.txtFileName.getPreferredSize().height;
        panelTextField.setPreferredSize(new Dimension(300, txtHeight + 5));
        panelTextField.setMaximumSize(new Dimension(600, txtHeight + 5));
        p.add(panelTextField);
        p.add(Box.createRigidArea(new Dimension(0, 16)));
        JPanel panelButton = new JPanel();
        panelButton.setLayout(new BorderLayout(8, 8));
        JButton but = new JButton(this.translator.translateMessage("browse"));
        but.setActionCommand("browse");
        but.addActionListener(this);
        panelButton.add((Component)but, "After");
        int butHeight = but.getPreferredSize().height;
        but.setPreferredSize(new Dimension(200, butHeight + 5));
        panelButton.setPreferredSize(new Dimension(300, butHeight + 5));
        panelButton.setMaximumSize(new Dimension(600, butHeight + 5));
        p.add(panelButton);
        return p;
    }

    private boolean fillListOfGenerators(int index) {
        if (index < 0 || index >= generatorInfos.length) {
            return false;
        }
        int iSize = generatorInfos[index].size();
        if (iSize == 0) {
            return false;
        }
        String[] listData = new String[iSize];
        this.keysForGeneratorInfos = new String[iSize];
        int pos = 0;
        for (Map.Entry<String, GeneratorInfos> e : generatorInfos[index].entrySet()) {
            this.keysForGeneratorInfos[pos] = e.getKey();
            GeneratorInfos info = e.getValue();
            listData[pos++] = info.getName();
        }
        this.listGenerators.setListData(listData);
        if (this.listGenerators.getModel().getSize() > 0) {
            this.listGenerators.setSelectedIndex(0);
        }
        this.currentIndex = index;
        return true;
    }

    private void fillInfosForGenerator(int pos) {
        if (pos < 0 || pos >= this.keysForGeneratorInfos.length) {
            return;
        }
        int index = this.currentIndex;
        String key = this.keysForGeneratorInfos[pos];
        GeneratorInfos infos = generatorInfos[index].get(key);
        if (infos == null) {
            return;
        }
        this.lblDescription.setText(infos.getDescription());
        this.lblDescription.setCaretPosition(0);
        this.lblCodeExample.setText(infos.getCodeExample());
        this.lblCodeExample.setCaretPosition(0);
        String fileExtMsg = this.translator.translateMessage("targetFileExtension", new String[]{infos.getFileExtension()});
        this.lblFileExtension.setText(fileExtMsg);
        this.currentPosition = pos;
    }

    private void fillPropertiesForGenerator() {
        if (this.selectedGenerator == null) {
            return;
        }
        StringBuilder buf = new StringBuilder(64);
        buf.append(this.selectedGenerator.getClass().getPackage().getName());
        buf.append("/");
        buf.append(this.selectedGenerator.getClass().getSimpleName());
        buf.append(".ptm");
        try {
            this.propPanel.loadURI(buf.toString());
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
        }
    }

    private void callMethodByName(String name) {
        if (this.selectedGenerator == null) {
            return;
        }
        Class<?> c = this.selectedGenerator.getClass();
        Class[] parameterTypes = new Class[]{};
        Object[] arguments = new Object[]{};
        try {
            Method theMethod = c.getMethod(name, parameterTypes);
            theMethod.invoke((Object)this.selectedGenerator, arguments);
        }
        catch (NoSuchMethodException e) {
            System.err.println(this.translator.translateMessage("noSuchMethod"));
            return;
        }
        catch (IllegalAccessException e) {
            return;
        }
        catch (InvocationTargetException e) {
            return;
        }
    }

    private void getGeneratorInfos() {
        Vector<String> generators = null;
        generators = this.readListOfGenerators();
        int diffTypes = 0;
        int diffGenerators = 0;
        generatorInfos = new TreeMap[GeneratorType.getNumberOfTypes()];
        int i = 0;
        while (i < generatorInfos.length) {
            GeneratorGUI.generatorInfos[i] = new TreeMap();
            ++i;
        }
        if (!generators.isEmpty()) {
            Enumeration<String> en = generators.elements();
            while (en.hasMoreElements()) {
                Generator gen;
                String next = en.nextElement();
                if (!(next instanceof String) || (gen = GeneratorGUI.createGeneratorByName(next)) == null) continue;
                int genType = gen.getGeneratorType().getType();
                GeneratorInfos infos = new GeneratorInfos(next, gen.getGeneratorType(), gen.getName(), gen.getDescription(), gen.getCodeExample(), gen.getFileExtension());
                ++diffGenerators;
                Vector<Integer> indexes = GeneratorType.getArrayIndexes(genType);
                for (int index : indexes) {
                    generatorInfos[index].put(next, infos);
                }
            }
        }
        i = 0;
        while (i < generatorInfos.length) {
            if (generatorInfos[i].size() > 0) {
                ++diffTypes;
            }
            ++i;
        }
        numberOfDifferentGeneratorTypes = diffTypes;
        numberOfDifferentGenerators = diffGenerators;
    }

    private static Generator createGeneratorByName(String className) {
        Object object;
        block5: {
            object = null;
            Class<?> genClass = Class.forName("generatorImplementations." + className);
            object = genClass.newInstance();
            if (object instanceof Generator) break block5;
            return null;
        }
        try {
            return object;
        }
        catch (InstantiationException e) {
            return null;
        }
        catch (IllegalAccessException e) {
            return null;
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    protected Vector<String> readListOfGenerators() {
        File f;
        ClassLoader cl;
        Vector<String> vec = new Vector<String>();
        URL url = null;
        if (this.generatorDummy == null) {
            try {
                this.generatorDummy = Class.forName("generatorImplementations.DummyGenerator");
            }
            catch (ClassNotFoundException cfe) {
                System.err.println("DummyGenerator could not be found!");
            }
        }
        if (this.generatorDummy != null && (cl = this.generatorDummy.getClassLoader()) != null) {
            url = cl.getResource("generatorImplementations");
        }
        if (url == null) {
            System.err.println("url null, using built-in");
            vec.addElement("BinarySearchWrapper");
            vec.addElement("BoyerMooreStringSearchWrapper");
            vec.addElement("BruteForceStringSearchWrapper");
            vec.addElement("BubbleSort");
            vec.addElement("BubbleSortEN");
            vec.addElement("BubbleSortGdI2");
            vec.addElement("BubbleSortGdI2Improved");
            vec.addElement("BubbleSortMathLab");
            vec.addElement("InsertionSort");
            vec.addElement("InsertionSortEN");
            vec.addElement("InsertionSortGdI2");
            vec.addElement("InsertionSortPseudoCode");
            vec.addElement("InsertionSortPseudoCode");
            vec.addElement("InsertionSortPseudoCode2");
            vec.addElement("InsertionSortPseudoCode2EN");
            vec.addElement("InsertionSortPseudoCodeEN");
            vec.addElement("InterpolationSearchWrapper");
            vec.addElement("KnuthMorrisPrattStringSearchWrapper");
            vec.addElement("MergeSort");
            vec.addElement("MergeSortEN");
            vec.addElement("QuickSort");
            vec.addElement("QuickSort2");
            vec.addElement("QuickSort3");
            vec.addElement("QuickSortEN");
            vec.addElement("QuickSortGdI2");
            vec.addElement("SelectionSort");
            vec.addElement("SelectionSortEN");
            vec.addElement("SelectionSortGdI2");
            vec.addElement("SequentialSearchWrapper");
            vec.addElement("ShellSort");
            vec.addElement("ShellSortEN");
            vec.addElement("VigenereDecodeWrapper");
            vec.addElement("VigenereDecodeWrapperEN");
            vec.addElement("VigenereEncodeWrapper");
            vec.addElement("VigenereEncodeWrapperEN");
            return vec;
        }
        String path = url.toString();
        if (path.startsWith("jar:")) {
            if (path.endsWith(".jar")) {
                path = path.substring(4, path.indexOf(".jar") + 4);
            } else if (path.indexOf("!") > 0) {
                path = path.substring(4, path.indexOf("!"));
            }
            try {
                JarEntry entry;
                URI uri = new URI(path);
                JarInputStream jf = new JarInputStream(new URL(path).openConnection().getInputStream());
                while ((entry = jf.getNextJarEntry()) != null) {
                    String name = entry.getName();
                    if (!name.startsWith("generatorImplementations") || name.length() < 31) continue;
                    name = name.substring(25, name.length() - 6);
                    vec.add(name);
                }
            }
            catch (Exception e) {
                System.err.println(String.valueOf(e.getClass().getName()) + " // " + e.getMessage());
                return vec;
            }
        }
        try {
            f = new File(url.toURI());
        }
        catch (URISyntaxException e) {
            return vec;
        }
        if (f == null) {
            return vec;
        }
        String[] files = f.list();
        if (files == null) {
            return vec;
        }
        int i = 0;
        while (i < files.length) {
            if (files[i].endsWith(".class")) {
                vec.add(files[i].substring(0, files[i].length() - 6));
            }
            ++i;
        }
        try {
            Properties config = null;
            InputStream in = this.getClass().getResourceAsStream("/generators.dat");
            if (in != null) {
                BufferedInputStream bins = new BufferedInputStream(in);
                config = new Properties();
                config.load(bins);
                bins.close();
                in.close();
                Enumeration<?> keys = config.propertyNames();
                while (keys.hasMoreElements()) {
                    String elementKey = (String)config.get(keys.nextElement());
                    if (vec.contains(elementKey)) continue;
                    vec.add(config.getProperty((String)keys.nextElement()));
                }
            }
        }
        catch (IOException ioex) {
            MessageDisplay.errorMsg(AnimalTranslator.translateMessage("genSpecMissing"), 4);
        }
        return vec;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e == null) {
            return;
        }
        if (e.getActionCommand().equalsIgnoreCase("browse")) {
            JFileChooser fc;
            if (this.txtFileName.getText().length() > 0) {
                File start = new File(this.txtFileName.getText());
                fc = new JFileChooser(start.getParent());
            } else {
                fc = new JFileChooser();
            }
            fc.addChoosableFileFilter(new CustomFileFilter(this.selectedGenerator.getFileExtension()));
            int result = fc.showSaveDialog(this.wiz.getWizardFrame());
            if (result != 0) {
                return;
            }
            File selFile = fc.getSelectedFile();
            try {
                String strFile = selFile.getCanonicalPath();
                if (selFile.getName().indexOf(".") == -1) {
                    strFile = strFile.concat("." + this.selectedGenerator.getFileExtension());
                }
                this.txtFileName.setText(strFile);
                this.wiz.btnNext.setEnabled(this.txtFileName.getText().length() > 0);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return;
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (e == null) {
            return;
        }
        if (e.getValueIsAdjusting()) {
            return;
        }
        if (e.getSource().equals(this.listGeneratorTypes)) {
            String message;
            int arrayPos;
            this.currentIndex = arrayPos = this.hashTypes.get(new Integer(this.listGeneratorTypes.getSelectedIndex())).intValue();
            String docName = GeneratorType.getStringForArrayIndex(arrayPos).toLowerCase().replaceAll(" ", "_");
            try {
                this.lblTypeName.setIcon(new ImageIcon(this.getClass().getResource("/generator/types/" + docName + ".gif")));
            }
            catch (Exception e1) {
                String message2 = this.translator.translateMessage("imageNotFound", new String[]{Integer.toString(arrayPos), docName});
                System.err.println(message2);
            }
            String label = this.translator.translateMessage(GeneratorType.getStringForArrayIndex(arrayPos));
            this.lblTypeName.setText(label);
            try {
                InputStream is = this.getClass().getResourceAsStream("/generator/types/" + docName + this.langCode.toUpperCase() + ".txt");
                if (is == null) {
                    throw new IOException();
                }
                InputStreamReader reader = new InputStreamReader(is);
                BufferedReader buf = new BufferedReader(reader, 1024);
                String line = buf.readLine();
                StringBuilder strBuf = new StringBuilder(1024);
                while (line != null) {
                    strBuf.append(line).append("\n");
                    line = buf.readLine();
                }
                this.lblTypeDescription.setText(strBuf.toString());
                this.lblTypeDescription.setContentType("text/html");
                this.lblTypeDescription.setCaretPosition(0);
            }
            catch (Exception e2) {
                message = this.translator.translateMessage("textNotFound", new String[]{Integer.toString(arrayPos), docName});
                System.err.println(message);
            }
            int numOfGens = generatorInfos[arrayPos].size();
            message = numOfGens > 1 ? this.translator.translateMessage("multipleGeneratorsFound", new String[]{Integer.toString(numOfGens)}) : this.translator.translateMessage("oneGeneratorFound");
            this.lblTypeDetails.setText(message);
            return;
        }
        if (e.getSource().equals(this.listGenerators)) {
            int index = this.listGenerators.getSelectedIndex();
            if (index < 0 || index >= this.listGenerators.getModel().getSize()) {
                return;
            }
            this.fillInfosForGenerator(index);
            return;
        }
    }

    @Override
    public void keyTyped(KeyEvent e) {
        if (e == null) {
            return;
        }
        final JTextField txt = this.txtFileName;
        final AbstractButton but = this.wiz.btnNext;
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                but.setEnabled(txt.getText().length() > 0);
            }
        });
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (e == null) {
            return;
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
        if (e == null) {
            return;
        }
    }

    public void setCategoryIndex(int index) {
        this.currentIndex = index;
    }

    public void setConcreteGenerator(int index) {
        this.currentPosition = index;
    }

    public boolean setStateTo(int stateNumber) {
        if (stateNumber == 0) {
            if (!this.fillListOfGenerators(this.currentIndex)) {
                return false;
            }
            this.listGenerators.setSelectedIndex(0);
            this.wiz.setHelpString(1, this.translator.translateMessage("selectedCategory", new String[]{this.translator.translateMessage(GeneratorType.getStringForArrayIndex(this.currentIndex))}));
            return true;
        }
        if (stateNumber == 1) {
            String key = this.keysForGeneratorInfos[this.currentPosition];
            this.wiz.setHelpString(2, this.translator.translateMessage("selectedGenerator", new String[]{generatorInfos[this.currentIndex].get(key).getName()}));
            this.selectedGenerator = GeneratorGUI.createGeneratorByName(key);
            this.fillPropertiesForGenerator();
            if (!this.propPanel.areThereElements()) {
                this.wiz.showStep(3);
            }
            return true;
        }
        if (stateNumber == 2) {
            this.propPanel.updateCurrentPropertyValues();
            return true;
        }
        if (stateNumber == 3) {
            File selFile = new File(this.txtFileName.getText());
            if (selFile.exists()) {
                if (!selFile.isFile()) {
                    JOptionPane.showMessageDialog(this.wiz.getWizardFrame(), this.translator.translateMessage("invalidFilename", new String[]{selFile.getPath()}), this.animalGenerator, 0);
                    return false;
                }
                int ret = JOptionPane.showConfirmDialog(this.wiz.getWizardFrame(), this.translator.translateMessage("invalidFilename", new String[]{selFile.getPath()}), this.animalGenerator, 0);
                if (ret == 1) {
                    return false;
                }
            }
            BufferedWriter buf = null;
            try {
                try {
                    FileWriter out = new FileWriter(selFile);
                    buf = new BufferedWriter(out);
                    PropertiesTreeModel aModel = (PropertiesTreeModel)this.propPanel.getTree().getModel();
                    buf.write(this.selectedGenerator.generate(aModel.getPropertiesContainer(), aModel.getPrimitivesContainer()));
                    buf.flush();
                    buf.close();
                    int choice = JOptionPane.showConfirmDialog(this.wiz.getWizardFrame(), this.translator.translateMessage("exitNow"), this.animalGenerator, 0, 3);
                    if (choice == 0) {
                        this.wiz.getWizardFrame().dispose();
                    }
                }
                catch (IOException e1) {
                    JOptionPane.showMessageDialog(this.wiz.getWizardFrame(), this.translator.translateMessage("errorWriting", new String[]{selFile.getPath()}), this.animalGenerator, 0);
                    try {
                        if (buf != null) {
                            buf.close();
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    return false;
                }
            }
            finally {
                try {
                    if (buf != null) {
                        buf.close();
                    }
                }
                catch (Exception exception) {}
            }
        }
        return false;
    }

    @Override
    public boolean nextPressed() {
        return this.setStateTo(this.wiz.getCurrentStep());
    }

    public void setGeneratorLocale(Locale targetLocale) {
        this.initialize(targetLocale);
    }

    public boolean storeFile() {
        File selFile = new File(this.txtFileName.getText());
        if (selFile.exists()) {
            if (!selFile.isFile()) {
                JOptionPane.showMessageDialog(this.wiz.getWizardFrame(), this.translator.translateMessage("invalidFilename", new String[]{selFile.getPath()}), this.animalGenerator, 0);
                return false;
            }
            int ret = JOptionPane.showConfirmDialog(this.wiz.getWizardFrame(), this.translator.translateMessage("invalidFilename", new String[]{selFile.getPath()}), this.animalGenerator, 0);
            if (ret == 1) {
                return false;
            }
        }
        BufferedWriter buf = null;
        try {
            try {
                FileWriter out = new FileWriter(selFile);
                buf = new BufferedWriter(out);
                buf.write(this.selectedGenerator.generate(((PropertiesTreeModel)this.propPanel.getTree().getModel()).getPropertiesContainer(), ((PropertiesTreeModel)this.propPanel.getTree().getModel()).getPrimitivesContainer()));
                buf.flush();
                buf.close();
                int choice = JOptionPane.showConfirmDialog(this.wiz.getWizardFrame(), this.translator.translateMessage("exitNow"), this.animalGenerator, 0, 3);
                if (choice == 0) {
                    this.wiz.getWizardFrame().dispose();
                }
            }
            catch (IOException e1) {
                JOptionPane.showMessageDialog(this.wiz.getWizardFrame(), this.translator.translateMessage("errorWriting", new String[]{selFile.getPath()}), this.animalGenerator, 0);
                try {
                    if (buf != null) {
                        buf.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return false;
            }
        }
        finally {
            try {
                if (buf != null) {
                    buf.close();
                }
            }
            catch (Exception exception) {}
        }
        return true;
    }

    @Override
    public boolean backPressed() {
        if (this.wiz.getCurrentStep() == 3 && !this.propPanel.areThereElements()) {
            this.wiz.showStep(1);
            return false;
        }
        return true;
    }

    @Override
    public void afterShowStep(int index) {
        if (index == 2) {
            this.propPanel.getTree().setSelectionRow(0);
        }
    }

    @Override
    public void callMethod(String methodName) {
        this.callMethodByName(methodName);
    }
}

