/*
 * Decompiled with CFR 0.152.
 */
package animalscriptapi.examples;

import animalscriptapi.animalscript.AnimalScript;
import animalscriptapi.exceptions.LineNotExistsException;
import animalscriptapi.primitives.ArrayMarker;
import animalscriptapi.primitives.Graph;
import animalscriptapi.primitives.IntArray;
import animalscriptapi.primitives.SourceCode;
import animalscriptapi.primitives.Text;
import animalscriptapi.primitives.generators.Language;
import animalscriptapi.properties.ArrayMarkerProperties;
import animalscriptapi.properties.GraphProperties;
import animalscriptapi.properties.TextProperties;
import animalscriptapi.util.Coordinates;
import animalscriptapi.util.MsTiming;
import animalscriptapi.util.Node;
import animalscriptapi.util.Offset;
import animalscriptapi.util.TicksTiming;
import java.awt.Color;
import java.awt.Font;

public class QuickSort {
    private Language lang;
    private static final String DESCRIPTION = "QuickSort w\u00e4hlt ein Element aus der zu sortierenden Liste aus (Pivotelement) und zerlegt die Liste in zwei Teillisten, eine untere, die alle Elemente kleiner und eine obere, die alle Elemente gleich oder gr\u00f6\u00dfer dem Pivotelement enth\u00e4lt.\nDazu wird zun\u00e4chst ein Element von unten gesucht, das gr\u00f6\u00dfer als (oder gleichgro\u00df wie) das Pivotelement und damit f\u00fcr die untere Liste zu gro\u00df ist. Entsprechend wird von oben ein kleineres Element als das Pivotelement gesucht. Die beiden Elemente werden dann vertauscht und landen damit in der jeweils richtigen Liste.\nDer Vorgang wird fortgesetzt, bis sich die untere und obere Suche treffen. Damit sind die oben erw\u00e4hnten Teillisten in einem einzigen Durchlauf entstanden. Suche und Vertauschung k\u00f6nnen in-place durchgef\u00fchrt werden.\n\nDie noch unsortierten Teillisten werden \u00fcber denselben Algorithmus in noch kleinere Teillisten zerlegt (z. B. mittels Rekursion) und, sobald nur noch Listen mit je einem Element vorhanden sind, wieder zusammengesetzt. Die Sortierung ist damit abgeschlossen.";
    private static final String SOURCE_CODE = "public void quickSort(int[] array, int l, int r)\n{\n  int i, j, pivot;\n  if (r>l)\n  {\n    pivot = array[r];\n    for (i = l; j = r - 1; i < j; )\n    {\n      while (array[i] <= pivot && j > i)\n        i++;\n      while (pivot < array[j] && j > i)\n        j--;\n      if (i < j)\n        swap(array, i, j);\n    }\n    if (pivot < array[i])\n      swap(array, i, r);\n    else\n      i=r;\n    quickSort(array, l, i - 1);\n    quickSort(array, i + 1, r);\n  }\n}";
    private int pointerCounter = 0;

    public QuickSort(Language l) {
        this.lang = l;
        this.lang.setStepMode(true);
    }

    public void sort(int[] a) {
        int[][] nArrayArray = new int[4][];
        int[] nArray = new int[4];
        nArray[1] = 1;
        nArray[3] = 2;
        nArrayArray[0] = nArray;
        int[] nArray2 = new int[4];
        nArray2[0] = 2;
        nArray2[3] = 10;
        nArrayArray[1] = nArray2;
        int[] nArray3 = new int[4];
        nArray3[0] = 17;
        nArrayArray[2] = nArray3;
        int[] nArray4 = new int[4];
        nArray4[2] = 1;
        nArrayArray[3] = nArray4;
        int[][] adj = nArrayArray;
        Node[] nodes = new Node[]{new Coordinates(20, 100), new Coordinates(120, 100), new Coordinates(20, 160), new Coordinates(120, 200)};
        String[] labels = new String[]{"A", "B", "C", "D"};
        GraphProperties graphProps = new GraphProperties();
        graphProps.set("color", Color.BLACK);
        graphProps.set("highlightColor", Color.RED);
        graphProps.set("fillColor", Color.GREEN);
        graphProps.set("weighted", true);
        graphProps.set("directed", true);
        graphProps.set("edgeColor", Color.BLUE);
        graphProps.set("nodeColor", Color.YELLOW);
        Graph graph = this.lang.newGraph("demoGraph", adj, nodes, labels, null, graphProps);
        this.lang.nextStep();
        graph.highlightEdge(0, 3, null, null);
        this.lang.nextStep();
        graph.highlightNode(2, null, null);
        this.lang.nextStep();
        graph.hideNode(1, null, null);
        this.lang.nextStep();
        graph.hideNode(3, null, null);
        this.lang.nextStep();
        graph.showNode(1, null, null);
        this.lang.nextStep();
        graph.showNodes(new int[]{1, 3}, null, null);
        this.lang.nextStep();
        graph.hideEdge(1, 3, null, null);
        graph.hideEdge(2, 0, null, null);
        this.lang.nextStep();
        graph.showEdge(2, 0, null, null);
        this.lang.nextStep();
        graph.setEdgeWeight(0, 3, 42, null, null);
        this.lang.nextStep();
        graph.hideEdgeWeight(0, 3, null, null);
        graph.hideEdgeWeight(0, 1, null, null);
        this.lang.nextStep();
        graph.showEdgeWeight(0, 3, null, null);
        this.lang.nextStep();
        TextProperties textProps = new TextProperties();
        textProps.set("color", Color.RED);
        textProps.set("centered", false);
        textProps.set("font", new Font("SansSerif", 0, 16));
        Text aText = this.lang.newText(new Coordinates(10, 30), "Hallo Welt!", "text", null, textProps);
        this.lang.nextStep();
        aText.setText("Hello World!", new MsTiming(500), new MsTiming(500));
        this.lang.nextStep();
        aText.setFont(new Font("Monospaced", 3, 20), new MsTiming(500), new MsTiming(500));
        this.lang.nextStep();
        graph.translateNode(2, new Offset(30, 75, aText, "S"), null, new TicksTiming(20));
        this.lang.nextStep();
        graph.translateWithFixedNodes(new int[]{1, 3}, new Offset(80, 45, aText, "S"), null, new TicksTiming(20));
        this.lang.nextStep();
        graph.translateNodes(new int[]{1, 3}, new Offset(80, 45, aText, "S"), null, new TicksTiming(20));
    }

    private void quickSort(IntArray array, SourceCode codeSupport, int l, int r) throws LineNotExistsException {
        codeSupport.highlight(0, 0, false);
        this.lang.nextStep();
        codeSupport.toggleHighlight(0, 0, false, 2, 0);
        ++this.pointerCounter;
        ArrayMarkerProperties arrayIMProps = new ArrayMarkerProperties();
        arrayIMProps.set("label", "i");
        arrayIMProps.set("color", Color.BLACK);
        ArrayMarker iMarker = this.lang.newArrayMarker(array, 0, "i" + this.pointerCounter, null, arrayIMProps);
        ++this.pointerCounter;
        ArrayMarkerProperties arrayJMProps = new ArrayMarkerProperties();
        arrayJMProps.set("label", "j");
        arrayJMProps.set("color", Color.BLACK);
        ArrayMarker jMarker = this.lang.newArrayMarker(array, 0, "j" + this.pointerCounter, null, arrayJMProps);
        this.lang.nextStep();
        codeSupport.toggleHighlight(2, 0, false, 3, 0);
        ++this.pointerCounter;
        ArrayMarkerProperties arrayPMProps = new ArrayMarkerProperties();
        arrayPMProps.set("label", "pivot");
        arrayPMProps.set("color", Color.BLUE);
        ArrayMarker pivotMarker = this.lang.newArrayMarker(array, 0, "pivot" + this.pointerCounter, null, arrayPMProps);
        this.lang.nextStep();
        codeSupport.unhighlight(3, 0, false);
        if (r > l) {
            this.lang.nextStep();
            codeSupport.highlight(5, 0, false);
            int pivot = array.getData()[r];
            pivotMarker.move(r, null, null);
            this.lang.nextStep();
            codeSupport.unhighlight(5, 0, false);
            int i = l;
            int j = r - 1;
            while (i < j) {
                codeSupport.highlight(6, 0, false);
                iMarker.move(i, null, null);
                jMarker.move(j, null, null);
                this.lang.nextStep();
                codeSupport.toggleHighlight(6, 0, false, 8, 0);
                while (array.getData()[i] <= pivot && j > i) {
                    this.lang.nextStep();
                    codeSupport.toggleHighlight(8, 0, false, 9, 0);
                    iMarker.move(++i, null, null);
                    this.lang.nextStep();
                    codeSupport.toggleHighlight(9, 0, false, 8, 0);
                }
                this.lang.nextStep();
                codeSupport.toggleHighlight(8, 0, false, 10, 0);
                while (pivot < array.getData()[j] && j > i) {
                    this.lang.nextStep();
                    codeSupport.toggleHighlight(10, 0, false, 11, 0);
                    jMarker.move(--j, null, null);
                    this.lang.nextStep();
                    codeSupport.toggleHighlight(11, 0, false, 10, 0);
                }
                this.lang.nextStep();
                codeSupport.toggleHighlight(10, 0, false, 12, 0);
                if (i < j) {
                    this.lang.nextStep();
                    codeSupport.toggleHighlight(12, 0, false, 13, 0);
                    array.swap(i, j, null, null);
                }
                this.lang.nextStep();
                codeSupport.toggleHighlight(13, 0, false, 12, 0);
            }
            codeSupport.toggleHighlight(6, 0, false, 13, 0);
            this.lang.nextStep();
            if (pivot < array.getData()[i]) {
                codeSupport.toggleHighlight(15, 0, false, 16, 0);
                array.swap(i, r, null, null);
                pivotMarker.move(i, null, null);
                this.lang.nextStep();
                codeSupport.unhighlight(16, 0, false);
            } else {
                i = r;
                codeSupport.toggleHighlight(15, 0, false, 18, 0);
                iMarker.move(r, null, null);
                this.lang.nextStep();
                codeSupport.unhighlight(18, 0, false);
            }
            array.highlightElem(i, null, null);
            this.lang.nextStep();
            codeSupport.highlight(19, 0, false);
            this.lang.nextStep();
            codeSupport.unhighlight(19, 0, false);
            array.unhighlightCell(i, r, null, null);
            this.quickSort(array, codeSupport, l, i - 1);
            this.lang.nextStep();
            array.highlightCell(l, r, null, null);
            codeSupport.highlight(20, 0, false);
            this.lang.nextStep();
            codeSupport.unhighlight(20, 0, false);
            array.unhighlightCell(l, i, null, null);
            this.quickSort(array, codeSupport, i + 1, r);
        }
        this.lang.nextStep();
        codeSupport.highlight(21, 0, false);
        this.lang.nextStep();
        codeSupport.highlight(22, 0, false);
        this.lang.nextStep();
        array.unhighlightCell(l, r, null, null);
    }

    protected String getAlgorithmDescription() {
        return DESCRIPTION;
    }

    protected String getAlgorithmCode() {
        return SOURCE_CODE;
    }

    public String getName() {
        return "Quicksort (pivot=last)";
    }

    public String getDescription() {
        return DESCRIPTION;
    }

    public String getCodeExample() {
        return SOURCE_CODE;
    }

    public static void main(String[] args) {
        AnimalScript l = new AnimalScript("Quicksort Animation", "Dr. Guido R\u00f6\u00dfling", 640, 480);
        QuickSort s = new QuickSort(l);
        int[] a = new int[]{7, 3, 2, 4, 1, 13, 52, 13, 5, 1};
        s.sort(a);
        System.out.println(l);
    }
}

