/*
 * Decompiled with CFR 0.152.
 */
package animalscriptapi.animalscript;

import animalscriptapi.animalscript.AnimalGenerator;
import animalscriptapi.animalscript.AnimalScript;
import animalscriptapi.primitives.ArrayMarker;
import animalscriptapi.primitives.generators.ArrayMarkerGenerator;
import animalscriptapi.primitives.generators.Language;
import animalscriptapi.properties.ArrayMarkerProperties;
import animalscriptapi.util.Timing;
import java.awt.Color;

public class AnimalArrayMarkerGenerator
extends AnimalGenerator
implements ArrayMarkerGenerator {
    private static int count = 1;

    public AnimalArrayMarkerGenerator(Language aLang) {
        super(aLang);
    }

    public void create(ArrayMarker am) {
        if (this.isNameUsed(am.getName()) || am.getName() == "") {
            am.setName("ArrayMarker" + count);
            ++count;
        }
        this.lang.addItem(am);
        StringBuilder def = new StringBuilder(AnimalScript.INITIAL_GENBUFFER_SIZE);
        def.append("arrayMarker \"").append(am.getName()).append("\" on \"");
        def.append(am.getArray().getName()).append("\" atIndex ");
        def.append(am.getPosition());
        ArrayMarkerProperties props = am.getProperties();
        if (props.get("label") != null && !((String)props.get("label")).equals("")) {
            def.append(" label \"").append((String)props.get("label")).append("\"");
        }
        if (props.get("color") != null) {
            def.append(" color ");
            def.append(AnimalGenerator.makeColorDef(((Color)props.get("color")).getRed(), ((Color)props.get("color")).getGreen(), ((Color)props.get("color")).getBlue()));
        }
        if (props.get("depth") != null) {
            def.append(" depth " + ((Integer)props.get("depth")).toString());
        }
        def.append(AnimalGenerator.makeDisplayOptionsDef(am.getDisplayOptions()));
        this.lang.addLine(def);
    }

    public void move(ArrayMarker am, int to, Timing delay, Timing duration) {
        this.lang.addLine("moveArrayMarker \"" + am.getName() + "\" to position " + to + " " + AnimalGenerator.makeOffsetTimingDef(delay) + " " + AnimalGenerator.makeDurationTimingDef(duration));
    }

    public void moveToEnd(ArrayMarker am, Timing delay, Timing duration) {
        this.lang.addLine("moveArrayMarker \"" + am.getName() + "\" to arrayEnd " + AnimalGenerator.makeOffsetTimingDef(delay) + " " + AnimalGenerator.makeDurationTimingDef(duration));
    }

    public void moveOutside(ArrayMarker am, Timing delay, Timing duration) {
        this.lang.addLine("moveArrayMarker \"" + am.getName() + "\" to outside " + AnimalGenerator.makeOffsetTimingDef(delay) + " " + AnimalGenerator.makeDurationTimingDef(duration));
    }
}

