/*
 * Decompiled with CFR 0.152.
 */
package animalscript.extensions;

import animal.animator.ColorChanger;
import animal.animator.TimedShow;
import animal.graphics.PTPoint;
import animal.misc.MessageDisplay;
import animal.misc.ParseSupport;
import animal.misc.XProperties;
import animalscript.core.AnimalParseSupport;
import animalscript.core.AnimalScriptInterface;
import animalscript.core.BasicParser;
import animalscript.extensions.CodeProducer;
import java.awt.Color;
import java.awt.Font;
import java.awt.Point;
import java.io.IOException;
import java.util.Hashtable;

public class CodeSupport
extends BasicParser
implements AnimalScriptInterface {
    private CodeProducer codeProducer = new CodeProducer();

    public CodeSupport() {
        this.handledKeywords = new Hashtable();
        this.rulesHash = new XProperties();
        this.handledKeywords.put("codegroup", "parseCodeInput");
        this.handledKeywords.put("addcodeelem", "parseCodeInput");
        this.handledKeywords.put("addcodeline", "parseCodeInput");
        this.handledKeywords.put("highlightcode", "parseColorChange");
        this.handledKeywords.put("unhighlightcode", "parseColorChange");
        this.handledKeywords.put("hidecode", "parseCodeDisplay");
    }

    public boolean generateNewStep(String command) {
        return !sameStep && !command.equalsIgnoreCase("addCodeGroup");
    }

    public XProperties parseCodeInput() throws IOException {
        String operationType = ParseSupport.parseWord(stok, "code keyword");
        String codeGroupName = null;
        if (operationType.equalsIgnoreCase("codeGroup")) {
            codeGroupName = AnimalParseSupport.parseText(stok, String.valueOf(operationType) + " name");
            CodeSupport.getObjectIDs().put(codeGroupName, "");
            CodeSupport.getObjectProperties().put(String.valueOf(codeGroupName) + ".lineNo", 0);
            ParseSupport.parseOptionalWord(stok, String.valueOf(operationType) + " location keyword 'at'", "at");
            Point startingPoint = AnimalParseSupport.parseNodeInfo(stok, String.valueOf(operationType) + " upper left corner", null);
            CodeSupport.getObjectProperties().put(String.valueOf(codeGroupName) + ".x0", startingPoint.x);
            CodeSupport.getObjectProperties().put(String.valueOf(codeGroupName) + ".y", startingPoint.y);
            CodeSupport.getObjectProperties().put(String.valueOf(codeGroupName) + ".y0", startingPoint.y);
            CodeSupport.getObjectProperties().put(String.valueOf(codeGroupName) + ".color", AnimalParseSupport.parseAndSetColor(stok, codeGroupName, "color", "black"));
            CodeSupport.getObjectProperties().put(String.valueOf(codeGroupName) + ".contextColor", AnimalParseSupport.parseAndSetColor(stok, codeGroupName, "highlightColor", "red"));
            CodeSupport.getObjectProperties().put(String.valueOf(codeGroupName) + ".contextColor", AnimalParseSupport.parseAndSetColor(stok, codeGroupName, "contextColor", "blue"));
            Font f = AnimalParseSupport.parseFontInfo(stok, codeGroupName);
            CodeSupport.getObjectProperties().put(String.valueOf(codeGroupName) + ".font", f);
            f = null;
            PTPoint p = new PTPoint(startingPoint);
            AnimalParseSupport.parseAndSetDepth(stok, p, operationType);
            CodeSupport.getObjectProperties().put(String.valueOf(codeGroupName) + ".depth", p.getDepth());
            p = null;
            String unit = "ticks";
            if (ParseSupport.parseOptionalWord(stok, String.valueOf(operationType) + "keyword 'after'", "after")) {
                CodeSupport.getObjectProperties().put(String.valueOf(codeGroupName) + ".delay", ParseSupport.parseInt(stok, String.valueOf(operationType) + " delay", 0));
                unit = ParseSupport.parseWord(stok, String.valueOf(operationType) + "delay unit");
                if (unit == null) {
                    unit = "ticks";
                }
                CodeSupport.getObjectProperties().put(String.valueOf(codeGroupName) + ".delayUnit", unit);
            }
        } else if (operationType.equalsIgnoreCase("addCodeLine") || operationType.equalsIgnoreCase("addCodeElem")) {
            XProperties codeProperties = new XProperties();
            boolean fullLine = operationType.equalsIgnoreCase("addCodeLine");
            String text = AnimalParseSupport.parseText(stok, String.valueOf(operationType) + " code", null, false, chosenLanguage);
            codeProperties.put("code.text", text);
            String name = null;
            if (ParseSupport.parseOptionalWord(stok, String.valueOf(operationType) + " keyword 'name'", "name")) {
                name = AnimalParseSupport.parseText(stok, String.valueOf(operationType) + " name");
            }
            ParseSupport.parseMandatoryWord(stok, String.valueOf(operationType) + " keyword 'to'", "to");
            String baseCodeGroup = AnimalParseSupport.parseText(stok, String.valueOf(operationType) + "base code group");
            if (CodeSupport.getObjectProperties().getProperty(String.valueOf(baseCodeGroup) + ".x0") == null) {
                ParseSupport.formatException("code group '" + baseCodeGroup + " not existent!", stok);
            }
            codeProperties.put("code.baseGroup", baseCodeGroup);
            int lineNr = CodeSupport.getObjectProperties().getIntProperty(String.valueOf(baseCodeGroup) + ".lineNo");
            if (name == null && fullLine) {
                name = String.valueOf(baseCodeGroup) + "[" + lineNr + "][0]";
            }
            int rowNr = 0;
            if (!fullLine && ParseSupport.parseOptionalWord(stok, String.valueOf(operationType) + " keyword 'row'", "row")) {
                rowNr = ParseSupport.parseInt(stok, String.valueOf(operationType) + " row position", 0);
                if (rowNr != 0) {
                    --lineNr;
                }
                if (name == null || rowNr != 0) {
                    name = String.valueOf(baseCodeGroup) + "[" + lineNr + "][" + rowNr + "]";
                }
            }
            codeProperties.put("code.lineNr", lineNr);
            codeProperties.put("code.rowNr", rowNr);
            codeProperties.put("code.name", name);
            if (ParseSupport.parseOptionalWord(stok, String.valueOf(operationType) + " keyword 'indentation'", "indentation")) {
                codeProperties.put("code.indentation", ParseSupport.parseInt(stok, String.valueOf(operationType) + " indentation", 0));
            }
            int displayDelay = CodeSupport.getObjectProperties().getIntProperty(String.valueOf(baseCodeGroup) + ".delay", 0);
            String unit = null;
            if (ParseSupport.parseOptionalWord(stok, String.valueOf(operationType) + "keyword 'after'", "after")) {
                displayDelay += ParseSupport.parseInt(stok, String.valueOf(operationType) + "delay", 0);
                unit = ParseSupport.parseWord(stok, String.valueOf(operationType) + "delay unit");
                if (unit == null) {
                    unit = "ticks";
                }
                codeProperties.put("code.delayUnit", unit);
            }
            codeProperties.put("code.delay", displayDelay);
            this.codeProducer.insertCode(codeProperties, CodeSupport.getObjectProperties());
            return codeProperties;
        }
        return null;
    }

    public void parseColorChange() throws IOException {
        String colorType = ParseSupport.parseWord(stok, "color change operation");
        boolean contextMode = false;
        ColorChanger colChanger = null;
        Color c = null;
        ParseSupport.parseMandatoryWord(stok, String.valueOf(colorType) + " keyword 'on'", "on");
        String targetCodeGroup = AnimalParseSupport.parseText(stok, String.valueOf(colorType) + " code group");
        ParseSupport.parseMandatoryWord(stok, String.valueOf(colorType) + " keyword 'line'", "line");
        int targetLine = ParseSupport.parseInt(stok, String.valueOf(colorType) + " line number", 0, CodeSupport.getObjectProperties().getIntProperty(String.valueOf(targetCodeGroup) + ".lineNo"));
        int targetRow = 0;
        if (ParseSupport.parseOptionalWord(stok, String.valueOf(colorType) + " keyword 'row'", "row")) {
            targetRow = ParseSupport.parseInt(stok, String.valueOf(colorType) + " row number", 0);
            if (CodeSupport.getObjectIDs().getProperty(String.valueOf(targetCodeGroup) + "[" + targetLine + "][" + targetRow + "]") == null) {
                MessageDisplay.errorMsg("Cannot highlight nonexisting code row " + targetRow + " in input line " + stok.lineno(), 4);
                targetRow = -1;
            }
        }
        boolean bl = contextMode = ParseSupport.parseOptionalWord(stok, String.valueOf(colorType) + " keyword 'region'", "region") || ParseSupport.parseOptionalWord(stok, String.valueOf(colorType) + " keyword 'region'", "context");
        c = colorType.equalsIgnoreCase("unhighlightCode") ? CodeSupport.getObjectProperties().getColorProperty(String.valueOf(targetCodeGroup) + ".color", Color.black) : (contextMode ? CodeSupport.getObjectProperties().getColorProperty(String.valueOf(targetCodeGroup) + ".contextColor", Color.blue) : CodeSupport.getObjectProperties().getColorProperty(String.valueOf(targetCodeGroup) + ".highlightColor", Color.red));
        int[] targetOIDs = new int[]{CodeSupport.getObjectIDs().getIntProperty(String.valueOf(targetCodeGroup) + "[" + targetLine + "][" + targetRow + "]")};
        colChanger = new ColorChanger(currentStep, targetOIDs, 0, "color", c);
        AnimalParseSupport.parseTiming(stok, colChanger, "Color");
        BasicParser.addAnimatorToAnimation(colChanger, anim);
    }

    public void parseCodeDisplay() throws IOException {
        String localType = ParseSupport.parseWord(stok, "show/hide type");
        boolean isShow = localType.equalsIgnoreCase("showcode");
        String codeBaseGroup = AnimalParseSupport.parseText(stok, "hideCode base group name");
        int[] ids = CodeSupport.getObjectIDs().getIntArrayProperty(codeBaseGroup);
        if (ParseSupport.parseOptionalWord(stok, String.valueOf(localType) + " 'after' keyword", "after")) {
            stok.pushBack();
            TimedShow ts = new TimedShow(currentStep, ids, 0, isShow ? "show" : "hide", isShow);
            AnimalParseSupport.parseTiming(stok, ts, "Timed Show");
            BasicParser.addAnimatorToAnimation(ts, anim);
        } else {
            BasicParser.addAnimatorToAnimation(new TimedShow(currentStep, ids, 0, isShow ? "show" : "hide", isShow), anim);
        }
    }
}

