/*
 * Decompiled with CFR 0.152.
 */
package animalscript.extensions;

import animal.animator.TimedShow;
import animal.graphics.PTText;
import animal.main.Animal;
import animal.misc.XProperties;
import animalscript.core.BasicParser;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Point;

public class CodeProducer
extends BasicParser {
    public void insertCode(XProperties codeProperties, XProperties objectProperties) {
        String baseCodeGroup = codeProperties.getProperty("code.baseGroup");
        String codeLineValue = codeProperties.getProperty("code.text", "<<error>>");
        Font font = CodeProducer.getObjectProperties().getFontProperty(String.valueOf(baseCodeGroup) + ".font");
        int x = CodeProducer.getObjectProperties().getIntProperty(String.valueOf(baseCodeGroup) + ".x0");
        int y = CodeProducer.getObjectProperties().getIntProperty(String.valueOf(baseCodeGroup) + ".y0");
        int indentation = codeProperties.getIntProperty("code.indentation", 0);
        int lineNr = codeProperties.getIntProperty("code.lineNr", 0);
        int rowNr = codeProperties.getIntProperty("code.rowNr", 0);
        int fontSizeUsed = font.getSize();
        x += fontSizeUsed * indentation;
        if (rowNr == 0) {
            y += fontSizeUsed + lineNr * (4 + fontSizeUsed);
        } else {
            y += fontSizeUsed + lineNr * (4 + fontSizeUsed);
            int predID = CodeProducer.getObjectIDs().getIntProperty(String.valueOf(baseCodeGroup) + "[" + lineNr + "][" + (rowNr - 1) + "]");
            PTText predTextObject = (PTText)animState.getCloneByNum(predID);
            String predText = predTextObject.getText();
            FontMetrics fm = Animal.getConcreteFontMetrics(font);
            x = predTextObject.getLocation().x + 10 + fm.stringWidth(predText);
        }
        PTText codeLine = new PTText(codeLineValue, font);
        String name = codeProperties.getProperty("code.name");
        codeLine.setObjectName(name);
        codeLine.setLocation(new Point(x, y));
        codeLine.setDepth(CodeProducer.getObjectProperties().getIntProperty(String.valueOf(baseCodeGroup) + ".depth"));
        codeLine.setColor(CodeProducer.getObjectProperties().getColorProperty(String.valueOf(baseCodeGroup) + ".color", Color.black));
        CodeProducer.getObjectProperties().put(String.valueOf(baseCodeGroup) + ".lineNo", lineNr + 1);
        BasicParser.addGraphicObject(codeLine, anim);
        int objectIDNr = codeLine.getNum(false);
        CodeProducer.getObjectIDs().put(name, objectIDNr);
        String currentProperty = CodeProducer.getObjectIDs().getProperty(baseCodeGroup, null);
        if (currentProperty == null || currentProperty == "") {
            CodeProducer.getObjectIDs().put(baseCodeGroup, objectIDNr);
        } else {
            CodeProducer.getObjectIDs().put(baseCodeGroup, String.valueOf(CodeProducer.getObjectIDs().getProperty(baseCodeGroup)) + " " + objectIDNr);
        }
        if (CodeProducer.getObjectIDs().getProperty(name) == null) {
            CodeProducer.getObjectIDs().put(name, objectIDNr);
        }
        CodeProducer.getObjectTypes().put(name, CodeProducer.getTypeIdentifier("code"));
        int[] ids = new int[]{objectIDNr};
        TimedShow ts = new TimedShow(currentStep, ids, 0, "show", true);
        int displayDelay = codeProperties.getIntProperty("code.delay", 0);
        if (displayDelay != 0) {
            ts.setOffset(displayDelay);
            ts.setUnitIsTicks(CodeProducer.getObjectProperties().getProperty(String.valueOf(baseCodeGroup) + ".delayUnit", "ticks").equalsIgnoreCase("ticks"));
        }
        BasicParser.addAnimatorToAnimation(ts, anim);
        currentlyVisible.put(String.valueOf(objectIDNr), "true");
    }
}

