/*
 * Decompiled with CFR 0.152.
 */
package animalscript.core;

import animal.animator.Animator;
import animal.graphics.PTGraphicObject;
import animal.main.Animal;
import animal.main.AnimalConfiguration;
import animal.main.AnimalFrame;
import animal.main.Animation;
import animal.main.AnimationListEntry;
import animal.main.AnimationState;
import animal.main.Link;
import animal.misc.MessageDisplay;
import animal.misc.ParseSupport;
import animal.misc.XProperties;
import animalscript.core.AnimalScriptInterface;
import animalscript.core.QuickAnimationStep;
import java.awt.Point;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Vector;
import translator.ResourceLocator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BasicParser
implements AnimalScriptInterface {
    public static final int ERROR = Integer.MAX_VALUE;
    public static final Point origin = new Point(0, 0);
    public static Animal animal = Animal.get();
    public static int currentStep = 0;
    public static int currentNodeMode = 0;
    protected static boolean employsQuestions = false;
    protected Hashtable<String, Object> handledKeywords = new Hashtable();
    private static HashMap<String, String> keyMap;
    protected XProperties rulesHash = new XProperties();
    public static StreamTokenizer stok;
    private static Vector<StreamTokenizer> tokenizers;
    protected static XProperties locations;
    private static XProperties objectIDs;
    protected static XProperties objectProperties;
    private static XProperties objectTypes;
    public static boolean sameStep;
    public static AnimationState animState;
    public static Animation anim;
    public static String chosenLanguage;
    public static Link currentLink;
    public static Hashtable<String, String> registeredTypes;
    public static Hashtable<String, AnimalScriptInterface> currentHandlers;
    public static Hashtable<String, String> currentlyVisible;
    public static Hashtable<String, String> registeredKeywords;
    public static Hashtable<String, String> registeredRules;
    public static XProperties compass;
    public static boolean debugMode;
    public static int errorCounter;
    public static int type;
    public static int lastType;
    protected static Reader underlyingReader;

    static {
        stok = null;
        tokenizers = null;
        locations = null;
        objectIDs = null;
        objectProperties = null;
        objectTypes = null;
        sameStep = false;
        anim = null;
        chosenLanguage = null;
        currentLink = null;
        registeredTypes = new Hashtable(503);
        currentHandlers = new Hashtable(503);
        currentlyVisible = new Hashtable(503);
        registeredKeywords = new Hashtable(503);
        registeredRules = new Hashtable(503);
        compass = new XProperties();
        compass.put("nw", 0);
        compass.put("northwest", 0);
        compass.put("n", 1);
        compass.put("north", 1);
        compass.put("ne", 2);
        compass.put("northeast", 2);
        compass.put("w", 3);
        compass.put("west", 3);
        compass.put("c", 4);
        compass.put("center", 4);
        compass.put("middle", 4);
        compass.put("e", 5);
        compass.put("east", 5);
        compass.put("sw", 6);
        compass.put("southwest", 6);
        compass.put("s", 7);
        compass.put("south", 7);
        compass.put("se", 8);
        compass.put("southeast", 8);
        BasicParser.parseRuleFile("elementDefinitions");
        if (tokenizers == null) {
            tokenizers = new Vector(20);
        }
        debugMode = false;
        errorCounter = 0;
        type = -4;
        lastType = -4;
    }

    public BasicParser() {
    }

    public BasicParser(StreamTokenizer aStok, int stepNumber, XProperties props) {
        stok = aStok;
        currentStep = stepNumber;
        objectIDs = props;
    }

    public String getChosenLanguage() {
        return chosenLanguage;
    }

    public static void printDebug(String s) {
        if (debugMode) {
            System.err.println(s);
        }
    }

    public static void printExceptionMessage(String errorType, String mode, String keyword, boolean showLineNr) {
        StringBuilder sb = new StringBuilder(250);
        sb.append("# !!!").append(errorType).append("!!! ").append(mode);
        sb.append(" '").append(keyword).append("'");
        if (showLineNr) {
            sb.append(" in line ").append(stok.lineno());
        }
        sb.append(" ").append(stok.toString());
        MessageDisplay.errorMsg(sb.toString(), 4);
        sb = null;
        ++errorCounter;
    }

    public static AnimalScriptInterface getHandlerForName(String handlerName) {
        if (handlerName == null) {
            return null;
        }
        AnimalScriptInterface o = currentHandlers.get(handlerName);
        if (o != null && o instanceof AnimalScriptInterface) {
            return o;
        }
        AnimalScriptInterface handler = null;
        try {
            Class<?> targetClass = Class.forName(handlerName);
            handler = (AnimalScriptInterface)targetClass.newInstance();
            currentHandlers.put(handlerName, handler);
            targetClass = null;
            handlerName = null;
            o = null;
        }
        catch (ClassNotFoundException classNotFound) {
            MessageDisplay.errorMsg("Class '" + handlerName + "' not found!!!", 4);
            handlerName = null;
            MessageDisplay.errorMsg(classNotFound.getMessage(), 4);
        }
        catch (IllegalAccessException illegalAccess) {
            MessageDisplay.errorMsg("Class '" + handlerName + "' has illegal access!!!", 4);
            handlerName = null;
            MessageDisplay.errorMsg(illegalAccess.getMessage(), 4);
        }
        catch (InstantiationException instantiationException) {
            MessageDisplay.errorMsg("Class '" + handlerName + "' has instantiation exception access!!!", 4);
            handlerName = null;
            MessageDisplay.errorMsg(instantiationException.getMessage(), 4);
        }
        return handler;
    }

    public AnimalScriptInterface getHandlerForCommand(String currentCommand) {
        String handlerName = registeredKeywords.get(currentCommand);
        return BasicParser.getHandlerForName(handlerName);
    }

    public static void dumpState(boolean showAnimators, boolean showObjects) {
        if (showAnimators) {
            AnimationListEntry[] info = anim.getAnimatorList();
            int j = 0;
            while (j < info.length) {
                if (info[j].mode == 1) {
                    System.out.println(info[j].animator.toString());
                } else if (info[j].mode == 2) {
                    System.out.println(info[j].link.toString());
                }
                ++j;
            }
            if (showObjects) {
                System.out.println("*****************");
            }
            info = null;
        }
        if (showObjects) {
            int i = 0;
            while (i < anim.getGraphicObjects().size()) {
                System.out.println(anim.getGraphicObjects().elementAt(i) + " NUM: " + anim.getGraphicObjects().elementAt(i).getNum(false));
                ++i;
            }
        }
    }

    public static void addGraphicObject(PTGraphicObject ptgo, Animation animation) {
        animation.insertGraphicObject(ptgo);
        if (animState instanceof QuickAnimationStep) {
            ((QuickAnimationStep)animState).addGraphicObject(ptgo);
        }
    }

    public static void addAnimatorToAnimation(Animator animator, Animation animation) {
        animation.insertAnimator(animator);
    }

    public static void newLink() {
        Link l = new Link(++currentStep, currentStep + 1);
        anim.insertLink(l);
        currentLink = l;
        l = null;
    }

    public static void printReport(XProperties props) {
        Point p;
        System.out.println("Object IDs:");
        props.list(System.out);
        System.out.println("-- end of object IDs  --\nObject Types:");
        System.out.println("-- end of object Types  --\nObject Properties:");
        if (objectProperties.get("Polyline.lastNode") instanceof Point && (p = (Point)objectProperties.get("Polyline.lastNode")) != null) {
            objectProperties.put("Polyline.lastNode", "(" + p.x + ", " + p.y + ")");
        }
        objectProperties.list(System.out);
        System.out.println("-- end of object Types  --\nDefined Locations:");
        Enumeration<Object> e = locations.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            Point p2 = locations.getPointProperty(key);
            System.out.println(String.valueOf(key) + " -> (" + p2.x + ", " + p2.y + ")");
        }
        System.out.println("-- end of locations  --");
    }

    public static String getTypeIdentifier(String elementType) {
        String s = elementType.toLowerCase();
        if (registeredTypes.contains(s)) {
            return registeredTypes.get(s);
        }
        registeredTypes.put(s, s);
        MessageDisplay.message("Inserted type " + s + " which was not registered in file 'types.dat'");
        return s;
    }

    public void clearTables() {
        anim = null;
        animState = null;
        if (locations != null) {
            locations.clear();
        }
        if (objectIDs != null) {
            objectIDs.clear();
        }
        if (objectProperties != null) {
            objectProperties.clear();
        }
        if (objectTypes != null) {
            objectTypes.clear();
        }
        if (currentlyVisible != null) {
            currentlyVisible.clear();
        }
    }

    public void setStep(int targetStepNr, boolean isSameStep) {
    }

    @Override
    public XProperties process(StreamTokenizer aStok, String currentCommand) throws IOException {
        XProperties props = null;
        if (this.generateNewStep(currentCommand)) {
            BasicParser.newLink();
        }
        if (animState == null) {
            animState = new QuickAnimationStep(anim);
        }
        animState.setStep(sameStep ? currentStep - 1 : currentStep, false);
        aStok.pushBack();
        Object localizedHandlerAccess = this.handledKeywords.get(currentCommand.toLowerCase());
        Method targetMethod = null;
        if (localizedHandlerAccess instanceof String) {
            String usedCommand = (String)localizedHandlerAccess;
            try {
                targetMethod = this.getClass().getDeclaredMethod(usedCommand, null);
                if (targetMethod != null) {
                    this.handledKeywords.put(currentCommand.toLowerCase(), targetMethod);
                }
            }
            catch (NoSuchMethodException noSuchMethod) {
                BasicParser.printExceptionMessage("NoSuchMethodException", "for handling", currentCommand, true);
            }
            catch (SecurityException security) {
                BasicParser.printExceptionMessage("Security exception", "when handling", currentCommand, true);
            }
        } else if (localizedHandlerAccess instanceof Method) {
            targetMethod = (Method)localizedHandlerAccess;
        }
        if (targetMethod != null) {
            try {
                props = (XProperties)targetMethod.invoke((Object)this, null);
            }
            catch (IllegalAccessException illegalAccess) {
                BasicParser.printExceptionMessage("Illegal access", "when handling", currentCommand, true);
            }
            catch (IllegalArgumentException illegalAccess) {
                BasicParser.printExceptionMessage("Illegal argument", "when handling", currentCommand, true);
            }
            catch (InvocationTargetException invocTarget) {
                System.err.println("******" + invocTarget.getTargetException().getMessage() + " .... " + invocTarget.getMessage() + invocTarget.toString() + ", cause: " + invocTarget.getCause() + " [line=" + aStok.lineno() + "] when handling " + currentCommand);
                BasicParser.printExceptionMessage(String.valueOf(invocTarget.getTargetException().getMessage()) + " .... " + invocTarget.getMessage(), "[line=" + aStok.lineno() + "] when handling", currentCommand, true);
                invocTarget.printStackTrace();
            }
            catch (SecurityException security) {
                BasicParser.printExceptionMessage("Security exception", "when handling", currentCommand, true);
            }
        }
        ParseSupport.consumeIncludingEOL(aStok, String.valueOf(currentCommand) + " EOL");
        if (props == null) {
            props = new XProperties();
        }
        return props;
    }

    @Override
    public boolean generateNewStep(String command) {
        return !sameStep;
    }

    @Override
    public Enumeration<String> getHandledKeywords() {
        return this.handledKeywords.keys();
    }

    public Hashtable<String, Object> getHandledKeywordsProps() {
        return this.handledKeywords;
    }

    @Override
    public Enumeration<Object> getHandledRules() {
        return this.rulesHash.keys();
    }

    @Override
    public String[] getRequiredExtensions() {
        return null;
    }

    @Override
    public String getRuleFor(String key) {
        String localKey = key.toLowerCase();
        StringBuilder sb = new StringBuilder(2000);
        if (keyMap.containsKey(localKey)) {
            sb.append(keyMap.get(localKey));
        }
        if (this.rulesHash.getProperty(localKey) != null) {
            sb.append(this.rulesHash.getProperty(localKey));
        }
        return sb.toString();
    }

    public static void parseRuleFile(String filename) {
        if (keyMap == null) {
            keyMap = new HashMap(511);
        }
        keyMap.clear();
        int lineNr = -1;
        try {
            InputStream inStream = ResourceLocator.getResourceLocator().getResourceStream(filename, AnimalFrame.runsInApplet, AnimalFrame.baseURL);
            if (inStream == null) {
                throw new IOException(String.valueOf(filename) + " not locatable!");
            }
            BufferedReader inputReader = new BufferedReader(new InputStreamReader(inStream));
            StringBuilder contentBuffer = null;
            boolean currentLineIsEmpty = true;
            String currentLine = null;
            String currentKey = null;
            while ((currentLine = inputReader.readLine()) != null) {
                currentLine.trim();
                if (currentLineIsEmpty && currentLine.startsWith("<") && currentLine.endsWith(">:")) {
                    currentKey = currentLine.substring(1, currentLine.length() - 2).toLowerCase();
                    contentBuffer = new StringBuilder(2048);
                    continue;
                }
                if (currentLine.length() == 0) {
                    currentLineIsEmpty = true;
                    keyMap.put(currentKey, contentBuffer.toString());
                    continue;
                }
                contentBuffer.append(currentLine).append("\n");
            }
        }
        catch (IOException e) {
            if (lineNr > 0) {
                MessageDisplay.errorMsg("Sorry, exception in line " + lineNr + " when reading elementDefinitions", 4);
            }
            MessageDisplay.errorMsg(e.getMessage(), 4);
        }
    }

    public void generateStreamTokenizer(String input, boolean fileMode) {
        StreamTokenizer localTokenizer = null;
        if (fileMode && input != null) {
            InputStream inStream = ResourceLocator.getResourceLocator().getResourceStream(input, null, AnimalConfiguration.getDefaultConfiguration().getCurrentDirectory());
            if (inStream != null) {
                underlyingReader = new BufferedReader(new InputStreamReader(inStream));
            }
        } else {
            underlyingReader = new StringReader(input);
        }
        localTokenizer = new StreamTokenizer(underlyingReader);
        localTokenizer.commentChar(35);
        localTokenizer.eolIsSignificant(true);
        localTokenizer.quoteChar(34);
        if (stok != null) {
            tokenizers.addElement(stok);
        }
        stok = localTokenizer;
    }

    public void popTokenizer() {
        if (tokenizers != null && tokenizers.size() > 0 && tokenizers.lastElement() != null) {
            stok = tokenizers.remove(tokenizers.size() - 1);
        }
    }

    public boolean canContinueParsing() {
        return BasicParser.stok.ttype != -1 || tokenizers != null && tokenizers.size() > 0;
    }

    public static Hashtable<String, String> getCurrentlyVisible() {
        return currentlyVisible;
    }

    public static XProperties getLocations() {
        return locations;
    }

    public static XProperties getObjectIDs() {
        return objectIDs;
    }

    public static XProperties getObjectProperties() {
        return objectProperties;
    }

    public static XProperties getObjectTypes() {
        return objectTypes;
    }

    protected void initializeTables() {
        objectIDs = new XProperties();
        locations = new XProperties();
        objectProperties = new XProperties();
        BasicParser.getObjectProperties().put("Polyline.lastNode", origin);
        objectTypes = new XProperties();
    }
}

