/*
 * Decompiled with CFR 0.152.
 */
package animalscript.core;

import animal.animator.TimedAnimator;
import animal.animator.TimedShow;
import animal.graphics.PTGraphicObject;
import animal.graphics.PTPoint;
import animal.graphics.PTPolyline;
import animal.main.Animation;
import animal.main.AnimationState;
import animal.misc.ColorChoice;
import animal.misc.MessageDisplay;
import animal.misc.ParseSupport;
import animal.misc.XProperties;
import animalscript.core.BasicParser;
import java.awt.Color;
import java.awt.Font;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.StreamTokenizer;
import java.util.Hashtable;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnimalParseSupport {
    public static int currentNodeMode = 0;
    private static int token = 0;

    public static double parseDouble(StreamTokenizer stok, String description, double minValue, double maxValue) throws IOException {
        token = stok.nextToken();
        double valueRead = 0.0;
        if (token == -2) {
            valueRead = stok.nval;
        } else if (token == 34) {
            String referenceName = stok.sval;
            int oid = AnimalParseSupport.getObjectIDs().getIntProperty(referenceName);
            token = stok.nextToken();
            if (token != -3) {
                ParseSupport.formatException("[x|y|width|height] " + description + " expected", stok);
            }
            if (oid != -1) {
                PTGraphicObject ptgo = AnimalParseSupport.getAnimationState().getCloneByNum(oid);
                Rectangle rect = null;
                if (ptgo != null) {
                    rect = ptgo.getBoundingBox();
                    if (stok.sval.equalsIgnoreCase("x")) {
                        valueRead = rect.x;
                    } else if (stok.sval.equalsIgnoreCase("y")) {
                        valueRead = rect.y;
                    } else if (stok.sval.equalsIgnoreCase("width")) {
                        valueRead = rect.width;
                    } else if (stok.sval.equalsIgnoreCase("height")) {
                        valueRead = rect.height;
                    }
                }
            }
        } else if (token == 40) {
            valueRead = AnimalParseSupport.parseDouble(stok, String.valueOf(description) + " expression L", Double.MIN_VALUE, Double.MAX_VALUE);
            int localToken = stok.nextToken();
            double secondValue = AnimalParseSupport.parseDouble(stok, String.valueOf(description) + " expression R", Double.MIN_VALUE, Double.MAX_VALUE);
            if (localToken == 43) {
                valueRead += secondValue;
            } else if (localToken == 45) {
                valueRead -= secondValue;
            }
            if (localToken == 42) {
                valueRead *= secondValue;
            }
            if (localToken == 58 && secondValue != 0.0) {
                valueRead /= secondValue;
            }
            ParseSupport.parseMandatoryChar(stok, "')' for " + description + " expression", ')');
        }
        if (valueRead < minValue || valueRead > maxValue) {
            ParseSupport.formatException("double value for " + description + " expected", stok);
        }
        return valueRead;
    }

    public static PTPolyline parsePolyline(StreamTokenizer stok, String description) throws IOException {
        PTPolyline poly = new PTPolyline();
        ParseSupport.parseMandatoryChar(stok, String.valueOf(description) + " '{'", '{');
        while (!ParseSupport.parseChar(stok, String.valueOf(description) + "'}'", '}')) {
            stok.pushBack();
            Point p = ParseSupport.parseNode(stok, String.valueOf(description) + " node");
            poly.addNode(new PTPoint(p.x, p.y));
        }
        return poly;
    }

    public static Color parseAndSetColor(StreamTokenizer stok, String objectType, String propertyName) throws IOException {
        return AnimalParseSupport.parseAndSetColor(stok, objectType, propertyName, "black");
    }

    public static Color parseAndSetColor(StreamTokenizer stok, String objectType, String propertyName, String defaultColor) throws IOException {
        if (ParseSupport.parseOptionalWord(stok, String.valueOf(propertyName) + " tag for " + objectType, propertyName)) {
            int aToken = stok.nextToken();
            stok.pushBack();
            String colorName = defaultColor;
            if (aToken == -3) {
                colorName = ParseSupport.parseWord(stok, String.valueOf(objectType) + ' ' + propertyName);
                if (colorName.equalsIgnoreCase("light")) {
                    colorName = String.valueOf(colorName) + " " + ParseSupport.parseWord(stok, String.valueOf(objectType) + ' ' + propertyName);
                }
                if (colorName == null || !ColorChoice.validColorName(colorName)) {
                    colorName = defaultColor;
                }
            } else {
                Color targetColor = ParseSupport.parseColorRaw(stok, propertyName);
                if (targetColor != null) {
                    colorName = ColorChoice.getColorName(targetColor);
                }
            }
            AnimalParseSupport.getObjectProperties().put(String.valueOf(objectType) + '.' + propertyName, colorName);
            return ColorChoice.getColor(colorName);
        }
        return AnimalParseSupport.getObjectProperties().getColorProperty(String.valueOf(objectType) + '.' + propertyName, ColorChoice.getColor(defaultColor));
    }

    public static Color parseColor(StreamTokenizer stok, String descriptor) throws IOException {
        int aToken = stok.nextToken();
        stok.pushBack();
        String colorName = "black";
        if (aToken == -3) {
            colorName = ParseSupport.parseWord(stok, descriptor);
            if (colorName.equalsIgnoreCase("light")) {
                colorName = String.valueOf(colorName) + " " + ParseSupport.parseWord(stok, descriptor);
            }
            if (colorName == null || !ColorChoice.validColorName(colorName)) {
                colorName = "black";
            }
        } else {
            Color targetColor = ParseSupport.parseColorRaw(stok, descriptor);
            if (targetColor != null) {
                colorName = ColorChoice.getColorName(targetColor);
            }
        }
        if (colorName.equalsIgnoreCase("light") || colorName.equalsIgnoreCase("dark")) {
            colorName = String.valueOf(colorName) + ' ' + ParseSupport.parseWord(stok, String.valueOf(descriptor) + " grey color");
        }
        if (!ColorChoice.validColorName(colorName)) {
            MessageDisplay.errorMsg("Color '" + colorName + "' unknown, substituting black.", 4);
            colorName = "black";
        }
        return ColorChoice.getColor(colorName);
    }

    public static void parseAndSetDepth(StreamTokenizer stok, PTGraphicObject ptgo, String objectType) throws IOException {
        if (ParseSupport.parseOptionalWord(stok, "'depth' tag for " + objectType, "depth")) {
            if (stok.nextToken() == -2) {
                ptgo.setDepth((int)stok.nval);
            }
        } else {
            ptgo.setDepth(Integer.MAX_VALUE);
        }
    }

    public static Font parseFontInfo(StreamTokenizer stok, String baseTag) throws IOException {
        String fontName = "SansSerif";
        int fontSize = 16;
        boolean isBold = false;
        boolean isItalic = false;
        if (ParseSupport.parseOptionalWord(stok, "'font' tag for " + baseTag, "font")) {
            fontName = ParseSupport.parseWord(stok, String.valueOf(baseTag) + " font");
            if (!(fontName.equalsIgnoreCase("Serif") || fontName.equalsIgnoreCase("SansSerif") || fontName.equalsIgnoreCase("Monospaced"))) {
                MessageDisplay.message("Font name '" + fontName + "' is not a Java system font, " + "use 'Serif', 'SansSerif' or 'Monospaced'");
                fontName = "SansSerif";
            }
        } else {
            fontName = AnimalParseSupport.getObjectProperties().getProperty(String.valueOf(baseTag) + ".fontName", "SansSerif");
        }
        fontSize = ParseSupport.parseOptionalWord(stok, "'size' tag for " + baseTag + " font size", "size") ? ParseSupport.parseInt(stok, String.valueOf(baseTag) + " font size") : AnimalParseSupport.getObjectProperties().getIntProperty(String.valueOf(baseTag) + ".fontSize", 16);
        isBold = ParseSupport.parseOptionalWord(stok, "optional 'bold' tag for " + baseTag, "bold");
        isItalic = ParseSupport.parseOptionalWord(stok, "optional 'italic' tag for " + baseTag, "italic");
        if (ParseSupport.parseOptionalWord(stok, "optional 'plain' tag for " + baseTag, "plain")) {
            isBold = false;
            isItalic = false;
        }
        Font f = new Font(fontName, 0 + (isBold ? 1 : 0) + (isItalic ? 2 : 0), fontSize);
        AnimalParseSupport.getObjectProperties().put(String.valueOf(baseTag) + ".font", f);
        fontName = null;
        return f;
    }

    public static String parseOIDsTillEOL(StreamTokenizer stok, String label) throws IOException {
        int aToken = stok.ttype;
        StringBuilder ids = new StringBuilder(128);
        while ((aToken = stok.nextToken()) != 10 && aToken != -1) {
            if (aToken == -2) {
                ids.append((int)stok.nval);
            } else if (aToken == -3) {
                ids.append(stok.sval);
            } else {
                ParseSupport.formatException("String or int value for " + label + " expected", stok);
            }
            ids.append(' ');
        }
        stok.pushBack();
        return ids.toString();
    }

    public static void parseTiming(StreamTokenizer stok, TimedAnimator ta, String animatorTag) throws IOException {
        int duration = 0;
        int delay = 0;
        String unit = "ticks";
        if (ParseSupport.parseOptionalWord(stok, String.valueOf(animatorTag) + " 'after' keyword", "after")) {
            delay = ParseSupport.parseInt(stok, String.valueOf(animatorTag) + " delay", 0);
            unit = ParseSupport.parseWord(stok, String.valueOf(animatorTag) + " unit");
        }
        if (ParseSupport.parseOptionalWord(stok, String.valueOf(animatorTag) + " 'within' keyword", "within")) {
            duration = ParseSupport.parseInt(stok, String.valueOf(animatorTag) + " duration", 0);
            if (delay == 0) {
                unit = ParseSupport.parseWord(stok, String.valueOf(animatorTag) + " unit");
            } else if (ParseSupport.parseOptionalWord(stok, String.valueOf(animatorTag) + " unit", "ms")) {
                unit = "ms";
            } else if (ParseSupport.parseOptionalWord(stok, String.valueOf(animatorTag) + " unit", "ticks")) {
                unit = "ticks";
            }
        }
        ta.setDuration(duration);
        ta.setOffset(delay);
        ta.setUnitIsTicks(!unit.equalsIgnoreCase("ms"));
        unit = null;
    }

    public static Point parseStartPosition(StreamTokenizer stok, String type) throws IOException {
        Point uLB = null;
        if (ParseSupport.parseOptionalWord(stok, String.valueOf(type) + " keyword 'at'", "at")) {
            uLB = ParseSupport.parseNode(stok, String.valueOf(type) + "left boundary");
        } else {
            ParseSupport.parseMandatoryWord(stok, String.valueOf(type) + " keyword 'offset'", "offset");
            Point offset = ParseSupport.parseNode(stok, String.valueOf(type) + " offset");
            ParseSupport.parseMandatoryWord(stok, String.valueOf(type) + " keyword 'from'", "from");
            String originName = ParseSupport.parseText(stok, "target object name");
            String direction = ParseSupport.parseWord(stok, "offset direction").toLowerCase();
            int oid = AnimalParseSupport.getObjectIDs().getIntProperty(originName);
            if (oid != -1) {
                PTGraphicObject ptgo = AnimalParseSupport.getAnimationState().getCloneByNum(oid);
                Rectangle rect = ptgo.getBoundingBox();
                uLB = direction.equals("center") ? new Point(rect.x + (rect.width >>> 1) + offset.x, rect.y + (rect.height >>> 1) + offset.y) : (direction.equals("top") ? new Point(rect.x + offset.x, rect.y + offset.y) : (direction.equals("bottom") ? new Point(rect.x + offset.x, rect.y + offset.y + rect.height) : (direction.equals("right") ? new Point(rect.x + offset.x + rect.width, rect.y + rect.height + offset.y) : new Point(rect.x + offset.x, rect.y + rect.height + offset.y))));
                rect = null;
                ptgo = null;
            } else {
                uLB = new Point(50, 50);
            }
            direction = null;
            offset = null;
            originName = null;
        }
        return uLB;
    }

    public static Point xParseNodeInfo(StreamTokenizer stok, String info) throws IOException {
        return AnimalParseSupport.parseNodeInfo(stok, info, null);
    }

    public static Point parseNodeInfo(StreamTokenizer stok, String info, String keyword) throws IOException {
        Point p;
        if (keyword != null) {
            ParseSupport.parseOptionalWord(stok, String.valueOf(info) + " keyword '" + keyword + "'", keyword);
        }
        if ((p = AnimalParseSupport.parseOptionalOffset(stok, info)) == null) {
            currentNodeMode = 0;
            int aToken = stok.nextToken();
            stok.pushBack();
            if ((char)aToken == '(') {
                p = ParseSupport.parseNode(stok, info);
            } else if ((char)aToken == '\"') {
                String locationName = ParseSupport.parseText(stok, "target object name");
                if (AnimalParseSupport.getLocations().containsKey(locationName)) {
                    p = AnimalParseSupport.getLocations().getPointProperty(locationName);
                } else {
                    MessageDisplay.message("Invalid node definition in line " + stok.lineno() + ", replaced by point of origin (0, 0)");
                    p = new Point(0, 0);
                }
            } else {
                MessageDisplay.message("Invalid node definition in line " + stok.lineno() + ", replaced by point of origin (0, 0)");
                p = new Point(0, 0);
            }
        }
        AnimalParseSupport.getObjectProperties().put("Polyline.lastNode", p);
        return p;
    }

    private static Point parseMoveOffset(Point offset) {
        Point reference = AnimalParseSupport.getObjectProperties().getPointProperty("Polyline.lastNode");
        Point refNode = new Point(reference.x, reference.y);
        refNode.translate(offset.x, offset.y);
        currentNodeMode = 4;
        return refNode;
    }

    private static Point parseNodeOffset(StreamTokenizer stok, Point offset, String originName) throws IOException {
        int[] oids = AnimalParseSupport.getObjectIDs().getIntArrayProperty(originName);
        PTGraphicObject ptgo = AnimalParseSupport.getAnimationState().getCloneByNum(oids[0]);
        Point reference = null;
        if (ptgo instanceof PTPolyline) {
            PTPolyline line = (PTPolyline)ptgo;
            int nodeNr = ParseSupport.parseInt(stok, "node number [1, " + line.getNodeCount() + "]", 1, line.getNodeCount());
            PTPoint refPoint = line.getNode(nodeNr - 1);
            reference = new Point(refPoint.getX(), refPoint.getY());
            reference.translate(offset.x, offset.y);
        } else {
            ParseSupport.formatException("Invalid reference for 'node' -- need PTPolyline object, got " + ptgo, stok);
            reference = BasicParser.origin;
        }
        currentNodeMode = 2;
        return reference;
    }

    private static Point parseDirOffset(StreamTokenizer stok, Point offset, String originName) throws IOException {
        PTGraphicObject ptgo = null;
        Rectangle bBox = null;
        Point reference = null;
        String direction = ParseSupport.parseWord(stok, "offset direction").toLowerCase();
        int dir = AnimalParseSupport.getCompass().getIntProperty(direction);
        if (dir == -1) {
            MessageDisplay.errorMsg("Invalid offset direction in line " + stok.lineno() + " changed to 'center'", 4);
            dir = 8;
        }
        int[] oids = null;
        if (originName != null && AnimalParseSupport.getObjectIDs().getProperty(originName) != null) {
            oids = AnimalParseSupport.getObjectIDs().getIntArrayProperty(originName);
        }
        if (oids != null) {
            Rectangle rect = null;
            int i = 0;
            while (i < oids.length) {
                ptgo = AnimalParseSupport.getAnimationState().getCloneByNum(oids[i]);
                rect = ptgo == null ? bBox : ptgo.getBoundingBox();
                bBox = bBox == null ? rect : bBox.union(rect);
                rect = null;
                ptgo = null;
                ++i;
            }
            oids = null;
            reference = bBox.getLocation();
            if (dir % 3 == 1) {
                reference.x += bBox.width >>> 1;
            }
            if (dir % 3 == 2) {
                reference.x += bBox.width;
            }
            if (dir / 3 == 1) {
                reference.y += bBox.height >>> 1;
            }
            if (dir / 3 == 2) {
                reference.y += bBox.height;
            }
            offset.translate(reference.x, reference.y);
        } else {
            MessageDisplay.errorMsg("Offset object '" + originName + "' does not exist in line " + stok.lineno(), 4);
            offset = BasicParser.origin;
        }
        currentNodeMode = 1;
        return offset;
    }

    private static Point parseBaselineOffset(StreamTokenizer stok, Point offset, String originName) throws IOException {
        PTGraphicObject ptgo = null;
        Rectangle bBox = null;
        Point reference = null;
        int width = 0;
        boolean incorrectUsage = false;
        int[] oids = AnimalParseSupport.getObjectIDs().getIntArrayProperty(originName);
        if (oids != null) {
            if (oids.length == 1 && AnimalParseSupport.getObjectTypes().getProperty(originName).equals(BasicParser.getTypeIdentifier("text"))) {
                reference = AnimalParseSupport.getObjectProperties().getPointProperty(String.valueOf(originName) + ".baseline");
                ptgo = AnimalParseSupport.getAnimationState().getCloneByNum(oids[0]);
                if (ptgo != null) {
                    width = ptgo.getBoundingBox().width;
                }
            } else {
                incorrectUsage = true;
                Rectangle rect = null;
                int i = 0;
                while (i < oids.length) {
                    ptgo = AnimalParseSupport.getAnimationState().getCloneByNum(oids[i]);
                    rect = ptgo.getBoundingBox();
                    bBox = bBox == null ? rect : bBox.union(rect);
                    ++i;
                }
                reference = bBox.getLocation();
                reference.translate(0, bBox.height);
                width = bBox.width;
                rect = null;
                ptgo = null;
            }
            offset.translate(reference.x, reference.y);
            if (!ParseSupport.parseOptionalWord(stok, "baseline position start|end", "start")) {
                offset.translate(width, 0);
            }
            if (incorrectUsage) {
                MessageDisplay.errorMsg("Use placement relative to a bounding box corner SW (start) or SE (end) if the base object is not a single text primitive! [line " + stok.lineno() + "]", 4);
            }
        } else {
            MessageDisplay.errorMsg("Offset base object '" + originName + "' does not exist in line " + stok.lineno(), 4);
            offset = BasicParser.origin;
        }
        currentNodeMode = 8;
        return offset;
    }

    public static Point parseOptionalOffset(StreamTokenizer stok, String type) throws IOException {
        if (ParseSupport.parseOptionalWord(stok, "relative command 'at location'", "at")) {
            String originName = ParseSupport.parseText(stok, "target object name");
            if (AnimalParseSupport.getLocations().containsKey(originName)) {
                return AnimalParseSupport.getLocations().getPointProperty(originName);
            }
        } else {
            if (ParseSupport.parseOptionalWord(stok, "relative command 'offset' | 'move'", "offset")) {
                Point offset = ParseSupport.parseNode(stok, String.valueOf(type) + " offset");
                ParseSupport.parseMandatoryWord(stok, String.valueOf(type) + " keyword 'from'", "from");
                String originName = ParseSupport.parseText(stok, "target object name");
                if (AnimalParseSupport.getLocations().containsKey(originName)) {
                    Point referenceLocation = AnimalParseSupport.getLocations().getPointProperty(originName);
                    offset.translate(referenceLocation.x, referenceLocation.y);
                    return offset;
                }
                if (ParseSupport.parseOptionalWord(stok, "relative command keyword 'node' | DIR", "node")) {
                    return AnimalParseSupport.parseNodeOffset(stok, offset, originName);
                }
                if (ParseSupport.parseOptionalWord(stok, "relative command keyword 'baseline'", "baseline")) {
                    return AnimalParseSupport.parseBaselineOffset(stok, offset, originName);
                }
                return AnimalParseSupport.parseDirOffset(stok, offset, originName);
            }
            if (ParseSupport.parseOptionalWord(stok, String.valueOf(type) + " keyword 'move'", "move")) {
                Point offset = ParseSupport.parseNode(stok, String.valueOf(type) + " offset");
                Point reference = AnimalParseSupport.parseMoveOffset(offset);
                return reference;
            }
        }
        return null;
    }

    public static void showComponents(StreamTokenizer stok, String idString, String objectType, boolean isShow) throws IOException {
        int[] ids = ParseSupport.parseOIDsFromString(idString);
        if (!ParseSupport.parseOptionalWord(stok, String.valueOf(objectType) + " 'hidden' keyword", "hidden")) {
            if (ParseSupport.parseOptionalWord(stok, String.valueOf(objectType) + " 'after' keyword", "after")) {
                stok.pushBack();
                TimedShow ts = new TimedShow(AnimalParseSupport.getCurrentStep(), ids, 0, isShow ? "show" : "hide", isShow);
                AnimalParseSupport.parseTiming(stok, ts, "Timed Show");
                BasicParser.addAnimatorToAnimation(ts, AnimalParseSupport.getAnimation());
            } else {
                BasicParser.addAnimatorToAnimation(new TimedShow(AnimalParseSupport.getCurrentStep(), ids, 0, isShow ? "show" : "hide", isShow), AnimalParseSupport.getAnimation());
            }
            int i = 0;
            while (i < ids.length) {
                AnimalParseSupport.getCurrentlyVisible().put(String.valueOf(ids[i]), String.valueOf(isShow));
                ++i;
            }
        }
        ids = null;
    }

    public static String parseMethod(StreamTokenizer stok, String operation, String keyword, String defaultValue) throws IOException {
        if (ParseSupport.parseOptionalWord(stok, String.valueOf(operation) + " keyword '" + keyword + "' ", keyword)) {
            return ParseSupport.parseText(stok, String.valueOf(operation) + " subtype for " + keyword);
        }
        return defaultValue;
    }

    public static String parseText(StreamTokenizer stok, String description) throws IOException {
        return AnimalParseSupport.parseText(stok, description, null, false, null);
    }

    public static String parseText(StreamTokenizer stok, String description, String tag) throws IOException {
        return AnimalParseSupport.parseText(stok, description, tag, true, null);
    }

    public static String parseText(StreamTokenizer stok, String description, String tag, boolean mandatoryTag) throws IOException {
        return AnimalParseSupport.parseText(stok, description, tag, mandatoryTag, null);
    }

    public static String parseText(StreamTokenizer stok, String description, String tag, boolean mandatoryTag, String languageKey) throws IOException {
        if (tag != null) {
            if (mandatoryTag) {
                ParseSupport.parseMandatoryWord(stok, description, tag);
            } else {
                ParseSupport.parseOptionalWord(stok, description, tag);
            }
            ParseSupport.parseOptionalChar(stok, String.valueOf(description) + " colon ':'", ':');
        }
        token = stok.nextToken();
        String value = stok.sval;
        if (token == -3) {
            if (value.equalsIgnoreCase("key")) {
                ParseSupport.parseMandatoryChar(stok, "text entry key colon ':'", ':');
                token = stok.nextToken();
                String keyReadIn = null;
                if (token == 34) {
                    keyReadIn = stok.sval;
                }
                value = ParseSupport.getMessagePattern(keyReadIn);
            } else if (value.equalsIgnoreCase("from")) {
                String filename = AnimalParseSupport.parseText(stok, "text base file name", null, false, null);
                ParseSupport.parseMandatoryWord(stok, "text from file keywod 'line'", "line");
                int lineNumber = ParseSupport.parseInt(stok, "text from file line number", 0);
                int currentLineNr = -1;
                try {
                    FileInputStream fis = new FileInputStream(filename);
                    BufferedReader br = new BufferedReader(new InputStreamReader(fis));
                    while ((value = br.readLine()) != null && currentLineNr < lineNumber) {
                        ++currentLineNr;
                    }
                    if (currentLineNr < lineNumber) {
                        System.err.println("file " + filename + " contained only lines [0, " + currentLineNr + "]!");
                    }
                }
                catch (IOException e) {
                    System.err.println("****" + e.getMessage());
                }
            }
        } else if (token == 40) {
            String langKey = null;
            String langText = null;
            while ((token = stok.nextToken()) != 41) {
                stok.pushBack();
                langKey = ParseSupport.parseWord(stok, "language key");
                ParseSupport.parseMandatoryChar(stok, String.valueOf(description) + " colon ':'", ':');
                langText = AnimalParseSupport.parseText(stok, "language entry", null, false, null);
                if (!langKey.equalsIgnoreCase(languageKey)) continue;
                value = langText;
            }
        } else if (token == 36) {
            token = stok.nextToken();
            String variableName = null;
            if (token == -3 || token == 34) {
                variableName = stok.sval;
            }
            String varType = AnimalParseSupport.getObjectProperties().getProperty(String.valueOf(variableName) + ".subType", "String");
            value = AnimalParseSupport.getObjectProperties().getProperty(String.valueOf(variableName) + ".value", "$" + variableName);
            boolean treatAsInt = ParseSupport.parseOptionalWord(stok, String.valueOf(variableName) + " optional keyword 'asInt'", "asInt");
            if (!treatAsInt) {
                boolean bl = treatAsInt = varType.equalsIgnoreCase("int") && value.indexOf(46) != -1;
            }
            if (treatAsInt) {
                value = value.substring(0, value.indexOf(46));
            }
        } else if (token != 34 && languageKey == null) {
            ParseSupport.formatException("*** expected '\"' here for " + description, stok);
        }
        token = stok.nextToken();
        if (token == 43) {
            value = String.valueOf(value) + AnimalParseSupport.parseText(stok, description, null, false, languageKey);
        } else {
            stok.pushBack();
        }
        return value;
    }

    public static String[] parseTexts(StreamTokenizer stok, String description, String tag, boolean mandatoryTag, String languageKey) throws IOException {
        Vector<String> elements = new Vector<String>(20);
        token = stok.nextToken();
        boolean inInternationalMode = languageKey != null && token == 40;
        stok.pushBack();
        while ((token = stok.nextToken()) == 34 || inInternationalMode && token != 41) {
            stok.pushBack();
            String element = AnimalParseSupport.parseText(stok, description, tag, mandatoryTag, languageKey);
            elements.addElement(element);
        }
        stok.pushBack();
        Object[] results = new String[elements.size()];
        elements.copyInto(results);
        return results;
    }

    private static Animation getAnimation() {
        return BasicParser.anim;
    }

    private static AnimationState getAnimationState() {
        return BasicParser.animState;
    }

    private static XProperties getCompass() {
        return BasicParser.compass;
    }

    public static Hashtable<String, String> getCurrentlyVisible() {
        return BasicParser.getCurrentlyVisible();
    }

    public static int getCurrentStep() {
        return BasicParser.currentStep;
    }

    private static XProperties getLocations() {
        return BasicParser.getLocations();
    }

    private static XProperties getObjectIDs() {
        return BasicParser.getObjectIDs();
    }

    private static XProperties getObjectProperties() {
        if (BasicParser.getObjectProperties() == null) {
            BasicParser.objectProperties = new XProperties();
        }
        return BasicParser.getObjectProperties();
    }

    private static XProperties getObjectTypes() {
        return BasicParser.getObjectTypes();
    }
}

