/*
 * Decompiled with CFR 0.152.
 */
package animal.misc;

import animal.misc.AnimalTranslator;
import animal.misc.DebugLogger;
import animal.misc.XProperties;
import java.awt.Toolkit;
import java.io.PrintStream;
import javax.swing.JTextArea;

public class MessageDisplay {
    public static final int CONFIG_ERROR = 8;
    public static final int DEBUG_MESSAGE = 1;
    public static final int INFO = 2;
    public static final int PROGRAM_ERROR = 16;
    public static final String LINE_FEED = "\n";
    public static final int RUN_ERROR = 4;
    private static boolean DEBUG_MODE = true;
    private static DebugLogger LOGGER = null;
    private static JTextArea OUTPUT_AREA;

    public static void initialize(JTextArea outputDisplayArea, boolean debugMode, XProperties props) {
        OUTPUT_AREA = outputDisplayArea;
        DEBUG_MODE = debugMode;
        MessageDisplay.instantiateLogger(props);
    }

    public static void errorMsg(String msg, int priority) {
        MessageDisplay.errorMsg(msg, priority, true);
    }

    public static void errorMsg(String key, Object[] params) {
        MessageDisplay.errorMsg(AnimalTranslator.translateMessage(key, params), 4);
    }

    public static void errorMsg(String key, Object params, int priority) {
        MessageDisplay.errorMsg(AnimalTranslator.translateMessage(key, new Object[]{params}), priority);
    }

    public static void errorMsg(String key, Object[] params, int priority) {
        MessageDisplay.errorMsg(AnimalTranslator.translateMessage(key, params), priority);
    }

    public static void errorMsg(String msg, int priority, boolean appendNewLine) {
        if (priority > 1 || DEBUG_MODE) {
            if (OUTPUT_AREA != null) {
                if (priority >= 8) {
                    msg = "!!!" + msg + "!!!";
                    Toolkit.getDefaultToolkit().beep();
                }
                OUTPUT_AREA.append(msg);
                if (appendNewLine) {
                    OUTPUT_AREA.append(LINE_FEED);
                }
                OUTPUT_AREA.setCaretPosition(OUTPUT_AREA.getDocument().getLength());
            } else {
                PrintStream out;
                PrintStream printStream = out = priority > 2 ? System.err : System.out;
                if (appendNewLine) {
                    out.println("Animal: " + msg);
                } else {
                    out.print(msg);
                }
            }
            if (LOGGER != null) {
                LOGGER.logMessage(msg, priority);
            }
        }
    }

    public static void addDebugMessage(String msg) {
        if (LOGGER != null) {
            LOGGER.logMessage(msg, 1);
        }
    }

    public static void message(String msg) {
        MessageDisplay.errorMsg(msg, 2);
    }

    public static void message(String msg, Object param) {
        MessageDisplay.errorMsg(msg, new Object[]{param}, 2);
    }

    public static void message(String msg, Object[] params) {
        MessageDisplay.errorMsg(msg, params, 2);
    }

    private static void instantiateLogger(XProperties props) {
        String defaultLogger = props.getProperty("animal.logger", "animal.misc.DefaultLogger");
        try {
            Class<?> c = Class.forName(defaultLogger);
            LOGGER = (DebugLogger)c.newInstance();
            LOGGER.init();
        }
        catch (ClassNotFoundException e) {
            MessageDisplay.errorMsg("Class " + e.getMessage() + " not found!", 8);
        }
        catch (InstantiationException e) {
            MessageDisplay.errorMsg("Error instantiating " + e.getMessage(), 16);
        }
        catch (IllegalAccessException e) {
            MessageDisplay.errorMsg("Illegal Access to " + e.getMessage() + ". Perhaps no public constructor.", 16);
        }
        catch (IllegalArgumentException e) {
            MessageDisplay.errorMsg("Illegal Class " + e.getMessage(), 16);
        }
    }
}

