/*
 * Decompiled with CFR 0.152.
 */
package animal.misc;

import animal.editor.Editor;
import animal.main.Animal;
import animal.main.PropertiedObject;

public abstract class EditableObject
extends PropertiedObject
implements Cloneable {
    private transient Editor editor;

    public Object clone() {
        try {
            EditableObject o = (EditableObject)super.clone();
            o.resetEditor();
            return o;
        }
        catch (CloneNotSupportedException i) {
            throw new InternalError();
        }
    }

    public Editor getEditor() {
        if (this.editor == null) {
            this.setDefaultEditor();
        }
        return this.editor;
    }

    public Editor getSecondaryEditor() {
        if (this.getEditor() == null) {
            return null;
        }
        if (!this.editor.isPrimaryEditor()) {
            return this.editor;
        }
        this.editor = this.editor.getSecondaryEditor(this);
        return this.editor;
    }

    public void resetEditor() {
        if (this.getEditor() != null && !this.editor.isPrimaryEditor()) {
            this.editor.setVisible(false);
            this.editor.dispose();
            this.editor = this.editor.getPrimaryEditor();
        }
    }

    public final void setDefaultEditor() {
        String name = this.getClass().getName();
        int i = name.lastIndexOf(46);
        if (i != -1) {
            name = name.substring(i + 1);
        }
        if (name.startsWith("PT")) {
            name = name.substring("PT".length());
        }
        this.setEditor(Animal.get().getEditor(name));
    }

    public void setEditor(Editor anEditor) {
        this.editor = anEditor;
    }
}

