/*
 * Decompiled with CFR 0.152.
 */
package animal.misc;

import animal.main.AnimalConfiguration;
import animal.misc.AnimalFileFilter;
import animal.misc.AnimalFileView;
import animal.misc.AnimalTranslator;
import animal.misc.FilePreviewer;
import java.awt.Image;
import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.filechooser.FileFilter;

public class AnimalFileChooser
extends JPanel {
    private static final long serialVersionUID = 4308537498924801898L;
    static JFrame frame;
    AnimalFileView fileView;
    public AnimalFileFilter exportFilter;
    public AnimalFileFilter importFilter;
    FileFilter currentLoadFilter;
    FileFilter currentImageFilter;
    FileFilter currentSaveFilter;
    FileFilter currentScriptFilter;
    FileFilter currentExportFilter;
    FileFilter currentImportFilter;
    FilePreviewer previewer;
    public JFileChooser chooser = new JFileChooser();
    String currentExtension;
    String currentFormatTag;
    File defaultDirectory;
    private AnimalConfiguration animalConfig;
    Image image = null;

    public AnimalFileChooser(AnimalConfiguration config) {
        this.fileView = new AnimalFileView();
        this.previewer = new FilePreviewer(this.chooser);
        this.chooser.setAccessory(this.previewer);
        this.animalConfig = config;
        if (this.animalConfig == null) {
            this.animalConfig = AnimalConfiguration.getDefaultConfiguration();
        }
    }

    public void setCurrentDirectory(String directory) {
        this.chooser.setCurrentDirectory(new File(directory));
    }

    public void setCurrentDirectory(File f) {
        this.chooser.setCurrentDirectory(f);
    }

    public String getCurrentDirectoryName() {
        if (this.defaultDirectory == null) {
            return ".";
        }
        return this.defaultDirectory.getName();
    }

    public void setAnimalXMLFilter() {
        AnimalFileFilter theFilter = new AnimalFileFilter("xml", "XML");
        this.chooser.addChoosableFileFilter(theFilter);
        this.chooser.removeChoosableFileFilter(this.chooser.getAcceptAllFileFilter());
        this.chooser.setFileFilter(theFilter);
    }

    public void resetFilters() {
        if (this.chooser == null) {
            this.chooser = new JFileChooser();
        }
        this.chooser.resetChoosableFileFilters();
        this.chooser.removeChoosableFileFilter(this.chooser.getAcceptAllFileFilter());
    }

    public void setAnimalLoadFilters() {
        this.chooser.resetChoosableFileFilters();
        this.chooser.addChoosableFileFilter(new AnimalFileFilter("aml", "ASCII (compressed; preferred)"));
        this.chooser.addChoosableFileFilter(new AnimalFileFilter("ama", "ASCII (uncompressed)"));
        this.chooser.addChoosableFileFilter(new AnimalFileFilter("asc", "Compressed Scripting"));
        this.chooser.addChoosableFileFilter(new AnimalFileFilter("asu", "Uncompressed Scripting"));
        String[] allFilters = new String[]{"aml", "ama", "asc", "asu"};
        this.chooser.addChoosableFileFilter(new AnimalFileFilter(allFilters, "Animal"));
        this.chooser.removeChoosableFileFilter(this.chooser.getAcceptAllFileFilter());
        if (this.currentLoadFilter == null) {
            this.currentLoadFilter = this.chooser.getChoosableFileFilters()[0];
        }
        this.chooser.setFileFilter(this.currentLoadFilter);
    }

    public void setAnimalScriptingFilters() {
        this.chooser.resetChoosableFileFilters();
        this.chooser.addChoosableFileFilter(new AnimalFileFilter("aml", "ASCII (compressed; preferred)"));
        this.chooser.addChoosableFileFilter(new AnimalFileFilter("ama", "ASCII (uncompressed)"));
        this.chooser.addChoosableFileFilter(new AnimalFileFilter("asc", "Compressed Scripting"));
        this.chooser.addChoosableFileFilter(new AnimalFileFilter("asu", "Uncompressed Scripting"));
        this.chooser.removeChoosableFileFilter(this.chooser.getAcceptAllFileFilter());
        if (this.currentScriptFilter == null) {
            this.currentScriptFilter = this.chooser.getChoosableFileFilters()[2];
        }
        this.chooser.setFileFilter(this.currentScriptFilter);
    }

    public void setAnimalSaveFilters() {
        this.chooser.resetChoosableFileFilters();
        FileFilter[] filters = this.chooser.getChoosableFileFilters();
        this.chooser.removeChoosableFileFilter(this.chooser.getAcceptAllFileFilter());
        this.chooser.addChoosableFileFilter(new AnimalFileFilter("aml", "ASCII (compressed; preferred)"));
        this.chooser.addChoosableFileFilter(new AnimalFileFilter("ama", "ASCII (uncompressed)"));
        this.chooser.addChoosableFileFilter(new AnimalFileFilter("xml", "XML"));
        if (this.currentSaveFilter == null) {
            this.currentSaveFilter = this.chooser.getChoosableFileFilters()[0];
        }
        this.chooser.setFileFilter(this.currentSaveFilter);
        filters = this.chooser.getChoosableFileFilters();
        int i = 0;
        while (i < filters.length) {
            System.err.println("Filter #" + i + ": " + filters[i].toString());
            ++i;
        }
    }

    public void setSpecificFilter(String mandatoryDir, String mandatoryPrefix, String description, boolean cleanAllFilters) {
        if (cleanAllFilters) {
            this.chooser.resetChoosableFileFilters();
            this.chooser.removeChoosableFileFilter(this.chooser.getAcceptAllFileFilter());
        }
        this.chooser.addChoosableFileFilter(new AnimalFileFilter(mandatoryDir, mandatoryPrefix, description));
    }

    public void setImageLoadFilters() {
        this.chooser.resetChoosableFileFilters();
        this.chooser.addChoosableFileFilter(new AnimalFileFilter("apf", "APF Activated Pseudo-Format"));
        this.chooser.addChoosableFileFilter(new AnimalFileFilter("bmp", "BMP Windows Bitmap format"));
        this.chooser.addChoosableFileFilter(new AnimalFileFilter("gif", "GIF format"));
        this.chooser.addChoosableFileFilter(new AnimalFileFilter("jpg", "JPG JPEG format"));
        this.chooser.addChoosableFileFilter(new AnimalFileFilter("pcx", "PCX image format"));
        this.chooser.addChoosableFileFilter(new AnimalFileFilter("pict", "PICT v2 format"));
        this.chooser.addChoosableFileFilter(new AnimalFileFilter("png", "PNG image format"));
        this.chooser.addChoosableFileFilter(new AnimalFileFilter("psd", "PSD Photoshop image format"));
        this.chooser.addChoosableFileFilter(new AnimalFileFilter("ras", "SunRaster format"));
        this.chooser.addChoosableFileFilter(new AnimalFileFilter("tga", "TGA image format"));
        this.chooser.addChoosableFileFilter(new AnimalFileFilter("xbm", "XBM Bitmap format"));
        this.chooser.addChoosableFileFilter(new AnimalFileFilter("xpm", "XPM Pixelmap format"));
        if (this.currentImageFilter == null) {
            this.currentImageFilter = this.chooser.getChoosableFileFilters()[2];
        }
        this.chooser.setFileFilter(this.currentImageFilter);
    }

    public void setImageFilters() {
        this.chooser.resetChoosableFileFilters();
        this.chooser.addChoosableFileFilter(new AnimalFileFilter("apf", "APF Activated Pseudo-Format"));
        this.chooser.addChoosableFileFilter(new AnimalFileFilter("bmp", "BMP Windows Bitmap format"));
        this.chooser.addChoosableFileFilter(new AnimalFileFilter("jpg", "JPG JPEG format"));
        this.chooser.addChoosableFileFilter(new AnimalFileFilter("pcx", "PCX image format"));
        this.chooser.addChoosableFileFilter(new AnimalFileFilter("pict", "PICT v2 format"));
        this.chooser.addChoosableFileFilter(new AnimalFileFilter("png", "PNG image format"));
        this.chooser.addChoosableFileFilter(new AnimalFileFilter("psd", "PSD Photoshop image format"));
        this.chooser.addChoosableFileFilter(new AnimalFileFilter("ras", "SunRaster format"));
        this.chooser.addChoosableFileFilter(new AnimalFileFilter("tga", "TGA image format"));
        this.chooser.addChoosableFileFilter(new AnimalFileFilter("xbm", "XBM Bitmap format"));
        this.chooser.addChoosableFileFilter(new AnimalFileFilter("xpm", "XPM Pixelmap format"));
        if (this.currentImageFilter == null) {
            this.currentImageFilter = this.chooser.getChoosableFileFilters()[2];
        }
        this.chooser.setFileFilter(this.currentImageFilter);
    }

    public void chooseDefaultFilter() {
        this.chooser.setFileFilter(this.chooser.getChoosableFileFilters()[0]);
    }

    public void addFilter(String extension, String formatDescription) {
        this.chooser.addChoosableFileFilter(new AnimalFileFilter(extension, formatDescription));
    }

    public void setImage(Image theImage) {
        this.image = theImage;
    }

    public String openForImageLoad(JFrame aFrame) {
        this.setImageLoadFilters();
        String filename = null;
        this.chooser.setDialogType(0);
        this.setCurrentDirectory(this.animalConfig.getCurrentFilename());
        int returnValue = this.chooser.showDialog(aFrame, null);
        if (returnValue == 0) {
            this.currentLoadFilter = this.chooser.getFileFilter();
            this.defaultDirectory = this.chooser.getCurrentDirectory();
            File theFile = this.chooser.getSelectedFile();
            if (theFile != null) {
                if (theFile.isDirectory()) {
                    JOptionPane.showMessageDialog(aFrame, AnimalTranslator.translateMessage("chosenDir", this.chooser.getSelectedFile().getAbsolutePath()));
                } else {
                    filename = theFile.getPath();
                }
            }
        }
        return filename;
    }

    public String openForLoad(JFrame aFrame) {
        this.setAnimalLoadFilters();
        String filename = null;
        this.chooser.setDialogType(0);
        this.setCurrentDirectory(this.animalConfig.getCurrentFilename());
        int returnValue = this.chooser.showDialog(aFrame, null);
        if (returnValue == 0) {
            this.currentLoadFilter = this.chooser.getFileFilter();
            this.defaultDirectory = this.chooser.getCurrentDirectory();
            File theFile = this.chooser.getSelectedFile();
            if (theFile != null) {
                if (theFile.isDirectory()) {
                    JOptionPane.showMessageDialog(aFrame, AnimalTranslator.translateMessage("chosenDir", this.chooser.getSelectedFile().getAbsolutePath()));
                } else {
                    filename = theFile.getPath();
                }
            }
        }
        return filename;
    }

    public String openForSave(JFrame aFrame) {
        this.setAnimalSaveFilters();
        return this.openForExport(aFrame);
    }

    public String openForExport(JFrame aFrame) {
        int returnValue;
        if (this.currentExportFilter != null) {
            this.chooser.setFileFilter(this.currentExportFilter);
        }
        this.chooser.setDialogType(1);
        if (this.animalConfig.getCurrentFilename() != null) {
            this.setCurrentDirectory(this.animalConfig.getCurrentFilename());
        }
        if ((returnValue = this.chooser.showDialog(aFrame, null)) == 0) {
            File theFile = this.chooser.getSelectedFile();
            this.currentExportFilter = this.chooser.getFileFilter();
            if (theFile != null && !theFile.isDirectory()) {
                this.defaultDirectory = this.chooser.getCurrentDirectory();
                String filename = this.chooser.getSelectedFile().getAbsolutePath();
                this.exportFilter = (AnimalFileFilter)this.chooser.getFileFilter();
                this.currentExtension = this.exportFilter.getExtension();
                this.currentFormatTag = this.exportFilter.getShortDescription();
                return filename;
            }
        }
        JOptionPane.showMessageDialog(aFrame, AnimalTranslator.translateMessage("noFileChosen"));
        return null;
    }

    public String openForStraightLoad(JFrame referenceFrame) {
        int returnValue = this.chooser.showDialog(referenceFrame, null);
        if (returnValue == 0) {
            File theFile = this.chooser.getSelectedFile();
            this.currentImportFilter = this.chooser.getFileFilter();
            if (theFile != null && !theFile.isDirectory()) {
                this.defaultDirectory = this.chooser.getCurrentDirectory();
                String filename = this.chooser.getSelectedFile().getAbsolutePath();
                this.importFilter = (AnimalFileFilter)this.chooser.getFileFilter();
                this.currentExtension = this.importFilter.getExtension();
                this.currentFormatTag = this.importFilter.getShortDescription();
                return filename;
            }
        }
        JOptionPane.showMessageDialog(referenceFrame, AnimalTranslator.translateMessage("noFileChosen"));
        return null;
    }

    public String openForImport(JFrame aFrame) {
        if (this.currentImportFilter != null) {
            this.chooser.setFileFilter(this.currentImportFilter);
        }
        this.chooser.setDialogType(0);
        this.setCurrentDirectory(this.animalConfig.getCurrentFilename());
        int returnValue = this.chooser.showDialog(aFrame, null);
        if (returnValue == 0) {
            File theFile = this.chooser.getSelectedFile();
            this.currentImportFilter = this.chooser.getFileFilter();
            if (theFile != null && !theFile.isDirectory()) {
                this.defaultDirectory = this.chooser.getCurrentDirectory();
                String filename = this.chooser.getSelectedFile().getAbsolutePath();
                this.importFilter = (AnimalFileFilter)this.chooser.getFileFilter();
                this.currentExtension = this.importFilter.getExtension();
                this.currentFormatTag = this.importFilter.getShortDescription();
                return filename;
            }
        }
        JOptionPane.showMessageDialog(aFrame, AnimalTranslator.translateMessage("noFileChosen"));
        return null;
    }

    public String openForFilenameChoice(JFrame aFrame) {
        this.chooser.setDialogType(0);
        this.setCurrentDirectory(this.animalConfig.getCurrentFilename());
        int returnValue = this.chooser.showDialog(aFrame, null);
        if (returnValue == 0) {
            File theFile = this.chooser.getSelectedFile();
            this.currentImportFilter = this.chooser.getFileFilter();
            if (theFile != null && !theFile.isDirectory()) {
                this.defaultDirectory = this.chooser.getCurrentDirectory();
                String filename = this.chooser.getSelectedFile().getAbsolutePath();
                return filename;
            }
        }
        JOptionPane.showMessageDialog(aFrame, AnimalTranslator.translateMessage("noFileChosen"));
        return null;
    }

    public String getExtension() {
        return this.currentExtension;
    }

    public String getFormat() {
        return this.currentFormatTag;
    }

    public String getDescription() {
        if (this.exportFilter == null) {
            return "animation/animal-ascii";
        }
        return this.exportFilter.getShortDescription();
    }
}

