/*
 * Decompiled with CFR 0.152.
 */
package animal.main;

import animal.animator.Animator;
import animal.animator.TimedAnimator;
import animal.animator.TimedShow;
import animal.editor.Editor;
import animal.graphics.PTGraphicObject;
import animal.gui.AnimalMainWindow;
import animal.gui.GraphicVector;
import animal.gui.GraphicVectorEntry;
import animal.main.AnimationListEntry;
import animal.main.AnimationState;
import animal.main.Link;
import animal.misc.AnimalTranslator;
import animal.misc.MessageDisplay;
import animal.misc.XProperties;
import avinteraction.backend.BackendInterface;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.util.Vector;
import javax.swing.SwingUtilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Animation {
    private static final long serialVersionUID = 5571850177577498419L;
    private static final int fileVersion = 1;
    Rectangle visualizationSize = new Rectangle(0, 0, 0, 0);
    public String language = "none";
    private int width = 0;
    private int height = 0;
    private BackendInterface backend;
    private static Animation pendingAnimation;
    private static Animation registeredAnimation;
    private Vector<Animator> allAnimators = new Vector();
    private Vector<PTGraphicObject> allGraphicObjects = new Vector();
    private Vector<Link> allLinks = new Vector();
    String author;
    private int lastChange = 0;
    private XProperties linkNrMapper;
    private int nextGraphicObjectNum = 0;
    private int nrAnimationSteps = 0;
    private int nrAnimators = 0;
    private int nrObjects = 0;
    private XProperties objectIDMapper;
    private long animationUID;
    String title;

    public int getFileVersion() {
        return 1;
    }

    public Animation() {
        this.insertLink(new Link(0, 1));
        this.insertLink(new Link(1, Integer.MAX_VALUE));
        pendingAnimation = this;
        this.doChange();
        this.nrAnimationSteps = 0;
        this.nrAnimators = 0;
        this.nrObjects = 0;
    }

    public Rectangle determineVisualizationSize() {
        AnimationState state = new AnimationState(this);
        int ticks = 0;
        Rectangle size = new Rectangle(0, 0, 1, 1);
        Rectangle currentBoundingBox = null;
        int step = 0;
        int w = 0;
        int h = 0;
        state.setStep(0, false);
        step = state.getNextStep();
        while (step != Integer.MAX_VALUE) {
            state.setStep(step, true);
            Vector<Animator> animators = state.getCurrentAnimators();
            long time = System.currentTimeMillis();
            int a = 0;
            while (a < animators.size()) {
                animators.elementAt(a).init(state, time, ticks);
                ++a;
            }
            boolean finished = false;
            int[] currentObjects = null;
            PTGraphicObject currentObject = null;
            while (!finished) {
                finished = true;
                time = System.currentTimeMillis();
                ++ticks;
                int a2 = 0;
                while (a2 < animators.size()) {
                    Animator animator = animators.elementAt(a2);
                    animator.action(time, ticks);
                    currentObjects = animator.getObjectNums();
                    int i = 0;
                    while (i < currentObjects.length) {
                        currentObject = state.getCloneByNum(currentObjects[i]);
                        if (currentObject != null) {
                            currentBoundingBox = currentObject.getBoundingBox();
                            w = currentBoundingBox.width + currentBoundingBox.x;
                            h = currentBoundingBox.height + currentBoundingBox.y;
                        }
                        size = SwingUtilities.computeUnion(0, 0, w, h, size);
                        ++i;
                    }
                    if (animator.hasFinished()) {
                        animators.removeElementAt(a2);
                        continue;
                    }
                    finished = false;
                    ++a2;
                }
            }
            step = state.getNextStep();
        }
        this.setWidth(size.width);
        this.setHeight(size.height);
        return size;
    }

    public Rectangle getVisualizationSize() {
        return this.visualizationSize;
    }

    protected void setVisualizationSize(Rectangle size) {
        this.visualizationSize = size != null ? size : new Rectangle(0, 0, 1, 1);
        this.setWidth(this.visualizationSize.width);
        this.setHeight(this.visualizationSize.height);
    }

    public BackendInterface getInteractionBackend() {
        return this.backend;
    }

    public void setInteractionBackend(BackendInterface backendInterface) {
        this.backend = backendInterface;
    }

    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String lang) {
        this.language = lang;
    }

    public String getAuthor() {
        return this.author != null ? this.author : AnimalTranslator.translateMessage("unknownAuthor");
    }

    public String getTitle() {
        return this.title != null ? this.title : AnimalTranslator.translateMessage("unnamedAnimation");
    }

    public void setAuthor(String authorName) {
        this.author = authorName;
    }

    public void setTitle(String titleString) {
        this.title = titleString;
    }

    void discard() {
        int i;
        long timeForDiscard = System.currentTimeMillis();
        AnimationListEntry[] localinfo = pendingAnimation.getAnimatorList();
        if (localinfo != null) {
            i = 0;
            while (i < localinfo.length) {
                localinfo[i].discard();
                ++i;
            }
        }
        Vector<PTGraphicObject> objects = Animation.pendingAnimation.allGraphicObjects;
        int nr = objects.size();
        i = 0;
        while (i < nr) {
            objects.elementAt(i).discard();
            ++i;
        }
        pendingAnimation = null;
        MessageDisplay.message("animDiscarded", System.currentTimeMillis() - timeForDiscard);
    }

    public void doChange() {
        ++this.lastChange;
    }

    public static Animation get() {
        if (pendingAnimation != null) {
            return pendingAnimation;
        }
        return registeredAnimation;
    }

    public int getLastChange() {
        if (AnimalMainWindow.getWindowCoordinator().getDrawWindow(false).isInitialized()) {
            AnimalMainWindow.getWindowCoordinator().getDrawWindow(true).writeBack();
        }
        return this.lastChange;
    }

    public void resetChange() {
        this.lastChange = 0;
    }

    public void resetNextGraphicObjectNum() {
        this.nextGraphicObjectNum = 0;
    }

    public int getNextGraphicObjectNum() {
        return this.nextGraphicObjectNum;
    }

    public void setNextGraphicObjectNum(int nr) {
        this.nextGraphicObjectNum = nr;
    }

    void register() {
        registeredAnimation = pendingAnimation;
        Editor.closeAllEditors();
    }

    public void deleteGraphicObject(int objectNum) {
        int i = this.allAnimators.size() - 1;
        while (i >= 0) {
            Animator a = this.allAnimators.elementAt(i);
            int[] nums = a.getObjectNums();
            if (Animation.isContained(nums, objectNum)) {
                if (nums.length == 1) {
                    this.allAnimators.removeElementAt(i);
                } else {
                    int[] newNums = new int[nums.length - 1];
                    int c = 0;
                    int j = 0;
                    while (j < nums.length) {
                        if (nums[j] != objectNum) {
                            newNums[c++] = nums[j];
                        }
                        ++j;
                    }
                    a.setObjectNums(newNums);
                }
            } else {
                nums = a.getTemporaryObjects();
                if (Animation.isContained(nums, objectNum)) {
                    if (nums.length == 1) {
                        this.allAnimators.removeElementAt(i);
                    } else {
                        MessageDisplay.errorMsg(AnimalTranslator.translateMessage("cannotDeleteMultiple"), 16);
                    }
                }
            }
            --i;
        }
        PTGraphicObject go = this.getGraphicObject(objectNum);
        if (go != null) {
            this.allGraphicObjects.removeElement(go);
            --this.nrObjects;
        }
        this.doChange();
    }

    public PTGraphicObject getGraphicObject(int num) {
        int j = 0;
        while (j < 2) {
            int i = 0;
            while (i < this.allGraphicObjects.size()) {
                PTGraphicObject g = this.allGraphicObjects.elementAt(i);
                if (g.getNum(false) == num) {
                    return g;
                }
                ++i;
            }
            if (j == 0 && !AnimalMainWindow.getWindowCoordinator().getDrawWindow(true).writeBack()) break;
            ++j;
        }
        return null;
    }

    public Vector<PTGraphicObject> getGraphicObjects() {
        return this.allGraphicObjects;
    }

    public int getUniqueGraphicObjectNum() {
        return ++this.nextGraphicObjectNum;
    }

    private boolean insertGraphicObject(GraphicVectorEntry gve) {
        int num = gve.go.getNum(true);
        if (gve.getMode() == 3) {
            return false;
        }
        int a = 0;
        while (a < this.allGraphicObjects.size()) {
            if (this.allGraphicObjects.elementAt(a).getNum(true) == num) {
                this.allGraphicObjects.setElementAt(gve.go, a);
                this.doChange();
                return false;
            }
            ++a;
        }
        this.allGraphicObjects.addElement(gve.go);
        this.doChange();
        ++this.nrObjects;
        return true;
    }

    public int insertGraphicObject(PTGraphicObject g) {
        this.insertGraphicObject(new GraphicVectorEntry(g, false, 1));
        return g.getNum(true);
    }

    public boolean isUsedTemporarily(int num, int step) {
        int s = step;
        while (step != 0 && s == step || s != Integer.MAX_VALUE && step != Integer.MIN_VALUE) {
            Vector<Animator> animators = this.getAnimatorsAtStep(s);
            int i = 0;
            while (i < animators.size()) {
                Animator a = animators.elementAt(i);
                int[] o = a.getTemporaryObjects();
                if (o != null) {
                    int k = 0;
                    while (k < o.length) {
                        if (o[k] == num) {
                            return true;
                        }
                        ++k;
                    }
                }
                ++i;
            }
            s = this.getNextStep(s);
        }
        return false;
    }

    public void putObjectsAtStep(int step, GraphicVector objects) {
        if (step == Integer.MAX_VALUE) {
            int s = this.getLastStep();
            step = s != Integer.MAX_VALUE ? s : this.newStep(step);
        }
        if (step == 0) {
            step = this.getNextStep(step);
        }
        Vector<Integer> newObjects = new Vector<Integer>();
        int a = 0;
        while (a < objects.getSize()) {
            GraphicVectorEntry gve = objects.elementAt(a);
            if (this.insertGraphicObject(gve) && !gve.isTemporary() && !this.isUsedTemporarily(gve.go.getNum(true), step)) {
                newObjects.addElement(new Integer(gve.go.getNum(true)));
            }
            ++a;
        }
        if (newObjects.size() > 0) {
            int[] newO = new int[newObjects.size()];
            int a2 = 0;
            while (a2 < newObjects.size()) {
                newO[a2] = (Integer)newObjects.elementAt(a2);
                ++a2;
            }
            this.insertAnimator(new TimedShow(step, newO, 0, "show", true));
        }
    }

    public boolean containsAnimator(Animator animator) {
        return this.allAnimators.contains(animator);
    }

    Vector<Animator> getAnimators() {
        return this.allAnimators;
    }

    public void insertAnimator(Animator animator) {
        int i = this.allAnimators.size() - 1;
        while (i >= 0 && this.allAnimators.elementAt(i).getStep() > animator.getStep()) {
            --i;
        }
        this.allAnimators.insertElementAt(animator, i + 1);
        if (animator instanceof TimedAnimator && animator != null) {
            TimedAnimator ta = (TimedAnimator)animator;
            Link targetLink = this.getLink(animator.getStep());
            int duration = ta.getOffset() + ta.getDuration();
            if (targetLink != null && duration > targetLink.getDurationInTicks() && ta.isUnitIsTicks()) {
                targetLink.setDurationInTicks(duration);
            }
        }
        ++this.nrAnimators;
        this.doChange();
    }

    public Animator getAnimator(int step, int objectNum, Animator dontGetThis) {
        int i = 0;
        while (i < this.allAnimators.size()) {
            Animator a = this.allAnimators.elementAt(i);
            if ((step == 0 && (objectNum == 0 || Animation.isContained(a.getObjectNums(), objectNum)) || a.getStep() == step && (objectNum == 0 || Animation.isContained(a.getObjectNums(), objectNum))) && a != dontGetThis) {
                return a;
            }
            ++i;
        }
        return null;
    }

    public Vector<Animator> getAnimatorsAtStep(int step) {
        Vector<Animator> nowAnimators = new Vector<Animator>();
        int a = 0;
        while (a < this.allAnimators.size()) {
            Animator ae = this.allAnimators.elementAt(a);
            if (ae.getStep() == step) {
                nowAnimators.addElement(ae);
            }
            ++a;
        }
        return nowAnimators;
    }

    public void deleteAnimator(Animator a) {
        this.allAnimators.removeElement(a);
        --this.nrAnimators;
        if (a instanceof TimedAnimator) {
            Link targetStep = this.getLink(a.getStep());
            targetStep.setDurationInTicks(0);
            int duration = 0;
            int localDuration = 0;
            TimedAnimator ta = null;
            Vector<Animator> stepAnimators = this.getAnimatorsAtStep(targetStep.getStep());
            int i = 0;
            while (i < stepAnimators.size()) {
                if (stepAnimators.elementAt(i) instanceof TimedAnimator && (ta = (TimedAnimator)stepAnimators.elementAt(i)).isUnitIsTicks() && (localDuration = ta.getDuration() + ta.getOffset()) > duration) {
                    duration = localDuration;
                }
                ++i;
            }
            targetStep.setDurationInTicks(duration);
        }
        this.doChange();
    }

    public void deleteStep(int step) {
        Link s = this.getLink(step);
        Link before = this.getLink(this.getPrevStep(step));
        Editor.closeLinkEditors(step, true);
        before.setNextStep(s.getNextStep());
        this.allLinks.removeElement(s);
        --this.nrAnimationSteps;
        int i = this.allAnimators.size() - 1;
        while (i >= 0) {
            if (this.allAnimators.elementAt(i).getStep() == step) {
                this.allAnimators.removeElementAt(i);
            }
            --i;
        }
        this.doChange();
    }

    public int[] findWayToStep(int step, int currentStep) {
        int size = this.getMaxStepNum() + 1;
        int[] result = null;
        int[] tempResult = new int[size];
        int thisStep = 0;
        if (step == Integer.MAX_VALUE) {
            step = this.getLastStep();
        }
        int count = 0;
        while (thisStep != step && count < size) {
            thisStep = this.getNextStep(thisStep);
            tempResult[count++] = thisStep;
        }
        if (count == size && thisStep != step) {
            return null;
        }
        result = new int[count];
        System.arraycopy(tempResult, 0, result, 0, count);
        tempResult = null;
        return result;
    }

    public int[] findWayToStepORIG(int step, int currentStep) {
        long timeTaken = System.currentTimeMillis();
        int size = this.getMaxStepNum() + 1;
        int[] result = null;
        int[] tempResult = new int[size];
        int thisStep = 0;
        if (step == Integer.MAX_VALUE) {
            step = this.getLastStep();
        }
        int count = 0;
        while (thisStep != step && count < size) {
            thisStep = this.getNextStep(thisStep);
            tempResult[count++] = thisStep;
        }
        if (count == size && thisStep != step) {
            return null;
        }
        result = new int[count];
        int i = 0;
        while (i < count) {
            result[i] = tempResult[i];
            ++i;
        }
        timeTaken = System.currentTimeMillis() - timeTaken;
        return result;
    }

    public int getLastStep() {
        int a = 0;
        while (a < this.allLinks.size()) {
            Link l = this.allLinks.elementAt(a);
            if (l.getNextStep() == Integer.MAX_VALUE) {
                return l.getStep();
            }
            ++a;
        }
        return Integer.MIN_VALUE;
    }

    public int getNextStep(int step) {
        Link l = this.getLink(step);
        if (l == null) {
            return Integer.MIN_VALUE;
        }
        return l.getNextStep();
    }

    public int getNextStepNum() {
        return this.getMaxStepNum() + 1;
    }

    public int getNrAnimationSteps() {
        if (this.nrAnimationSteps <= 0) {
            this.nrAnimationSteps = 1;
            int currentStepNr = 0;
            while (currentStepNr != Integer.MAX_VALUE) {
                currentStepNr = this.getNextStep(currentStepNr);
                ++this.nrAnimationSteps;
            }
        }
        return this.nrAnimationSteps;
    }

    public int getNrAnimators() {
        if (this.nrAnimators < 0) {
            this.nrAnimators = 0;
        }
        return this.nrAnimators;
    }

    public int getNrObjects() {
        if (this.nrObjects < 0) {
            this.nrObjects = 0;
        }
        return this.nrObjects;
    }

    public int getMaxStepNum() {
        int max = 0;
        int i = 0;
        while (i < this.allLinks.size()) {
            int newLink = this.allLinks.elementAt(i).getNextStep();
            if (newLink != Integer.MAX_VALUE && newLink > max) {
                max = newLink;
            }
            ++i;
        }
        return max;
    }

    public int getPrevStep(int step) {
        if (step == 0) {
            return 0;
        }
        int a = 0;
        while (a < this.allLinks.size()) {
            Link l = this.allLinks.elementAt(a);
            if (l.getNextStep() == step) {
                return l.getStep();
            }
            ++a;
        }
        return Integer.MAX_VALUE;
    }

    public int getStepCount() {
        return this.allLinks.size() - 1;
    }

    public static String getStepString(int step) {
        if (step == Integer.MAX_VALUE) {
            return "end";
        }
        return Integer.toString(step);
    }

    public int newStep(int beforeStep) {
        int newStep = this.getNextStepNum();
        int prevStep = this.getPrevStep(beforeStep);
        Link l = this.getLink(prevStep);
        l.setNextStep(newStep);
        this.insertLink(new Link(newStep, beforeStep));
        Editor.closeLinkEditors(prevStep, false);
        this.doChange();
        return newStep;
    }

    public int appendStep(int currentStep) {
        int newStep = this.getNextStepNum();
        Link l = this.getLink(currentStep);
        int nextStep = l.getNextStep();
        if (l.getMode() == 1) {
            this.insertLink(new Link(newStep, nextStep));
        } else {
            this.insertLink(new Link(newStep, nextStep, l.getTime()));
        }
        l.setNextStep(newStep);
        Editor.closeLinkEditors(newStep, false);
        this.doChange();
        return newStep;
    }

    public int prependStep(int currentStep) {
        if (currentStep == 0) {
            currentStep = this.getNextStep(currentStep);
        }
        return this.newStep(currentStep);
    }

    public int verifyStep(int step) {
        if (step < 0) {
            return 0;
        }
        if (step == Integer.MAX_VALUE) {
            step = this.getLastStep();
        }
        if (this.getLink(step) == null) {
            return 0;
        }
        return step;
    }

    public void insertLink(Link l) {
        Link oldLink = this.getLink(l.getStep());
        if (oldLink != null) {
            this.allLinks.removeElement(oldLink);
        }
        this.allLinks.addElement(l);
        this.doChange();
        ++this.nrAnimationSteps;
    }

    public Link getLink(int from) {
        int a = 0;
        while (a < this.allLinks.size()) {
            Link l = this.allLinks.elementAt(a);
            if (from == l.getStep()) {
                return l;
            }
            ++a;
        }
        return null;
    }

    public boolean isSameState(int step1, int step2) {
        return false;
    }

    public AnimationListEntry[] getAnimatorList() {
        Vector<AnimationListEntry> result = new Vector<AnimationListEntry>();
        Link l = this.getLink(0);
        while (l != null) {
            if (l.getStep() != 0) {
                result.addElement(new AnimationListEntry(l.toString(), l));
                Vector<Animator> animators = this.getAnimatorsAtStep(l.getStep());
                int i = 0;
                while (i < animators.size()) {
                    Animator a = animators.elementAt(i);
                    result.addElement(new AnimationListEntry(a.toString(), a));
                    ++i;
                }
            }
            if (l.getStep() == Integer.MAX_VALUE) break;
            l = this.getLink(l.getNextStep());
        }
        result.addElement(new AnimationListEntry("----- end -----", new Link(Integer.MAX_VALUE, Integer.MAX_VALUE)));
        Object[] ai = new AnimationListEntry[result.size()];
        result.copyInto(ai);
        return ai;
    }

    public static boolean isContained(int[] nums, int num) {
        if (nums == null) {
            return false;
        }
        int a = 0;
        while (a < nums.length) {
            if (nums[a] == num) {
                return true;
            }
            ++a;
        }
        return false;
    }

    public XProperties getObjectIDs() {
        return this.objectIDMapper;
    }

    public int mapLinkID(int oldID) {
        return this.linkNrMapper.getIntProperty(String.valueOf(oldID));
    }

    public int mapObjectID(int id) {
        return this.objectIDMapper.getIntProperty(String.valueOf(id));
    }

    public int[] mapObjectIDs(int[] ids) {
        int n = ids.length;
        int[] result = null;
        if (n != 0) {
            result = new int[n];
            int i = 0;
            while (i < n) {
                result[i] = this.objectIDMapper.getIntProperty(String.valueOf(ids[i]));
                ++i;
            }
        }
        return result;
    }

    public int mapNewObject(int objectID) {
        ++this.nextGraphicObjectNum;
        this.objectIDMapper.put(objectID, this.nextGraphicObjectNum);
        return this.nextGraphicObjectNum;
    }

    public void sequentialize() {
    }

    public int getWidth() {
        if (this.width == 0) {
            return -1;
        }
        return this.width;
    }

    public int getHeight() {
        if (this.height <= 0) {
            return -1;
        }
        return this.height;
    }

    public void setWidth(int w) {
        this.width = w;
    }

    public void setSize(Dimension d) {
        this.setWidth((int)d.getWidth());
        this.setHeight((int)d.getHeight());
    }

    public void setHeight(int h) {
        this.height = h;
    }

    public Dimension getSize() {
        return new Dimension(this.getWidth(), this.getHeight());
    }

    public String[] getLinkLabels() {
        int nr = this.allLinks.size();
        String[] result = new String[nr];
        int i = 0;
        while (i < nr) {
            result[i] = this.allLinks.elementAt(i).getLinkDescription();
            ++i;
        }
        return result;
    }

    public int getNrOfSteps() {
        return this.allLinks.size();
    }

    public int getPositionOfStep(int stepNr) {
        int linkPos = -1;
        int nrLinks = this.allLinks.size();
        int a = 0;
        while (linkPos == -1 && a < nrLinks) {
            if (stepNr == this.allLinks.elementAt(a).getStep()) {
                linkPos = a;
            }
            ++a;
        }
        return linkPos;
    }

    public Animation getPartialAnimation(boolean[] exportSteps) {
        if (exportSteps == null) {
            return this;
        }
        int currentStep = 0;
        while (currentStep < exportSteps.length && exportSteps[currentStep]) {
            ++currentStep;
        }
        if (currentStep == exportSteps.length) {
            return this;
        }
        int currentIndex = 0;
        AnimationState animationState = new AnimationState(this);
        currentStep = 0;
        animationState.setStep(currentStep, true);
        animationState.setStep(animationState.getNextStep(), true);
        currentStep = animationState.getStep();
        while (currentStep != Integer.MAX_VALUE) {
            boolean cfr_ignored_0 = exportSteps[currentIndex];
            animationState.setStep(animationState.getNextStep(), true);
            currentStep = animationState.getStep();
            ++currentIndex;
        }
        return this;
    }

    public Animation getPartialAnimation2(boolean[] exportSteps) {
        if (exportSteps == null) {
            return this;
        }
        int i = 0;
        while (i < exportSteps.length && exportSteps[i]) {
            ++i;
        }
        if (i == exportSteps.length) {
            return this;
        }
        AnimationState animationState = new AnimationState(this);
        int nrOfObjects = this.getNextGraphicObjectNum();
        boolean[] objectHasBeenExported = new boolean[nrOfObjects + 1];
        boolean[] dirtyObject = new boolean[nrOfObjects + 1];
        int currentStep = 0;
        animationState.setStep(currentStep, true);
        animationState.setStep(animationState.getNextStep(), true);
        currentStep = animationState.getStep();
        int j = 0;
        XProperties propertyHandler = new XProperties();
        Animation animationToExport = this.buildNewAnimationStructure(exportSteps);
        while (currentStep != Integer.MAX_VALUE) {
            if (!exportSteps[currentStep]) {
                Vector<Animator> animators = animationState.getCurrentAnimators();
                j = 0;
                while (j < animators.size()) {
                    Animator animator = animators.elementAt(j);
                    if (animator.isChangingAnimator()) {
                        int[] objectNums = animator.getObjectNums();
                        int pos = 0;
                        while (pos < objectNums.length) {
                            dirtyObject[objectNums[pos]] = true;
                            ++pos;
                        }
                    }
                    ++j;
                }
            } else {
                animationToExport.directGraphicObjectExport(animationState, objectHasBeenExported);
                int[] reinsertTheseObjects = animationToExport.determineDirtyExportObjects(animationState, dirtyObject);
                animationToExport.insertTemporaryExportLink(animationState, reinsertTheseObjects, currentStep, propertyHandler);
                animationToExport.exportAnimators(animationState.getCurrentAnimators(), propertyHandler, animationState, objectHasBeenExported);
            }
            currentStep = animationState.getNextStep();
            animationState.setStep(currentStep, true);
        }
        return animationToExport;
    }

    private Animator updateObjectIDs(Animator animator, XProperties mapping) {
        if (animator == null || mapping == null) {
            return null;
        }
        Animator newAnimator = (Animator)animator.clone();
        int[] animatorObjects = newAnimator.getObjectNums();
        int nrOfObjects = animatorObjects.length;
        int[] newAnimatorObjects = new int[nrOfObjects];
        int i = 0;
        while (i < nrOfObjects) {
            newAnimatorObjects[i] = mapping.getIntProperty(String.valueOf(animatorObjects[i]), animatorObjects[i]);
            ++i;
        }
        newAnimator.setObjectNums(newAnimatorObjects);
        return newAnimator;
    }

    private Animation buildNewAnimationStructure(boolean[] selectedSteps) {
        Animation animationToExport = new Animation();
        int nrOfSteps = selectedSteps.length;
        int previousStep = 0;
        int j = 0;
        while (j < nrOfSteps) {
            if (selectedSteps[j]) {
                animationToExport.insertLink(new Link(previousStep, j));
                previousStep = j;
            }
            ++j;
        }
        animationToExport.insertLink(new Link(previousStep, Integer.MAX_VALUE));
        return animationToExport;
    }

    private void directGraphicObjectExport(AnimationState animationState, boolean[] isExported) {
        PTGraphicObject ptgo = null;
        GraphicVectorEntry[] objectsVisibleInStep = animationState.getCurrentObjects().convertToArray();
        if (objectsVisibleInStep != null && objectsVisibleInStep.length != 0) {
            int objectID = 0;
            while (objectID < objectsVisibleInStep.length) {
                ptgo = objectsVisibleInStep[objectID].getGraphicObject();
                if (ptgo != null && !isExported[ptgo.getNum(false)]) {
                    this.insertGraphicObject(animationState.getCloneByNum(ptgo.getNum(false)));
                    isExported[ptgo.getNum((boolean)false)] = true;
                }
                ++objectID;
            }
        }
    }

    private int[] determineDirtyExportObjects(AnimationState animationState, boolean[] isDirty) {
        int objectNr = 0;
        int objectID = 0;
        XProperties localHandler = new XProperties();
        Vector<Animator> animators = animationState.getCurrentAnimators();
        String dirty = "dirty";
        localHandler.put(dirty, " ");
        int animatorNr = 0;
        while (animatorNr < animators.size()) {
            Animator animator = animators.elementAt(animatorNr);
            int[] objectNums = animator.getObjectNums();
            objectNr = 0;
            while (objectNr < objectNums.length) {
                if (isDirty[objectNums[objectNr]]) {
                    localHandler.put(dirty, localHandler.get(dirty) + " " + objectNums[objectNr]);
                    isDirty[objectNums[objectNr]] = false;
                }
                ++objectNr;
            }
            ++animatorNr;
        }
        GraphicVectorEntry[] objectsVisibleInStep = animationState.getCurrentObjects().convertToArray();
        if (objectsVisibleInStep != null && objectsVisibleInStep.length != 0) {
            objectNr = 0;
            while (objectNr < objectsVisibleInStep.length) {
                if (isDirty[objectID = objectsVisibleInStep[objectID].getGraphicObject().getNum(false)]) {
                    localHandler.put(dirty, localHandler.get(dirty) + " " + objectID);
                }
                ++objectNr;
            }
        }
        int[] dirtyMustBeReinserted = null;
        if (localHandler.getProperty(dirty) != null) {
            dirtyMustBeReinserted = localHandler.getIntArrayProperty(dirty);
        }
        localHandler = null;
        animators = null;
        dirty = null;
        return dirtyMustBeReinserted;
    }

    private void insertTemporaryExportLink(AnimationState animationState, int[] targetIDs, int currentStep, XProperties propertyHandler) {
        if (targetIDs == null || targetIDs.length == 0) {
            return;
        }
        int generatedStepID = this.newStep(currentStep);
        Link generatedLink = this.getLink(generatedStepID);
        generatedLink.setMode(2);
        generatedLink.setTime(0);
        TimedShow timedShow = new TimedShow(generatedStepID, targetIDs, 0, "hide", false);
        this.insertAnimator(timedShow);
        PTGraphicObject ptgo = null;
        PTGraphicObject ptgoClone = null;
        int nrOfObjects = targetIDs.length;
        int[] newIDs = new int[nrOfObjects];
        int objectNr = 0;
        while (objectNr < nrOfObjects) {
            ptgo = animationState.getCloneByNum(targetIDs[objectNr]);
            ptgoClone = (PTGraphicObject)ptgo.clone();
            ptgoClone.resetNum();
            newIDs[objectNr] = ptgoClone.getNum(true);
            propertyHandler.put(String.valueOf(ptgo.getNum(false)), ptgoClone.getNum(false));
            ++objectNr;
        }
        timedShow = new TimedShow(generatedStepID, newIDs, 0, "show", true);
        this.insertAnimator(timedShow);
    }

    private void exportAnimators(Vector<Animator> animators, XProperties mapping, AnimationState animationState, boolean[] isExported) {
        int j = 0;
        while (j < animators.size()) {
            Animator animator = animators.elementAt(j);
            this.insertAnimator(this.updateObjectIDs(animator, mapping));
            int[] objectNums = animator.getTemporaryObjects();
            if (objectNums != null) {
                int k = 0;
                while (k < objectNums.length) {
                    PTGraphicObject ptgo = animationState.getCloneByNum(objectNums[k]);
                    if (ptgo != null && !isExported[ptgo.getNum(false)]) {
                        isExported[ptgo.getNum((boolean)false)] = true;
                        this.insertGraphicObject(ptgo);
                    }
                    ++k;
                }
            }
            ++j;
        }
    }

    public boolean hasSingleAnimatorInStep(int[] selectedOIDs, int step, Animator currentAnimator) {
        return this.checkSingleAnimator(selectedOIDs, step, currentAnimator) == null;
    }

    public String checkSingleAnimator(int[] selectedOIDs, int step, Animator currentAnimator) {
        int nrOfOIDs = selectedOIDs == null ? 0 : selectedOIDs.length;
        StringBuilder usedBuffer = new StringBuilder(selectedOIDs.length << 2);
        int oidIndex = 0;
        while (oidIndex < nrOfOIDs) {
            if (Animation.get().getAnimator(step, selectedOIDs[oidIndex], currentAnimator) != null) {
                usedBuffer.append(selectedOIDs[oidIndex]).append(' ');
            }
            ++oidIndex;
        }
        return usedBuffer.length() == 0 ? null : usedBuffer.toString();
    }

    public long getAnimationUID() {
        return this.animationUID;
    }
}

