/*
 * Decompiled with CFR 0.152.
 */
package animal.handler;

import animal.animator.ScaleParams;
import animal.graphics.PTGraphicObject;
import animal.graphics.PTTriangle;
import animal.handler.GraphicObjectHandler;
import animal.misc.AnimalTranslator;
import animal.misc.MSMath;
import animal.misc.MessageDisplay;
import java.awt.Color;
import java.awt.Point;
import java.beans.PropertyChangeEvent;
import java.util.StringTokenizer;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TriangleHandler
extends GraphicObjectHandler {
    @Override
    public Vector<String> getMethods(PTGraphicObject ptgo, Object obj) {
        Vector<String> result = new Vector<String>();
        if (!(ptgo instanceof PTTriangle)) {
            return result;
        }
        if (obj instanceof Point) {
            result.addElement("translate");
            result.addElement("translate #1");
            result.addElement("translate #2");
            result.addElement("translate #3");
        }
        if (obj instanceof ScaleParams) {
            result.addElement("scale");
        }
        if (obj instanceof Color) {
            result.addElement("color");
            result.addElement("fillColor");
            result.addElement("colors: color, fillColor");
        }
        if (obj instanceof Boolean) {
            result.addElement("show");
            result.addElement("hide");
        }
        if (obj instanceof String) {
            result.addElement("fill");
            result.addElement("unfill");
        }
        this.addExtensionMethodsFor(ptgo, obj, result);
        return result;
    }

    @Override
    public void propertyChange(PTGraphicObject ptgo, PropertyChangeEvent e) {
        String what;
        PTTriangle shape = null;
        if (ptgo instanceof PTTriangle) {
            shape = (PTTriangle)ptgo;
        }
        if ("translate".equalsIgnoreCase(what = e.getPropertyName())) {
            Point old = (Point)e.getOldValue();
            Point now = (Point)e.getNewValue();
            Point diff = MSMath.diff(now, old);
            shape.translate(diff.x, diff.y);
        } else if ("translate #1".equalsIgnoreCase(what)) {
            Point old = (Point)e.getOldValue();
            Point now = (Point)e.getNewValue();
            Point diff = MSMath.diff(now, old);
            shape.setFirstNode(diff.x, diff.y);
        } else if ("translate #2".equalsIgnoreCase(what)) {
            Point old = (Point)e.getOldValue();
            Point now = (Point)e.getNewValue();
            Point diff = MSMath.diff(now, old);
            shape.setSecondNode(diff.x, diff.y);
        } else if ("translate #3".equalsIgnoreCase(what)) {
            Point old = (Point)e.getOldValue();
            Point now = (Point)e.getNewValue();
            Point diff = MSMath.diff(now, old);
            shape.setThirdNode(diff.x, diff.y);
        } else if (what.equalsIgnoreCase("scale")) {
            double yFactor;
            ScaleParams s = (ScaleParams)e.getNewValue();
            double xFactor = s.getXScaleFactor() / ((ScaleParams)e.getOldValue()).getXScaleFactor();
            if (xFactor != (yFactor = s.getYScaleFactor() / ((ScaleParams)e.getOldValue()).getYScaleFactor())) {
                MessageDisplay.errorMsg("Must scale by common factor for shape!", 4);
            } else {
                shape.translate(-s.getCenter().getX(), -s.getCenter().getY());
                shape.scale(xFactor, yFactor);
                shape.translate(s.getCenter().getX(), s.getCenter().getY());
            }
        } else if (what.equalsIgnoreCase("color")) {
            shape.setColor((Color)e.getNewValue());
        } else if (what.equalsIgnoreCase("fillColor")) {
            shape.setFillColor((Color)e.getNewValue());
        } else if (what.startsWith("colors:")) {
            StringTokenizer stringTokenizer = new StringTokenizer(what, ":, ");
            stringTokenizer.nextToken();
            while (stringTokenizer.hasMoreTokens()) {
                String currentToken = stringTokenizer.nextToken();
                if (currentToken.equalsIgnoreCase("color")) {
                    shape.setColor((Color)e.getNewValue());
                    continue;
                }
                if (currentToken.equalsIgnoreCase("fillColor")) {
                    shape.setFillColor((Color)e.getNewValue());
                    continue;
                }
                MessageDisplay.message("unparsedHandlerToken", new String[]{AnimalTranslator.translateMessage("polylineColor"), currentToken});
            }
        } else if (what.equalsIgnoreCase("fill")) {
            shape.setFilled(true);
        } else if (what.equalsIgnoreCase("unfill")) {
            shape.setFilled(false);
        } else {
            super.propertyChange(ptgo, e);
        }
    }
}

