/*
 * Decompiled with CFR 0.152.
 */
package animal.gui;

import animal.graphics.PTGraphicObject;
import animal.gui.AnimalMainWindow;
import animal.misc.AnimalTranslator;
import javax.swing.JOptionPane;

public class GraphicVectorEntry {
    public static final int CREATED = 1;
    public static final int UNTOUCHED = 2;
    public static final int ANIMATED = 3;
    public static final int TEMPORARY = 4;
    public PTGraphicObject go = null;
    boolean selected = false;
    int mode = 0;

    public GraphicVectorEntry() {
    }

    public boolean mustBeDrawnBefore(GraphicVectorEntry other) {
        return this.go.getDepth() > other.go.getDepth() || this.go.getDepth() == other.go.getDepth() && this.go.getNum(false) < other.go.getNum(false);
    }

    public GraphicVectorEntry(PTGraphicObject aGO, boolean isSelected, int numericMode) {
        this.go = aGO;
        this.selected = isSelected;
        this.mode = numericMode;
    }

    void setEditorVisible(boolean b) {
        if (b && this.mode == 3) {
            JOptionPane.showMessageDialog(AnimalMainWindow.getWindowCoordinator().getDrawWindow(false), AnimalTranslator.translateMessage("modified"), AnimalTranslator.translateMessage("notPossible"), 1);
            return;
        }
        this.go.getSecondaryEditor().setVisible(b);
    }

    void setSelected(boolean isSelected, boolean showEditors) {
        if (showEditors && isSelected != this.selected) {
            this.setEditorVisible(isSelected);
        }
        this.selected = isSelected;
    }

    boolean isSelected() {
        return this.selected;
    }

    public int getMode() {
        return this.mode;
    }

    boolean toggleSelected(boolean showEditors) {
        this.setSelected(!this.selected, showEditors);
        return this.selected;
    }

    public boolean isTemporary() {
        return (this.mode & 4) != 0;
    }

    public void setTemporary(boolean b) {
        this.mode = b ? (this.mode |= 4) : (this.mode -= this.mode & 4);
    }

    public void setAnimated() {
        this.mode = 3;
    }

    public PTGraphicObject getGraphicObject() {
        return this.go;
    }
}

