/*
 * Decompiled with CFR 0.152.
 */
package animal.graphics;

import animal.animator.MoveBase;
import animal.graphics.PolygonalShape;
import animal.main.AnimalConfiguration;
import animal.misc.XProperties;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;

public class PTRectangle
extends PolygonalShape
implements MoveBase {
    public static final String TYPE_LABEL = "Rectangle";
    public static final String RECTANGLE_COLOR = "Rectangle.color";
    public static final String RECTANGLE_FILL_COLOR = "Rectangle.fillColor";
    public static final String RECTANGLE_FILLED = "Rectangle.filled";
    private static final long serialVersionUID = 5793164474737251118L;
    public static XProperties DefaultProperties;
    private int height;
    private int width;

    public static void initializeDefaultProperties(XProperties properties) {
        DefaultProperties = PTRectangle.extractDefaultProperties(properties, TYPE_LABEL);
    }

    public PTRectangle() {
        this(10, 10, 2, 2);
    }

    public PTRectangle(Point node1, Point node2) {
        this(node1.x, node1.y, node2.x - node1.x, node2.y - node1.y);
    }

    public PTRectangle(int x, int y, int targetWidth, int targetHeight) {
        this.setFirstNode(x, y);
        this.setHeight(targetHeight);
        this.setWidth(targetWidth);
        if (DefaultProperties == null) {
            PTRectangle.initializeDefaultProperties(AnimalConfiguration.getDefaultConfiguration().getProperties());
        }
    }

    public int getFileVersion() {
        return 1;
    }

    public XProperties getDefaultProperties() {
        return DefaultProperties;
    }

    public int getHeight() {
        return this.height;
    }

    public Dimension getSize() {
        return new Dimension(this.width, this.height);
    }

    public int getWidth() {
        return this.width;
    }

    public int getNodeCount() {
        if (this.firstNode == null) {
            return 0;
        }
        return 2;
    }

    public String getType() {
        return TYPE_LABEL;
    }

    public String[] handledKeywords() {
        return new String[]{TYPE_LABEL};
    }

    public void setHeight(int newHeight) {
        this.height = newHeight;
    }

    public void setSize(Dimension newSize) {
        if (newSize == null) {
            this.width = 0;
            this.height = 0;
        } else {
            this.setWidth(newSize.width);
            this.setHeight(newSize.height);
        }
    }

    public void setWidth(int newWidth) {
        this.width = newWidth;
    }

    public void scale(double scaleX, double scaleY) {
        if (this.getFirstNode() != null) {
            this.firstNode.x = (int)((double)this.firstNode.x * scaleX);
            this.firstNode.y = (int)((double)this.firstNode.y * scaleY);
        }
        this.width = (int)((double)this.width * scaleX);
        this.height = (int)((double)this.height * scaleY);
    }

    public int getDifferentNodesCount() {
        return this.getNodeCount();
    }

    public void translate(int deltaX, int deltaY) {
        this.getFirstNode().translate(deltaX, deltaY);
    }

    public String toString() {
        StringBuilder result = new StringBuilder(120);
        result.append("PTRectangle ");
        if (this.getObjectName() != null) {
            result.append("\"").append(this.getObjectName()).append("\" ");
        }
        result.append(this.nodeToString(this.getFirstNode()));
        result.append("size (").append(this.width).append(", ").append(this.height);
        result.append(")");
        return result.toString();
    }

    public Polygon toPolygon() {
        if (this.getFirstNode() == null) {
            int[] nArray = new int[2];
            nArray[1] = 1;
            int[] nArray2 = new int[2];
            nArray2[1] = 1;
            return new Polygon(nArray, nArray2, 2);
        }
        Point node = this.getFirstNode();
        int[] xpoints = new int[]{node.x, node.x + this.width};
        int[] ypoints = new int[]{node.y, node.y + this.height};
        return new Polygon(xpoints, ypoints, 2);
    }

    public void paint(Graphics g) {
        int x = this.getFirstNode().x;
        int y = this.getFirstNode().y;
        int paintWidth = Math.abs(this.width);
        int paintHeight = Math.abs(this.height);
        if (this.width < 0) {
            x += this.width;
        }
        if (this.height < 0) {
            y += this.height;
        }
        if (this.isFilled()) {
            g.setColor(this.fillColor);
            g.fillRect(x, y, paintWidth, paintHeight);
        }
        g.setColor(this.color);
        g.drawRect(x, y, paintWidth, paintHeight);
    }

    public Object clone() {
        PTRectangle p = new PTRectangle(this.getFirstNode().x, this.getFirstNode().y, this.getWidth(), this.getHeight());
        this.cloneCommonFeaturesInto(p);
        return p;
    }

    public int getLength() {
        return this.width * 2 + this.height * 2;
    }

    public Point getPointAtLength(int length) {
        int remainingLength = length;
        int nrSide = 0;
        int size = this.getLength();
        while (remainingLength > size) {
            remainingLength -= size;
            ++nrSide;
        }
        Point node = this.getFirstNode();
        switch (nrSide %= 4) {
            case 1: {
                return new Point(node.x + size, node.y + remainingLength);
            }
            case 2: {
                return new Point(node.x + size - remainingLength, node.y);
            }
            case 3: {
                return new Point(node.x, node.y + size - remainingLength);
            }
        }
        return new Point(node.x + remainingLength, node.y);
    }

    public void useAsMoveBase() {
    }

    public Rectangle getBoundingBox() {
        return new Rectangle(this.getFirstNode().x, this.getFirstNode().y, this.getWidth(), this.getHeight());
    }

    public void discard() {
        super.discard();
    }
}

