/*
 * Decompiled with CFR 0.152.
 */
package animal.graphics;

import animal.animator.MoveBase;
import animal.graphics.ArcBasedShape;
import animal.main.AnimalConfiguration;
import animal.misc.MSMath;
import animal.misc.XProperties;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.beans.PropertyChangeListener;

public class PTEllipse
extends ArcBasedShape
implements PropertyChangeListener,
MoveBase {
    public static final String TYPE_LABEL = "Ellipse";
    public static final String ELLIPSE_CENTER = "Ellipse.center";
    public static final String ELLIPSE_COLOR = "Ellipse.color";
    public static final String ELLIPSE_FILL_COLOR = "Ellipse.fillColor";
    public static final String ELLIPSE_FILLED = "Ellipse.filled";
    public static final String ELLIPSE_RADIUS = "Ellipse.radius";
    private Color color;
    private Color fillColor;
    private boolean isFilled;
    private Point radius;
    private Point center;
    private static final long serialVersionUID = 4711724437159551059L;
    public static XProperties DefaultProperties;

    public int getFileVersion() {
        return 1;
    }

    public PTEllipse() {
        this(DefaultProperties);
    }

    public PTEllipse(XProperties props) {
        if (props == null) {
            PTEllipse.initializeDefaultProperties(AnimalConfiguration.getDefaultConfiguration().getProperties());
            props = DefaultProperties;
        }
    }

    public void paint(Graphics g) {
        g.setColor(this.color);
        if (this.center == null) {
            return;
        }
        if (this.isFilled()) {
            g.setColor(this.fillColor);
            g.fillArc(this.center.x - this.radius.x, this.center.y - this.radius.y, this.radius.x * 2, this.radius.y * 2, 0, 360);
            g.setColor(this.color);
            if (!this.color.equals(this.fillColor)) {
                g.drawArc(this.center.x - this.radius.x, this.center.y - this.radius.y, this.radius.x * 2, this.radius.y * 2, 0, 360);
            }
        } else {
            g.drawArc(this.center.x - this.radius.x, this.center.y - this.radius.y, this.radius.x * 2, this.radius.y * 2, 0, 360);
        }
        g.setColor(this.color);
        if (!this.color.equals(this.fillColor)) {
            g.drawArc(this.center.x - this.radius.x, this.center.y - this.radius.y, this.radius.x * 2, this.radius.y * 2, 0, 360);
        }
    }

    public void translate(int x, int y) {
        this.center.translate(x, y);
    }

    public void useAsMoveBase() {
        this.setFilled(false);
    }

    public int getAngle(Point p) {
        int xRadius = this.getXRadius();
        int yRadius = this.getYRadius();
        Point localCenter = this.getCenter();
        int xdist = p.x - localCenter.x;
        int ydist = p.y - localCenter.y;
        if (xRadius == 0 || yRadius == 0) {
            return -1;
        }
        int angle = (int)(MSMath.getAngle(localCenter, new Point(localCenter.x + xdist * 100 / xRadius, localCenter.y + ydist * 100 / yRadius)) * 180.0 / Math.PI);
        if (angle < 0) {
            angle += 360;
        }
        return angle;
    }

    public Rectangle getBoundingBox() {
        Point localCenter = this.getCenter();
        return new Rectangle(localCenter.x - this.getXRadius(), localCenter.y - this.getYRadius(), this.getXRadius() * 2, this.getYRadius() * 2);
    }

    public Point getCenter() {
        return this.center;
    }

    public Color getFillColor() {
        if (this.fillColor == null) {
            this.fillColor = Color.BLACK;
        }
        return this.fillColor;
    }

    public Point getPointAtAngle(int alpha) {
        Point localCenter = this.getCenter();
        double x = (double)alpha * Math.PI / 180.0;
        return new Point((int)((double)localCenter.x + (double)this.getXRadius() * Math.cos(x)), (int)((double)localCenter.y - (double)this.getYRadius() * Math.sin(x)));
    }

    public Point getPointAtLength(int alpha) {
        double x = (double)alpha * Math.PI / 180.0;
        return new Point((int)((double)this.center.x + (double)this.getXRadius() * Math.cos(x)), (int)((double)this.center.y - (double)this.getYRadius() * Math.sin(x)));
    }

    public Point getRadius() {
        return this.radius;
    }

    public String getType() {
        return TYPE_LABEL;
    }

    public int getXRadius() {
        return this.getRadius().x;
    }

    public int getYRadius() {
        return this.getRadius().y;
    }

    public String[] handledKeywords() {
        return new String[]{TYPE_LABEL};
    }

    public static void initializeDefaultProperties(XProperties properties) {
        DefaultProperties = PTEllipse.extractDefaultProperties(properties, TYPE_LABEL);
    }

    public boolean isFilled() {
        return this.isFilled;
    }

    public void setCenter(int x, int y) {
        this.center = new Point(x, y);
    }

    public void setCenter(Point localCenter) {
        this.setCenter(localCenter.x, localCenter.y);
    }

    public void setColor(Color targetColor) {
        this.color = targetColor;
    }

    public void setFillColor(Color targetFillColor) {
        this.fillColor = targetFillColor;
    }

    public void setFilled(boolean filled) {
        this.isFilled = filled;
    }

    public void setRadius(Point targetRadius) {
        if (targetRadius != null) {
            this.setRadius(targetRadius.x, targetRadius.y);
        } else {
            this.setRadius(0, 0);
        }
    }

    public void setRadius(int radiusX, int radiusY) {
        this.radius = new Point(radiusX, radiusY);
    }

    public void setXRadius(int r) {
        this.setRadius(r, this.getYRadius());
    }

    public void setYRadius(int r) {
        this.setRadius(this.getXRadius(), r);
    }

    public void discard() {
        this.setFillColor(null);
        this.color = null;
        this.center = null;
        this.radius = null;
        super.discard();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("PTEllipse ");
        Point localCenter = this.getCenter();
        if (this.getObjectName() != null) {
            sb.append("\"").append(this.getObjectName()).append("\" ");
        }
        sb.append("center= (");
        sb.append(localCenter.x).append(", ").append(localCenter.y);
        sb.append("), radius (").append(this.getXRadius()).append(", ");
        sb.append(this.getYRadius()).append(")");
        return sb.toString();
    }

    public int getLength() {
        return 360;
    }
}

