/*
 * Decompiled with CFR 0.152.
 */
package animal.graphics;

import animal.animator.MoveBase;
import animal.graphics.PTGraphicObject;
import animal.graphics.PTPoint;
import animal.graphics.PTPolyline;
import animal.graphics.PTText;
import animal.main.AnimalConfiguration;
import animal.misc.MSMath;
import animal.misc.PropertyNameMapper;
import animal.misc.XProperties;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.beans.PropertyChangeListener;

public class PTArc
extends PTGraphicObject
implements PropertyChangeListener,
MoveBase {
    public static final String TYPE_LABEL = "Arc";
    public static final String ARC_ANGLE = "Arc.arcAngle";
    public static final String ARC_BOLD = "Arc.bold";
    public static final String ARC_BW_ARROW = "Arc.bwArrow";
    public static final String ARC_CENTER = "Arc.center";
    public static final String ARC_CIRCLE = "Arc.circle";
    public static final String ARC_CLOCKWISE = "Arc.clockwise";
    public static final String ARC_CLOSED = "Arc.closed";
    public static final String ARC_COLOR = "Arc.color";
    public static final String ARC_FILL_COLOR = "Arc.fillColor";
    public static final String ARC_FONT = "Arc.font";
    public static final String ARC_FONT_NAME = "Arc.fontName";
    public static final String ARC_FONT_SIZE = "Arc.fontSize";
    public static final String ARC_FONT_STYLE = "Arc.fontStyle";
    public static final String ARC_FILLED = "Arc.filled";
    public static final String ARC_ITALIC = "Arc.italic";
    public static final String ARC_FW_ARROW = "Arc.fwArrow";
    public static final String ARC_START_ANGLE = "Arc.startAngle";
    public static final String ARC_TEXT_COLOR = "Arc.textColor";
    public static final String ARC_TEXT = "Arc.text";
    public static final String ARC_RADIUS = "Arc.radius";
    private static PropertyNameMapper textMapper = new PropertyNameMapper();
    private static final long serialVersionUID = 4711724437159551059L;
    public static XProperties DefaultProperties;
    private PTText textComponent;

    static {
        textMapper.insertMapping("Text.font", ARC_FONT);
        textMapper.insertMapping("Text.fontName", ARC_FONT_NAME);
        textMapper.insertMapping("Text.fontSize", ARC_FONT_SIZE);
        textMapper.insertMapping("Text.fontStyle", ARC_FONT_STYLE);
        textMapper.insertMapping("Text.color", ARC_TEXT_COLOR);
        textMapper.insertMapping("Text.text", ARC_TEXT);
    }

    public int getFileVersion() {
        return 5;
    }

    public PTArc() {
        this(DefaultProperties);
    }

    public PTArc(XProperties props) {
        if (props == null) {
            PTArc.initializeDefaultProperties(AnimalConfiguration.getDefaultConfiguration().getProperties());
            props = DefaultProperties;
        }
        this.setProperties((XProperties)props.clone());
        this.initTextComponent();
    }

    private void drawArrow(Graphics g, double angle, boolean clockwise) {
        Point center = this.getCenter();
        int xRadius = this.getXRadius();
        int yRadius = this.getYRadius();
        double before = angle + (double)(clockwise ? 1 : -1) * 1.0 / 100.0;
        double tipX = (double)center.x + (double)xRadius * Math.cos(angle);
        double tipY = (double)center.y - (double)yRadius * Math.sin(angle);
        double inclinationX = (double)center.x + (double)xRadius * Math.cos(before) - tipX;
        double inclinationY = (double)center.y - (double)yRadius * Math.sin(before) - tipY;
        double length = Math.sqrt(inclinationX * inclinationX + inclinationY * inclinationY);
        Point from = new Point((int)(tipX + inclinationX * (double)this.getRadius() / length), (int)(tipY + inclinationY * (double)this.getRadius() / length));
        PTPolyline.drawArrow(g, new Point((int)tipX, (int)tipY), from);
    }

    public void paint(Graphics g) {
        Point a;
        Color color = this.getColor();
        Color fillColor = this.getFillColor();
        Point center = this.getCenter();
        int arcAngle = this.getArcAngle();
        int startAngle = this.getStartAngle();
        int xRadius = this.getXRadius();
        int yRadius = this.getYRadius();
        g.setColor(color);
        if (center == null) {
            return;
        }
        if (this.isFilled()) {
            g.setColor(fillColor);
            g.fillArc(center.x - xRadius, center.y - yRadius, xRadius * 2, yRadius * 2, startAngle, arcAngle);
            g.setColor(color);
            if (!fillColor.equals(color)) {
                g.drawArc(center.x - xRadius, center.y - yRadius, xRadius * 2, yRadius * 2, startAngle, arcAngle);
                if (arcAngle % 360 != 0) {
                    a = this.getPointAtAngle(startAngle);
                    g.drawLine(center.x, center.y, a.x, a.y);
                    a = this.getPointAtAngle(startAngle + arcAngle);
                    g.drawLine(center.x, center.y, a.x, a.y);
                }
            }
        } else {
            g.drawArc(center.x - xRadius, center.y - yRadius, xRadius * 2, yRadius * 2, startAngle, arcAngle);
            if (this.isClosed() && arcAngle % 360 != 0) {
                a = this.getPointAtAngle(startAngle);
                g.drawLine(center.x, center.y, a.x, a.y);
                a = this.getPointAtAngle(startAngle + arcAngle);
                g.drawLine(center.x, center.y, a.x, a.y);
            }
        }
        if (!this.isClosed() && !this.isFilled()) {
            if (this.hasFWArrow()) {
                double angle = (double)(startAngle + arcAngle) * Math.PI / 180.0;
                this.drawArrow(g, angle, this.isClockwise());
            }
            if (this.hasBWArrow()) {
                double angle = (double)startAngle * Math.PI / 180.0;
                this.drawArrow(g, angle, !this.isClockwise());
            }
        }
        if (this.getText() != null) {
            g.setFont(this.getFont());
            FontMetrics fm = g.getFontMetrics();
            g.setColor(this.getTextColor());
            int width = fm.stringWidth(this.getText());
            g.drawString(this.getText(), center.x - width / 2, center.y + fm.getHeight() / 3);
        }
    }

    public void rotate(double angle) {
        PTPoint center = new PTPoint(this.getCenter());
        center.rotate(angle);
        this.getProperties().put(this.mapKey(ARC_CENTER), center.toPoint());
        this.setStartAngle((int)((long)this.getStartAngle() + Math.round(angle * 180.0 / Math.PI)));
    }

    public void rotate(double angle, PTPoint center) {
        this.translate(-center.getX(), -center.getY());
        this.rotate(angle);
        this.translate(center.getX(), center.getY());
    }

    public void translate(int x, int y) {
        Point center = this.getCenter();
        center.translate(x, y);
        this.getProperties().put(this.mapKey(ARC_CENTER), center);
    }

    public void useAsMoveBase() {
        this.setFilled(false);
        this.setClosed(false);
        this.setFWArrow(true);
        this.setBWArrow(false);
    }

    public int getAngle(Point p) {
        int xRadius = this.getXRadius();
        int yRadius = this.getYRadius();
        Point center = this.getCenter();
        int xdist = p.x - center.x;
        int ydist = p.y - center.y;
        if (xRadius == 0 || yRadius == 0) {
            return -1;
        }
        int angle = (int)(MSMath.getAngle(center, new Point(center.x + xdist * 100 / xRadius, center.y + ydist * 100 / yRadius)) * 180.0 / Math.PI);
        if (angle < 0) {
            angle += 360;
        }
        return angle;
    }

    public int getArcAngle() {
        return this.getProperties().getIntProperty(this.mapKey(ARC_ANGLE), 720);
    }

    public Rectangle getBoundingBox() {
        Point center = this.getCenter();
        return new Rectangle(center.x - this.getXRadius(), center.y - this.getYRadius(), this.getXRadius() * 2, this.getYRadius() * 2);
    }

    public Point getCenter() {
        return this.getProperties().getPointProperty(this.mapKey(ARC_CENTER));
    }

    public Color getFillColor() {
        return this.getProperties().getColorProperty(this.mapKey(ARC_FILL_COLOR), Color.black);
    }

    public Font getFont() {
        return this.getProperties().getFontProperty(this.mapKey(ARC_FONT));
    }

    public int getLength() {
        return Math.abs(this.getArcAngle());
    }

    public Point getPointAtAngle(int alpha) {
        Point center = this.getCenter();
        double x = (double)alpha * Math.PI / 180.0;
        return new Point((int)((double)center.x + (double)this.getXRadius() * Math.cos(x)), (int)((double)center.y - (double)this.getYRadius() * Math.sin(x)));
    }

    public Point getPointAtLength(int x) {
        return this.getPointAtAngle(this.getStartAngle() + (this.isClockwise() ? -1 : 1) * x);
    }

    public int getRadius() {
        return (this.getXRadius() + this.getYRadius()) / 2;
    }

    public Point getRadiusPoint() {
        return this.getProperties().getPointProperty(this.mapKey(ARC_RADIUS));
    }

    public int getStartAngle() {
        return this.getProperties().getIntProperty(this.mapKey(ARC_START_ANGLE), 0);
    }

    public String getText() {
        return this.getProperties().getProperty(this.mapKey(ARC_TEXT));
    }

    public Color getTextColor() {
        return this.getProperties().getColorProperty(this.mapKey(ARC_TEXT_COLOR), Color.black);
    }

    public PTText getTextComponent() {
        if (this.textComponent == null) {
            this.initTextComponent();
        }
        return this.textComponent;
    }

    public String getType() {
        return TYPE_LABEL;
    }

    public int getXRadius() {
        return this.getProperties().getPointProperty((String)this.mapKey((String)ARC_RADIUS)).x;
    }

    public int getYRadius() {
        return this.getProperties().getPointProperty((String)this.mapKey((String)ARC_RADIUS)).y;
    }

    public String[] handledKeywords() {
        return new String[]{TYPE_LABEL};
    }

    public boolean hasBWArrow() {
        return this.getProperties().getBoolProperty(this.mapKey(ARC_BW_ARROW), false);
    }

    public boolean hasFWArrow() {
        return this.getProperties().getBoolProperty(this.mapKey(ARC_FW_ARROW), false);
    }

    public void initTextComponent() {
        this.textComponent = new PTText(this.getProperties());
        this.textComponent.setPropertyNameMapper(textMapper);
        this.textComponent.setText("");
    }

    public static void initializeDefaultProperties(XProperties properties) {
        DefaultProperties = PTArc.extractDefaultProperties(properties, TYPE_LABEL);
    }

    public boolean isAngleInside(int angle) {
        int arcAngle = this.getArcAngle();
        int startAngle = this.getStartAngle();
        if (this.isClockwise()) {
            if (-arcAngle < startAngle) {
                return angle < startAngle && angle > startAngle + arcAngle;
            }
            return angle < startAngle || angle > startAngle + arcAngle + 360;
        }
        if (startAngle + arcAngle < 360) {
            return angle > startAngle && angle < startAngle + arcAngle;
        }
        return angle > startAngle || angle < startAngle + arcAngle - 360;
    }

    public boolean isCircle() {
        return this.getProperties().getBoolProperty(this.mapKey(ARC_CIRCLE), false);
    }

    public boolean isClockwise() {
        return this.getProperties().getBoolProperty(this.mapKey(ARC_CLOCKWISE), false);
    }

    public boolean isClosed() {
        return this.getProperties().getBoolProperty(this.mapKey(ARC_CLOSED), false);
    }

    public boolean isFilled() {
        return this.getProperties().getBoolProperty(this.mapKey(ARC_FILLED), false);
    }

    public void setArcAngle(int alpha) {
        this.getProperties().put(this.mapKey(ARC_ANGLE), (this.isClockwise() ? -1 : 1) * Math.abs(alpha));
    }

    public void setBWArrow(boolean bwArrow) {
        this.getProperties().put(this.mapKey(ARC_BW_ARROW), bwArrow);
    }

    public void setCenter(Point center) {
        this.getProperties().put(this.mapKey(ARC_CENTER), center);
    }

    public void setCircle(boolean b) {
        this.getProperties().put(this.mapKey(ARC_CIRCLE), b);
        if (b) {
            this.setRadius(this.getRadius());
        }
    }

    public void setClockwise(boolean clockwise) {
        if (this.isClockwise() != clockwise) {
            this.getProperties().put(this.mapKey(ARC_CLOCKWISE), clockwise);
            if (this.isClockwise()) {
                this.setArcAngle(this.getArcAngle() - 360);
            } else {
                this.setArcAngle(360 + this.getArcAngle());
            }
        }
    }

    public void setClosed(boolean closed) {
        this.getProperties().put(this.mapKey(ARC_CLOSED), closed);
    }

    public void setColor(Color color) {
        this.getProperties().put(this.mapKey(ARC_COLOR), color);
    }

    public void setFillColor(Color color) {
        this.getProperties().put(this.mapKey(ARC_FILL_COLOR), color);
    }

    public void setFilled(boolean filled) {
        this.getProperties().put(this.mapKey(ARC_FILLED), filled);
    }

    public void setFont(Font f) {
        this.getProperties().put(this.mapKey(ARC_FONT), f);
    }

    public void setFWArrow(boolean fwArrow) {
        this.getProperties().put(this.mapKey(ARC_FW_ARROW), fwArrow);
    }

    public void setRadius(int r) {
        this.setRadius(new Point(r, r));
    }

    public void setRadius(Point radius) {
        this.getProperties().put(this.mapKey(ARC_RADIUS), new Point(radius.x, radius.y));
    }

    public void setStartAngle(int alpha) {
        this.getProperties().put(this.mapKey(ARC_START_ANGLE), alpha);
    }

    public void setText(String text) {
        this.getProperties().put(this.mapKey(ARC_TEXT), text);
    }

    public void setTextColor(Color color) {
        this.getProperties().put(this.mapKey(ARC_TEXT_COLOR), color);
    }

    public void setXRadius(int r) {
        Point currentRadius = this.getProperties().getPointProperty(this.mapKey(ARC_RADIUS));
        this.getProperties().put(this.mapKey(ARC_RADIUS), new Point(r, currentRadius.y));
    }

    public void setYRadius(int r) {
        Point currentRadius = this.getProperties().getPointProperty(this.mapKey(ARC_RADIUS));
        this.getProperties().put(this.mapKey(ARC_RADIUS), new Point(currentRadius.y, r));
    }

    public void discard() {
        this.setFillColor(null);
        this.textComponent = null;
        super.discard();
    }

    public String toString() {
        Point center = this.getCenter();
        StringBuilder sb = new StringBuilder("PTArc ");
        if (this.getObjectName() != null) {
            sb.append("\"").append(this.getObjectName()).append("\" ");
        }
        sb.append("(").append(center.x).append(", ").append(center.y);
        sb.append(") radius (").append(this.getXRadius()).append(", ");
        sb.append(this.getYRadius()).append(")");
        if (this.getStartAngle() != 0) {
            sb.append(" startAngle ").append(this.getStartAngle());
        }
        if (this.getArcAngle() % 360 != 0) {
            sb.append(" angle ").append(this.getArcAngle());
        }
        return sb.toString();
    }
}

