/*
 * Decompiled with CFR 0.152.
 */
package animal.exchange.animalascii;

import animal.exchange.animalascii.PTGraphicObjectImporter;
import animal.graphics.PTStringArray;
import animal.misc.MessageDisplay;
import animal.misc.ParseSupport;
import java.awt.Font;
import java.io.IOException;
import java.io.StreamTokenizer;

public class PTStringArrayImporter
extends PTGraphicObjectImporter {
    public Object importFrom(int version, StreamTokenizer stok) {
        PTStringArray array;
        try {
            array = new PTStringArray();
            if (version > array.getFileVersion()) {
                ParseSupport.formatException2("fileVersionMismatch", new Object[]{String.valueOf(version), String.valueOf(array.getFileVersion()), stok.toString()});
            }
            ParseSupport.parseMandatoryWord(stok, "StringArray keyword 'size'", "size");
            int size = ParseSupport.parseInt(stok, "size", 0);
            array = new PTStringArray(size);
            ParseSupport.parseMandatoryWord(stok, "StringArray keyword 'entries'", "entries");
            ParseSupport.parseMandatoryChar(stok, "{", '{');
            int i = 0;
            while (i < size) {
                array.enterValue(i, ParseSupport.parseText(stok, "StringArray[" + i + "]"));
                ++i;
            }
            ParseSupport.parseMandatoryChar(stok, "}", '}');
            ParseSupport.parseMandatoryWord(stok, "StringArray location", "location");
            array.setOrigin(ParseSupport.parseNode(stok, "location"));
            array.setBGColor(ParseSupport.parseColor(stok, "background color", "bgColor"));
            ParseSupport.parseMandatoryWord(stok, "StringArray keyword 'font'", "font");
            ParseSupport.parseMandatoryChar(stok, "StringArray keyword font '('", '(');
            String fontName = ParseSupport.parseWord(stok, "font name");
            ParseSupport.parseMandatoryChar(stok, "StringArray keyword font ','", ',');
            int fontSize = ParseSupport.parseInt(stok, "font size");
            ParseSupport.parseMandatoryChar(stok, "StringArray keyword font ')'", ')');
            Font font = new Font(fontName, 0, fontSize);
            array.setFont(font);
            array.setFontColor(ParseSupport.parseColor(stok, "StringArray font color", "fontColor"));
            array.setOutlineColor(ParseSupport.parseColor(stok, "StringArray outline color", "outlineColor"));
            array.setHighlightColor(ParseSupport.parseColor(stok, "StringArray highlight color", "highlightColor"));
            if (version >= 3) {
                array.setElemHighlightColor(ParseSupport.parseColor(stok, "StringArray element highlight color", "elementHighlightColor"));
            }
            if (version >= 2) {
                array.showIndices(ParseSupport.parseOptionalWord(stok, "Show cell indices?", "showIndices"));
            }
            ParseSupport.parseMandatoryWord(stok, "StringArray keyword 'depth'", "depth");
            array.setDepth(ParseSupport.parseInt(stok, "StringArray depth", 2));
        }
        catch (IOException e) {
            MessageDisplay.errorMsg(e.getMessage(), 4);
            array = new PTStringArray();
        }
        return array;
    }
}

