/*
 * Decompiled with CFR 0.152.
 */
package animal.editor;

import animal.editor.Editor;
import animal.editor.PolygonalShapeEditor;
import animal.graphics.PTGraphicObject;
import animal.graphics.PTTriangle;
import animal.gui.DrawCanvas;
import animal.main.Animation;
import animal.misc.AnimalTranslator;
import animal.misc.EditPoint;
import animal.misc.EditableObject;
import animal.misc.MSMath;
import animal.misc.XProperties;
import java.awt.Color;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Box;
import translator.TranslatableGUIElement;

public class TriangleEditor
extends PolygonalShapeEditor
implements ItemListener,
ActionListener,
PropertyChangeListener {
    private static final long serialVersionUID = -2413776784253970663L;

    public TriangleEditor() {
        TranslatableGUIElement generator = AnimalTranslator.getGUIBuilder();
        Box contentBox = this.createCommonElements(generator);
        this.filledCB = generator.generateJCheckBox("filled", null, this);
        this.filledCB.addItemListener(this);
        contentBox.add(this.filledCB);
        this.finishBoxes();
    }

    public int pointsNeeded() {
        return 3;
    }

    public boolean nextPoint(int num, Point p) {
        PTTriangle triangle = (PTTriangle)this.getCurrentObject();
        switch (num) {
            case 1: {
                triangle.setFirstNode(p.x, p.y);
                break;
            }
            case 2: {
                triangle.setSecondNode(p.x, p.y);
                break;
            }
            case 3: {
                triangle.setThirdNode(p.x, p.y);
            }
        }
        return true;
    }

    public int getMinDist(PTGraphicObject go, Point p) {
        PTTriangle pg = (PTTriangle)go;
        Rectangle boundingBox = pg.getBoundingBox();
        if (boundingBox.contains(p.x, p.y)) {
            return 0;
        }
        int minDist = Integer.MAX_VALUE;
        int newDist = MSMath.dist(p, pg.getFirstNode(), pg.getSecondNode());
        if (newDist < minDist) {
            minDist = newDist;
        }
        if ((newDist = MSMath.dist(p, pg.getSecondNode(), pg.getThirdNode())) < minDist) {
            minDist = newDist;
        }
        if ((newDist = MSMath.dist(p, pg.getThirdNode(), pg.getFirstNode())) < minDist) {
            minDist = newDist;
        }
        return minDist;
    }

    public EditPoint[] getEditPoints(PTGraphicObject go) {
        PTTriangle pg = (PTTriangle)go;
        EditPoint[] result = new EditPoint[6];
        result[0] = new EditPoint(1, pg.getFirstNode());
        result[1] = new EditPoint(2, pg.getSecondNode());
        result[2] = new EditPoint(3, pg.getThirdNode());
        Point start = pg.getFirstNode();
        Point end = pg.getSecondNode();
        result[3] = new EditPoint(-1, new Point((start.x + end.x) / 2, (start.y + end.y) / 2));
        start = end;
        end = pg.getThirdNode();
        result[4] = new EditPoint(-1, new Point((start.x + end.x) / 2, (start.y + end.y) / 2));
        start = end;
        end = pg.getFirstNode();
        result[5] = new EditPoint(-1, new Point((start.x + end.x) / 2, (start.y + end.y) / 2));
        return result;
    }

    public void setProperties(XProperties props) {
        this.colorChooser.setColor(props.getColorProperty("Triangle.color", Color.black));
        this.depthBox.setSelectedItem(props.getProperty("depth", String.valueOf(16)));
        this.fillColorChooser.setColor(props.getColorProperty("Triangle.fillColor", Color.black));
        this.filledCB.setSelected(props.getBoolProperty("Triangle.filled"));
    }

    public void getProperties(XProperties props) {
        props.put("Triangle.color", this.colorChooser.getColor());
        props.put((Object)"depth", this.depthBox.getSelectedItem());
        props.put("Triangle.fillColor", this.fillColorChooser.getColor());
        props.put("Triangle.filled", this.filledCB.isSelected());
    }

    public void itemStateChanged(ItemEvent e) {
        PTTriangle p = (PTTriangle)this.getCurrentObject();
        if (e.getSource() == this.filledCB && p != null) {
            p.setFilled(this.filledCB.isSelected());
        }
        Animation.get().doChange();
        this.repaintNow();
    }

    public EditableObject createObject() {
        PTTriangle pg = new PTTriangle();
        this.storeAttributesInto(pg);
        return pg;
    }

    void storeAttributesInto(EditableObject eo) {
        super.storeAttributesInto(eo);
        PTTriangle p = (PTTriangle)eo;
        p.setColor(this.colorChooser.getColor());
        p.setFilled(this.filledCB.isSelected());
        p.setFillColor(this.fillColorChooser.getColor());
    }

    void extractAttributesFrom(EditableObject eo) {
        super.extractAttributesFrom(eo);
        PTTriangle p = (PTTriangle)eo;
        this.colorChooser.setColor(p.getColor());
        this.filledCB.setEnabled(true);
        this.filledCB.setSelected(p.isFilled());
        this.fillColorChooser.setColor(p.getFillColor());
    }

    public Editor getSecondaryEditor(EditableObject go) {
        TriangleEditor result = new TriangleEditor();
        result.extractAttributesFrom(go);
        return result;
    }

    public String getStatusLineMsg() {
        return AnimalTranslator.translateMessage("triangleStatusLine", new Object[]{DrawCanvas.translateDrawButton(), DrawCanvas.translateFinishButton(), DrawCanvas.translateCancelButton()});
    }

    public void actionPerformed(ActionEvent e) {
        super.actionPerformed(e);
        PTTriangle p = (PTTriangle)this.getCurrentObject();
        if (p != null) {
            if (Animation.get() != null) {
                Animation.get().doChange();
            }
            this.repaintNow();
        }
    }

    public void propertyChange(PropertyChangeEvent event) {
        PTTriangle poly = (PTTriangle)this.getCurrentObject();
        String eventName = event.getPropertyName();
        if (eventName.equals("color")) {
            poly.setColor((Color)event.getNewValue());
        } else if (eventName.equals("fillColor")) {
            poly.setFillColor((Color)event.getNewValue());
        }
        if (!event.getOldValue().equals(event.getNewValue())) {
            this.repaintNow();
            if (Animation.get() != null) {
                Animation.get().doChange();
            }
        }
    }

    public String getBasicType() {
        return "Triangle";
    }
}

